/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Client {
    public static final Header[] EMPTY_HEADER_ARRAY = new Header[0];
    private static final Log LOG = LogFactory.getLog(Client.class);
    private HttpClient httpClient;
    private Cluster cluster;
    private boolean sslEnabled;
    private Map<String, String> extraHeaders;
    private static final String AUTH_COOKIE = "hadoop.auth";
    private static final String AUTH_COOKIE_EQ = "hadoop.auth=";
    private static final String COOKIE = "Cookie";

    public Client() {
        this(null);
    }

    private void initialize(Cluster cluster, boolean sslEnabled) {
        this.cluster = cluster;
        this.sslEnabled = sslEnabled;
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams managerParams = manager.getParams();
        managerParams.setConnectionTimeout(2000);
        managerParams.setDefaultMaxConnectionsPerHost(10);
        managerParams.setMaxTotalConnections(100);
        this.extraHeaders = new ConcurrentHashMap<String, String>();
        this.httpClient = new HttpClient((HttpConnectionManager)manager);
        HttpClientParams clientParams = this.httpClient.getParams();
        clientParams.setVersion(HttpVersion.HTTP_1_1);
    }

    public Client(Cluster cluster) {
        this.initialize(cluster, false);
    }

    public Client(Cluster cluster, boolean sslEnabled) {
        this.initialize(cluster, sslEnabled);
    }

    public void shutdown() {
        MultiThreadedHttpConnectionManager manager = (MultiThreadedHttpConnectionManager)this.httpClient.getHttpConnectionManager();
        manager.shutdown();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void addExtraHeader(String name, String value) {
        this.extraHeaders.put(name, value);
    }

    public String getExtraHeader(String name) {
        return this.extraHeaders.get(name);
    }

    public Map<String, String> getExtraHeaders() {
        return Collections.unmodifiableMap(this.extraHeaders);
    }

    public void removeExtraHeader(String name) {
        this.extraHeaders.remove(name);
    }

    public int executePathOnly(Cluster cluster, HttpMethod method, Header[] headers, String path) throws IOException {
        int start;
        if (cluster.nodes.size() < 1) {
            throw new IOException("Cluster is empty");
        }
        int i = start = (int)Math.round((double)(cluster.nodes.size() - 1) * Math.random());
        while (true) {
            cluster.lastHost = cluster.nodes.get(i);
            try {
                StringBuilder sb = new StringBuilder();
                if (this.sslEnabled) {
                    sb.append("https://");
                } else {
                    sb.append("http://");
                }
                sb.append(cluster.lastHost);
                sb.append(path);
                URI uri = new URI(sb.toString(), true);
                return this.executeURI(method, headers, uri.toString());
            }
            catch (IOException e) {
                IOException lastException = e;
                if (++i != start && i < cluster.nodes.size()) continue;
                throw lastException;
            }
            break;
        }
    }

    public int executeURI(HttpMethod method, Header[] headers, String uri) throws IOException {
        method.setURI(new URI(uri, true));
        for (Map.Entry<String, String> e : this.extraHeaders.entrySet()) {
            method.addRequestHeader(e.getKey(), e.getValue());
        }
        if (headers != null) {
            for (Header header : headers) {
                method.addRequestHeader(header);
            }
        }
        long startTime = System.currentTimeMillis();
        int code = this.httpClient.executeMethod(method);
        if (code == 401) {
            LOG.debug((Object)"Performing negotiation with the server.");
            this.negotiate(method, uri);
            code = this.httpClient.executeMethod(method);
        }
        long endTime = System.currentTimeMillis();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(method.getName() + " " + uri + " " + code + " " + method.getStatusText() + " in " + (endTime - startTime) + " ms"));
        }
        return code;
    }

    public int execute(Cluster cluster, HttpMethod method, Header[] headers, String path) throws IOException {
        if (path.startsWith("/")) {
            return this.executePathOnly(cluster, method, headers, path);
        }
        return this.executeURI(method, headers, path);
    }

    private void negotiate(HttpMethod method, String uri) throws IOException {
        try {
            AuthenticatedURL.Token token = new AuthenticatedURL.Token();
            KerberosAuthenticator authenticator = new KerberosAuthenticator();
            authenticator.authenticate(new URL(uri), token);
            this.injectToken(method, token);
        }
        catch (AuthenticationException e) {
            LOG.error((Object)"Failed to negotiate with the server.", (Throwable)e);
            throw new IOException(e);
        }
    }

    private void injectToken(HttpMethod method, AuthenticatedURL.Token token) {
        String t = token.toString();
        if (t != null) {
            if (!t.startsWith("\"")) {
                t = "\"" + t + "\"";
            }
            method.addRequestHeader(COOKIE, AUTH_COOKIE_EQ + t);
        }
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public Response head(String path) throws IOException {
        return this.head(this.cluster, path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response head(Cluster cluster, String path, Header[] headers) throws IOException {
        HeadMethod method = new HeadMethod();
        try {
            int code = this.execute(cluster, (HttpMethod)method, null, path);
            headers = method.getResponseHeaders();
            Response response = new Response(code, headers, null);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    public Response get(String path) throws IOException {
        return this.get(this.cluster, path);
    }

    public Response get(Cluster cluster, String path) throws IOException {
        return this.get(cluster, path, EMPTY_HEADER_ARRAY);
    }

    public Response get(String path, String accept) throws IOException {
        return this.get(this.cluster, path, accept);
    }

    public Response get(Cluster cluster, String path, String accept) throws IOException {
        Header[] headers = new Header[]{new Header("Accept", accept)};
        return this.get(cluster, path, headers);
    }

    public Response get(String path, Header[] headers) throws IOException {
        return this.get(this.cluster, path, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response get(Cluster c, String path, Header[] headers) throws IOException {
        GetMethod method = new GetMethod();
        try {
            int code = this.execute(c, (HttpMethod)method, headers, path);
            headers = method.getResponseHeaders();
            byte[] body = method.getResponseBody();
            InputStream in = method.getResponseBodyAsStream();
            Response response = new Response(code, headers, body, in);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    public Response put(String path, String contentType, byte[] content) throws IOException {
        return this.put(this.cluster, path, contentType, content);
    }

    public Response put(Cluster cluster, String path, String contentType, byte[] content) throws IOException {
        Header[] headers = new Header[]{new Header("Content-Type", contentType)};
        return this.put(cluster, path, headers, content);
    }

    public Response put(String path, Header[] headers, byte[] content) throws IOException {
        return this.put(this.cluster, path, headers, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response put(Cluster cluster, String path, Header[] headers, byte[] content) throws IOException {
        PutMethod method = new PutMethod();
        try {
            method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(content));
            int code = this.execute(cluster, (HttpMethod)method, headers, path);
            headers = method.getResponseHeaders();
            content = method.getResponseBody();
            Response response = new Response(code, headers, content);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    public Response post(String path, String contentType, byte[] content) throws IOException {
        return this.post(this.cluster, path, contentType, content);
    }

    public Response post(Cluster cluster, String path, String contentType, byte[] content) throws IOException {
        Header[] headers = new Header[]{new Header("Content-Type", contentType)};
        return this.post(cluster, path, headers, content);
    }

    public Response post(String path, Header[] headers, byte[] content) throws IOException {
        return this.post(this.cluster, path, headers, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response post(Cluster cluster, String path, Header[] headers, byte[] content) throws IOException {
        PostMethod method = new PostMethod();
        try {
            method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(content));
            int code = this.execute(cluster, (HttpMethod)method, headers, path);
            headers = method.getResponseHeaders();
            content = method.getResponseBody();
            Response response = new Response(code, headers, content);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    public Response delete(String path) throws IOException {
        return this.delete(this.cluster, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response delete(Cluster cluster, String path) throws IOException {
        DeleteMethod method = new DeleteMethod();
        try {
            int code = this.execute(cluster, (HttpMethod)method, null, path);
            Header[] headers = method.getResponseHeaders();
            byte[] content = method.getResponseBody();
            Response response = new Response(code, headers, content);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }
}

