/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.ResultGenerator;
import org.apache.hadoop.hbase.rest.ScannerResource;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ScannerInstanceResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(ScannerInstanceResource.class);
    static CacheControl cacheControl = new CacheControl();
    ResultGenerator generator = null;
    String id = null;
    int batch = 1;

    public ScannerInstanceResource() throws IOException {
    }

    public ScannerInstanceResource(String table, String id, ResultGenerator generator, int batch) throws IOException {
        this.id = id;
        this.generator = generator;
        this.batch = batch;
    }

    @GET
    @Produces(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context UriInfo uriInfo, @QueryParam(value="n") int maxRows, @QueryParam(value="c") int maxValues) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        if (this.generator == null) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Not found\r\n").build();
        }
        RESTServlet.getInstance().getConnectionCache().updateConnectionAccessTime();
        CellSetModel model = new CellSetModel();
        RowModel rowModel = null;
        byte[] rowKey = null;
        int limit = this.batch;
        if (maxValues > 0) {
            limit = maxValues;
        }
        int count = limit;
        do {
            Cell value = null;
            try {
                value = (Cell)this.generator.next();
            }
            catch (IllegalStateException e) {
                if (ScannerResource.delete(this.id)) {
                    this.servlet.getMetrics().incrementSucessfulDeleteRequests(1);
                } else {
                    this.servlet.getMetrics().incrementFailedDeleteRequests(1);
                }
                this.servlet.getMetrics().incrementFailedGetRequests(1);
                return Response.status((Response.Status)Response.Status.GONE).type("text/plain").entity((Object)"Gone\r\n").build();
            }
            catch (IllegalArgumentException e) {
                Throwable t = e.getCause();
                if (t instanceof TableNotFoundException) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Not found\r\n").build();
                }
                throw e;
            }
            if (value == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"generator exhausted");
                }
                if (count != limit) break;
                return Response.noContent().build();
            }
            if (rowKey == null) {
                rowKey = CellUtil.cloneRow((Cell)value);
                rowModel = new RowModel(rowKey);
            }
            if (!Bytes.equals((byte[])CellUtil.cloneRow((Cell)value), (byte[])rowKey)) {
                if (maxRows > 0 && --maxRows == 0) {
                    this.generator.putBack(value);
                    break;
                }
                model.addRow(rowModel);
                rowKey = CellUtil.cloneRow((Cell)value);
                rowModel = new RowModel(rowKey);
            }
            rowModel.addCell(new CellModel(CellUtil.cloneFamily((Cell)value), CellUtil.cloneQualifier((Cell)value), value.getTimestamp(), CellUtil.cloneValue((Cell)value)));
        } while (--count > 0);
        model.addRow(rowModel);
        Response.ResponseBuilder response = Response.ok((Object)model);
        response.cacheControl(cacheControl);
        this.servlet.getMetrics().incrementSucessfulGetRequests(1);
        return response.build();
    }

    @GET
    @Produces(value={"application/octet-stream"})
    public Response getBinary(@Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("GET " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream"));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            Cell value = (Cell)this.generator.next();
            if (value == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"generator exhausted");
                }
                return Response.noContent().build();
            }
            Response.ResponseBuilder response = Response.ok((Object)CellUtil.cloneValue((Cell)value));
            response.cacheControl(cacheControl);
            response.header("X-Row", (Object)Base64.encodeBytes((byte[])CellUtil.cloneRow((Cell)value)));
            response.header("X-Column", (Object)Base64.encodeBytes((byte[])KeyValue.makeColumn((byte[])CellUtil.cloneFamily((Cell)value), (byte[])CellUtil.cloneQualifier((Cell)value))));
            response.header("X-Timestamp", (Object)value.getTimestamp());
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return response.build();
        }
        catch (IllegalStateException e) {
            if (ScannerResource.delete(this.id)) {
                this.servlet.getMetrics().incrementSucessfulDeleteRequests(1);
            } else {
                this.servlet.getMetrics().incrementFailedDeleteRequests(1);
            }
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return Response.status((Response.Status)Response.Status.GONE).type("text/plain").entity((Object)"Gone\r\n").build();
        }
    }

    @DELETE
    public Response delete(@Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("DELETE " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        if (ScannerResource.delete(this.id)) {
            this.servlet.getMetrics().incrementSucessfulDeleteRequests(1);
        } else {
            this.servlet.getMetrics().incrementFailedDeleteRequests(1);
        }
        return Response.ok().build();
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

