/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.rest.ProtobufStreamingOutput;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TableScanResource
extends ResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(TableScanResource.class);
    TableResource tableResource;
    ResultScanner results;
    int userRequestedLimit;

    public TableScanResource(ResultScanner scanner, int userRequestedLimit) throws IOException {
        this.results = scanner;
        this.userRequestedLimit = userRequestedLimit;
    }

    @GET
    @Produces(value={"text/xml", "application/json"})
    public CellSetModelStream get(@Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("GET " + uriInfo.getAbsolutePath());
        }
        this.servlet.getMetrics().incrementRequests(1);
        final int rowsToSend = this.userRequestedLimit;
        this.servlet.getMetrics().incrementSucessfulScanRequests(1);
        final Iterator itr = this.results.iterator();
        return new CellSetModelStream(new ArrayList<RowModel>(){

            @Override
            public Iterator<RowModel> iterator() {
                return new Iterator<RowModel>(){
                    int count;
                    {
                        this.count = rowsToSend;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.count > 0 && itr.hasNext();
                    }

                    @Override
                    public RowModel next() {
                        Result rs = (Result)itr.next();
                        if (rs == null || this.count <= 0) {
                            return null;
                        }
                        byte[] rowKey = rs.getRow();
                        RowModel rModel = new RowModel(rowKey);
                        List kvs = rs.listCells();
                        for (Cell kv : kvs) {
                            rModel.addCell(new CellModel(CellUtil.cloneFamily((Cell)kv), CellUtil.cloneQualifier((Cell)kv), kv.getTimestamp(), CellUtil.cloneValue((Cell)kv)));
                        }
                        --this.count;
                        if (this.count == 0) {
                            TableScanResource.this.results.close();
                        }
                        return rModel;
                    }
                };
            }
        });
    }

    @GET
    @Produces(value={"application/x-protobuf", "application/protobuf"})
    public Response getProtobuf(@Context UriInfo uriInfo, @HeaderParam(value="Accept") String contentType) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("GET " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream");
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            int fetchSize = this.servlet.getConfiguration().getInt("hbase.rest.scan.fetchsize", 10);
            ProtobufStreamingOutput stream = new ProtobufStreamingOutput(this.results, contentType, this.userRequestedLimit, fetchSize);
            this.servlet.getMetrics().incrementSucessfulScanRequests(1);
            Response.ResponseBuilder response = Response.ok((Object)stream);
            response.header("content-type", (Object)contentType);
            return response.build();
        }
        catch (Exception exp) {
            this.servlet.getMetrics().incrementFailedScanRequests(1);
            this.processException(exp);
            LOG.warn(exp.toString(), (Throwable)exp);
            return null;
        }
    }

    @XmlRootElement(name="CellSet")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class CellSetModelStream {
        @XmlElement(name="Row")
        @JsonIgnore
        private ArrayList<RowModel> Row;

        public CellSetModelStream() {
        }

        public CellSetModelStream(ArrayList<RowModel> rowList) {
            this.Row = rowList;
        }

        @JsonProperty(value="Row")
        public Iterator<RowModel> getIterator() {
            return this.Row.iterator();
        }
    }
}

