/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RowSpec {
    public static final long DEFAULT_START_TIMESTAMP = 0L;
    public static final long DEFAULT_END_TIMESTAMP = Long.MAX_VALUE;
    private byte[] row = HConstants.EMPTY_START_ROW;
    private byte[] endRow = null;
    private TreeSet<byte[]> columns = new TreeSet(Bytes.BYTES_COMPARATOR);
    private List<String> labels = new ArrayList<String>();
    private long startTime = 0L;
    private long endTime = Long.MAX_VALUE;
    private int maxVersions = 1;
    private int maxValues = Integer.MAX_VALUE;

    public RowSpec(String path) throws IllegalArgumentException {
        int i = 0;
        while (path.charAt(i) == '/') {
            ++i;
        }
        i = this.parseRowKeys(path, i);
        i = this.parseColumns(path, i);
        i = this.parseTimestamp(path, i);
        i = this.parseQueryParams(path, i);
    }

    private int parseRowKeys(String path, int i) throws IllegalArgumentException {
        String startRow = null;
        String endRow = null;
        try {
            char c;
            StringBuilder sb = new StringBuilder();
            while (i < path.length() && (c = path.charAt(i)) != '/') {
                sb.append(c);
                ++i;
            }
            ++i;
            String row = startRow = sb.toString();
            int idx = startRow.indexOf(44);
            if (idx != -1) {
                startRow = URLDecoder.decode(row.substring(0, idx), "UTF-8");
                endRow = URLDecoder.decode(row.substring(idx + 1), "UTF-8");
            } else {
                startRow = URLDecoder.decode(row, "UTF-8");
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (startRow.charAt(startRow.length() - 1) == '*') {
            if (endRow != null) {
                throw new IllegalArgumentException("invalid path: start row specified with wildcard");
            }
            this.row = Bytes.toBytes((String)startRow.substring(0, startRow.lastIndexOf("*")));
            this.endRow = new byte[this.row.length + 1];
            System.arraycopy(this.row, 0, this.endRow, 0, this.row.length);
            this.endRow[this.row.length] = -1;
        } else {
            this.row = Bytes.toBytes((String)startRow.toString());
            if (endRow != null) {
                this.endRow = Bytes.toBytes((String)endRow.toString());
            }
        }
        return i;
    }

    private int parseColumns(String path, int i) throws IllegalArgumentException {
        if (i >= path.length()) {
            return i;
        }
        try {
            String s;
            char c;
            StringBuilder column = new StringBuilder();
            while (i < path.length() && (c = path.charAt(i)) != '/') {
                if (c == ',') {
                    if (column.length() < 1) {
                        throw new IllegalArgumentException("invalid path");
                    }
                    s = URLDecoder.decode(column.toString(), "UTF-8");
                    this.columns.add(Bytes.toBytes((String)s));
                    column.setLength(0);
                    ++i;
                    continue;
                }
                column.append(c);
                ++i;
            }
            ++i;
            if (column.length() > 0) {
                s = URLDecoder.decode(column.toString(), "UTF-8");
                this.columns.add(Bytes.toBytes((String)s));
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return i;
    }

    private int parseTimestamp(String path, int i) throws IllegalArgumentException {
        if (i >= path.length()) {
            return i;
        }
        long time0 = 0L;
        long time1 = 0L;
        try {
            char c = '\u0000';
            StringBuilder stamp = new StringBuilder();
            while (i < path.length() && (c = path.charAt(i)) != '/' && c != ',') {
                stamp.append(c);
                ++i;
            }
            try {
                time0 = Long.parseLong(URLDecoder.decode(stamp.toString(), "UTF-8"));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
            if (c == ',') {
                stamp = new StringBuilder();
                ++i;
                while (i < path.length() && (c = path.charAt(i)) != '/') {
                    stamp.append(c);
                    ++i;
                }
                try {
                    time1 = Long.parseLong(URLDecoder.decode(stamp.toString(), "UTF-8"));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (c == '/') {
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (time1 != 0L) {
            this.startTime = time0;
            this.endTime = time1;
        } else {
            this.endTime = time0;
        }
        return i;
    }

    private int parseQueryParams(String path, int i) {
        char c;
        if (i >= path.length()) {
            return i;
        }
        StringBuilder query = new StringBuilder();
        try {
            query.append(URLDecoder.decode(path.substring(i), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        i += query.length();
        int j = 0;
        block6: while (j < query.length() && ((c = query.charAt(j)) == '?' || c == '&')) {
            if (++j > query.length()) {
                throw new IllegalArgumentException("malformed query parameter");
            }
            char what = query.charAt(j);
            if (++j > query.length()) break;
            c = query.charAt(j);
            if (c != '=') {
                throw new IllegalArgumentException("malformed query parameter");
            }
            if (++j > query.length()) break;
            switch (what) {
                case 'm': {
                    StringBuilder sb = new StringBuilder();
                    while (j <= query.length()) {
                        c = query.charAt(j);
                        if (c < '0' || c > '9') {
                            --j;
                            break;
                        }
                        sb.append(c);
                    }
                    this.maxVersions = Integer.parseInt(sb.toString());
                    continue block6;
                }
                case 'n': {
                    StringBuilder sb = new StringBuilder();
                    while (j <= query.length()) {
                        c = query.charAt(j);
                        if (c < '0' || c > '9') {
                            --j;
                            break;
                        }
                        sb.append(c);
                    }
                    this.maxValues = Integer.parseInt(sb.toString());
                    continue block6;
                }
            }
            throw new IllegalArgumentException("unknown parameter '" + c + "'");
        }
        return i;
    }

    public RowSpec(byte[] startRow, byte[] endRow, byte[][] columns, long startTime, long endTime, int maxVersions) {
        this.row = startRow;
        this.endRow = endRow;
        if (columns != null) {
            Collections.addAll(this.columns, columns);
        }
        this.startTime = startTime;
        this.endTime = endTime;
        this.maxVersions = maxVersions;
    }

    public RowSpec(byte[] startRow, byte[] endRow, Collection<byte[]> columns, long startTime, long endTime, int maxVersions, Collection<String> labels) {
        this(startRow, endRow, columns, startTime, endTime, maxVersions);
        if (labels != null) {
            this.labels.addAll(labels);
        }
    }

    public RowSpec(byte[] startRow, byte[] endRow, Collection<byte[]> columns, long startTime, long endTime, int maxVersions) {
        this.row = startRow;
        this.endRow = endRow;
        if (columns != null) {
            this.columns.addAll(columns);
        }
        this.startTime = startTime;
        this.endTime = endTime;
        this.maxVersions = maxVersions;
    }

    public boolean isSingleRow() {
        return this.endRow == null;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public void setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
    }

    public int getMaxValues() {
        return this.maxValues;
    }

    public void setMaxValues(int maxValues) {
        this.maxValues = maxValues;
    }

    public boolean hasColumns() {
        return !this.columns.isEmpty();
    }

    public boolean hasLabels() {
        return !this.labels.isEmpty();
    }

    public byte[] getRow() {
        return this.row;
    }

    public byte[] getStartRow() {
        return this.row;
    }

    public boolean hasEndRow() {
        return this.endRow != null;
    }

    public byte[] getEndRow() {
        return this.endRow;
    }

    public void addColumn(byte[] column) {
        this.columns.add(column);
    }

    public byte[][] getColumns() {
        return (byte[][])this.columns.toArray((T[])new byte[this.columns.size()][]);
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public boolean hasTimestamp() {
        return this.startTime == 0L && this.endTime != Long.MAX_VALUE;
    }

    public long getTimestamp() {
        return this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("{startRow => '");
        if (this.row != null) {
            result.append(Bytes.toString((byte[])this.row));
        }
        result.append("', endRow => '");
        if (this.endRow != null) {
            result.append(Bytes.toString((byte[])this.endRow));
        }
        result.append("', columns => [");
        for (byte[] col : this.columns) {
            result.append(" '");
            result.append(Bytes.toString((byte[])col));
            result.append("'");
        }
        result.append(" ], startTime => ");
        result.append(Long.toString(this.startTime));
        result.append(", endTime => ");
        result.append(Long.toString(this.endTime));
        result.append(", maxVersions => ");
        result.append(Integer.toString(this.maxVersions));
        result.append(", maxValues => ");
        result.append(Integer.toString(this.maxValues));
        result.append("}");
        return result.toString();
    }
}

