/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdmin;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;

@InterfaceAudience.Private
public class RSGroupAdminServer
implements RSGroupAdmin {
    private static final Log LOG = LogFactory.getLog(RSGroupAdminServer.class);
    private MasterServices master;
    private ConcurrentMap<Address, String> serversInTransition = new ConcurrentHashMap<Address, String>();
    private RSGroupInfoManager rsGroupInfoManager;

    public RSGroupAdminServer(MasterServices master, RSGroupInfoManager RSGroupInfoManager2) throws IOException {
        this.master = master;
        this.rsGroupInfoManager = RSGroupInfoManager2;
    }

    @Override
    public RSGroupInfo getRSGroupInfo(String groupName) throws IOException {
        return this.getRSGroupInfoManager().getRSGroup(groupName);
    }

    @Override
    public RSGroupInfo getRSGroupInfoOfTable(TableName tableName) throws IOException {
        String groupName = this.getRSGroupInfoManager().getRSGroupOfTable(tableName);
        if (groupName == null) {
            return null;
        }
        return this.getRSGroupInfoManager().getRSGroup(groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveServers(Set<Address> servers, String targetGroupName) throws IOException {
        RSGroupInfoManager manager;
        if (servers == null) {
            throw new ConstraintException("The list of servers cannot be null.");
        }
        if (StringUtils.isEmpty((String)targetGroupName)) {
            throw new ConstraintException("The target group cannot be null.");
        }
        if (servers.size() < 1) {
            return;
        }
        RSGroupInfo targetGrp = this.getRSGroupInfo(targetGroupName);
        if (targetGrp == null) {
            throw new ConstraintException("Group does not exist: " + targetGroupName);
        }
        RSGroupInfoManager rSGroupInfoManager = manager = this.getRSGroupInfoManager();
        synchronized (rSGroupInfoManager) {
            Address firstServer = servers.iterator().next();
            RSGroupInfo srcGrp = manager.getRSGroupOfServer(firstServer);
            if (srcGrp == null) {
                throw new ConstraintException("Server " + firstServer + " does not have a group.");
            }
            if ("default".equals(srcGrp.getName())) {
                HashSet<Address> onlineServers = new HashSet<Address>();
                for (ServerName serverName : this.master.getServerManager().getOnlineServers().keySet()) {
                    onlineServers.add(serverName.getAddress());
                }
                for (Address address : servers) {
                    if (onlineServers.contains(address)) continue;
                    throw new ConstraintException("Server " + address + " is not an online server in default group.");
                }
            }
            if ("default".equals(srcGrp.getName()) && srcGrp.getServers().size() <= servers.size()) {
                throw new ConstraintException("Should keep at least one server in 'default' RSGroup ");
            }
            if (srcGrp.getServers().size() <= servers.size() && srcGrp.getTables().size() > 0) {
                throw new ConstraintException("Cannot leave a group " + srcGrp.getName() + " that contains tables " + "without servers.");
            }
            String sourceGroupName = this.getRSGroupInfoManager().getRSGroupOfServer(srcGrp.getServers().iterator().next()).getName();
            if (this.getRSGroupInfo(targetGroupName) == null) {
                throw new ConstraintException("Target group does not exist: " + targetGroupName);
            }
            for (Address address : servers) {
                if (this.serversInTransition.containsKey(address)) {
                    throw new ConstraintException("Server list contains a server that is already being moved: " + address);
                }
                String tmpGroup = this.getRSGroupInfoManager().getRSGroupOfServer(address).getName();
                if (sourceGroupName == null || tmpGroup.equals(sourceGroupName)) continue;
                throw new ConstraintException("Move server request should only come from one source group. Expecting only " + sourceGroupName + " but contains " + tmpGroup);
            }
            if (sourceGroupName.equals(targetGroupName)) {
                throw new ConstraintException("Target group is the same as source group: " + targetGroupName);
            }
            try {
                boolean found;
                for (Address address : servers) {
                    this.serversInTransition.put(address, targetGroupName);
                }
                this.getRSGroupInfoManager().moveServers(servers, sourceGroupName, targetGroupName);
                ArrayList arrayList = Lists.newArrayList(servers);
                do {
                    found = false;
                    Iterator iter = arrayList.iterator();
                    while (iter.hasNext()) {
                        Address rs = (Address)iter.next();
                        LinkedList<Object> regions = new LinkedList<Object>();
                        for (Map.Entry el : this.master.getAssignmentManager().getRegionStates().getRegionAssignments().entrySet()) {
                            if (!((ServerName)el.getValue()).getAddress().equals((Object)rs)) continue;
                            regions.add(el.getKey());
                        }
                        for (RegionState state : this.master.getAssignmentManager().getRegionStates().getRegionsInTransition()) {
                            if (!state.getServerName().getAddress().equals((Object)rs)) continue;
                            regions.add(state.getRegion());
                        }
                        LOG.info((Object)("Unassigning " + regions.size() + " regions from server " + rs + " for move to " + targetGroupName));
                        if (regions.size() > 0) {
                            for (HRegionInfo hRegionInfo : regions) {
                                if (targetGrp.containsTable(hRegionInfo.getTable())) continue;
                                this.master.getAssignmentManager().unassign(hRegionInfo);
                                found = true;
                            }
                        }
                        if (found) continue;
                        iter.remove();
                    }
                    try {
                        manager.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)"Sleep interrupted", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                } while (found);
            }
            finally {
                for (Address address : servers) {
                    this.serversInTransition.remove(address);
                }
            }
            LOG.info((Object)("Move server done: " + sourceGroupName + "->" + targetGroupName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTables(Set<TableName> tables, String targetGroup) throws IOException {
        RSGroupInfoManager manager;
        if (tables == null) {
            throw new ConstraintException("The list of servers cannot be null.");
        }
        if (tables.size() < 1) {
            LOG.debug((Object)"moveTables() passed an empty set. Ignoring.");
            return;
        }
        RSGroupInfoManager rSGroupInfoManager = manager = this.getRSGroupInfoManager();
        synchronized (rSGroupInfoManager) {
            if (targetGroup != null) {
                RSGroupInfo destGroup = manager.getRSGroup(targetGroup);
                if (destGroup == null) {
                    throw new ConstraintException("Target group does not exist: " + targetGroup);
                }
                if (destGroup.getServers().size() < 1) {
                    throw new ConstraintException("Target group must have at least one server.");
                }
            }
            for (TableName table : tables) {
                String srcGroup = manager.getRSGroupOfTable(table);
                if (srcGroup == null || !srcGroup.equals(targetGroup)) continue;
                throw new ConstraintException("Source group is the same as target group for table " + table + " :" + srcGroup);
            }
            manager.moveTables(tables, targetGroup);
        }
        for (TableName table : tables) {
            if (this.master.getAssignmentManager().getTableStateManager().isTableState(table, new ZooKeeperProtos.Table.State[]{ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING})) {
                LOG.debug((Object)("Skipping move regions because the table" + table + " is disabled."));
                continue;
            }
            TableLockManager.TableLock lock = this.master.getTableLockManager().writeLock(table, "Group: table move");
            for (HRegionInfo region : this.master.getAssignmentManager().getRegionStates().getRegionsOfTable(table)) {
                this.master.getAssignmentManager().unassign(region);
            }
        }
    }

    @Override
    public void addRSGroup(String name) throws IOException {
        this.getRSGroupInfoManager().addRSGroup(new RSGroupInfo(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRSGroup(String name) throws IOException {
        RSGroupInfoManager manager;
        RSGroupInfoManager rSGroupInfoManager = manager = this.getRSGroupInfoManager();
        synchronized (rSGroupInfoManager) {
            RSGroupInfo groupInfo = this.getRSGroupInfoManager().getRSGroup(name);
            if (groupInfo == null) {
                throw new ConstraintException("Group " + name + " does not exist");
            }
            int tableCount = groupInfo.getTables().size();
            if (tableCount > 0) {
                throw new ConstraintException("Group " + name + " must have no associated tables: " + tableCount);
            }
            int serverCount = groupInfo.getServers().size();
            if (serverCount > 0) {
                throw new ConstraintException("Group " + name + " must have no associated servers: " + serverCount);
            }
            for (NamespaceDescriptor ns : this.master.getTableNamespaceManager().list()) {
                String nsGroup = ns.getConfigurationValue("hbase.rsgroup.name");
                if (nsGroup == null || !nsGroup.equals(name)) continue;
                throw new ConstraintException("Group " + name + " is referenced by namespace: " + ns.getName());
            }
            manager.removeRSGroup(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean balanceRSGroup(String groupName) throws IOException {
        boolean balancerRan;
        LoadBalancer balancer;
        ServerManager serverManager = this.master.getServerManager();
        AssignmentManager assignmentManager = this.master.getAssignmentManager();
        LoadBalancer loadBalancer = balancer = this.master.getLoadBalancer();
        synchronized (loadBalancer) {
            if (this.getRSGroupInfo(groupName) == null) {
                throw new ConstraintException("Group does not exist: " + groupName);
            }
            Map<String, RegionState> groupRIT = this.rsGroupGetRegionsInTransition(groupName);
            if (groupRIT.size() > 0) {
                LOG.debug((Object)("Not running balancer because " + groupRIT.size() + " region(s) in transition: " + StringUtils.abbreviate((String)this.master.getAssignmentManager().getRegionStates().getRegionsInTransition().toString(), (int)256)));
                return false;
            }
            if (serverManager.areDeadServersInProgress()) {
                LOG.debug((Object)("Not running balancer because processing dead regionserver(s): " + serverManager.getDeadServers()));
                return false;
            }
            ArrayList plans = new ArrayList();
            for (Map.Entry<TableName, Map<ServerName, List<HRegionInfo>>> tableMap : this.getRSGroupAssignmentsByTable(groupName).entrySet()) {
                LOG.info((Object)("Creating partial plan for table " + tableMap.getKey() + ": " + tableMap.getValue()));
                List partialPlans = balancer.balanceCluster(tableMap.getValue());
                LOG.info((Object)("Partial plan for table " + tableMap.getKey() + ": " + partialPlans));
                if (partialPlans == null) continue;
                plans.addAll(partialPlans);
            }
            long startTime = System.currentTimeMillis();
            boolean bl = balancerRan = plans != null;
            if (plans != null && !plans.isEmpty()) {
                LOG.info((Object)("Group balance " + groupName + " starting with plan count: " + plans.size()));
                for (RegionPlan plan : plans) {
                    LOG.info((Object)("balance " + plan));
                    assignmentManager.balance(plan);
                }
                LOG.info((Object)("Group balance " + groupName + " completed after " + (System.currentTimeMillis() - startTime) + " seconds"));
            }
        }
        return balancerRan;
    }

    @Override
    public List<RSGroupInfo> listRSGroups() throws IOException {
        return this.getRSGroupInfoManager().listRSGroups();
    }

    @Override
    public RSGroupInfo getRSGroupOfServer(Address server) throws IOException {
        return this.getRSGroupInfoManager().getRSGroupOfServer(server);
    }

    @InterfaceAudience.Private
    public RSGroupInfoManager getRSGroupInfoManager() throws IOException {
        return this.rsGroupInfoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServers(Set<Address> servers) throws IOException {
        if (servers == null || servers.isEmpty()) {
            throw new ConstraintException("The set of servers to remove cannot be null or empty.");
        }
        RSGroupInfoManager rSGroupInfoManager = this.rsGroupInfoManager;
        synchronized (rSGroupInfoManager) {
            this.checkForDeadOrOnlineServers(servers);
            this.rsGroupInfoManager.removeServers(servers);
            LOG.info((Object)("Remove decommissioned servers " + servers + " from rsgroup done."));
        }
    }

    private Map<String, RegionState> rsGroupGetRegionsInTransition(String groupName) throws IOException {
        TreeMap rit = Maps.newTreeMap();
        AssignmentManager am = this.master.getAssignmentManager();
        RSGroupInfo RSGroupInfo2 = this.getRSGroupInfo(groupName);
        for (TableName tableName : RSGroupInfo2.getTables()) {
            for (HRegionInfo regionInfo : am.getRegionStates().getRegionsOfTable(tableName)) {
                RegionState state = this.master.getAssignmentManager().getRegionStates().getRegionTransitionState(regionInfo);
                if (state == null) continue;
                rit.put(regionInfo.getEncodedName(), state);
            }
        }
        return rit;
    }

    private Map<TableName, Map<ServerName, List<HRegionInfo>>> getRSGroupAssignmentsByTable(String groupName) throws IOException {
        HashMap result = Maps.newHashMap();
        RSGroupInfo RSGroupInfo2 = this.getRSGroupInfo(groupName);
        HashMap assignments = Maps.newHashMap();
        for (Map.Entry entry : this.master.getAssignmentManager().getRegionStates().getRegionAssignments().entrySet()) {
            TableName currTable = ((HRegionInfo)entry.getKey()).getTable();
            ServerName currServer = (ServerName)entry.getValue();
            HRegionInfo currRegion = (HRegionInfo)entry.getKey();
            if (!RSGroupInfo2.getTables().contains(currTable)) continue;
            if (!assignments.containsKey(((HRegionInfo)entry.getKey()).getTable())) {
                assignments.put(currTable, new HashMap());
            }
            if (!((Map)assignments.get(currTable)).containsKey(currServer)) {
                ((Map)assignments.get(currTable)).put(currServer, new ArrayList());
            }
            ((List)((Map)assignments.get(currTable)).get(currServer)).add(currRegion);
        }
        HashMap serverMap = Maps.newHashMap();
        for (ServerName serverName : this.master.getServerManager().getOnlineServers().keySet()) {
            if (!RSGroupInfo2.getServers().contains(serverName.getAddress())) continue;
            serverMap.put(serverName, Collections.emptyList());
        }
        for (TableName tableName : RSGroupInfo2.getTables()) {
            if (!assignments.containsKey(tableName)) continue;
            result.put(tableName, new HashMap());
            ((Map)result.get(tableName)).putAll(serverMap);
            ((Map)result.get(tableName)).putAll((Map)assignments.get(tableName));
            LOG.debug((Object)("Adding assignments for " + tableName + ": " + assignments.get(tableName)));
        }
        return result;
    }

    public void prepareRSGroupForTable(HTableDescriptor desc) throws IOException {
        RSGroupInfo RSGroupInfo2;
        String groupName = this.master.getTableNamespaceManager().get(desc.getTableName().getNamespaceAsString()).getConfigurationValue("hbase.rsgroup.name");
        if (groupName == null) {
            groupName = "default";
        }
        if ((RSGroupInfo2 = this.getRSGroupInfo(groupName)) == null) {
            throw new ConstraintException("RSGroup " + groupName + " does not exist.");
        }
        if (!RSGroupInfo2.containsTable(desc.getTableName())) {
            LOG.debug((Object)("Pre-moving table " + desc.getTableName() + " to rsgroup " + groupName));
            this.moveTables(Sets.newHashSet((Object[])new TableName[]{desc.getTableName()}), groupName);
        }
    }

    public void cleanupRSGroupForTable(TableName tableName) throws IOException {
        try {
            RSGroupInfo group = this.getRSGroupInfoOfTable(tableName);
            if (group != null) {
                LOG.debug((Object)("Removing deleted table from table rsgroup " + group.getName()));
                this.moveTables(Sets.newHashSet((Object[])new TableName[]{tableName}), null);
            }
        }
        catch (ConstraintException ex) {
            LOG.debug((Object)("Failed to perform rsgroup information cleanup for table: " + tableName), (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.debug((Object)("Failed to perform rsgroup information cleanup for table: " + tableName), (Throwable)ex);
        }
    }

    @Override
    public void moveServersAndTables(Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
        if (servers == null || servers.isEmpty()) {
            throw new ConstraintException("The list of servers to move cannot be null or empty.");
        }
        if (tables == null || tables.isEmpty()) {
            throw new ConstraintException("The list of tables to move cannot be null or empty.");
        }
        this.moveServers(servers, targetGroup);
        this.moveTables(tables, targetGroup);
    }

    @Override
    public void close() throws IOException {
    }

    private void checkForDeadOrOnlineServers(Set<Address> servers) throws ConstraintException {
        HashSet<Address> onlineServers = new HashSet<Address>();
        for (ServerName server : this.master.getServerManager().getOnlineServers().keySet()) {
            onlineServers.add(server.getAddress());
        }
        HashSet<Address> deadServers = new HashSet<Address>();
        for (ServerName server : this.master.getServerManager().getDeadServers().copyServerNames()) {
            deadServers.add(server.getAddress());
        }
        for (Address address : servers) {
            if (onlineServers.contains(address)) {
                throw new ConstraintException("Server " + address + " is an online server, not allowed to remove.");
            }
            if (!deadServers.contains(address)) continue;
            throw new ConstraintException("Server " + address + " is on the dead servers list," + " Maybe it will come back again, not allowed to remove.");
        }
    }
}

