/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableStateManager;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.protobuf.generated.RSGroupProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupProtobufUtil;
import org.apache.hadoop.hbase.rsgroup.RSGroupSerDe;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class RSGroupInfoManagerImpl
implements RSGroupInfoManager,
ServerListener {
    private static final Log LOG = LogFactory.getLog(RSGroupInfoManagerImpl.class);
    private static final HTableDescriptor RSGROUP_TABLE_DESC = new HTableDescriptor(RSGROUP_TABLE_NAME);
    private volatile Map<String, RSGroupInfo> rsGroupMap = Collections.emptyMap();
    private volatile Map<TableName, String> tableMap = Collections.emptyMap();
    private MasterServices master;
    private ClusterConnection conn;
    private ZooKeeperWatcher watcher;
    private RSGroupStartupWorker rsGroupStartupWorker;
    private volatile Set<String> prevRSGroups;
    private RSGroupSerDe rsGroupSerDe = new RSGroupSerDe();
    private DefaultServerUpdater defaultServerUpdater;
    private FailedOpenUpdater failedOpenUpdater;
    private boolean isInit = false;

    public RSGroupInfoManagerImpl(MasterServices master) throws IOException {
        this.master = master;
        this.watcher = master.getZooKeeper();
        this.conn = master.getConnection();
        this.prevRSGroups = new HashSet<String>();
    }

    public void init() throws IOException {
        this.rsGroupStartupWorker = new RSGroupStartupWorker(this, this.master, this.conn);
        this.refresh();
        this.defaultServerUpdater = new DefaultServerUpdater(this);
        Threads.setDaemonThreadRunning((Thread)this.defaultServerUpdater);
        this.failedOpenUpdater = new FailedOpenUpdater(this);
        Threads.setDaemonThreadRunning((Thread)this.failedOpenUpdater);
        this.master.getServerManager().registerListener((ServerListener)this);
        this.isInit = true;
    }

    boolean isInit() {
        return this.isInit;
    }

    @Override
    public void start() {
        this.rsGroupStartupWorker.start();
    }

    @Override
    public synchronized void addRSGroup(RSGroupInfo rsGroupInfo) throws IOException {
        this.checkGroupName(rsGroupInfo.getName());
        if (this.rsGroupMap.get(rsGroupInfo.getName()) != null || rsGroupInfo.getName().equals("default")) {
            throw new DoNotRetryIOException("Group already exists: " + rsGroupInfo.getName());
        }
        HashMap newGroupMap = Maps.newHashMap(this.rsGroupMap);
        newGroupMap.put(rsGroupInfo.getName(), rsGroupInfo);
        this.flushConfig(newGroupMap);
    }

    @Override
    public synchronized Set<Address> moveServers(Set<Address> servers, String srcGroup, String dstGroup) throws IOException {
        if (servers == null) {
            throw new ConstraintException("The list of servers to move cannot be null.");
        }
        HashSet movedServers = Sets.newHashSet();
        if (!this.rsGroupMap.containsKey(srcGroup)) {
            throw new DoNotRetryIOException("Group " + srcGroup + " does not exist");
        }
        if (!this.rsGroupMap.containsKey(dstGroup)) {
            throw new DoNotRetryIOException("Group " + dstGroup + " does not exist");
        }
        RSGroupInfo src = new RSGroupInfo(this.getRSGroup(srcGroup));
        RSGroupInfo dst = new RSGroupInfo(this.getRSGroup(dstGroup));
        for (Address el : servers) {
            if (src.removeServer(el)) {
                movedServers.add(el);
            }
            dst.addServer(el);
        }
        HashMap newGroupMap = Maps.newHashMap(this.rsGroupMap);
        newGroupMap.put(src.getName(), src);
        newGroupMap.put(dst.getName(), dst);
        this.flushConfig(newGroupMap);
        return movedServers;
    }

    @Override
    public RSGroupInfo getRSGroupOfServer(Address server) throws IOException {
        for (RSGroupInfo info : this.rsGroupMap.values()) {
            if (!info.containsServer(server)) continue;
            return info;
        }
        return null;
    }

    @Override
    public RSGroupInfo getRSGroup(String groupName) throws IOException {
        return this.rsGroupMap.get(groupName);
    }

    @Override
    public String getRSGroupOfTable(TableName tableName) throws IOException {
        return this.tableMap.get(tableName);
    }

    @Override
    public synchronized void moveTables(Set<TableName> tableNames, String groupName) throws IOException {
        if (groupName != null && !this.rsGroupMap.containsKey(groupName)) {
            throw new DoNotRetryIOException("Group " + groupName + " does not exist");
        }
        HashMap newGroupMap = Maps.newHashMap(this.rsGroupMap);
        for (TableName tableName : tableNames) {
            if (this.tableMap.containsKey(tableName)) {
                RSGroupInfo src = new RSGroupInfo((RSGroupInfo)newGroupMap.get(this.tableMap.get(tableName)));
                src.removeTable(tableName);
                newGroupMap.put(src.getName(), src);
            }
            if (groupName == null) continue;
            RSGroupInfo dst = new RSGroupInfo((RSGroupInfo)newGroupMap.get(groupName));
            dst.addTable(tableName);
            newGroupMap.put(dst.getName(), dst);
        }
        this.flushConfig(newGroupMap);
    }

    @Override
    public synchronized void removeRSGroup(String groupName) throws IOException {
        if (!this.rsGroupMap.containsKey(groupName) || groupName.equals("default")) {
            throw new DoNotRetryIOException("Group " + groupName + " does not exist or is a reserved group");
        }
        HashMap newGroupMap = Maps.newHashMap(this.rsGroupMap);
        newGroupMap.remove(groupName);
        this.flushConfig(newGroupMap);
    }

    @Override
    public List<RSGroupInfo> listRSGroups() throws IOException {
        LinkedList list = Lists.newLinkedList(this.rsGroupMap.values());
        return list;
    }

    @Override
    public boolean isOnline() {
        return this.rsGroupStartupWorker.isOnline();
    }

    @Override
    public synchronized void refresh() throws IOException {
        this.refresh(false);
    }

    private synchronized void refresh(boolean forceOnline) throws IOException {
        LinkedList<RSGroupInfo> groupList = new LinkedList<RSGroupInfo>();
        if (forceOnline || this.isOnline()) {
            LOG.debug((Object)"Refreshing in Online mode.");
            try (HTableInterface rsGroupTable = this.conn.getTable(RSGROUP_TABLE_NAME);){
                groupList.addAll(this.rsGroupSerDe.retrieveGroupList((Table)rsGroupTable));
            }
        } else {
            LOG.debug((Object)"Refreshing in Offline mode.");
            String groupBasePath = ZKUtil.joinZNode((String)this.watcher.baseZNode, (String)"rsgroup");
            groupList.addAll(this.rsGroupSerDe.retrieveGroupList(this.watcher, groupBasePath));
        }
        TreeSet<TableName> orphanTables = new TreeSet<TableName>();
        for (String entry : this.master.getTableDescriptors().getAll().keySet()) {
            orphanTables.add(TableName.valueOf((String)entry));
        }
        for (RSGroupInfo group : groupList) {
            if (group.getName().equals("default")) continue;
            orphanTables.removeAll(group.getTables());
        }
        groupList.add(new RSGroupInfo("default", Sets.newHashSet(this.getDefaultServers()), orphanTables));
        HashMap newGroupMap = Maps.newHashMap();
        HashMap newTableMap = Maps.newHashMap();
        for (RSGroupInfo group : groupList) {
            newGroupMap.put(group.getName(), group);
            for (TableName table : group.getTables()) {
                newTableMap.put(table, group.getName());
            }
        }
        this.rsGroupMap = Collections.unmodifiableMap(newGroupMap);
        this.tableMap = Collections.unmodifiableMap(newTableMap);
        this.prevRSGroups.clear();
        this.prevRSGroups.addAll(this.rsGroupMap.keySet());
    }

    private synchronized Map<TableName, String> flushConfigTable(Map<String, RSGroupInfo> newGroupMap) throws IOException {
        HashMap newTableMap = Maps.newHashMap();
        ArrayList mutations = Lists.newArrayList();
        for (String groupName : this.prevRSGroups) {
            if (newGroupMap.containsKey(groupName)) continue;
            Delete d = new Delete(Bytes.toBytes((String)groupName));
            mutations.add(d);
        }
        for (RSGroupInfo RSGroupInfo2 : newGroupMap.values()) {
            RSGroupProtos.RSGroupInfo proto = RSGroupProtobufUtil.toProtoGroupInfo(RSGroupInfo2);
            Put p = new Put(Bytes.toBytes((String)RSGroupInfo2.getName()));
            p.addColumn(META_FAMILY_BYTES, META_QUALIFIER_BYTES, proto.toByteArray());
            mutations.add(p);
            for (TableName entry : RSGroupInfo2.getTables()) {
                newTableMap.put(entry, RSGroupInfo2.getName());
            }
        }
        if (mutations.size() > 0) {
            this.multiMutate(mutations);
        }
        return newTableMap;
    }

    private synchronized void flushConfig(Map<String, RSGroupInfo> newGroupMap) throws IOException {
        if (!this.isOnline()) {
            HashMap m = Maps.newHashMap(this.rsGroupMap);
            RSGroupInfo oldDefaultGroup = (RSGroupInfo)m.remove("default");
            RSGroupInfo newDefaultGroup = newGroupMap.remove("default");
            if (!m.equals(newGroupMap) || !oldDefaultGroup.getTables().equals(newDefaultGroup.getTables())) {
                throw new IOException("Only default servers can be updated during offline mode");
            }
            newGroupMap.put("default", newDefaultGroup);
            this.rsGroupMap = newGroupMap;
            return;
        }
        Map<TableName, String> newTableMap = this.flushConfigTable(newGroupMap);
        this.rsGroupMap = Collections.unmodifiableMap(newGroupMap);
        this.tableMap = Collections.unmodifiableMap(newTableMap);
        try {
            String znode;
            String groupBasePath = ZKUtil.joinZNode((String)this.watcher.baseZNode, (String)"rsgroup");
            ZKUtil.createAndFailSilent((ZooKeeperWatcher)this.watcher, (String)groupBasePath, (byte[])ProtobufUtil.PB_MAGIC);
            ArrayList<ZKUtil.ZKUtilOp> zkOps = new ArrayList<ZKUtil.ZKUtilOp>(newGroupMap.size());
            for (String groupName : this.prevRSGroups) {
                if (newGroupMap.containsKey(groupName)) continue;
                znode = ZKUtil.joinZNode((String)groupBasePath, (String)groupName);
                zkOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)znode));
            }
            for (RSGroupInfo RSGroupInfo2 : newGroupMap.values()) {
                znode = ZKUtil.joinZNode((String)groupBasePath, (String)RSGroupInfo2.getName());
                RSGroupProtos.RSGroupInfo proto = RSGroupProtobufUtil.toProtoGroupInfo(RSGroupInfo2);
                LOG.debug((Object)("Updating znode: " + znode));
                ZKUtil.createAndFailSilent((ZooKeeperWatcher)this.watcher, (String)znode);
                zkOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)znode));
                zkOps.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)znode, (byte[])ProtobufUtil.prependPBMagic((byte[])proto.toByteArray())));
            }
            LOG.debug((Object)("Writing ZK GroupInfo count: " + zkOps.size()));
            ZKUtil.multiOrSequential((ZooKeeperWatcher)this.watcher, zkOps, (boolean)false);
        }
        catch (KeeperException e) {
            LOG.error((Object)"Failed to write to rsGroupZNode", (Throwable)e);
            this.master.abort("Failed to write to rsGroupZNode", (Throwable)e);
            throw new IOException("Failed to write to rsGroupZNode", e);
        }
        this.prevRSGroups.clear();
        this.prevRSGroups.addAll(newGroupMap.keySet());
    }

    private List<ServerName> getOnlineRS() throws IOException {
        if (this.master != null) {
            return this.master.getServerManager().getOnlineServersList();
        }
        try {
            LOG.debug((Object)"Reading online RS from zookeeper");
            LinkedList<ServerName> servers = new LinkedList<ServerName>();
            for (String el : ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.watcher, (String)this.watcher.rsZNode)) {
                servers.add(ServerName.parseServerName((String)el));
            }
            return servers;
        }
        catch (KeeperException e) {
            throw new IOException("Failed to retrieve server list from zookeeper", e);
        }
    }

    private List<Address> getDefaultServers() throws IOException {
        LinkedList<Address> defaultServers = new LinkedList<Address>();
        for (ServerName server : this.getOnlineRS()) {
            Address address = Address.fromParts((String)server.getHostname(), (int)server.getPort());
            boolean found = false;
            for (RSGroupInfo info : this.rsGroupMap.values()) {
                if ("default".equals(info.getName()) || !info.containsServer(address)) continue;
                found = true;
                break;
            }
            if (found) continue;
            defaultServers.add(address);
        }
        return defaultServers;
    }

    private synchronized void updateDefaultServers(Set<Address> server) throws IOException {
        RSGroupInfo info = this.rsGroupMap.get("default");
        RSGroupInfo newInfo = new RSGroupInfo(info.getName(), server, info.getTables());
        HashMap newGroupMap = Maps.newHashMap(this.rsGroupMap);
        newGroupMap.put(newInfo.getName(), newInfo);
        this.flushConfig(newGroupMap);
    }

    public void serverAdded(ServerName serverName) {
        this.defaultServerUpdater.serverChanged();
        this.failedOpenUpdater.serverChanged();
    }

    public void serverRemoved(ServerName serverName) {
        this.defaultServerUpdater.serverChanged();
    }

    public void waiting() {
    }

    private void createGroupTable(MasterServices masterServices) throws IOException {
        int tries;
        HRegionInfo[] newRegions = ModifyRegionUtils.createHRegionInfos((HTableDescriptor)RSGROUP_TABLE_DESC, (byte[][])null);
        ProcedurePrepareLatch latch = ProcedurePrepareLatch.createLatch();
        masterServices.getMasterProcedureExecutor().submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)masterServices.getMasterProcedureExecutor().getEnvironment(), RSGROUP_TABLE_DESC, newRegions, latch));
        latch.await();
        for (tries = 600; masterServices.getAssignmentManager().getRegionStates().getRegionServerOfRegion(newRegions[0]) == null && tries > 0; --tries) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                throw new IOException("Wait interrupted", e);
            }
        }
        if (tries <= 0) {
            throw new IOException("Failed to create group table.");
        }
    }

    private void multiMutate(List<Mutation> mutations) throws IOException {
        MultiRowMutationProtos.MutateRowsRequest.Builder mrmBuilder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
        for (Mutation mutation : mutations) {
            if (mutation instanceof Put) {
                mrmBuilder.addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)mutation));
                continue;
            }
            if (mutation instanceof Delete) {
                mrmBuilder.addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.DELETE, (Mutation)mutation));
                continue;
            }
            throw new DoNotRetryIOException("multiMutate doesn't support " + mutation.getClass().getName());
        }
        MultiRowMutationProtos.MutateRowsRequest mrm = mrmBuilder.build();
        this.conn.clearRegionCache(RSGROUP_TABLE_NAME);
        try (HTableInterface rsGroupTable = this.conn.getTable(RSGROUP_TABLE_NAME);){
            CoprocessorRpcChannel channel = rsGroupTable.coprocessorService(ROW_KEY);
            MultiRowMutationProtos.MultiRowMutationService.BlockingInterface service = MultiRowMutationProtos.MultiRowMutationService.newBlockingStub((BlockingRpcChannel)channel);
            try {
                service.mutateRows(null, mrm);
            }
            catch (ServiceException ex) {
                ProtobufUtil.toIOException((ServiceException)ex);
            }
        }
    }

    private void checkGroupName(String groupName) throws ConstraintException {
        if (!groupName.matches("[a-zA-Z0-9_]+")) {
            throw new ConstraintException("Group name should only contain alphanumeric characters");
        }
    }

    @Override
    public void moveServersAndTables(Set<Address> servers, Set<TableName> tables, String srcGroup, String dstGroup) throws IOException {
        RSGroupInfo srcGroupInfo = this.getRSGroup(srcGroup);
        RSGroupInfo dstGroupInfo = this.getRSGroup(dstGroup);
        for (Address el : servers) {
            srcGroupInfo.removeServer(el);
            dstGroupInfo.addServer(el);
        }
        for (TableName tableName : tables) {
            srcGroupInfo.removeTable(tableName);
            dstGroupInfo.addTable(tableName);
        }
        HashMap newGroupMap = Maps.newHashMap(this.rsGroupMap);
        newGroupMap.put(srcGroupInfo.getName(), srcGroupInfo);
        newGroupMap.put(dstGroupInfo.getName(), dstGroupInfo);
        this.flushConfig(newGroupMap);
    }

    @Override
    public synchronized void removeServers(Set<Address> servers) throws IOException {
        HashMap<String, RSGroupInfo> rsGroupInfos = new HashMap<String, RSGroupInfo>();
        for (Address el : servers) {
            RSGroupInfo rsGroupInfo = this.getRSGroupOfServer(el);
            if (rsGroupInfo != null) {
                RSGroupInfo newRsGroupInfo = (RSGroupInfo)rsGroupInfos.get(rsGroupInfo.getName());
                if (newRsGroupInfo == null) {
                    rsGroupInfo.removeServer(el);
                    rsGroupInfos.put(rsGroupInfo.getName(), rsGroupInfo);
                    continue;
                }
                newRsGroupInfo.removeServer(el);
                rsGroupInfos.put(newRsGroupInfo.getName(), newRsGroupInfo);
                continue;
            }
            LOG.warn((Object)("Server " + el + " does not belong to any rsgroup."));
        }
        if (rsGroupInfos.size() > 0) {
            HashMap newGroupMap = Maps.newHashMap(this.rsGroupMap);
            newGroupMap.putAll(rsGroupInfos);
            this.flushConfig(newGroupMap);
        }
    }

    static {
        RSGROUP_TABLE_DESC.addFamily(new HColumnDescriptor(META_FAMILY_BYTES));
        RSGROUP_TABLE_DESC.setRegionSplitPolicyClassName(DisabledRegionSplitPolicy.class.getName());
        try {
            RSGROUP_TABLE_DESC.addCoprocessor(MultiRowMutationEndpoint.class.getName(), null, 0x1FFFFFFF, null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class RSGroupStartupWorker
    extends Thread {
        private static final Log LOG = LogFactory.getLog(RSGroupStartupWorker.class);
        private volatile boolean isOnline = false;
        private MasterServices masterServices;
        private RSGroupInfoManagerImpl groupInfoManager;
        private ClusterConnection conn;

        public RSGroupStartupWorker(RSGroupInfoManagerImpl groupInfoManager, MasterServices masterServices, ClusterConnection conn) {
            this.masterServices = masterServices;
            this.groupInfoManager = groupInfoManager;
            this.conn = conn;
            this.setName(RSGroupStartupWorker.class.getName() + "-" + masterServices.getServerName());
            this.setDaemon(true);
        }

        @Override
        public void run() {
            if (this.waitForGroupTableOnline()) {
                LOG.info((Object)"GroupBasedLoadBalancer is now online");
            }
        }

        public boolean waitForGroupTableOnline() {
            final LinkedList foundRegions = new LinkedList();
            final LinkedList assignedRegions = new LinkedList();
            final AtomicBoolean found = new AtomicBoolean(false);
            final TableStateManager tsm = this.masterServices.getAssignmentManager().getTableStateManager();
            boolean createSent = false;
            while (!found.get() && this.isMasterRunning()) {
                foundRegions.clear();
                assignedRegions.clear();
                found.set(true);
                try {
                    boolean rootMetaFound = this.masterServices.getMetaTableLocator().verifyMetaRegionLocation((HConnection)this.conn, this.masterServices.getZooKeeper(), 1L);
                    final AtomicBoolean nsFound = new AtomicBoolean(false);
                    if (rootMetaFound) {
                        MetaTableAccessor.Visitor visitor = new MetaTableAccessor.Visitor(){

                            public boolean visit(Result row) throws IOException {
                                HRegionInfo info = MetaTableAccessor.getHRegionInfo((Result)row);
                                if (info != null) {
                                    Cell serverCell = row.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                                    if (RSGroupInfoManager.RSGROUP_TABLE_NAME.equals((Object)info.getTable()) && serverCell != null) {
                                        ServerName sn = ServerName.parseVersionedServerName((byte[])CellUtil.cloneValue((Cell)serverCell));
                                        if (sn == null) {
                                            found.set(false);
                                        } else if (tsm.isTableState(RSGroupInfoManager.RSGROUP_TABLE_NAME, new ZooKeeperProtos.Table.State[]{ZooKeeperProtos.Table.State.ENABLED})) {
                                            try {
                                                ClientProtos.ClientService.BlockingInterface rs = RSGroupStartupWorker.this.conn.getClient(sn);
                                                ClientProtos.GetRequest request = RequestConverter.buildGetRequest((byte[])info.getRegionName(), (Get)new Get(RSGroupInfoManager.ROW_KEY));
                                                rs.get(null, request);
                                                assignedRegions.add(info);
                                            }
                                            catch (Exception ex) {
                                                LOG.debug((Object)"Caught exception while verifying group region", (Throwable)ex);
                                            }
                                        }
                                        foundRegions.add(info);
                                    }
                                    if (TableName.NAMESPACE_TABLE_NAME.equals((Object)info.getTable())) {
                                        Cell cell = row.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                                        ServerName sn = null;
                                        if (cell != null) {
                                            sn = ServerName.parseVersionedServerName((byte[])CellUtil.cloneValue((Cell)cell));
                                        }
                                        if (sn == null) {
                                            nsFound.set(false);
                                        } else if (tsm.isTableState(TableName.NAMESPACE_TABLE_NAME, new ZooKeeperProtos.Table.State[]{ZooKeeperProtos.Table.State.ENABLED})) {
                                            try {
                                                ClientProtos.ClientService.BlockingInterface rs = RSGroupStartupWorker.this.conn.getClient(sn);
                                                ClientProtos.GetRequest request = RequestConverter.buildGetRequest((byte[])info.getRegionName(), (Get)new Get(RSGroupInfoManager.ROW_KEY));
                                                rs.get(null, request);
                                                nsFound.set(true);
                                            }
                                            catch (Exception ex) {
                                                LOG.debug((Object)"Caught exception while verifying group region", (Throwable)ex);
                                            }
                                        }
                                    }
                                }
                                return true;
                            }
                        };
                        MetaTableAccessor.fullScan((Connection)this.conn, (MetaTableAccessor.Visitor)visitor);
                        if (foundRegions.size() < 1 && rootMetaFound && !createSent && nsFound.get()) {
                            this.groupInfoManager.createGroupTable(this.masterServices);
                            createSent = true;
                        }
                        LOG.info((Object)("Group table: " + RSGroupInfoManager.RSGROUP_TABLE_NAME + " isOnline: " + found.get() + ", regionCount: " + foundRegions.size() + ", assignCount: " + assignedRegions.size() + ", rootMetaFound: " + rootMetaFound));
                        found.set(found.get() && assignedRegions.size() == foundRegions.size() && foundRegions.size() > 0);
                    } else {
                        LOG.info((Object)"Waiting for catalog tables to come online");
                        found.set(false);
                    }
                    if (found.get()) {
                        LOG.debug((Object)"With group table online, refreshing cached information.");
                        this.groupInfoManager.refresh(true);
                        this.isOnline = true;
                        this.groupInfoManager.flushConfig(this.groupInfoManager.rsGroupMap);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    found.set(false);
                    LOG.warn((Object)"Failed to perform check", (Throwable)e);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"Sleep interrupted", (Throwable)e);
                }
            }
            return found.get();
        }

        public boolean isOnline() {
            return this.isOnline;
        }

        private boolean isMasterRunning() {
            return !this.masterServices.isAborted() && !this.masterServices.isStopped();
        }
    }

    private static class FailedOpenUpdater
    extends Thread {
        private static final Log LOG = LogFactory.getLog(FailedOpenUpdater.class);
        private final RSGroupInfoManagerImpl mgr;
        private final long waitInterval;
        private volatile boolean hasChanged = false;

        public FailedOpenUpdater(RSGroupInfoManagerImpl mgr) {
            this.mgr = mgr;
            this.waitInterval = mgr.master.getConfiguration().getLong("hbase.rsgroup.reassign.wait", 30000L);
            this.setName(FailedOpenUpdater.class.getName() + "-" + mgr.master.getServerName());
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.mgr.master.isAborted() && !this.mgr.master.isStopped()) {
                boolean interrupted = false;
                try {
                    FailedOpenUpdater failedOpenUpdater = this;
                    synchronized (failedOpenUpdater) {
                        while (!this.hasChanged) {
                            this.wait();
                        }
                        this.hasChanged = false;
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted", (Throwable)e);
                    interrupted = true;
                }
                if (this.mgr.master.isAborted() || this.mgr.master.isStopped() || interrupted) continue;
                try {
                    Thread.sleep(this.waitInterval);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted", (Throwable)e);
                }
                if (this.mgr.master.isAborted() || this.mgr.master.isStopped()) continue;
                ArrayList failedAssignments = Lists.newArrayList();
                for (RegionState state : this.mgr.master.getAssignmentManager().getRegionStates().getRegionsInTransition()) {
                    if (!state.isFailedOpen()) continue;
                    failedAssignments.add(state.getRegion());
                }
                for (HRegionInfo region : failedAssignments) {
                    LOG.info((Object)("Retrying assignment of " + region));
                    this.mgr.master.getAssignmentManager().unassign(region);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serverChanged() {
            FailedOpenUpdater failedOpenUpdater = this;
            synchronized (failedOpenUpdater) {
                this.hasChanged = true;
                this.notify();
            }
        }
    }

    private static class DefaultServerUpdater
    extends Thread {
        private static final Log LOG = LogFactory.getLog(DefaultServerUpdater.class);
        private RSGroupInfoManagerImpl mgr;
        private volatile boolean hasChanged = false;

        public DefaultServerUpdater(RSGroupInfoManagerImpl mgr) {
            this.mgr = mgr;
            this.setName(DefaultServerUpdater.class.getName() + "-" + mgr.master.getServerName());
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List prevDefaultServers = new LinkedList();
            while (!this.mgr.master.isAborted() && !this.mgr.master.isStopped()) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Updating default servers");
                    }
                    List servers = this.mgr.getDefaultServers();
                    Collections.sort(servers, new Comparator<Address>(){

                        @Override
                        public int compare(Address o1, Address o2) {
                            int diff = o1.getHostname().compareTo(o2.getHostname());
                            if (diff != 0) {
                                return diff;
                            }
                            return o1.getPort() - o2.getPort();
                        }
                    });
                    if (!servers.equals(prevDefaultServers)) {
                        this.mgr.updateDefaultServers(Sets.newHashSet((Iterable)servers));
                        prevDefaultServers = servers;
                        LOG.info((Object)("Updated with servers: " + servers.size()));
                    }
                    try {
                        DefaultServerUpdater defaultServerUpdater = this;
                        synchronized (defaultServerUpdater) {
                            while (!this.hasChanged) {
                                this.wait();
                            }
                            this.hasChanged = false;
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)"Interrupted", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)"Failed to update default servers", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serverChanged() {
            DefaultServerUpdater defaultServerUpdater = this;
            synchronized (defaultServerUpdater) {
                this.hasChanged = true;
                this.notify();
            }
        }
    }
}

