/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRSGroupsAdmin1
extends TestRSGroupsBase {
    protected static final Log LOG = LogFactory.getLog(TestRSGroupsAdmin1.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestRSGroupsAdmin1.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsAdmin1.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testValidGroupNames() throws IOException {
        String[] badNames = new String[]{"foo*", "foo@", "-"};
        String[] goodNames = new String[]{"foo_123"};
        for (String entry : badNames) {
            try {
                rsGroupAdmin.addRSGroup(entry);
                Assert.fail((String)("Expected a constraint exception for: " + entry));
            }
            catch (ConstraintException constraintException) {
                // empty catch block
            }
        }
        for (String entry : goodNames) {
            rsGroupAdmin.addRSGroup(entry);
        }
    }

    @Test
    public void testBogusArgs() throws Exception {
        Assert.assertNull((Object)rsGroupAdmin.getRSGroupInfoOfTable(TableName.valueOf((String)"nonexistent")));
        Assert.assertNull((Object)rsGroupAdmin.getRSGroupOfServer(Address.fromParts((String)"bogus", (int)123)));
        Assert.assertNull((Object)rsGroupAdmin.getRSGroupInfo("bogus"));
        try {
            rsGroupAdmin.removeRSGroup("bogus");
            Assert.fail((String)"Expected removing bogus group to fail");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
        try {
            rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{TableName.valueOf((String)"bogustable")}), "bogus");
            Assert.fail((String)"Expected move with bogus group to fail");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
        try {
            rsGroupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{Address.fromParts((String)"bogus", (int)123)}), "bogus");
            Assert.fail((String)"Expected move with bogus group to fail");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
        try {
            rsGroupAdmin.balanceRSGroup("bogus");
            Assert.fail((String)"Expected move with bogus group to fail");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    @Test
    public void testNamespaceConstraint() throws Exception {
        String nsName = "Group_foo";
        String groupName = "Group_foo";
        LOG.info((Object)"testNamespaceConstraint");
        rsGroupAdmin.addRSGroup(groupName);
        Assert.assertTrue((boolean)TestRSGroupsAdmin1.observer.preAddRSGroupCalled);
        Assert.assertTrue((boolean)TestRSGroupsAdmin1.observer.postAddRSGroupCalled);
        admin.createNamespace(NamespaceDescriptor.create((String)nsName).addConfiguration("hbase.rsgroup.name", groupName).build());
        try {
            rsGroupAdmin.removeRSGroup(groupName);
            Assert.fail((String)"Expected a constraint exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        admin.modifyNamespace(NamespaceDescriptor.create((String)nsName).addConfiguration("hbase.rsgroup.name", groupName).build());
        String anotherGroup = "Group_anotherGroup";
        rsGroupAdmin.addRSGroup(anotherGroup);
        admin.deleteNamespace(nsName);
        rsGroupAdmin.removeRSGroup(groupName);
        Assert.assertTrue((boolean)TestRSGroupsAdmin1.observer.preRemoveRSGroupCalled);
        Assert.assertTrue((boolean)TestRSGroupsAdmin1.observer.postRemoveRSGroupCalled);
        try {
            admin.createNamespace(NamespaceDescriptor.create((String)nsName).addConfiguration("hbase.rsgroup.name", "foo").build());
            Assert.fail((String)"Expected a constraint exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGroupInfoMultiAccessing() throws Exception {
        RSGroupInfoManager manager = RSGroupAdminEndpoint.getGroupInfoManager();
        RSGroupInfo defaultGroup = manager.getRSGroup("default");
        Iterator it = defaultGroup.getServers().iterator();
        manager.getRSGroup("default");
        it.next();
    }

    @Test
    public void testFailRemoveGroup() throws IOException, InterruptedException {
        LOG.info((Object)"testFailRemoveGroup");
        int initNumGroups = rsGroupAdmin.listRSGroups().size();
        this.addGroup(rsGroupAdmin, "bar", 3);
        TableName tableName = TableName.valueOf((String)"Group_my_table");
        TEST_UTIL.createTable(tableName, Bytes.toBytes((String)"f"));
        rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{tableName}), "bar");
        RSGroupInfo barGroup = rsGroupAdmin.getRSGroupInfo("bar");
        try {
            rsGroupAdmin.removeRSGroup(barGroup.getName());
            Assert.fail((String)"Expected remove group to fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            rsGroupAdmin.moveServers(barGroup.getServers(), "default");
            Assert.fail((String)"Expected move servers to fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        rsGroupAdmin.moveTables((Set)barGroup.getTables(), "default");
        try {
            rsGroupAdmin.removeRSGroup(barGroup.getName());
            Assert.fail((String)"Expected move servers to fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        rsGroupAdmin.moveServers(barGroup.getServers(), "default");
        rsGroupAdmin.removeRSGroup(barGroup.getName());
        Assert.assertEquals((long)initNumGroups, (long)rsGroupAdmin.listRSGroups().size());
    }

    @Test
    public void testMultiTableMove() throws Exception {
        LOG.info((Object)"testMultiTableMove");
        final TableName tableNameA = TableName.valueOf((String)"Group_testMultiTableMoveA");
        final TableName tableNameB = TableName.valueOf((String)"Group_testMultiTableMoveB");
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        String newGroupName = this.getGroupName("testMultiTableMove");
        RSGroupInfo newGroup = this.addGroup(rsGroupAdmin, newGroupName, 1);
        TEST_UTIL.createTable(tableNameA, familyNameBytes);
        TEST_UTIL.createTable(tableNameB, familyNameBytes);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regionsA = TestRSGroupsAdmin1.this.getTableRegionMap().get(tableNameA);
                if (regionsA == null) {
                    return false;
                }
                List<String> regionsB = TestRSGroupsAdmin1.this.getTableRegionMap().get(tableNameB);
                if (regionsB == null) {
                    return false;
                }
                return TestRSGroupsAdmin1.this.getTableRegionMap().get(tableNameA).size() >= 1 && TestRSGroupsAdmin1.this.getTableRegionMap().get(tableNameB).size() >= 1;
            }
        });
        RSGroupInfo tableGrpA = rsGroupAdmin.getRSGroupInfoOfTable(tableNameA);
        Assert.assertTrue((boolean)tableGrpA.getName().equals("default"));
        RSGroupInfo tableGrpB = rsGroupAdmin.getRSGroupInfoOfTable(tableNameB);
        Assert.assertTrue((boolean)tableGrpB.getName().equals("default"));
        LOG.info((Object)("Moving table [" + tableNameA + "," + tableNameB + "] to " + newGroup.getName()));
        rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{tableNameA, tableNameB}), newGroup.getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)rsGroupAdmin.getRSGroupInfoOfTable(tableNameA).getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)rsGroupAdmin.getRSGroupInfoOfTable(tableNameB).getName());
        NavigableSet DefaultTables = rsGroupAdmin.getRSGroupInfo("default").getTables();
        Assert.assertFalse((boolean)DefaultTables.contains(tableNameA));
        Assert.assertFalse((boolean)DefaultTables.contains(tableNameB));
        NavigableSet newGroupTables = rsGroupAdmin.getRSGroupInfo(newGroupName).getTables();
        Assert.assertTrue((boolean)newGroupTables.contains(tableNameA));
        Assert.assertTrue((boolean)newGroupTables.contains(tableNameB));
    }

    @Test
    public void testTableMoveTruncateAndDrop() throws Exception {
        LOG.info((Object)"testTableMove");
        final TableName tableName = TableName.valueOf((String)"Group_testTableMoveAndDrop");
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        String newGroupName = this.getGroupName("testTableMove");
        final RSGroupInfo newGroup = this.addGroup(rsGroupAdmin, newGroupName, 2);
        TEST_UTIL.createMultiRegionTable(tableName, familyNameBytes, 5);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsAdmin1.this.getTableRegionMap().get(tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsAdmin1.this.getTableRegionMap().get(tableName).size() >= 5;
            }
        });
        RSGroupInfo tableGrp = rsGroupAdmin.getRSGroupInfoOfTable(tableName);
        Assert.assertTrue((boolean)tableGrp.getName().equals("default"));
        LOG.info((Object)("Moving table " + tableName + " to " + newGroup.getName()));
        rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{tableName}), newGroup.getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)rsGroupAdmin.getRSGroupInfoOfTable(tableName).getName());
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Map<ServerName, List<String>> serverMap = TestRSGroupsAdmin1.this.getTableServerRegionMap().get(tableName);
                int count = 0;
                if (serverMap != null) {
                    for (ServerName rs : serverMap.keySet()) {
                        if (!newGroup.containsServer(rs.getAddress())) continue;
                        count += serverMap.get(rs).size();
                    }
                }
                return count == 5;
            }
        });
        admin.disableTable(tableName);
        admin.truncateTable(tableName, true);
        Assert.assertEquals((long)1L, (long)rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getTables().size());
        Assert.assertEquals((Object)tableName, rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getTables().first());
        TEST_UTIL.deleteTable(tableName);
        Assert.assertEquals((long)0L, (long)rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getTables().size());
        Assert.assertTrue((boolean)TestRSGroupsAdmin1.observer.preMoveTablesCalled);
        Assert.assertTrue((boolean)TestRSGroupsAdmin1.observer.postMoveTablesCalled);
    }

    @Test
    public void testDisabledTableMove() throws Exception {
        final TableName tableName = TableName.valueOf((String)"Group_testDisabledTableMove");
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        String newGroupName = this.getGroupName("testDisabledTableMove");
        RSGroupInfo newGroup = this.addGroup(rsGroupAdmin, newGroupName, 2);
        TEST_UTIL.createMultiRegionTable(tableName, familyNameBytes, 5);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsAdmin1.this.getTableRegionMap().get(tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsAdmin1.this.getTableRegionMap().get(tableName).size() >= 5;
            }
        });
        RSGroupInfo tableGrp = rsGroupAdmin.getRSGroupInfoOfTable(tableName);
        Assert.assertTrue((boolean)tableGrp.getName().equals("default"));
        admin.disableTable(tableName);
        LOG.info((Object)("Moving table " + tableName + " to " + newGroup.getName()));
        rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{tableName}), newGroup.getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)rsGroupAdmin.getRSGroupInfoOfTable(tableName).getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRSGroupListDoesNotContainFailedTableCreation() throws Exception {
        this.toggleQuotaCheckAndRestartMiniCluster(true);
        String nsp = "np1";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxregions", "5").addConfiguration("hbase.namespace.quota.maxtables", "2").build();
        admin.createNamespace(nspDesc);
        Assert.assertEquals((long)3L, (long)admin.listNamespaceDescriptors().length);
        HColumnDescriptor fam1 = new HColumnDescriptor("fam1");
        HTableDescriptor tableDescOne = new HTableDescriptor(TableName.valueOf((String)(nsp + ':' + "table1")));
        tableDescOne.addFamily(fam1);
        admin.createTable(tableDescOne);
        HTableDescriptor tableDescTwo = new HTableDescriptor(TableName.valueOf((String)(nsp + ':' + "table2")));
        tableDescTwo.addFamily(fam1);
        boolean constraintViolated = false;
        try {
            admin.createTable(tableDescTwo, Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 6);
            Assert.fail((String)"Creation table should fail because of quota violation.");
        }
        catch (Exception exp) {
            Assert.assertTrue((boolean)(exp instanceof IOException));
            constraintViolated = true;
        }
        finally {
            Assert.assertTrue((String)("Constraint not violated for table " + tableDescTwo.getTableName()), (boolean)constraintViolated);
        }
        List rsGroupInfoList = rsGroupAdmin.listRSGroups();
        boolean foundTable2 = false;
        boolean foundTable1 = false;
        for (int i = 0; i < rsGroupInfoList.size(); ++i) {
            if (((RSGroupInfo)rsGroupInfoList.get(i)).getTables().contains(tableDescTwo.getTableName())) {
                foundTable2 = true;
            }
            if (!((RSGroupInfo)rsGroupInfoList.get(i)).getTables().contains(tableDescOne.getTableName())) continue;
            foundTable1 = true;
        }
        Assert.assertFalse((String)"Found table2 in rsgroup list.", (boolean)foundTable2);
        Assert.assertTrue((String)"Did not find table1 in rsgroup list", (boolean)foundTable1);
        TEST_UTIL.deleteTable(tableDescOne.getTableName());
        admin.deleteNamespace(nspDesc.getName());
        this.toggleQuotaCheckAndRestartMiniCluster(false);
    }

    @Test
    public void testNotMoveTableToNullRSGroupWhenCreatingExistingTable() throws Exception {
        TableName tn1 = TableName.valueOf((String)"t1");
        TEST_UTIL.createTable(tn1, "cf1");
        try {
            TEST_UTIL.createTable(tn1, "cf1");
        }
        catch (TableExistsException tableExistsException) {
            // empty catch block
        }
        TEST_UTIL.waitFor(5000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.master.getMasterProcedureExecutor().getActiveExecutorCount() == 0;
            }
        });
        NavigableSet tables = rsGroupAdmin.getRSGroupInfo("default").getTables();
        Assert.assertTrue((String)"Table 't1' must be in 'default' rsgroup", (boolean)tables.contains(tn1));
        TEST_UTIL.deleteTable(tn1);
    }

    private void toggleQuotaCheckAndRestartMiniCluster(boolean enable) throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", enable);
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", 3);
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TestRSGroupsAdmin1.initialize();
    }
}

