/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRSGroupsBasics
extends TestRSGroupsBase {
    protected static final Log LOG = LogFactory.getLog(TestRSGroupsBasics.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestRSGroupsBasics.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsBasics.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testBasicStartUp() throws IOException {
        RSGroupInfo defaultInfo = rsGroupAdmin.getRSGroupInfo("default");
        Assert.assertEquals((long)4L, (long)defaultInfo.getServers().size());
        int count = master.getAssignmentManager().getRegionStates().getRegionAssignments().size();
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testCreateAndDrop() throws Exception {
        LOG.info((Object)"testCreateAndDrop");
        final TableName tableName = TableName.valueOf((String)"Group_testCreateAndDrop");
        TEST_UTIL.createTable(tableName, Bytes.toBytes((String)"cf"));
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBasics.this.getTableRegionMap().get(tableName) != null;
            }
        });
        TEST_UTIL.deleteTable(tableName);
    }

    @Test
    public void testCreateMultiRegion() throws IOException {
        LOG.info((Object)"testCreateMultiRegion");
        TableName tableName = TableName.valueOf((String)"Group_testCreateMultiRegion");
        byte[] end = new byte[]{1, 3, 5, 7, 9};
        byte[] start = new byte[]{0, 2, 4, 6, 8};
        byte[][] f = new byte[][]{Bytes.toBytes((String)"f")};
        TEST_UTIL.createTable(tableName, (byte[][])f, 1, start, end, 10);
    }

    @Test
    public void testNamespaceCreateAndAssign() throws Exception {
        LOG.info((Object)"testNamespaceCreateAndAssign");
        String nsName = "Group_foo";
        TableName tableName = TableName.valueOf((String)nsName, (String)"Group_testCreateAndAssign");
        RSGroupInfo appInfo = this.addGroup(rsGroupAdmin, "appInfo", 1);
        admin.createNamespace(NamespaceDescriptor.create((String)nsName).addConfiguration("hbase.rsgroup.name", "appInfo").build());
        final HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("f"));
        admin.createTable(desc);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBasics.this.getTableRegionMap().get(desc.getTableName()) != null;
            }
        });
        ServerName targetServer = ServerName.parseServerName((String)((Address)appInfo.getServers().iterator().next()).toString());
        AdminProtos.AdminService.BlockingInterface rs = admin.getConnection().getAdmin(targetServer);
        Assert.assertEquals((long)1L, (long)ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs).size());
    }

    @Test
    public void testDefaultNamespaceCreateAndAssign() throws Exception {
        LOG.info((Object)"testDefaultNamespaceCreateAndAssign");
        byte[] tableName = Bytes.toBytes((String)"Group_testCreateAndAssign");
        admin.modifyNamespace(NamespaceDescriptor.create((String)"default").addConfiguration("hbase.rsgroup.name", "default").build());
        final HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("f"));
        admin.createTable(desc);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBasics.this.getTableRegionMap().get(desc.getTableName()) != null;
            }
        });
    }

    @Test
    public void testCloneSnapshot() throws Exception {
        TableName tableName = TableName.valueOf((String)"Group_testCloneSnapshot");
        LOG.info((Object)"testCloneSnapshot");
        byte[] FAMILY = Bytes.toBytes((String)"test");
        String snapshotName = tableName.getNameAsString() + "_snap";
        TableName clonedTableName = TableName.valueOf((String)(tableName.getNameAsString() + "_clone"));
        TEST_UTIL.createTable(tableName, FAMILY);
        admin.snapshot(snapshotName, tableName);
        admin.cloneSnapshot(snapshotName, clonedTableName);
    }

    @Test
    public void testClearDeadServers() throws Exception {
        int serverCountToMoveToNewGroup = 3;
        RSGroupInfo newGroup = this.addGroup(rsGroupAdmin, "testClearDeadServers", 3);
        ServerName serverToStop = ServerName.parseServerName((String)((Address)newGroup.getServers().iterator().next()).toString());
        AdminProtos.AdminService.BlockingInterface regionServerToStop = ((ClusterConnection)admin.getConnection()).getAdmin(serverToStop);
        try {
            serverToStop = ProtobufUtil.toServerName((HBaseProtos.ServerName)regionServerToStop.getServerInfo(null, AdminProtos.GetServerInfoRequest.newBuilder().build()).getServerInfo().getServerName());
            regionServerToStop.stopServer(null, AdminProtos.StopServerRequest.newBuilder().setReason("Die").build());
        }
        catch (Exception exception) {
            // empty catch block
        }
        final HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !master.getServerManager().areDeadServersInProgress() && TestRSGroupsBase.cluster.getClusterStatus().getDeadServerNames().size() > 0;
            }
        });
        Assert.assertFalse((boolean)cluster.getClusterStatus().getServers().contains(serverToStop));
        Assert.assertTrue((boolean)cluster.getClusterStatus().getDeadServerNames().contains(serverToStop));
        Assert.assertTrue((boolean)newGroup.getServers().contains(serverToStop.getAddress()));
        List notClearedServers = admin.clearDeadServers((List)Lists.newArrayList((Object[])new ServerName[]{serverToStop}));
        Assert.assertEquals((long)0L, (long)notClearedServers.size());
        Set newGroupServers = rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getServers();
        Assert.assertFalse((boolean)newGroupServers.contains(serverToStop.getAddress()));
        Assert.assertEquals((long)2L, (long)newGroupServers.size());
    }
}

