/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRSGroupsKillRS
extends TestRSGroupsBase {
    protected static final Log LOG = LogFactory.getLog(TestRSGroupsKillRS.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestRSGroupsKillRS.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsKillRS.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testKillRS() throws Exception {
        LOG.info((Object)"testKillRS");
        RSGroupInfo appInfo = this.addGroup(rsGroupAdmin, "appInfo", 1);
        TableName tableName = TableName.valueOf((String)"Group_ns", (String)"_testKillRS");
        admin.createNamespace(NamespaceDescriptor.create((String)tableName.getNamespaceAsString()).addConfiguration("hbase.rsgroup.name", appInfo.getName()).build());
        final HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("f"));
        admin.createTable(desc);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsKillRS.this.getTableRegionMap().get(desc.getTableName()) != null;
            }
        });
        ServerName targetServer = ServerName.parseServerName((String)((Address)appInfo.getServers().iterator().next()).toString());
        AdminProtos.AdminService.BlockingInterface targetRS = admin.getConnection().getAdmin(targetServer);
        Assert.assertEquals((long)1L, (long)ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)targetRS).size());
        try {
            targetRS.stopServer(null, AdminProtos.StopServerRequest.newBuilder().setReason("Die").build());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)cluster.getClusterStatus().getServers().contains(targetServer));
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.cluster.getClusterStatus().getRegionsInTransition().size() == 0;
            }
        });
        HashSet newServers = Sets.newHashSet();
        newServers.add(rsGroupAdmin.getRSGroupInfo("default").getServers().iterator().next());
        rsGroupAdmin.moveServers((Set)newServers, appInfo.getName());
        admin.disableTable(tableName);
        admin.enableTable(tableName);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.cluster.getClusterStatus().getRegionsInTransition().size() == 0;
            }
        });
        targetServer = ServerName.parseServerName((String)((Address)newServers.iterator().next()).toString());
        targetRS = admin.getConnection().getAdmin(targetServer);
        Assert.assertEquals((long)1L, (long)ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)targetRS).size());
        Assert.assertEquals((Object)tableName, (Object)((HRegionInfo)ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)targetRS).get(0)).getTable());
    }
}

