/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminClient;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.util.compaction.MajorCompactorTTL;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class RSGroupMajorCompactionTTL
extends MajorCompactorTTL {
    private static final Logger LOG = LoggerFactory.getLogger(RSGroupMajorCompactionTTL.class);

    @VisibleForTesting
    RSGroupMajorCompactionTTL() {
    }

    public int compactTTLRegionsOnGroup(Configuration conf, String rsgroup, int concurrency, long sleep, int numServers, int numRegions, boolean dryRun, boolean skipWait) throws Exception {
        Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        RSGroupAdminClient rsGroupAdmin = new RSGroupAdminClient(conn);
        RSGroupInfo rsGroupInfo = rsGroupAdmin.getRSGroupInfo(rsgroup);
        if (rsGroupInfo == null) {
            LOG.error("Invalid rsgroup specified: " + rsgroup);
            throw new IllegalArgumentException("Invalid rsgroup specified: " + rsgroup);
        }
        for (TableName tableName : rsGroupInfo.getTables()) {
            int status = this.compactRegionsTTLOnTable(conf, tableName.getNameAsString(), concurrency, sleep, numServers, numRegions, dryRun, skipWait);
            if (status == 0) continue;
            LOG.error("Failed to compact table: " + tableName);
            return status;
        }
        return 0;
    }

    protected Options getOptions() {
        Options options = this.getCommonOptions();
        Option rsGroupOption = new Option("rsgroup", true, "Tables of rsgroup to be compacted");
        rsGroupOption.setRequired(true);
        options.addOption(rsGroupOption);
        return options;
    }

    public int run(String[] args) throws Exception {
        CommandLine commandLine;
        Options options = this.getOptions();
        BasicParser cmdLineParser = new BasicParser();
        try {
            commandLine = cmdLineParser.parse(options, args);
        }
        catch (ParseException parseException) {
            System.err.println("ERROR: Unable to parse command-line arguments " + Arrays.toString(args) + " due to: " + (Object)((Object)parseException));
            RSGroupMajorCompactionTTL.printUsage((Options)options);
            throw parseException;
        }
        String rsgroup = commandLine.getOptionValue("rsgroup");
        int numServers = Integer.parseInt(commandLine.getOptionValue("numservers", "-1"));
        int numRegions = Integer.parseInt(commandLine.getOptionValue("numregions", "-1"));
        int concurrency = Integer.parseInt(commandLine.getOptionValue("servers", "1"));
        long sleep = Long.parseLong(commandLine.getOptionValue("sleep", "30000"));
        boolean dryRun = commandLine.hasOption("dryRun");
        boolean skipWait = commandLine.hasOption("skipWait");
        Configuration conf = HBaseConfiguration.create();
        return this.compactTTLRegionsOnGroup(conf, rsgroup, concurrency, sleep, numServers, numRegions, dryRun, skipWait);
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new RSGroupMajorCompactionTTL(), (String[])args);
    }
}

