/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.RSGroupProtos;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupProtobufUtil;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class RSGroupSerDe {
    private static final Log LOG = LogFactory.getLog(RSGroupSerDe.class);

    public List<RSGroupInfo> retrieveGroupList(Table groupTable) throws IOException {
        ArrayList RSGroupInfoList = Lists.newArrayList();
        for (Result result : groupTable.getScanner(new Scan())) {
            RSGroupProtos.RSGroupInfo proto = RSGroupProtos.RSGroupInfo.parseFrom((byte[])result.getValue(RSGroupInfoManager.META_FAMILY_BYTES, RSGroupInfoManager.META_QUALIFIER_BYTES));
            RSGroupInfoList.add(RSGroupProtobufUtil.toGroupInfo(proto));
        }
        return RSGroupInfoList;
    }

    public List<RSGroupInfo> retrieveGroupList(ZooKeeperWatcher watcher, String groupBasePath) throws IOException {
        ArrayList RSGroupInfoList = Lists.newArrayList();
        try {
            if (ZKUtil.checkExists((ZooKeeperWatcher)watcher, (String)groupBasePath) != -1) {
                for (String znode : ZKUtil.listChildrenAndWatchForNewChildren((ZooKeeperWatcher)watcher, (String)groupBasePath)) {
                    byte[] data = ZKUtil.getData((ZooKeeperWatcher)watcher, (String)ZKUtil.joinZNode((String)groupBasePath, (String)znode));
                    if (data.length <= 0) continue;
                    ProtobufUtil.expectPBMagicPrefix((byte[])data);
                    ByteArrayInputStream bis = new ByteArrayInputStream(data, ProtobufUtil.lengthOfPBMagic(), data.length);
                    RSGroupInfoList.add(RSGroupProtobufUtil.toGroupInfo(RSGroupProtos.RSGroupInfo.parseFrom((InputStream)bis)));
                }
                LOG.debug((Object)("Read ZK GroupInfo count:" + RSGroupInfoList.size()));
            }
        }
        catch (KeeperException e) {
            throw new IOException("Failed to read rsGroupZNode", e);
        }
        catch (DeserializationException e) {
            throw new IOException("Failed to read rsGroupZNode", e);
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to read rsGroupZNode", e);
        }
        return RSGroupInfoList;
    }
}

