/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.balancer.RSGroupableBalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.SimpleLoadBalancer;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRSGroupBasedLoadBalancer
extends RSGroupableBalancerTestBase {
    private static final Log LOG = LogFactory.getLog(TestRSGroupBasedLoadBalancer.class);
    private static RSGroupBasedLoadBalancer loadBalancer;

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        servers = TestRSGroupBasedLoadBalancer.generateServers(7);
        groupMap = TestRSGroupBasedLoadBalancer.constructGroupInfo(servers, groups);
        tableDescs = TestRSGroupBasedLoadBalancer.constructTableDesc(true);
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.regions.slop", "0");
        conf.set("hbase.group.grouploadbalancer.class", SimpleLoadBalancer.class.getCanonicalName());
        loadBalancer = new RSGroupBasedLoadBalancer(TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager());
        loadBalancer.setMasterServices(TestRSGroupBasedLoadBalancer.getMockedMaster());
        loadBalancer.setConf(conf);
        loadBalancer.initialize();
    }

    @Test
    public void testBalanceCluster() throws Exception {
        Map<ServerName, List<HRegionInfo>> servers = this.mockClusterServers();
        ArrayListMultimap<String, ServerAndLoad> list = this.convertToGroupBasedMap(servers);
        LOG.info((Object)("Mock Cluster :  " + this.printStats(list)));
        List plans = loadBalancer.balanceCluster(servers);
        ArrayListMultimap<String, ServerAndLoad> balancedCluster = this.reconcile(list, plans);
        LOG.info((Object)("Mock Balance : " + this.printStats(balancedCluster)));
        this.assertClusterAsBalanced(balancedCluster);
    }

    @Test
    public void testBulkAssignment() throws Exception {
        List<HRegionInfo> regions = this.randomRegions(25);
        Map assignments = loadBalancer.roundRobinAssignment(regions, servers);
        loadBalancer.roundRobinAssignment(regions, Collections.emptyList());
        Assert.assertTrue((assignments.keySet().size() == servers.size() ? 1 : 0) != 0);
        for (ServerName sn : assignments.keySet()) {
            List regionAssigned = (List)assignments.get(sn);
            for (HRegionInfo region : regionAssigned) {
                TableName tableName = region.getTable();
                String groupName = TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager().getRSGroupOfTable(tableName);
                Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)groupName));
                RSGroupInfo gInfo = TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager().getRSGroup(groupName);
                Assert.assertTrue((String)"Region is not correctly assigned to group servers.", (boolean)gInfo.containsServer(sn.getAddress()));
            }
        }
        ArrayListMultimap<String, ServerAndLoad> loadMap = this.convertToGroupBasedMap(assignments);
        this.assertClusterAsBalanced(loadMap);
    }

    @Test
    public void testRetainAssignment() throws Exception {
        Map<ServerName, List<HRegionInfo>> currentAssignments = this.mockClusterServers();
        HashMap<HRegionInfo, ServerName> inputForTest = new HashMap<HRegionInfo, ServerName>();
        for (ServerName sn : currentAssignments.keySet()) {
            for (HRegionInfo region : currentAssignments.get(sn)) {
                inputForTest.put(region, sn);
            }
        }
        inputForTest.put(this.randomRegions(1).get(0), null);
        Map newAssignment = loadBalancer.retainAssignment(inputForTest, servers);
        this.assertRetainedAssignment(inputForTest, servers, newAssignment);
    }

    @Test
    public void testGetMisplacedRegions() throws Exception {
        HashMap inputForTest = new HashMap();
        HRegionInfo ri = new HRegionInfo(table0, new byte[16], new byte[16], false, (long)regionId++);
        inputForTest.put(ri, servers.iterator().next());
        Set misplacedRegions = loadBalancer.getMisplacedRegions(inputForTest);
        Assert.assertFalse((boolean)misplacedRegions.contains(ri));
    }

    @Test
    public void testRoundRobinAssignment() throws Exception {
        ArrayList onlineServers = new ArrayList(servers.size());
        onlineServers.addAll(servers);
        List<HRegionInfo> regions = this.randomRegions(25);
        int bogusRegion = 0;
        for (HRegionInfo region : regions) {
            String group = (String)tableMap.get(region.getTable());
            if (!"dg3".equals(group) && !"dg4".equals(group)) continue;
            ++bogusRegion;
        }
        HashSet offlineServers = new HashSet();
        offlineServers.addAll(((RSGroupInfo)groupMap.get("dg3")).getServers());
        offlineServers.addAll(((RSGroupInfo)groupMap.get("dg4")).getServers());
        Iterator it = onlineServers.iterator();
        while (it.hasNext()) {
            ServerName server = (ServerName)it.next();
            Address address = server.getAddress();
            if (!offlineServers.contains(address)) continue;
            it.remove();
        }
        Map assignments = loadBalancer.roundRobinAssignment(regions, onlineServers);
        Assert.assertEquals((long)bogusRegion, (long)((List)assignments.get(LoadBalancer.BOGUS_SERVER_NAME)).size());
    }

    @Test
    public void testOnConfigurationChange() {
        Assert.assertFalse((boolean)loadBalancer.isFallbackEnabled());
        Configuration conf = loadBalancer.getConf();
        conf.setBoolean("hbase.rsgroup.fallback.enable", true);
        loadBalancer.onConfigurationChange(conf);
        Assert.assertTrue((boolean)loadBalancer.isFallbackEnabled());
        conf.setBoolean("hbase.rsgroup.fallback.enable", false);
        loadBalancer.onConfigurationChange(conf);
        Assert.assertFalse((boolean)loadBalancer.isFallbackEnabled());
    }
}

