/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRSGroupsAdmin2
extends TestRSGroupsBase {
    protected static final Log LOG = LogFactory.getLog(TestRSGroupsAdmin2.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestRSGroupsAdmin2.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsAdmin2.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testRegionMove() throws Exception {
        ServerName server;
        LOG.info((Object)"testRegionMove");
        RSGroupInfo newGroup = this.addGroup(rsGroupAdmin, this.getGroupName("testRegionMove"), 1);
        final TableName tableName = TableName.valueOf((String)("Group" + rand.nextInt()));
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        TEST_UTIL.createMultiRegionTable(tableName, familyNameBytes, 6);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsAdmin2.this.getTableRegionMap().get(tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsAdmin2.this.getTableRegionMap().get(tableName).size() >= 6;
            }
        });
        Map<ServerName, List<String>> assignMap = this.getTableServerRegionMap().get(tableName);
        String targetRegion = null;
        Iterator<ServerName> i$ = assignMap.keySet().iterator();
        while (i$.hasNext() && (targetRegion = assignMap.get(server = i$.next()).size() > 0 ? assignMap.get(server).get(0) : null) == null) {
        }
        ServerName targetServer = null;
        for (ServerName server2 : admin.getClusterStatus().getServers()) {
            if (newGroup.containsServer(server2.getAddress())) continue;
            targetServer = server2;
            break;
        }
        Assert.assertNotNull(targetServer);
        final AdminProtos.AdminService.BlockingInterface targetRS = admin.getConnection().getAdmin(targetServer);
        rsGroupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}), newGroup.getName());
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)targetRS).size() <= 0;
            }
        });
        TEST_UTIL.getHBaseAdmin().move(Bytes.toBytes((String)HRegionInfo.encodeRegionName((byte[])Bytes.toBytes((String)targetRegion))), Bytes.toBytes((String)targetServer.getServerName()));
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsAdmin2.this.getTableRegionMap().get(tableName);
                Set regionsInTransition = TestRSGroupsBase.admin.getClusterStatus().getRegionsInTransition();
                return regions != null && TestRSGroupsAdmin2.this.getTableRegionMap().get(tableName).size() == 6 && (regionsInTransition == null || regionsInTransition.size() < 1);
            }
        });
        for (HRegionInfo region : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)targetRS)) {
            if (!targetRegion.equals(region.getRegionNameAsString())) continue;
            Assert.fail((String)"Target server opened region");
        }
    }

    @Test
    public void testRegionServerMove() throws IOException, InterruptedException {
        LOG.info((Object)"testRegionServerMove");
        int initNumGroups = rsGroupAdmin.listRSGroups().size();
        RSGroupInfo appInfo = this.addGroup(rsGroupAdmin, this.getGroupName("testRegionServerMove"), 1);
        RSGroupInfo adminInfo = this.addGroup(rsGroupAdmin, this.getGroupName("testRegionServerMove"), 1);
        RSGroupInfo dInfo = rsGroupAdmin.getRSGroupInfo("default");
        Assert.assertEquals((long)(initNumGroups + 2), (long)rsGroupAdmin.listRSGroups().size());
        Assert.assertEquals((long)1L, (long)adminInfo.getServers().size());
        Assert.assertEquals((long)1L, (long)appInfo.getServers().size());
        Assert.assertEquals((long)(this.getNumServers() - 2), (long)dInfo.getServers().size());
        rsGroupAdmin.moveServers(appInfo.getServers(), "default");
        rsGroupAdmin.removeRSGroup(appInfo.getName());
        rsGroupAdmin.moveServers(adminInfo.getServers(), "default");
        rsGroupAdmin.removeRSGroup(adminInfo.getName());
        Assert.assertEquals((long)rsGroupAdmin.listRSGroups().size(), (long)initNumGroups);
    }

    @Test
    public void testMoveServers() throws Exception {
        LOG.info((Object)"testMoveServers");
        this.addGroup(rsGroupAdmin, "bar", 3);
        rsGroupAdmin.addRSGroup("foo");
        RSGroupInfo barGroup = rsGroupAdmin.getRSGroupInfo("bar");
        RSGroupInfo fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        Assert.assertEquals((long)3L, (long)barGroup.getServers().size());
        Assert.assertEquals((long)0L, (long)fooGroup.getServers().size());
        try {
            rsGroupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{Address.fromString((String)"foo:9999")}), "foo");
            Assert.fail((String)"Bogus servers shouldn't have been successfully moved.");
        }
        catch (IOException ex) {
            String exp = "Server foo:9999 does not have a group.";
            String msg = "Expected '" + exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains(exp));
        }
        LOG.info((Object)("moving servers " + barGroup.getServers() + " to group foo"));
        rsGroupAdmin.moveServers(barGroup.getServers(), fooGroup.getName());
        barGroup = rsGroupAdmin.getRSGroupInfo("bar");
        fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        Assert.assertEquals((long)0L, (long)barGroup.getServers().size());
        Assert.assertEquals((long)3L, (long)fooGroup.getServers().size());
        LOG.info((Object)("moving servers " + fooGroup.getServers() + " to group default"));
        rsGroupAdmin.moveServers(fooGroup.getServers(), "default");
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsAdmin2.this.getNumServers() == TestRSGroupsBase.rsGroupAdmin.getRSGroupInfo("default").getServers().size();
            }
        });
        fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        Assert.assertEquals((long)0L, (long)fooGroup.getServers().size());
        LOG.info((Object)("Remove group " + barGroup.getName()));
        rsGroupAdmin.removeRSGroup(barGroup.getName());
        Assert.assertEquals(null, (Object)rsGroupAdmin.getRSGroupInfo(barGroup.getName()));
        LOG.info((Object)("Remove group " + fooGroup.getName()));
        rsGroupAdmin.removeRSGroup(fooGroup.getName());
        Assert.assertEquals(null, (Object)rsGroupAdmin.getRSGroupInfo(fooGroup.getName()));
    }

    @Test
    public void testRemoveServers() throws Exception {
        RSGroupInfo newGroup = this.addGroup(rsGroupAdmin, "testRemoveServers", 3);
        ServerName targetServer = ServerName.parseServerName((String)((Address)newGroup.getServers().iterator().next()).toString());
        try {
            rsGroupAdmin.removeServers((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}));
            Assert.fail((String)"Online servers shouldn't have been successfully removed.");
        }
        catch (IOException ex) {
            String exp = "Server " + targetServer.getAddress() + " is an online server, not allowed to remove.";
            String msg = "Expected '" + exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains(exp));
        }
        Assert.assertTrue((boolean)newGroup.getServers().contains(targetServer.getAddress()));
        AdminProtos.AdminService.BlockingInterface targetRS = ((ClusterConnection)admin.getConnection()).getAdmin(targetServer);
        try {
            targetServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)targetRS.getServerInfo(null, AdminProtos.GetServerInfoRequest.newBuilder().build()).getServerInfo().getServerName());
            targetRS.stopServer(null, AdminProtos.StopServerRequest.newBuilder().setReason("Die").build());
        }
        catch (Exception exp) {
            // empty catch block
        }
        final HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !master.getServerManager().areDeadServersInProgress() && TestRSGroupsBase.cluster.getClusterStatus().getDeadServerNames().size() > 0;
            }
        });
        try {
            rsGroupAdmin.removeServers((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}));
            Assert.fail((String)"Dead servers shouldn't have been successfully removed.");
        }
        catch (IOException ex) {
            String exp = "Server " + targetServer.getAddress() + " is on the dead servers list," + " Maybe it will come back again, not allowed to remove.";
            String msg = "Expected '" + exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains(exp));
        }
        Assert.assertTrue((boolean)newGroup.getServers().contains(targetServer.getAddress()));
        ServerName sn = TEST_UTIL.getHBaseClusterInterface().getClusterStatus().getMaster();
        TEST_UTIL.getHBaseClusterInterface().stopMaster(sn);
        TEST_UTIL.getHBaseClusterInterface().waitForMasterToStop(sn, 60000L);
        TEST_UTIL.getHBaseClusterInterface().startMaster(sn.getHostname(), 0);
        TEST_UTIL.getHBaseClusterInterface().waitForActiveAndReadyMaster(60000L);
        Assert.assertEquals((long)3L, (long)cluster.getClusterStatus().getServersSize());
        Assert.assertFalse((boolean)cluster.getClusterStatus().getServers().contains(targetServer));
        Assert.assertFalse((boolean)cluster.getClusterStatus().getDeadServerNames().contains(targetServer));
        Assert.assertTrue((boolean)newGroup.getServers().contains(targetServer.getAddress()));
        rsGroupAdmin.removeServers((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}));
        Set newGroupServers = rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getServers();
        Assert.assertFalse((boolean)newGroupServers.contains(targetServer.getAddress()));
        Assert.assertEquals((long)2L, (long)newGroupServers.size());
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.observer.preRemoveServersCalled);
    }

    @Test
    public void testNonExistentTableMove() throws Exception {
        TableName tableName = TableName.valueOf((String)("Group" + rand.nextInt()));
        RSGroupInfo tableGrp = rsGroupAdmin.getRSGroupInfoOfTable(tableName);
        Assert.assertNull((Object)tableGrp);
        boolean exist = admin.tableExists(tableName);
        Assert.assertFalse((boolean)exist);
        LOG.info((Object)("Moving table " + tableName + " to " + "default"));
        try {
            rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{tableName}), "default");
            Assert.fail((String)("Table " + tableName + " shouldn't have been successfully moved."));
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)(ex instanceof TableNotFoundException));
        }
        try {
            rsGroupAdmin.moveServersAndTables((Set)Sets.newHashSet((Object[])new Address[]{Address.fromParts((String)"bogus", (int)123)}), (Set)Sets.newHashSet((Object[])new TableName[]{tableName}), "default");
            Assert.fail((String)("Table " + tableName + " shouldn't have been successfully moved."));
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)(ex instanceof TableNotFoundException));
        }
        Assert.assertNull((Object)rsGroupAdmin.getRSGroupInfoOfTable(tableName));
    }

    @Test
    public void testMoveServersAndTables() throws Exception {
        final TableName tableName = TableName.valueOf((String)"Group_testMoveServersAndTables");
        RSGroupInfo newGroup = this.addGroup(rsGroupAdmin, this.getGroupName("testMoveServersAndTables"), 1);
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        TEST_UTIL.createMultiRegionTable(tableName, familyNameBytes, 5);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsAdmin2.this.getTableRegionMap().get(tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsAdmin2.this.getTableRegionMap().get(tableName).size() >= 5;
            }
        });
        ServerName targetServer = null;
        for (ServerName server : admin.getClusterStatus().getServers()) {
            if (newGroup.containsServer(server.getAddress()) || rsGroupAdmin.getRSGroupInfo("master").containsServer(server.getAddress())) continue;
            targetServer = server;
            break;
        }
        LOG.debug((Object)("Print group info : " + rsGroupAdmin.listRSGroups()));
        int oldDefaultGroupServerSize = rsGroupAdmin.getRSGroupInfo("default").getServers().size();
        int oldDefaultGroupTableSize = rsGroupAdmin.getRSGroupInfo("default").getTables().size();
        try {
            rsGroupAdmin.moveServersAndTables((Set)Sets.newHashSet((Object[])new Address[]{Address.fromString((String)"foo:9999")}), (Set)Sets.newHashSet((Object[])new TableName[]{tableName}), newGroup.getName());
            Assert.fail((String)"Bogus servers shouldn't have been successfully moved.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            rsGroupAdmin.moveServersAndTables((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}), (Set)Sets.newHashSet((Object[])new TableName[]{tableName}), "default");
            Assert.fail((String)"servers shouldn't have been successfully moved.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((long)oldDefaultGroupServerSize, (long)rsGroupAdmin.getRSGroupInfo("default").getServers().size());
        Assert.assertEquals((long)oldDefaultGroupTableSize, (long)rsGroupAdmin.getRSGroupInfo("default").getTables().size());
        Assert.assertEquals((long)1L, (long)rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getServers().size());
        Assert.assertEquals((long)0L, (long)rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getTables().size());
        List<String> regionList = this.getTableRegionMap().get(tableName);
        for (String region : regionList) {
            admin.move(Bytes.toBytes((String)HRegionInfo.encodeRegionName((byte[])Bytes.toBytes((String)region))), Bytes.toBytes((String)targetServer.getServerName()));
        }
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsAdmin2.this.getTableRegionMap().get(tableName);
                Map<ServerName, List<String>> serverMap = TestRSGroupsAdmin2.this.getTableServerRegionMap().get(tableName);
                Set regionsInTransition = TestRSGroupsBase.admin.getClusterStatus().getRegionsInTransition();
                return regions != null && regions.size() == 5 && serverMap != null && serverMap.size() == 1 && (regionsInTransition == null || regionsInTransition.size() < 1);
            }
        });
        Assert.assertNotNull(this.getTableServerRegionMap().get(tableName));
        Assert.assertNotNull(this.getTableServerRegionMap().get(tableName).get(targetServer));
        Assert.assertEquals((long)5L, (long)this.getTableServerRegionMap().get(tableName).get(targetServer).size());
        LOG.info((Object)"moving server and table to newGroup");
        rsGroupAdmin.moveServersAndTables((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}), (Set)Sets.newHashSet((Object[])new TableName[]{tableName}), newGroup.getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)rsGroupAdmin.getRSGroupInfoOfTable(tableName).getName());
        Set defaultServers = rsGroupAdmin.getRSGroupInfo("default").getServers();
        Assert.assertFalse((boolean)defaultServers.contains(targetServer.getAddress()));
        Set newGroupServers = rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getServers();
        Assert.assertTrue((boolean)newGroupServers.contains(targetServer.getAddress()));
        NavigableSet defaultTables = rsGroupAdmin.getRSGroupInfo("default").getTables();
        Assert.assertFalse((boolean)defaultTables.contains(tableName));
        NavigableSet newGroupTables = rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getTables();
        Assert.assertTrue((boolean)newGroupTables.contains(tableName));
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.observer.preMoveServersAndTables);
        Assert.assertTrue((boolean)TestRSGroupsAdmin2.observer.postMoveServersAndTables);
    }
}

