/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRSGroupsBalance
extends TestRSGroupsBase {
    protected static final Log LOG = LogFactory.getLog(TestRSGroupsBalance.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestRSGroupsBalance.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsBalance.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testRSGroupBalancerSwitch() throws IOException {
        Assert.assertFalse((boolean)admin.setBalancerRunning(true, true));
        Assert.assertTrue((boolean)admin.isBalancerEnabled());
        Assert.assertTrue((boolean)admin.setBalancerRunning(false, true));
        Assert.assertFalse((boolean)admin.isBalancerEnabled());
    }

    @Test
    public void testGroupBalance() throws Exception {
        LOG.info((Object)"testGroupBalance");
        String newGroupName = this.getGroupName("testGroupBalance");
        RSGroupInfo newGroup = this.addGroup(rsGroupAdmin, newGroupName, 3);
        final TableName tableName = TableName.valueOf((String)"Group_ns", (String)"testGroupBalance");
        admin.createNamespace(NamespaceDescriptor.create((String)tableName.getNamespaceAsString()).addConfiguration("hbase.rsgroup.name", newGroupName).build());
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("f"));
        byte[] startKey = Bytes.toBytes((String)"aaaaa");
        byte[] endKey = Bytes.toBytes((String)"zzzzz");
        admin.createTable(desc, startKey, endKey, 6);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsBalance.this.getTableRegionMap().get(tableName);
                if (regions == null) {
                    return false;
                }
                return regions.size() >= 6;
            }
        });
        Map<ServerName, List<String>> assignMap = this.getTableServerRegionMap().get(tableName);
        final ServerName first = assignMap.entrySet().iterator().next().getKey();
        for (HRegionInfo region : admin.getTableRegions(tableName)) {
            if (assignMap.get(first).contains(region.getRegionNameAsString())) continue;
            admin.move(region.getEncodedNameAsBytes(), Bytes.toBytes((String)first.getServerName()));
        }
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Map<ServerName, List<String>> map = TestRSGroupsBalance.this.getTableServerRegionMap().get(tableName);
                if (map == null) {
                    return true;
                }
                List<String> regions = map.get(first);
                if (regions == null) {
                    return true;
                }
                return regions.size() >= 6;
            }
        });
        rsGroupAdmin.balanceRSGroup("default");
        Assert.assertEquals((long)6L, (long)this.getTableServerRegionMap().get(tableName).get(first).size());
        rsGroupAdmin.balanceRSGroup(newGroupName);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                for (List<String> regions : TestRSGroupsBalance.this.getTableServerRegionMap().get(tableName).values()) {
                    if (2 == regions.size()) continue;
                    return false;
                }
                return true;
            }
        });
        Assert.assertTrue((boolean)TestRSGroupsBalance.observer.preBalanceRSGroupCalled);
        Assert.assertTrue((boolean)TestRSGroupsBalance.observer.postBalanceRSGroupCalled);
    }

    @Test
    public void testMisplacedRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)"Group_testMisplacedRegions");
        LOG.info((Object)"testMisplacedRegions");
        final RSGroupInfo RSGroupInfo2 = this.addGroup(rsGroupAdmin, "testMisplacedRegions", 1);
        TEST_UTIL.createMultiRegionTable(tableName, new byte[]{102}, 15);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        RSGroupAdminEndpoint.getGroupInfoManager().moveTables((Set)Sets.newHashSet((Object[])new TableName[]{tableName}), RSGroupInfo2.getName());
        Assert.assertTrue((boolean)rsGroupAdmin.balanceRSGroup(RSGroupInfo2.getName()));
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                ServerName serverName = ServerName.valueOf((String)((Address)RSGroupInfo2.getServers().iterator().next()).toString(), (long)1L);
                return TestRSGroupsBase.admin.getConnection().getAdmin().getOnlineRegions(serverName).size() == 15;
            }
        });
    }
}

