/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.coprocessor.BaseMasterObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdmin;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminClient;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.VerifyingRSGroupAdminClient;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;

public abstract class TestRSGroupsBase {
    protected static final Log LOG = LogFactory.getLog(TestRSGroupsBase.class);
    protected static final String groupPrefix = "Group";
    protected static final String tablePrefix = "Group";
    protected static final Random rand = new Random();
    protected static HBaseTestingUtility TEST_UTIL;
    protected static HBaseAdmin admin;
    protected static HBaseCluster cluster;
    protected static RSGroupAdmin rsGroupAdmin;
    protected static HMaster master;
    protected static boolean init;
    protected static RSGroupAdminEndpoint RSGroupAdminEndpoint;
    protected static CPMasterObserver observer;
    public static final long WAIT_TIMEOUT = 300000L;
    public static final int NUM_SLAVES_BASE = 4;

    public static void setUpTestBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.getConfiguration().setFloat("hbase.master.balancer.stochastic.tableSkewCost", 6000.0f);
        TEST_UTIL.getConfiguration().set("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class.getName());
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", RSGroupAdminEndpoint.class.getName() + "," + CPMasterObserver.class.getName());
        TEST_UTIL.getConfiguration().setBoolean("hbase.zookeeper.useMulti", true);
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", 3);
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TestRSGroupsBase.initialize();
    }

    protected static void initialize() throws Exception {
        admin = TEST_UTIL.getHBaseAdmin();
        cluster = TEST_UTIL.getHBaseCluster();
        master = ((MiniHBaseCluster)cluster).getMaster();
        master.balanceSwitch(true);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return master.isInitialized() && ((RSGroupBasedLoadBalancer)master.getLoadBalancer()).isOnline();
            }
        });
        admin.setBalancerRunning(false, true);
        rsGroupAdmin = new VerifyingRSGroupAdminClient((RSGroupAdmin)new RSGroupAdminClient(TEST_UTIL.getConnection()), TEST_UTIL.getConfiguration());
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        observer = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class.getName());
        RSGroupAdminEndpoint = (RSGroupAdminEndpoint)host.findCoprocessors(RSGroupAdminEndpoint.class).get(0);
    }

    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    public void setUpBeforeMethod() throws Exception {
        if (!init) {
            init = true;
            this.tearDownAfterMethod();
        }
        observer.resetFlags();
    }

    public void tearDownAfterMethod() throws Exception {
        this.deleteTableIfNecessary();
        this.deleteNamespaceIfNecessary();
        this.deleteGroups();
        int missing = 4 - this.getNumServers();
        LOG.info((Object)("Restoring servers: " + missing));
        for (int i = 0; i < missing; ++i) {
            ((MiniHBaseCluster)cluster).startRegionServer();
        }
        rsGroupAdmin.addRSGroup("master");
        ServerName masterServerName = ((MiniHBaseCluster)cluster).getMaster().getServerName();
        try {
            rsGroupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{masterServerName.getAddress()}), "master");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                LOG.info((Object)("Waiting for cleanup to finish " + rsGroupAdmin.listRSGroups()));
                return rsGroupAdmin.getRSGroupInfo("default").getServers().size() == 4;
            }
        });
    }

    protected int getNumServers() throws IOException {
        ClusterStatus status = admin.getClusterStatus();
        ServerName master = status.getMaster();
        int count = 0;
        for (ServerName sn : status.getServers()) {
            if (sn.equals((Object)master)) continue;
            ++count;
        }
        return count;
    }

    protected RSGroupInfo addGroup(RSGroupAdmin gAdmin, String groupName, int serverCount) throws IOException, InterruptedException {
        RSGroupInfo defaultInfo = gAdmin.getRSGroupInfo("default");
        gAdmin.addRSGroup(groupName);
        HashSet<Address> set = new HashSet<Address>();
        for (Address server : defaultInfo.getServers()) {
            if (set.size() == serverCount) break;
            set.add(server);
        }
        gAdmin.moveServers(set, groupName);
        RSGroupInfo result = gAdmin.getRSGroupInfo(groupName);
        return result;
    }

    static void removeGroup(RSGroupAdminClient groupAdmin, String groupName) throws IOException {
        RSGroupInfo info = groupAdmin.getRSGroupInfo(groupName);
        groupAdmin.moveTables((Set)info.getTables(), "default");
        groupAdmin.moveServers(info.getServers(), "default");
        groupAdmin.removeRSGroup(groupName);
    }

    protected void deleteTableIfNecessary() throws IOException {
        for (HTableDescriptor desc : TEST_UTIL.getHBaseAdmin().listTables("Group.*")) {
            TEST_UTIL.deleteTable(desc.getTableName());
        }
    }

    protected void deleteNamespaceIfNecessary() throws IOException {
        for (NamespaceDescriptor desc : TEST_UTIL.getHBaseAdmin().listNamespaceDescriptors()) {
            if (!desc.getName().startsWith("Group")) continue;
            admin.deleteNamespace(desc.getName());
        }
    }

    protected void deleteGroups() throws IOException {
        try (RSGroupAdminClient groupAdmin = new RSGroupAdminClient(TEST_UTIL.getConnection());){
            for (RSGroupInfo group : groupAdmin.listRSGroups()) {
                if (group.getName().equals("default")) continue;
                groupAdmin.moveTables((Set)group.getTables(), "default");
                groupAdmin.moveServers(group.getServers(), "default");
                groupAdmin.removeRSGroup(group.getName());
            }
        }
    }

    public Map<TableName, List<String>> getTableRegionMap() throws IOException {
        TreeMap map = Maps.newTreeMap();
        Map<TableName, Map<ServerName, List<String>>> tableServerRegionMap = this.getTableServerRegionMap();
        for (TableName tableName : tableServerRegionMap.keySet()) {
            if (!map.containsKey(tableName)) {
                map.put(tableName, new LinkedList());
            }
            for (List<String> subset : tableServerRegionMap.get(tableName).values()) {
                ((List)map.get(tableName)).addAll(subset);
            }
        }
        return map;
    }

    public Map<TableName, Map<ServerName, List<String>>> getTableServerRegionMap() throws IOException {
        TreeMap map = Maps.newTreeMap();
        ClusterStatus status = TEST_UTIL.getHBaseClusterInterface().getClusterStatus();
        for (ServerName serverName : status.getServers()) {
            for (RegionLoad rl : status.getLoad(serverName).getRegionsLoad().values()) {
                TableName tableName = null;
                try {
                    tableName = HRegionInfo.getTable((byte[])rl.getName());
                }
                catch (IllegalArgumentException e) {
                    LOG.warn((Object)("Failed parse a table name from regionname=" + Bytes.toStringBinary((byte[])rl.getName())));
                    continue;
                }
                if (!map.containsKey(tableName)) {
                    map.put(tableName, new TreeMap());
                }
                if (!((Map)map.get(tableName)).containsKey(serverName)) {
                    ((Map)map.get(tableName)).put(serverName, new LinkedList());
                }
                ((List)((Map)map.get(tableName)).get(serverName)).add(rl.getNameAsString());
            }
        }
        return map;
    }

    protected String getGroupName(String baseName) {
        return "Group_" + baseName + "_" + rand.nextInt(Integer.MAX_VALUE);
    }

    protected final ServerName getServerName(Address addr) {
        for (JVMClusterUtil.RegionServerThread rsThread : TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            ServerName sn = rsThread.getRegionServer().getServerName();
            if (!sn.getAddress().equals((Object)addr)) continue;
            return sn;
        }
        return null;
    }

    static {
        init = false;
    }

    public static class CPMasterObserver
    extends BaseMasterObserver {
        boolean preBalanceRSGroupCalled = false;
        boolean postBalanceRSGroupCalled = false;
        boolean preMoveServersCalled = false;
        boolean postMoveServersCalled = false;
        boolean preMoveTablesCalled = false;
        boolean postMoveTablesCalled = false;
        boolean preAddRSGroupCalled = false;
        boolean postAddRSGroupCalled = false;
        boolean preRemoveRSGroupCalled = false;
        boolean postRemoveRSGroupCalled = false;
        boolean preRemoveServersCalled = false;
        boolean postRemoveServersCalled = false;
        boolean preMoveServersAndTables = false;
        boolean postMoveServersAndTables = false;
        boolean preRenameRSGroupCalled = false;
        boolean postRenameRSGroupCalled = false;

        public void resetFlags() {
            this.preBalanceRSGroupCalled = false;
            this.postBalanceRSGroupCalled = false;
            this.preMoveServersCalled = false;
            this.postMoveServersCalled = false;
            this.preMoveTablesCalled = false;
            this.postMoveTablesCalled = false;
            this.preAddRSGroupCalled = false;
            this.postAddRSGroupCalled = false;
            this.preRemoveRSGroupCalled = false;
            this.postRemoveRSGroupCalled = false;
            this.preRemoveServersCalled = false;
            this.postRemoveServersCalled = false;
            this.preMoveServersAndTables = false;
            this.postMoveServersAndTables = false;
            this.preRenameRSGroupCalled = false;
            this.postRenameRSGroupCalled = false;
        }

        public void preMoveServersAndTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
            this.preMoveServersAndTables = true;
        }

        public void postMoveServersAndTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
            this.postMoveServersAndTables = true;
        }

        public void preRemoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers) throws IOException {
            this.preRemoveServersCalled = true;
        }

        public void postRemoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers) throws IOException {
            this.postRemoveServersCalled = true;
        }

        public void preRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
            this.preRemoveRSGroupCalled = true;
        }

        public void postRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
            this.postRemoveRSGroupCalled = true;
        }

        public void preAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
            this.preAddRSGroupCalled = true;
        }

        public void postAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
            this.postAddRSGroupCalled = true;
        }

        public void preMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
            this.preMoveTablesCalled = true;
        }

        public void postMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
            this.postMoveTablesCalled = true;
        }

        public void preMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
            this.preMoveServersCalled = true;
        }

        public void postMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
            this.postMoveServersCalled = true;
        }

        public void preBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName) throws IOException {
            this.preBalanceRSGroupCalled = true;
        }

        public void postBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName, boolean balancerRan) throws IOException {
            this.postBalanceRSGroupCalled = true;
        }

        public void preRenameRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String oldName, String newName) throws IOException {
            this.preRenameRSGroupCalled = true;
        }

        public void postRenameRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String oldName, String newName) throws IOException {
            this.postRenameRSGroupCalled = true;
        }
    }
}

