/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRSGroupsFallback
extends TestRSGroupsBase {
    protected static final Logger LOG = LoggerFactory.getLogger(TestRSGroupsFallback.class);
    private static final String FALLBACK_GROUP = "fallback";

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.getConfiguration().setBoolean("hbase.rsgroup.fallback.enable", true);
        TEST_UTIL.getConfiguration().setFloat("hbase.master.balancer.stochastic.tableSkewCost", 6000.0f);
        TEST_UTIL.getConfiguration().set("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class.getName());
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", RSGroupAdminEndpoint.class.getName() + "," + TestRSGroupsBase.CPMasterObserver.class.getName());
        TEST_UTIL.getConfiguration().setBoolean("hbase.zookeeper.useMulti", true);
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", 3);
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TestRSGroupsFallback.initialize();
        master.balanceSwitch(true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsFallback.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testFallback() throws Exception {
        this.addGroup(rsGroupAdmin, FALLBACK_GROUP, 1);
        String groupName = "appInfo";
        RSGroupInfo appInfo = this.addGroup(rsGroupAdmin, groupName, 1);
        TableName tableName = TableName.valueOf((String)"Group_ns", (String)"_testFallback");
        admin.createNamespace(NamespaceDescriptor.create((String)tableName.getNamespaceAsString()).addConfiguration("hbase.rsgroup.name", appInfo.getName()).build());
        final HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("f"));
        admin.createTable(desc);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsFallback.this.getTableRegionMap().get(desc.getTableName()) != null;
            }
        });
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        this.crashRsInGroup(groupName);
        this.assertRegionsInGroup(tableName, "default");
        this.crashRsInGroup("default");
        this.assertRegionsInGroup(tableName, FALLBACK_GROUP);
        JVMClusterUtil.RegionServerThread t = TEST_UTIL.getMiniHBaseCluster().startRegionServerAndWait(60000L);
        Assert.assertTrue((boolean)master.balance());
        this.assertRegionsInGroup(tableName, "default");
        JVMClusterUtil.RegionServerThread t1 = TEST_UTIL.getMiniHBaseCluster().startRegionServerAndWait(60000L);
        rsGroupAdmin.moveServers(Collections.singleton(t.getRegionServer().getServerName().getAddress()), groupName);
        Assert.assertTrue((boolean)master.balance());
        this.assertRegionsInGroup(tableName, groupName);
        TEST_UTIL.getMiniHBaseCluster().killRegionServer(t.getRegionServer().getServerName());
        TEST_UTIL.getMiniHBaseCluster().killRegionServer(t1.getRegionServer().getServerName());
        TEST_UTIL.deleteTable(tableName);
    }

    private void assertRegionsInGroup(TableName table, String group) throws IOException {
        ProcedureExecutor procExecutor = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        for (ProcedureInfo procInfo : procExecutor.listProcedures()) {
            LOG.debug("Waiting for " + procInfo.getProcName() + " " + procInfo.toString());
            this.waitProcedure((ProcedureExecutor<MasterProcedureEnv>)procExecutor, procInfo, 10000L);
        }
        RSGroupInfo rsGroup = rsGroupAdmin.getRSGroupInfo(group);
        for (HRegionInfo region : master.getAssignmentManager().getRegionStates().getRegionsOfTable(table)) {
            Address regionOnServer = ((ServerName)master.getAssignmentManager().getRegionStates().getRegionAssignments().get(region)).getAddress();
            Assert.assertTrue((boolean)rsGroup.getServers().contains(regionOnServer));
        }
    }

    private void crashRsInGroup(String groupName) throws Exception {
        for (Address server : rsGroupAdmin.getRSGroupInfo(groupName).getServers()) {
            final ServerName sn = this.getServerName(server);
            TEST_UTIL.getMiniHBaseCluster().killRegionServer(sn);
            TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() {
                    return TestRSGroupsBase.master.getServerManager().isServerDead(sn);
                }
            });
        }
        Threads.sleep((long)1000L);
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
    }

    private void waitProcedure(ProcedureExecutor<MasterProcedureEnv> procExecutor, ProcedureInfo procInfo, long timeout) {
        long start = EnvironmentEdgeManager.currentTime();
        while (EnvironmentEdgeManager.currentTime() - start < timeout && (procInfo.getProcState() == ProcedureProtos.ProcedureState.INITIALIZING || procExecutor.isRunning() && !procExecutor.isFinished(procInfo.getProcId()))) {
            Threads.sleep((long)1000L);
        }
    }
}

