/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupableBalancer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public class RSGroupBasedLoadBalancer
implements RSGroupableBalancer,
LoadBalancer {
    public static final String HBASE_GROUP_LOADBALANCER_CLASS = "hbase.group.grouploadbalancer.class";
    private static final Log LOG = LogFactory.getLog(RSGroupBasedLoadBalancer.class);
    private Configuration config;
    private ClusterStatus clusterStatus;
    private MasterServices masterServices;
    private RSGroupInfoManager infoManager;
    private LoadBalancer internalBalancer;
    public static final String FALLBACK_GROUP_ENABLE_KEY = "hbase.rsgroup.fallback.enable";
    private boolean fallbackEnabled = false;

    @InterfaceAudience.Private
    public RSGroupBasedLoadBalancer() {
    }

    @InterfaceAudience.Private
    public RSGroupBasedLoadBalancer(RSGroupInfoManager RSGroupInfoManager2) {
        this.infoManager = RSGroupInfoManager2;
    }

    public Configuration getConf() {
        return this.config;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
        if (this.internalBalancer != null) {
            this.internalBalancer.setConf(conf);
        }
    }

    public void setClusterStatus(ClusterStatus st) {
        this.clusterStatus = st;
        if (this.internalBalancer != null) {
            this.internalBalancer.setClusterStatus(st);
        }
    }

    public void setMasterServices(MasterServices masterServices) {
        this.masterServices = masterServices;
    }

    public List<RegionPlan> balanceCluster(TableName tableName, Map<ServerName, List<HRegionInfo>> clusterState) throws HBaseIOException {
        return this.balanceCluster(clusterState);
    }

    public List<RegionPlan> balanceCluster(Map<ServerName, List<HRegionInfo>> clusterState) throws HBaseIOException {
        if (!this.isOnline()) {
            throw new ConstraintException(RSGroupInfoManager.RSGROUP_TABLE_NAME + " is not online, unable to perform balance");
        }
        Map<ServerName, List<HRegionInfo>> correctedState = this.correctAssignments(clusterState);
        ArrayList<RegionPlan> regionPlans = new ArrayList<RegionPlan>();
        List<HRegionInfo> misplacedRegions = correctedState.get(LoadBalancer.BOGUS_SERVER_NAME);
        for (HRegionInfo regionInfo : misplacedRegions) {
            if (this.fallbackEnabled) {
                regionPlans.add(new RegionPlan(regionInfo, this.findServerForRegion(clusterState, regionInfo), null));
                continue;
            }
            regionPlans.add(new RegionPlan(regionInfo, null, null));
        }
        try {
            HashSet<ServerName> processedServers = new HashSet<ServerName>();
            for (RSGroupInfo rsgroup : this.infoManager.listRSGroups()) {
                HashMap<ServerName, List<HRegionInfo>> groupClusterState = new HashMap<ServerName, List<HRegionInfo>>();
                for (ServerName server : clusterState.keySet()) {
                    if (processedServers.contains(server) || !rsgroup.containsServer(server.getAddress())) continue;
                    List<HRegionInfo> regionsOnServer = correctedState.get(server);
                    groupClusterState.put(server, regionsOnServer);
                    processedServers.add(server);
                }
                List groupPlans = this.internalBalancer.balanceCluster(groupClusterState);
                if (groupPlans == null) continue;
                regionPlans.addAll(groupPlans);
            }
        }
        catch (IOException exp) {
            LOG.warn((Object)"Exception while balancing cluster.", (Throwable)exp);
            regionPlans.clear();
        }
        return regionPlans;
    }

    public Map<ServerName, List<HRegionInfo>> roundRobinAssignment(List<HRegionInfo> regions, List<ServerName> servers) throws HBaseIOException {
        HashMap assignments = Maps.newHashMap();
        List<Pair<List<HRegionInfo>, List<ServerName>>> pairs = this.generateGroupAssignments(regions, servers);
        for (Pair<List<HRegionInfo>, List<ServerName>> pair : pairs) {
            Map result = this.internalBalancer.roundRobinAssignment((List)pair.getFirst(), (List)pair.getSecond());
            if (result == null) continue;
            for (Map.Entry entry : result.entrySet()) {
                ServerName serverName = (ServerName)entry.getKey();
                List regionInfos = (List)entry.getValue();
                if (!assignments.containsKey(serverName)) {
                    assignments.put(serverName, Lists.newArrayList());
                }
                ((List)assignments.get(serverName)).addAll(regionInfos);
            }
        }
        return assignments;
    }

    public Map<ServerName, List<HRegionInfo>> retainAssignment(Map<HRegionInfo, ServerName> regions, List<ServerName> servers) throws HBaseIOException {
        try {
            TreeMap<ServerName, List<HRegionInfo>> assignments = new TreeMap<ServerName, List<HRegionInfo>>();
            List<Pair<List<HRegionInfo>, List<ServerName>>> pairs = this.generateGroupAssignments(Lists.newArrayList(regions.keySet()), servers);
            for (Pair<List<HRegionInfo>, List<ServerName>> pair : pairs) {
                List regionList = (List)pair.getFirst();
                TreeMap currentAssignmentMap = Maps.newTreeMap();
                for (HRegionInfo regionInfo : regionList) {
                    currentAssignmentMap.put(regionInfo, regions.get(regionInfo));
                }
                Map pairResult = this.internalBalancer.retainAssignment((Map)currentAssignmentMap, (List)pair.getSecond());
                for (Map.Entry entry : pairResult.entrySet()) {
                    ServerName serverName = (ServerName)entry.getKey();
                    List regionInfos = (List)entry.getValue();
                    if (!assignments.containsKey(serverName)) {
                        assignments.put(serverName, Lists.newArrayList());
                    }
                    ((List)assignments.get(serverName)).addAll(regionInfos);
                }
            }
            return assignments;
        }
        catch (IOException e) {
            throw new HBaseIOException("Failed to do online retain assignment", (Throwable)e);
        }
    }

    public Map<HRegionInfo, ServerName> immediateAssignment(List<HRegionInfo> regions, List<ServerName> servers) throws HBaseIOException {
        throw new UnsupportedOperationException("immediateAssignment is not supported");
    }

    public ServerName randomAssignment(HRegionInfo region, List<ServerName> servers) throws HBaseIOException {
        List<Pair<List<HRegionInfo>, List<ServerName>>> pairs = this.generateGroupAssignments(Lists.newArrayList((Object[])new HRegionInfo[]{region}), servers);
        List filteredServers = (List)pairs.iterator().next().getSecond();
        return this.internalBalancer.randomAssignment(region, filteredServers);
    }

    private List<Pair<List<HRegionInfo>, List<ServerName>>> generateGroupAssignments(List<HRegionInfo> regions, List<ServerName> servers) throws HBaseIOException {
        try {
            ArrayListMultimap regionMap = ArrayListMultimap.create();
            ArrayListMultimap serverMap = ArrayListMultimap.create();
            for (HRegionInfo region : regions) {
                String groupName = this.infoManager.getRSGroupOfTable(region.getTable());
                if (groupName == null) {
                    LOG.debug((Object)("Group not found for table " + region.getTable() + ", using default"));
                    groupName = "default";
                }
                regionMap.put((Object)groupName, (Object)region);
            }
            for (String groupKey : regionMap.keySet()) {
                RSGroupInfo info = this.infoManager.getRSGroup(groupKey);
                serverMap.putAll((Object)groupKey, this.filterOfflineServers(info, servers));
            }
            ArrayList result = Lists.newArrayList();
            ArrayList fallbackRegions = Lists.newArrayList();
            for (String groupKey : regionMap.keySet()) {
                if (serverMap.get((Object)groupKey).isEmpty()) {
                    fallbackRegions.addAll(regionMap.get((Object)groupKey));
                    continue;
                }
                result.add(Pair.newPair((Object)regionMap.get((Object)groupKey), (Object)serverMap.get((Object)groupKey)));
            }
            if (!fallbackRegions.isEmpty()) {
                ArrayList candidates = null;
                if (this.isFallbackEnabled()) {
                    candidates = this.getFallBackCandidates(servers);
                }
                candidates = candidates == null || candidates.isEmpty() ? Lists.newArrayList((Object[])new ServerName[]{BOGUS_SERVER_NAME}) : candidates;
                result.add(Pair.newPair((Object)fallbackRegions, (Object)candidates));
            }
            return result;
        }
        catch (IOException e) {
            throw new HBaseIOException("Failed to generate group assignments", (Throwable)e);
        }
    }

    private List<ServerName> filterOfflineServers(RSGroupInfo RSGroupInfo2, List<ServerName> onlineServers) {
        if (RSGroupInfo2 != null) {
            return this.filterServers(RSGroupInfo2.getServers(), onlineServers);
        }
        LOG.debug((Object)"Group Information found to be null. Some regions might be unassigned.");
        return Collections.emptyList();
    }

    private List<ServerName> filterServers(Set<Address> servers, List<ServerName> onlineServers) {
        ArrayList<ServerName> finalList = new ArrayList<ServerName>();
        for (ServerName onlineServer : onlineServers) {
            if (!servers.contains(onlineServer.getAddress())) continue;
            finalList.add(onlineServer);
        }
        return finalList;
    }

    public Set<HRegionInfo> getMisplacedRegions(Map<HRegionInfo, ServerName> regions) throws IOException {
        HashSet<HRegionInfo> misplacedRegions = new HashSet<HRegionInfo>();
        for (Map.Entry<HRegionInfo, ServerName> region : regions.entrySet()) {
            HRegionInfo regionInfo = region.getKey();
            ServerName assignedServer = region.getValue();
            String groupName = this.infoManager.getRSGroupOfTable(regionInfo.getTable());
            if (groupName == null) {
                LOG.debug((Object)("Group not found for table " + regionInfo.getTable() + ", using default"));
                groupName = "default";
            }
            RSGroupInfo info = this.infoManager.getRSGroup(groupName);
            if (assignedServer == null) {
                LOG.debug((Object)("There is no assigned server for " + region));
                continue;
            }
            RSGroupInfo otherInfo = this.infoManager.getRSGroupOfServer(assignedServer.getAddress());
            if (info == null && otherInfo == null) {
                LOG.warn((Object)("Couldn't obtain rs group information for " + region + " on " + assignedServer));
                continue;
            }
            if (info != null && info.containsServer(assignedServer.getAddress())) continue;
            LOG.debug((Object)("Found misplaced region: " + regionInfo.getRegionNameAsString() + " on server: " + assignedServer + " found in group: " + otherInfo + " outside of group: " + (info == null ? "UNKNOWN" : info.getName())));
            misplacedRegions.add(regionInfo);
        }
        return misplacedRegions;
    }

    private ServerName findServerForRegion(Map<ServerName, List<HRegionInfo>> existingAssignments, HRegionInfo region) {
        for (Map.Entry<ServerName, List<HRegionInfo>> entry : existingAssignments.entrySet()) {
            if (!entry.getValue().contains(region)) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Could not find server for region " + region.getShortNameToLog());
    }

    private Map<ServerName, List<HRegionInfo>> correctAssignments(Map<ServerName, List<HRegionInfo>> existingAssignments) {
        TreeMap<ServerName, List<HRegionInfo>> correctAssignments = new TreeMap<ServerName, List<HRegionInfo>>();
        correctAssignments.put(LoadBalancer.BOGUS_SERVER_NAME, new LinkedList());
        for (Map.Entry<ServerName, List<HRegionInfo>> assignments : existingAssignments.entrySet()) {
            ServerName sName = assignments.getKey();
            correctAssignments.put(sName, new LinkedList());
            List<HRegionInfo> regions = assignments.getValue();
            for (HRegionInfo region : regions) {
                RSGroupInfo info = null;
                try {
                    String groupName = this.infoManager.getRSGroupOfTable(region.getTable());
                    if (groupName == null) {
                        LOG.debug((Object)("Group not found for table " + region.getTable() + ", using default"));
                        groupName = "default";
                    }
                    info = this.infoManager.getRSGroup(groupName);
                }
                catch (IOException exp) {
                    LOG.debug((Object)("Group information null for region of table " + region.getTable()), (Throwable)exp);
                }
                if (info == null || !info.containsServer(sName.getAddress())) {
                    ((List)correctAssignments.get(LoadBalancer.BOGUS_SERVER_NAME)).add(region);
                    continue;
                }
                ((List)correctAssignments.get(sName)).add(region);
            }
        }
        return correctAssignments;
    }

    public void initialize() throws HBaseIOException {
        try {
            if (this.infoManager == null) {
                List cps = this.masterServices.getMasterCoprocessorHost().findCoprocessors(RSGroupAdminEndpoint.class);
                if (cps.size() != 1) {
                    String msg = "Expected one implementation of GroupAdminEndpoint but found " + cps.size();
                    LOG.error((Object)msg);
                    throw new HBaseIOException(msg);
                }
                this.infoManager = ((RSGroupAdminEndpoint)((Object)cps.get(0))).getGroupInfoManager();
                if (this.infoManager == null) {
                    String msg = "RSGroupInfoManager hasn't been initialized";
                    LOG.error((Object)msg);
                    throw new HBaseIOException(msg);
                }
                this.infoManager.start();
            }
        }
        catch (IOException e) {
            throw new HBaseIOException("Failed to initialize GroupInfoManagerImpl", (Throwable)e);
        }
        Class balancerKlass = this.config.getClass(HBASE_GROUP_LOADBALANCER_CLASS, StochasticLoadBalancer.class, LoadBalancer.class);
        this.internalBalancer = (LoadBalancer)ReflectionUtils.newInstance((Class)balancerKlass, (Configuration)this.config);
        if (this.clusterStatus != null) {
            this.internalBalancer.setClusterStatus(this.clusterStatus);
        }
        this.internalBalancer.setMasterServices(this.masterServices);
        this.internalBalancer.setConf(this.config);
        this.internalBalancer.initialize();
        this.fallbackEnabled = this.config.getBoolean(FALLBACK_GROUP_ENABLE_KEY, false);
    }

    public boolean isOnline() {
        return this.infoManager != null && this.infoManager.isOnline();
    }

    public boolean isFallbackEnabled() {
        return this.fallbackEnabled;
    }

    public void regionOnline(HRegionInfo regionInfo, ServerName sn) {
    }

    public void regionOffline(HRegionInfo regionInfo) {
    }

    public void onConfigurationChange(Configuration conf) {
        boolean newFallbackEnabled = conf.getBoolean(FALLBACK_GROUP_ENABLE_KEY, false);
        if (this.fallbackEnabled != newFallbackEnabled) {
            LOG.info((Object)("Changing the value of hbase.rsgroup.fallback.enable from " + this.fallbackEnabled + " to " + newFallbackEnabled));
            this.fallbackEnabled = newFallbackEnabled;
        }
        this.internalBalancer.onConfigurationChange(conf);
    }

    public void stop(String why) {
    }

    public boolean isStopped() {
        return false;
    }

    public void postMasterStartupInitialize() {
        this.internalBalancer.postMasterStartupInitialize();
    }

    public void updateBalancerStatus(boolean status) {
        this.internalBalancer.updateBalancerStatus(status);
    }

    private List<ServerName> getFallBackCandidates(List<ServerName> servers) {
        List<ServerName> serverNames = null;
        try {
            RSGroupInfo info = this.infoManager.getRSGroup("default");
            serverNames = this.filterOfflineServers(info, servers);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to get default rsgroup info to fallback", (Throwable)e);
        }
        return serverNames == null || serverNames.isEmpty() ? servers : serverNames;
    }
}

