/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class MultiTableInputFormatBase
extends InputFormat<ImmutableBytesWritable, Result> {
    final Log LOG = LogFactory.getLog(MultiTableInputFormatBase.class);
    private List<Scan> scans;
    private TableRecordReader tableRecordReader = null;

    public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        TableSplit tSplit = (TableSplit)split;
        if (tSplit.getTableName() == null) {
            throw new IOException("Cannot create a record reader because of a previous error. Please look at the previous logs lines from the task's full log for more details.");
        }
        HTable table = new HTable(context.getConfiguration(), tSplit.getTableName());
        TableRecordReader trr = this.tableRecordReader;
        if (trr == null) {
            trr = new TableRecordReader();
        }
        Scan sc = tSplit.getScan();
        sc.setStartRow(tSplit.getStartRow());
        sc.setStopRow(tSplit.getEndRow());
        trr.setScan(sc);
        trr.setHTable(table);
        return trr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InputSplit> getSplits(JobContext context) throws IOException {
        if (this.scans.isEmpty()) {
            throw new IOException("No scans were provided.");
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (Scan scan : this.scans) {
            byte[] tableName = scan.getAttribute("scan.attributes.table.name");
            if (tableName == null) {
                throw new IOException("A scan object did not have a table name");
            }
            HTable table = null;
            try {
                table = new HTable(context.getConfiguration(), tableName);
                Pair keys = table.getStartEndKeys();
                if (keys == null || keys.getFirst() == null || ((byte[][])keys.getFirst()).length == 0) {
                    throw new IOException("Expecting at least one region for table : " + Bytes.toString((byte[])tableName));
                }
                int count = 0;
                byte[] startRow = scan.getStartRow();
                byte[] stopRow = scan.getStopRow();
                for (int i = 0; i < ((byte[][])keys.getFirst()).length; ++i) {
                    if (!this.includeRegionInSplit(((byte[][])keys.getFirst())[i], ((byte[][])keys.getSecond())[i])) continue;
                    String regionLocation = table.getRegionLocation(((byte[][])keys.getFirst())[i], false).getHostname();
                    if (startRow.length != 0 && ((byte[][])keys.getSecond())[i].length != 0 && Bytes.compareTo((byte[])startRow, (byte[])((byte[][])keys.getSecond())[i]) >= 0 || stopRow.length != 0 && Bytes.compareTo((byte[])stopRow, (byte[])((byte[][])keys.getFirst())[i]) <= 0) continue;
                    byte[] splitStart = startRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getFirst())[i], (byte[])startRow) >= 0 ? ((byte[][])keys.getFirst())[i] : startRow;
                    byte[] splitStop = (stopRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getSecond())[i], (byte[])stopRow) <= 0) && ((byte[][])keys.getSecond())[i].length > 0 ? ((byte[][])keys.getSecond())[i] : stopRow;
                    TableSplit split = new TableSplit(table.getName(), scan, splitStart, splitStop, regionLocation);
                    splits.add(split);
                    if (!this.LOG.isDebugEnabled()) continue;
                    this.LOG.debug((Object)("getSplits: split -> " + count++ + " -> " + split));
                }
            }
            finally {
                if (null == table) continue;
                table.close();
            }
        }
        return splits;
    }

    protected boolean includeRegionInSplit(byte[] startKey, byte[] endKey) {
        return true;
    }

    protected List<Scan> getScans() {
        return this.scans;
    }

    protected void setScans(List<Scan> scans) {
        this.scans = scans;
    }

    protected void setTableRecordReader(TableRecordReader tableRecordReader) {
        this.tableRecordReader = tableRecordReader;
    }
}

