/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.HMaster;

@InterfaceAudience.Private
public class BalancerChore
extends Chore {
    private static final Log LOG = LogFactory.getLog(BalancerChore.class);
    private final HMaster master;

    public BalancerChore(HMaster master) {
        super(master.getServerName() + "-BalancerChore", master.getConfiguration().getInt("hbase.balancer.period", 300000), (Stoppable)master);
        this.master = master;
    }

    protected void chore() {
        try {
            this.master.balance();
        }
        catch (HBaseIOException e) {
            LOG.error((Object)"Failed to balance.", (Throwable)e);
        }
    }
}

