/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.BulkReOpen;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public abstract class TableEventHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(TableEventHandler.class);
    protected final MasterServices masterServices;
    protected final TableName tableName;
    protected TableLockManager.TableLock tableLock;
    private boolean isPrepareCalled = false;

    public TableEventHandler(EventType eventType, TableName tableName, Server server, MasterServices masterServices) {
        super(server, eventType);
        this.masterServices = masterServices;
        this.tableName = tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableEventHandler prepare() throws IOException {
        this.tableLock = this.masterServices.getTableLockManager().writeLock(this.tableName, this.eventType.toString());
        this.tableLock.acquire();
        boolean success = false;
        try {
            try {
                this.masterServices.checkTableModifiable(this.tableName);
            }
            catch (TableNotDisabledException ex) {
                if (this.isOnlineSchemaChangeAllowed() && this.eventType.isOnlineSchemaChangeSupported()) {
                    LOG.debug((Object)"Ignoring table not disabled exception for supporting online schema changes.");
                }
                throw ex;
            }
            this.prepareWithTableLock();
            success = true;
        }
        finally {
            if (!success) {
                this.releaseTableLock();
            }
        }
        this.isPrepareCalled = true;
        return this;
    }

    protected void prepareWithTableLock() throws IOException {
    }

    private boolean isOnlineSchemaChangeAllowed() {
        return this.server.getConfiguration().getBoolean("hbase.online.schema.update.enable", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        if (!this.isPrepareCalled) {
            throw new RuntimeException("Implementation should have called prepare() first");
        }
        try {
            LOG.info((Object)("Handling table operation " + this.eventType + " on table " + this.tableName));
            List hris = MetaReader.getTableRegions((CatalogTracker)this.server.getCatalogTracker(), (TableName)this.tableName);
            this.handleTableOperation(hris);
            if (this.eventType.isOnlineSchemaChangeSupported() && this.masterServices.getAssignmentManager().getZKTable().isEnabledTable(this.tableName)) {
                if (this.reOpenAllRegions(hris)) {
                    LOG.info((Object)("Completed table operation " + this.eventType + " on table " + this.tableName));
                } else {
                    LOG.warn((Object)"Error on reopening the regions");
                }
            }
            this.completed(null);
        }
        catch (IOException e) {
            LOG.error((Object)("Error manipulating table " + this.tableName), (Throwable)e);
            this.completed(e);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Error manipulating table " + this.tableName), (Throwable)e);
            this.completed(e);
        }
        finally {
            this.releaseTableLock();
        }
    }

    protected void releaseTableLock() {
        if (this.tableLock != null) {
            try {
                this.tableLock.release();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Could not release the table lock", (Throwable)ex);
            }
        }
    }

    protected void completed(Throwable exception) {
    }

    public boolean reOpenAllRegions(List<HRegionInfo> regions) throws IOException {
        boolean done = false;
        LOG.info((Object)"Bucketing regions by region server...");
        HTable table = new HTable(this.masterServices.getConfiguration(), this.tableName);
        TreeMap serverToRegions = Maps.newTreeMap();
        NavigableMap hriHserverMapping = table.getRegionLocations();
        ArrayList<HRegionInfo> reRegions = new ArrayList<HRegionInfo>();
        for (HRegionInfo hri : regions) {
            ServerName rsLocation = (ServerName)hriHserverMapping.get(hri);
            if (null == rsLocation) {
                LOG.info((Object)("Skip " + hri));
                continue;
            }
            if (!serverToRegions.containsKey(rsLocation)) {
                LinkedList hriList = Lists.newLinkedList();
                serverToRegions.put(rsLocation, hriList);
            }
            reRegions.add(hri);
            ((List)serverToRegions.get(rsLocation)).add(hri);
        }
        LOG.info((Object)("Reopening " + reRegions.size() + " regions on " + serverToRegions.size() + " region servers."));
        this.masterServices.getAssignmentManager().setRegionsToReopen(reRegions);
        BulkReOpen bulkReopen = new BulkReOpen(this.server, serverToRegions, this.masterServices.getAssignmentManager());
        try {
            while (true) {
                if (bulkReopen.bulkReOpen()) {
                    done = true;
                    break;
                }
                LOG.warn((Object)"Timeout before reopening all regions");
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Reopen was interrupted");
            Thread.currentThread().interrupt();
        }
        return done;
    }

    public HTableDescriptor getTableDescriptor() throws FileNotFoundException, IOException {
        HTableDescriptor htd = this.masterServices.getTableDescriptors().get(this.tableName);
        if (htd == null) {
            throw new IOException("HTableDescriptor missing for " + this.tableName);
        }
        return htd;
    }

    byte[] hasColumnFamily(HTableDescriptor htd, byte[] cf) throws InvalidFamilyOperationException {
        if (!htd.hasFamily(cf)) {
            throw new InvalidFamilyOperationException("Column family '" + Bytes.toString((byte[])cf) + "' does not exist");
        }
        return cf;
    }

    protected abstract void handleTableOperation(List<HRegionInfo> var1) throws IOException, KeeperException;
}

