/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.codehaus.jackson.map.ObjectMapper;

@InterfaceAudience.Private
class MonitoredTaskImpl
implements MonitoredTask {
    private long startTime;
    private long statusTime;
    private long stateTime;
    private volatile String status;
    private volatile String description;
    protected volatile MonitoredTask.State state = MonitoredTask.State.RUNNING;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public MonitoredTaskImpl() {
        this.statusTime = this.startTime = System.currentTimeMillis();
        this.stateTime = this.startTime;
    }

    @Override
    public synchronized MonitoredTaskImpl clone() {
        try {
            return (MonitoredTaskImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public long getStatusTime() {
        return this.statusTime;
    }

    @Override
    public MonitoredTask.State getState() {
        return this.state;
    }

    @Override
    public long getStateTime() {
        return this.stateTime;
    }

    @Override
    public long getCompletionTimestamp() {
        if (this.state == MonitoredTask.State.COMPLETE || this.state == MonitoredTask.State.ABORTED) {
            return this.stateTime;
        }
        return -1L;
    }

    @Override
    public void markComplete(String status) {
        this.setState(MonitoredTask.State.COMPLETE);
        this.setStatus(status);
    }

    @Override
    public void pause(String msg) {
        this.setState(MonitoredTask.State.WAITING);
        this.setStatus(msg);
    }

    @Override
    public void resume(String msg) {
        this.setState(MonitoredTask.State.RUNNING);
        this.setStatus(msg);
    }

    @Override
    public void abort(String msg) {
        this.setStatus(msg);
        this.setState(MonitoredTask.State.ABORTED);
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
        this.statusTime = System.currentTimeMillis();
    }

    protected void setState(MonitoredTask.State state) {
        this.state = state;
        this.stateTime = System.currentTimeMillis();
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void cleanup() {
        if (this.state == MonitoredTask.State.RUNNING) {
            this.setState(MonitoredTask.State.ABORTED);
        }
    }

    @Override
    public void expireNow() {
        this.stateTime -= 180000L;
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", this.getDescription());
        map.put("status", this.getStatus());
        map.put("state", (Object)this.getState());
        map.put("starttimems", this.getStartTime());
        map.put("statustimems", this.getCompletionTimestamp());
        map.put("statetimems", this.getCompletionTimestamp());
        return map;
    }

    @Override
    public String toJSON() throws IOException {
        return MAPPER.writeValueAsString(this.toMap());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.getDescription());
        sb.append(": status=");
        sb.append(this.getStatus());
        sb.append(", state=");
        sb.append((Object)this.getState());
        sb.append(", startTime=");
        sb.append(this.getStartTime());
        sb.append(", completionTime=");
        sb.append(this.getCompletionTimestamp());
        return sb.toString();
    }
}

