/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.metrics2.MetricsExecutor;

@InterfaceAudience.Private
class MetricsRegionServerWrapperImpl
implements MetricsRegionServerWrapper {
    public static final Log LOG = LogFactory.getLog(MetricsRegionServerWrapperImpl.class);
    private final HRegionServer regionServer;
    private BlockCache blockCache;
    private volatile long numStores = 0L;
    private volatile long numHLogFiles = 0L;
    private volatile long hlogFileSize = 0L;
    private volatile long numStoreFiles = 0L;
    private volatile long memstoreSize = 0L;
    private volatile long storeFileSize = 0L;
    private volatile double requestsPerSecond = 0.0;
    private volatile long readRequestsCount = 0L;
    private volatile long writeRequestsCount = 0L;
    private volatile long checkAndMutateChecksFailed = 0L;
    private volatile long checkAndMutateChecksPassed = 0L;
    private volatile long storefileIndexSize = 0L;
    private volatile long totalStaticIndexSize = 0L;
    private volatile long totalStaticBloomSize = 0L;
    private volatile long numMutationsWithoutWAL = 0L;
    private volatile long dataInMemoryWithoutWAL = 0L;
    private volatile int percentFileLocal = 0;
    private CacheStats cacheStats;
    private ScheduledExecutorService executor;
    private Runnable runnable;
    private long period;

    public MetricsRegionServerWrapperImpl(HRegionServer regionServer) {
        this.regionServer = regionServer;
        this.initBlockCache();
        this.period = regionServer.conf.getLong("hbase.regionserver.metrics.period", 5000L);
        this.executor = ((MetricsExecutor)CompatibilitySingletonFactory.getInstance(MetricsExecutor.class)).getExecutor();
        this.runnable = new RegionServerMetricsWrapperRunnable();
        this.executor.scheduleWithFixedDelay(this.runnable, this.period, this.period, TimeUnit.MILLISECONDS);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Computing regionserver metrics every " + this.period + " milliseconds"));
        }
    }

    private synchronized void initBlockCache() {
        CacheConfig cacheConfig = this.regionServer.cacheConfig;
        if (cacheConfig != null && this.blockCache == null) {
            this.blockCache = cacheConfig.getBlockCache();
        }
        if (this.blockCache != null && this.cacheStats == null) {
            this.cacheStats = this.blockCache.getStats();
        }
    }

    public String getClusterId() {
        return this.regionServer.getClusterId();
    }

    public long getStartCode() {
        return this.regionServer.getStartcode();
    }

    public String getZookeeperQuorum() {
        ZooKeeperWatcher zk = this.regionServer.getZooKeeperWatcher();
        if (zk == null) {
            return "";
        }
        return zk.getQuorum();
    }

    public String getCoprocessors() {
        Object[] coprocessors = this.regionServer.getCoprocessors();
        if (coprocessors == null || coprocessors.length == 0) {
            return "";
        }
        return StringUtils.join((Object[])coprocessors, (String)", ");
    }

    public String getServerName() {
        ServerName serverName = this.regionServer.getServerName();
        if (serverName == null) {
            return "";
        }
        return serverName.getServerName();
    }

    public long getNumOnlineRegions() {
        Collection<HRegion> onlineRegionsLocalContext = this.regionServer.getOnlineRegionsLocalContext();
        if (onlineRegionsLocalContext == null) {
            return 0L;
        }
        return onlineRegionsLocalContext.size();
    }

    public long getTotalRequestCount() {
        return this.regionServer.requestCount.get();
    }

    public int getCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getCompactionQueueSize();
    }

    public int getSmallCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getSmallCompactionQueueSize();
    }

    public int getLargeCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getLargeCompactionQueueSize();
    }

    public int getFlushQueueSize() {
        if (this.regionServer.cacheFlusher == null) {
            return 0;
        }
        return this.regionServer.cacheFlusher.getFlushQueueSize();
    }

    public long getBlockCacheCount() {
        if (this.blockCache == null) {
            return 0L;
        }
        return this.blockCache.size();
    }

    public long getBlockCacheSize() {
        if (this.blockCache == null) {
            return 0L;
        }
        return this.blockCache.getCurrentSize();
    }

    public long getBlockCacheFreeSize() {
        if (this.blockCache == null) {
            return 0L;
        }
        return this.blockCache.getFreeSize();
    }

    public long getBlockCacheHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getHitCount();
    }

    public long getBlockCacheMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getMissCount();
    }

    public long getBlockCacheEvictedCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getEvictedCount();
    }

    public int getBlockCacheHitPercent() {
        if (this.cacheStats == null) {
            return 0;
        }
        return (int)(this.cacheStats.getHitRatio() * 100.0);
    }

    public int getBlockCacheHitCachingPercent() {
        if (this.cacheStats == null) {
            return 0;
        }
        return (int)(this.cacheStats.getHitCachingRatio() * 100.0);
    }

    public void forceRecompute() {
        this.runnable.run();
    }

    public long getNumStores() {
        return this.numStores;
    }

    public long getNumHLogFiles() {
        return this.numHLogFiles;
    }

    public long getHLogFileSize() {
        return this.hlogFileSize;
    }

    public long getNumStoreFiles() {
        return this.numStoreFiles;
    }

    public long getMemstoreSize() {
        return this.memstoreSize;
    }

    public long getStoreFileSize() {
        return this.storeFileSize;
    }

    public double getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public long getReadRequestsCount() {
        return this.readRequestsCount;
    }

    public long getWriteRequestsCount() {
        return this.writeRequestsCount;
    }

    public long getCheckAndMutateChecksFailed() {
        return this.checkAndMutateChecksFailed;
    }

    public long getCheckAndMutateChecksPassed() {
        return this.checkAndMutateChecksPassed;
    }

    public long getStoreFileIndexSize() {
        return this.storefileIndexSize;
    }

    public long getTotalStaticIndexSize() {
        return this.totalStaticIndexSize;
    }

    public long getTotalStaticBloomSize() {
        return this.totalStaticBloomSize;
    }

    public long getNumMutationsWithoutWAL() {
        return this.numMutationsWithoutWAL;
    }

    public long getDataInMemoryWithoutWAL() {
        return this.dataInMemoryWithoutWAL;
    }

    public int getPercentFileLocal() {
        return this.percentFileLocal;
    }

    public long getUpdatesBlockedTime() {
        if (this.regionServer.cacheFlusher == null) {
            return 0L;
        }
        return this.regionServer.cacheFlusher.getUpdatesBlockedMsHighWater().get();
    }

    public class RegionServerMetricsWrapperRunnable
    implements Runnable {
        private long lastRan = 0L;
        private long lastRequestCount = 0L;

        @Override
        public synchronized void run() {
            MetricsRegionServerWrapperImpl.this.initBlockCache();
            MetricsRegionServerWrapperImpl.this.cacheStats = MetricsRegionServerWrapperImpl.this.blockCache.getStats();
            HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
            long tempNumStores = 0L;
            long tempNumStoreFiles = 0L;
            long tempMemstoreSize = 0L;
            long tempStoreFileSize = 0L;
            long tempReadRequestsCount = 0L;
            long tempWriteRequestsCount = 0L;
            long tempCheckAndMutateChecksFailed = 0L;
            long tempCheckAndMutateChecksPassed = 0L;
            long tempStorefileIndexSize = 0L;
            long tempTotalStaticIndexSize = 0L;
            long tempTotalStaticBloomSize = 0L;
            long tempNumMutationsWithoutWAL = 0L;
            long tempDataInMemoryWithoutWAL = 0L;
            int tempPercentFileLocal = 0;
            for (HRegion r : MetricsRegionServerWrapperImpl.this.regionServer.getOnlineRegionsLocalContext()) {
                tempNumMutationsWithoutWAL += r.numMutationsWithoutWAL.get();
                tempDataInMemoryWithoutWAL += r.dataInMemoryWithoutWAL.get();
                tempReadRequestsCount += r.readRequestsCount.get();
                tempWriteRequestsCount += r.writeRequestsCount.get();
                tempCheckAndMutateChecksFailed += r.checkAndMutateChecksFailed.get();
                tempCheckAndMutateChecksPassed += r.checkAndMutateChecksPassed.get();
                tempNumStores += (long)r.stores.size();
                for (Store store : r.stores.values()) {
                    tempNumStoreFiles += (long)store.getStorefilesCount();
                    tempMemstoreSize += store.getMemStoreSize();
                    tempStoreFileSize += store.getStorefilesSize();
                    tempStorefileIndexSize += store.getStorefilesIndexSize();
                    tempTotalStaticBloomSize += store.getTotalStaticBloomSize();
                    tempTotalStaticIndexSize += store.getTotalStaticIndexSize();
                }
                hdfsBlocksDistribution.add(r.getHDFSBlocksDistribution());
            }
            float localityIndex = hdfsBlocksDistribution.getBlockLocalityIndex(MetricsRegionServerWrapperImpl.this.regionServer.getServerName().getHostname());
            tempPercentFileLocal = (int)(localityIndex * 100.0f);
            long currentTime = EnvironmentEdgeManager.currentTimeMillis();
            if (this.lastRan == 0L) {
                this.lastRan = currentTime - MetricsRegionServerWrapperImpl.this.period * 1000L;
            }
            if (currentTime - this.lastRan > 0L) {
                long currentRequestCount = MetricsRegionServerWrapperImpl.this.getTotalRequestCount();
                MetricsRegionServerWrapperImpl.this.requestsPerSecond = (double)(currentRequestCount - this.lastRequestCount) / ((double)(currentTime - this.lastRan) / 1000.0);
                this.lastRequestCount = currentRequestCount;
            }
            this.lastRan = currentTime;
            MetricsRegionServerWrapperImpl.this.numStores = tempNumStores;
            long tempNumHLogFiles = ((MetricsRegionServerWrapperImpl)MetricsRegionServerWrapperImpl.this).regionServer.hlog.getNumLogFiles();
            if (((MetricsRegionServerWrapperImpl)MetricsRegionServerWrapperImpl.this).regionServer.hlogForMeta != null) {
                tempNumHLogFiles += (long)((MetricsRegionServerWrapperImpl)MetricsRegionServerWrapperImpl.this).regionServer.hlogForMeta.getNumLogFiles();
            }
            MetricsRegionServerWrapperImpl.this.numHLogFiles = tempNumHLogFiles;
            long tempHlogFileSize = ((MetricsRegionServerWrapperImpl)MetricsRegionServerWrapperImpl.this).regionServer.hlog.getLogFileSize();
            if (((MetricsRegionServerWrapperImpl)MetricsRegionServerWrapperImpl.this).regionServer.hlogForMeta != null) {
                tempHlogFileSize += ((MetricsRegionServerWrapperImpl)MetricsRegionServerWrapperImpl.this).regionServer.hlogForMeta.getLogFileSize();
            }
            MetricsRegionServerWrapperImpl.this.hlogFileSize = tempHlogFileSize;
            MetricsRegionServerWrapperImpl.this.numStoreFiles = tempNumStoreFiles;
            MetricsRegionServerWrapperImpl.this.memstoreSize = tempMemstoreSize;
            MetricsRegionServerWrapperImpl.this.storeFileSize = tempStoreFileSize;
            MetricsRegionServerWrapperImpl.this.readRequestsCount = tempReadRequestsCount;
            MetricsRegionServerWrapperImpl.this.writeRequestsCount = tempWriteRequestsCount;
            MetricsRegionServerWrapperImpl.this.checkAndMutateChecksFailed = tempCheckAndMutateChecksFailed;
            MetricsRegionServerWrapperImpl.this.checkAndMutateChecksPassed = tempCheckAndMutateChecksPassed;
            MetricsRegionServerWrapperImpl.this.storefileIndexSize = tempStorefileIndexSize;
            MetricsRegionServerWrapperImpl.this.totalStaticIndexSize = tempTotalStaticIndexSize;
            MetricsRegionServerWrapperImpl.this.totalStaticBloomSize = tempTotalStaticBloomSize;
            MetricsRegionServerWrapperImpl.this.numMutationsWithoutWAL = tempNumMutationsWithoutWAL;
            MetricsRegionServerWrapperImpl.this.dataInMemoryWithoutWAL = tempDataInMemoryWithoutWAL;
            MetricsRegionServerWrapperImpl.this.percentFileLocal = tempPercentFileLocal;
        }
    }
}

