/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;

@InterfaceAudience.Private
public class CompactionConfiguration {
    static final Log LOG = LogFactory.getLog(CompactionConfiguration.class);
    private static final String CONFIG_PREFIX = "hbase.hstore.compaction.";
    Configuration conf;
    StoreConfigInformation storeConfigInfo;
    long maxCompactSize;
    long minCompactSize;
    int minFilesToCompact;
    int maxFilesToCompact;
    double compactionRatio;
    double offPeekCompactionRatio;
    long throttlePoint;
    boolean shouldDeleteExpired;
    long majorCompactionPeriod;
    float majorCompactionJitter;

    CompactionConfiguration(Configuration conf, StoreConfigInformation storeConfigInfo) {
        this.conf = conf;
        this.storeConfigInfo = storeConfigInfo;
        this.maxCompactSize = conf.getLong("hbase.hstore.compaction.max.size", Long.MAX_VALUE);
        this.minCompactSize = conf.getLong("hbase.hstore.compaction.min.size", storeConfigInfo.getMemstoreFlushSize());
        this.minFilesToCompact = Math.max(2, conf.getInt("hbase.hstore.compaction.min", conf.getInt("hbase.hstore.compactionThreshold", 3)));
        this.maxFilesToCompact = conf.getInt("hbase.hstore.compaction.max", 10);
        this.compactionRatio = conf.getFloat("hbase.hstore.compaction.ratio", 1.2f);
        this.offPeekCompactionRatio = conf.getFloat("hbase.hstore.compaction.ratio.offpeak", 5.0f);
        this.throttlePoint = conf.getLong("hbase.regionserver.thread.compaction.throttle", (long)(2 * this.maxFilesToCompact) * storeConfigInfo.getMemstoreFlushSize());
        this.shouldDeleteExpired = conf.getBoolean("hbase.store.delete.expired.storefile", true);
        this.majorCompactionPeriod = conf.getLong("hbase.hregion.majorcompaction", 604800000L);
        this.majorCompactionJitter = conf.getFloat("hbase.hregion.majorcompaction.jitter", 0.5f);
        LOG.info((Object)this);
    }

    public String toString() {
        return String.format("size [%d, %d); files [%d, %d); ratio %f; off-peak ratio %f; throttle point %d;%s delete expired; major period %d, major jitter %f", this.minCompactSize, this.maxCompactSize, this.minFilesToCompact, this.maxFilesToCompact, this.compactionRatio, this.offPeekCompactionRatio, this.throttlePoint, this.shouldDeleteExpired ? "" : " don't", this.majorCompactionPeriod, Float.valueOf(this.majorCompactionJitter));
    }

    long getMinCompactSize() {
        return this.minCompactSize;
    }

    long getMaxCompactSize() {
        return this.maxCompactSize;
    }

    int getMinFilesToCompact() {
        return this.minFilesToCompact;
    }

    int getMaxFilesToCompact() {
        return this.maxFilesToCompact;
    }

    double getCompactionRatio() {
        return this.compactionRatio;
    }

    double getCompactionRatioOffPeak() {
        return this.offPeekCompactionRatio;
    }

    long getThrottlePoint() {
        return this.throttlePoint;
    }

    long getMajorCompactionPeriod() {
        return this.majorCompactionPeriod;
    }

    float getMajorCompactionJitter() {
        return this.majorCompactionJitter;
    }

    boolean shouldDeleteExpired() {
        return this.shouldDeleteExpired;
    }
}

