/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSHDFSUtils
extends FSUtils {
    private static final Log LOG = LogFactory.getLog(FSHDFSUtils.class);

    @Override
    public void recoverFileLease(FileSystem fs, Path p, Configuration conf, CancelableProgressable reporter) throws IOException {
        if (!(fs instanceof DistributedFileSystem)) {
            return;
        }
        this.recoverDFSFileLease((DistributedFileSystem)fs, p, conf, reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recoverDFSFileLease(DistributedFileSystem dfs, Path p, Configuration conf, CancelableProgressable reporter) throws IOException {
        LOG.info((Object)("Recovering lease on dfs file " + p));
        long startWaiting = EnvironmentEdgeManager.currentTimeMillis();
        long recoveryTimeout = (long)conf.getInt("hbase.lease.recovery.timeout", 900000) + startWaiting;
        long firstPause = conf.getInt("hbase.lease.recovery.first.pause", 4000);
        long subsequentPause = conf.getInt("hbase.lease.recovery.dfs.timeout", 61000);
        Method isFileClosedMeth = null;
        boolean findIsFileClosedMeth = true;
        boolean recovered = false;
        int nbAttempt = 0;
        while (!recovered && !(recovered = this.recoverLease(dfs, nbAttempt, p, startWaiting))) {
            block12: {
                this.checkIfCancelled(reporter);
                if (this.checkIfTimedout(conf, recoveryTimeout, nbAttempt, p, startWaiting)) break;
                try {
                    if (nbAttempt == 0) {
                        Thread.sleep(firstPause);
                        break block12;
                    }
                    long localStartWaiting = EnvironmentEdgeManager.currentTimeMillis();
                    while (EnvironmentEdgeManager.currentTimeMillis() - localStartWaiting < subsequentPause) {
                        Thread.sleep(conf.getInt("hbase.lease.recovery.pause", 1000));
                        if (findIsFileClosedMeth) {
                            try {
                                isFileClosedMeth = dfs.getClass().getMethod("isFileClosed", Path.class);
                            }
                            catch (NoSuchMethodException nsme) {
                                LOG.debug((Object)"isFileClosed not available");
                            }
                            finally {
                                findIsFileClosedMeth = false;
                            }
                        }
                        if (isFileClosedMeth != null && this.isFileClosed(dfs, isFileClosedMeth, p)) {
                            recovered = true;
                            break;
                        }
                        this.checkIfCancelled(reporter);
                    }
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
            ++nbAttempt;
        }
        return recovered;
    }

    boolean checkIfTimedout(Configuration conf, long recoveryTimeout, int nbAttempt, Path p, long startWaiting) {
        if (recoveryTimeout < EnvironmentEdgeManager.currentTimeMillis()) {
            LOG.warn((Object)("Cannot recoverLease after trying for " + conf.getInt("hbase.lease.recovery.timeout", 900000) + "ms (hbase.lease.recovery.timeout); continuing, but may be DATALOSS!!!; " + this.getLogMessageDetail(nbAttempt, p, startWaiting)));
            return true;
        }
        return false;
    }

    boolean recoverLease(DistributedFileSystem dfs, int nbAttempt, Path p, long startWaiting) throws FileNotFoundException {
        boolean recovered = false;
        try {
            recovered = dfs.recoverLease(p);
            LOG.info((Object)("recoverLease=" + recovered + ", " + this.getLogMessageDetail(nbAttempt, p, startWaiting)));
        }
        catch (IOException e) {
            if (e instanceof LeaseExpiredException && e.getMessage().contains("File does not exist")) {
                throw new FileNotFoundException("The given HLog wasn't found at " + p);
            }
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            LOG.warn((Object)this.getLogMessageDetail(nbAttempt, p, startWaiting), (Throwable)e);
        }
        return recovered;
    }

    private String getLogMessageDetail(int nbAttempt, Path p, long startWaiting) {
        return "attempt=" + nbAttempt + " on file=" + p + " after " + (EnvironmentEdgeManager.currentTimeMillis() - startWaiting) + "ms";
    }

    private boolean isFileClosed(DistributedFileSystem dfs, Method m, Path p) {
        try {
            return (Boolean)m.invoke((Object)dfs, p);
        }
        catch (SecurityException e) {
            LOG.warn((Object)"No access", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed invocation for " + p.toString()), (Throwable)e);
        }
        return false;
    }

    void checkIfCancelled(CancelableProgressable reporter) throws InterruptedIOException {
        if (reporter == null) {
            return;
        }
        if (!reporter.progress()) {
            throw new InterruptedIOException("Operation cancelled");
        }
    }
}

