/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class RegionServerTracker
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(RegionServerTracker.class);
    private NavigableSet<ServerName> regionServers = new TreeSet<ServerName>();
    private ServerManager serverManager;
    private Abortable abortable;

    public RegionServerTracker(ZooKeeperWatcher watcher, Abortable abortable, ServerManager serverManager) {
        super(watcher);
        this.abortable = abortable;
        this.serverManager = serverManager;
    }

    public void start() throws KeeperException, IOException {
        this.watcher.registerListener((ZooKeeperListener)this);
        List servers = ZKUtil.listChildrenAndWatchThem((ZooKeeperWatcher)this.watcher, (String)this.watcher.rsZNode);
        this.add(servers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(List<String> servers) throws IOException {
        NavigableSet<ServerName> navigableSet = this.regionServers;
        synchronized (navigableSet) {
            this.regionServers.clear();
            for (String n : servers) {
                ServerName sn = ServerName.parseServerName((String)ZKUtil.getNodeName((String)n));
                this.regionServers.add(sn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ServerName sn) {
        NavigableSet<ServerName> navigableSet = this.regionServers;
        synchronized (navigableSet) {
            this.regionServers.remove(sn);
        }
    }

    public void nodeDeleted(String path) {
        if (path.startsWith(this.watcher.rsZNode)) {
            String serverName = ZKUtil.getNodeName((String)path);
            LOG.info((Object)("RegionServer ephemeral node deleted, processing expiration [" + serverName + "]"));
            ServerName sn = ServerName.parseServerName((String)serverName);
            if (!this.serverManager.isServerOnline(sn)) {
                LOG.warn((Object)(serverName.toString() + " is not online or isn't known to the master." + "The latter could be caused by a DNS misconfiguration."));
                return;
            }
            this.remove(sn);
            this.serverManager.expireServer(sn);
        }
    }

    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.rsZNode)) {
            try {
                List servers = ZKUtil.listChildrenAndWatchThem((ZooKeeperWatcher)this.watcher, (String)this.watcher.rsZNode);
                this.add(servers);
            }
            catch (IOException e) {
                this.abortable.abort("Unexpected zk exception getting RS nodes", (Throwable)e);
            }
            catch (KeeperException e) {
                this.abortable.abort("Unexpected zk exception getting RS nodes", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerName> getOnlineServers() {
        NavigableSet<ServerName> navigableSet = this.regionServers;
        synchronized (navigableSet) {
            return new ArrayList<ServerName>(this.regionServers);
        }
    }
}

