/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public interface RegionObserver
extends Coprocessor {
    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> var1) throws IOException;

    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> var1);

    public void postLogReplay(ObserverContext<RegionCoprocessorEnvironment> var1);

    public InternalScanner preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> var1, Store var2, KeyValueScanner var3, InternalScanner var4) throws IOException;

    public void preFlush(ObserverContext<RegionCoprocessorEnvironment> var1) throws IOException;

    public InternalScanner preFlush(ObserverContext<RegionCoprocessorEnvironment> var1, Store var2, InternalScanner var3) throws IOException;

    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> var1) throws IOException;

    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> var1, Store var2, StoreFile var3) throws IOException;

    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> var1, Store var2, List<StoreFile> var3, CompactionRequest var4) throws IOException;

    @Deprecated
    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> var1, Store var2, List<StoreFile> var3) throws IOException;

    public void postCompactSelection(ObserverContext<RegionCoprocessorEnvironment> var1, Store var2, ImmutableList<StoreFile> var3, CompactionRequest var4);

    @Deprecated
    public void postCompactSelection(ObserverContext<RegionCoprocessorEnvironment> var1, Store var2, ImmutableList<StoreFile> var3);

    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> var1, Store var2, InternalScanner var3, ScanType var4, CompactionRequest var5) throws IOException;

    @Deprecated
    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> var1, Store var2, InternalScanner var3, ScanType var4) throws IOException;

    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> var1, Store var2, List<? extends KeyValueScanner> var3, ScanType var4, long var5, InternalScanner var7, CompactionRequest var8) throws IOException;

    @Deprecated
    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> var1, Store var2, List<? extends KeyValueScanner> var3, ScanType var4, long var5, InternalScanner var7) throws IOException;

    public void postCompact(ObserverContext<RegionCoprocessorEnvironment> var1, Store var2, StoreFile var3, CompactionRequest var4) throws IOException;

    @Deprecated
    public void postCompact(ObserverContext<RegionCoprocessorEnvironment> var1, Store var2, StoreFile var3) throws IOException;

    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> var1) throws IOException;

    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> var1, byte[] var2) throws IOException;

    public void postSplit(ObserverContext<RegionCoprocessorEnvironment> var1, HRegion var2, HRegion var3) throws IOException;

    public void preRollBackSplit(ObserverContext<RegionCoprocessorEnvironment> var1) throws IOException;

    public void postRollBackSplit(ObserverContext<RegionCoprocessorEnvironment> var1) throws IOException;

    public void postCompleteSplit(ObserverContext<RegionCoprocessorEnvironment> var1) throws IOException;

    public void preClose(ObserverContext<RegionCoprocessorEnvironment> var1, boolean var2) throws IOException;

    public void postClose(ObserverContext<RegionCoprocessorEnvironment> var1, boolean var2);

    public void preGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> var1, byte[] var2, byte[] var3, Result var4) throws IOException;

    public void postGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> var1, byte[] var2, byte[] var3, Result var4) throws IOException;

    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> var1, Get var2, List<Cell> var3) throws IOException;

    @Deprecated
    public void preGet(ObserverContext<RegionCoprocessorEnvironment> var1, Get var2, List<KeyValue> var3) throws IOException;

    public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> var1, Get var2, List<Cell> var3) throws IOException;

    @Deprecated
    public void postGet(ObserverContext<RegionCoprocessorEnvironment> var1, Get var2, List<KeyValue> var3) throws IOException;

    public boolean preExists(ObserverContext<RegionCoprocessorEnvironment> var1, Get var2, boolean var3) throws IOException;

    public boolean postExists(ObserverContext<RegionCoprocessorEnvironment> var1, Get var2, boolean var3) throws IOException;

    public void prePut(ObserverContext<RegionCoprocessorEnvironment> var1, Put var2, WALEdit var3, Durability var4) throws IOException;

    public void postPut(ObserverContext<RegionCoprocessorEnvironment> var1, Put var2, WALEdit var3, Durability var4) throws IOException;

    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> var1, Delete var2, WALEdit var3, Durability var4) throws IOException;

    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> var1, Delete var2, WALEdit var3, Durability var4) throws IOException;

    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> var1, MiniBatchOperationInProgress<Mutation> var2) throws IOException;

    public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> var1, MiniBatchOperationInProgress<Mutation> var2) throws IOException;

    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> var1, byte[] var2, byte[] var3, byte[] var4, CompareFilter.CompareOp var5, ByteArrayComparable var6, Put var7, boolean var8) throws IOException;

    public boolean postCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> var1, byte[] var2, byte[] var3, byte[] var4, CompareFilter.CompareOp var5, ByteArrayComparable var6, Put var7, boolean var8) throws IOException;

    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> var1, byte[] var2, byte[] var3, byte[] var4, CompareFilter.CompareOp var5, ByteArrayComparable var6, Delete var7, boolean var8) throws IOException;

    public boolean postCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> var1, byte[] var2, byte[] var3, byte[] var4, CompareFilter.CompareOp var5, ByteArrayComparable var6, Delete var7, boolean var8) throws IOException;

    @Deprecated
    public long preIncrementColumnValue(ObserverContext<RegionCoprocessorEnvironment> var1, byte[] var2, byte[] var3, byte[] var4, long var5, boolean var7) throws IOException;

    @Deprecated
    public long postIncrementColumnValue(ObserverContext<RegionCoprocessorEnvironment> var1, byte[] var2, byte[] var3, byte[] var4, long var5, boolean var7, long var8) throws IOException;

    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> var1, Append var2) throws IOException;

    public Result postAppend(ObserverContext<RegionCoprocessorEnvironment> var1, Append var2, Result var3) throws IOException;

    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> var1, Increment var2) throws IOException;

    public Result postIncrement(ObserverContext<RegionCoprocessorEnvironment> var1, Increment var2, Result var3) throws IOException;

    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> var1, Scan var2, RegionScanner var3) throws IOException;

    public KeyValueScanner preStoreScannerOpen(ObserverContext<RegionCoprocessorEnvironment> var1, Store var2, Scan var3, NavigableSet<byte[]> var4, KeyValueScanner var5) throws IOException;

    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> var1, Scan var2, RegionScanner var3) throws IOException;

    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> var1, InternalScanner var2, List<Result> var3, int var4, boolean var5) throws IOException;

    public boolean postScannerNext(ObserverContext<RegionCoprocessorEnvironment> var1, InternalScanner var2, List<Result> var3, int var4, boolean var5) throws IOException;

    public boolean postScannerFilterRow(ObserverContext<RegionCoprocessorEnvironment> var1, InternalScanner var2, byte[] var3, int var4, short var5, boolean var6) throws IOException;

    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> var1, InternalScanner var2) throws IOException;

    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> var1, InternalScanner var2) throws IOException;

    public void preWALRestore(ObserverContext<RegionCoprocessorEnvironment> var1, HRegionInfo var2, HLogKey var3, WALEdit var4) throws IOException;

    public void postWALRestore(ObserverContext<RegionCoprocessorEnvironment> var1, HRegionInfo var2, HLogKey var3, WALEdit var4) throws IOException;

    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> var1, List<Pair<byte[], String>> var2) throws IOException;

    public boolean postBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> var1, List<Pair<byte[], String>> var2, boolean var3) throws IOException;
}

