/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface Store
extends HeapSize,
StoreConfigInformation {
    public static final int PRIORITY_USER = 1;
    public static final int NO_PRIORITY = Integer.MIN_VALUE;

    public KeyValue.KVComparator getComparator();

    public Collection<StoreFile> getStorefiles();

    public Collection<StoreFile> close() throws IOException;

    public KeyValueScanner getScanner(Scan var1, NavigableSet<byte[]> var2) throws IOException;

    public List<KeyValueScanner> getScanners(boolean var1, boolean var2, boolean var3, boolean var4, ScanQueryMatcher var5, byte[] var6, byte[] var7) throws IOException;

    public ScanInfo getScanInfo();

    public long upsert(Iterable<Cell> var1, long var2) throws IOException;

    public long add(KeyValue var1);

    public long timeOfOldestEdit();

    public void rollback(KeyValue var1);

    public KeyValue getRowKeyAtOrBefore(byte[] var1) throws IOException;

    public FileSystem getFileSystem();

    public StoreFile.Writer createWriterInTmp(long var1, Compression.Algorithm var3, boolean var4, boolean var5) throws IOException;

    public boolean throttleCompaction(long var1);

    public CompactionProgress getCompactionProgress();

    public CompactionContext requestCompaction() throws IOException;

    public CompactionContext requestCompaction(int var1, CompactionRequest var2) throws IOException;

    public void cancelRequestedCompaction(CompactionContext var1);

    public List<StoreFile> compact(CompactionContext var1) throws IOException;

    public boolean isMajorCompaction() throws IOException;

    public void triggerMajorCompaction();

    public boolean needsCompaction();

    public int getCompactPriority();

    public StoreFlushContext createFlushContext(long var1);

    public void completeCompactionMarker(WALProtos.CompactionDescriptor var1) throws IOException;

    public boolean canSplit();

    public byte[] getSplitPoint();

    public void assertBulkLoadHFileOk(Path var1) throws IOException;

    public void bulkLoadHFile(String var1, long var2) throws IOException;

    public boolean hasReferences();

    public long getMemStoreSize();

    public long getFlushableSize();

    public HColumnDescriptor getFamily();

    public long getMaxMemstoreTS();

    public HFileDataBlockEncoder getDataBlockEncoder();

    public long getLastCompactSize();

    public long getSize();

    public int getStorefilesCount();

    public long getStoreSizeUncompressed();

    public long getStorefilesSize();

    public long getStorefilesIndexSize();

    public long getTotalStaticIndexSize();

    public long getTotalStaticBloomSize();

    public CacheConfig getCacheConfig();

    public HRegionInfo getRegionInfo();

    public RegionCoprocessorHost getCoprocessorHost();

    public boolean areWritesEnabled();

    public long getSmallestReadPoint();

    public String getColumnFamilyName();

    public TableName getTableName();

    public void addChangedReaderObserver(ChangedReadersObserver var1);

    public void deleteChangedReaderObserver(ChangedReadersObserver var1);

    public boolean hasTooManyStoreFiles();
}

