/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public final class Canary
implements Tool {
    private static final int USAGE_EXIT_CODE = 1;
    private static final int INIT_ERROR_EXIT_CODE = 2;
    private static final int TIMEOUT_ERROR_EXIT_CODE = 3;
    private static final int ERROR_EXIT_CODE = 4;
    private static final long DEFAULT_INTERVAL = 6000L;
    private static final long DEFAULT_TIMEOUT = 600000L;
    private static final Log LOG = LogFactory.getLog(Canary.class);
    private Configuration conf = null;
    private long interval = 0L;
    private Sink sink = null;
    private boolean useRegExp;
    private long timeout = 600000L;
    private boolean failOnError = true;
    private boolean regionServerMode = false;

    public Canary() {
        this(new RegionServerStdOutSink());
    }

    public Canary(Sink sink) {
        this.sink = sink;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public int run(String[] args) throws Exception {
        int index = -1;
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.startsWith("-")) {
                if (index >= 0) {
                    System.err.println("Invalid command line options");
                    this.printUsageAndExit();
                }
                if (cmd.equals("-help")) {
                    this.printUsageAndExit();
                    continue;
                }
                if (cmd.equals("-daemon") && this.interval == 0L) {
                    this.interval = 6000L;
                    continue;
                }
                if (cmd.equals("-interval")) {
                    if (++i == args.length) {
                        System.err.println("-interval needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    try {
                        this.interval = Long.parseLong(args[i]) * 1000L;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("-interval needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    continue;
                }
                if (cmd.equals("-regionserver")) {
                    this.regionServerMode = true;
                    continue;
                }
                if (cmd.equals("-e")) {
                    this.useRegExp = true;
                    continue;
                }
                if (cmd.equals("-t")) {
                    if (++i == args.length) {
                        System.err.println("-t needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    try {
                        this.timeout = Long.parseLong(args[i]);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("-t needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    continue;
                }
                if (cmd.equals("-f")) {
                    if (++i == args.length) {
                        System.err.println("-f needs a boolean value argument (true|false).");
                        this.printUsageAndExit();
                    }
                    this.failOnError = Boolean.parseBoolean(args[i]);
                    continue;
                }
                System.err.println(cmd + " options is invalid.");
                this.printUsageAndExit();
                continue;
            }
            if (index >= 0) continue;
            index = i;
        }
        Monitor monitor = null;
        Thread monitorThread = null;
        long startTime = 0L;
        long currentTimeLength = 0L;
        do {
            monitor = this.newMonitor(index, args);
            monitorThread = new Thread(monitor);
            startTime = System.currentTimeMillis();
            monitorThread.start();
            while (!monitor.isDone()) {
                Thread.sleep(1000L);
                if (this.failOnError && monitor.hasError()) {
                    monitorThread.interrupt();
                    if (monitor.initialized) {
                        System.exit(monitor.errorCode);
                    } else {
                        System.exit(2);
                    }
                }
                if ((currentTimeLength = System.currentTimeMillis() - startTime) <= this.timeout) continue;
                LOG.error((Object)("The monitor is running too long (" + currentTimeLength + ") after timeout limit:" + this.timeout + " will be killed itself !!"));
                if (monitor.initialized) {
                    System.exit(3);
                    break;
                }
                System.exit(2);
                break;
            }
            if (this.failOnError && monitor.hasError()) {
                monitorThread.interrupt();
                System.exit(monitor.errorCode);
            }
            Thread.sleep(this.interval);
        } while (this.interval > 0L);
        return monitor.errorCode;
    }

    private void printUsageAndExit() {
        System.err.printf("Usage: bin/hbase %s [opts] [table1 [table2]...] | [regionserver1 [regionserver2]..]%n", this.getClass().getName());
        System.err.println(" where [opts] are:");
        System.err.println("   -help          Show this help and exit.");
        System.err.println("   -regionserver  replace the table argument to regionserver,");
        System.err.println("      which means to enable regionserver mode");
        System.err.println("   -daemon        Continuous check at defined intervals.");
        System.err.println("   -interval <N>  Interval between checks (sec)");
        System.err.println("   -e             Use region/regionserver as regular expression");
        System.err.println("      which means the region/regionserver is regular expression pattern");
        System.err.println("   -f <B>         stop whole program if first error occurs, default is true");
        System.err.println("   -t <N>         timeout for a check, default is 600000 (milisecs)");
        System.exit(1);
    }

    public Monitor newMonitor(int index, String[] args) {
        Monitor monitor = null;
        String[] monitorTargets = null;
        if (index >= 0) {
            int length = args.length - index;
            monitorTargets = new String[length];
            System.arraycopy(args, index, monitorTargets, 0, length);
        }
        monitor = this.regionServerMode ? new RegionServerMonitor(this.conf, monitorTargets, this.useRegExp, (ExtendedSink)this.sink) : new RegionMonitor(this.conf, monitorTargets, this.useRegExp, this.sink);
        return monitor;
    }

    public static void sniff(HBaseAdmin admin, TableName tableName) throws Exception {
        Canary.sniff(admin, (Sink)new StdOutSink(), tableName.getNameAsString());
    }

    private static void sniff(HBaseAdmin admin, Sink sink, String tableName) throws Exception {
        if (admin.isTableAvailable(tableName)) {
            Canary.sniff(admin, sink, admin.getTableDescriptor(tableName.getBytes()));
        } else {
            LOG.warn((Object)String.format("Table %s is not available", tableName));
        }
    }

    private static void sniff(HBaseAdmin admin, Sink sink, HTableDescriptor tableDesc) throws Exception {
        HTable table = null;
        try {
            table = new HTable(admin.getConfiguration(), tableDesc.getName());
        }
        catch (TableNotFoundException e) {
            return;
        }
        for (HRegionInfo region : admin.getTableRegions(tableDesc.getName())) {
            try {
                Canary.sniffRegion(admin, sink, region, table);
            }
            catch (Exception e) {
                sink.publishReadFailure(region, e);
                LOG.debug((Object)"sniffRegion failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sniffRegion(HBaseAdmin admin, Sink sink, HRegionInfo region, HTable table) throws Exception {
        HTableDescriptor tableDesc = table.getTableDescriptor();
        byte[] startKey = null;
        Get get = null;
        Scan scan = null;
        ResultScanner rs = null;
        StopWatch stopWatch = new StopWatch();
        for (HColumnDescriptor column : tableDesc.getColumnFamilies()) {
            stopWatch.reset();
            startKey = region.getStartKey();
            if (startKey.length > 0) {
                get = new Get(startKey);
                get.addFamily(column.getName());
            } else {
                scan = new Scan();
                scan.setCaching(1);
                scan.addFamily(column.getName());
                scan.setMaxResultSize(1L);
            }
            try {
                if (startKey.length > 0) {
                    stopWatch.start();
                    table.get(get);
                    stopWatch.stop();
                    sink.publishReadTiming(region, column, stopWatch.getTime());
                    continue;
                }
                stopWatch.start();
                rs = table.getScanner(scan);
                stopWatch.stop();
                sink.publishReadTiming(region, column, stopWatch.getTime());
            }
            catch (Exception e) {
                sink.publishReadFailure(region, column, e);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                scan = null;
                get = null;
                startKey = null;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new Canary(), (String[])args);
        System.exit(exitCode);
    }

    private static class RegionServerMonitor
    extends Monitor {
        public RegionServerMonitor(Configuration config, String[] monitorTargets, boolean useRegExp, ExtendedSink sink) {
            super(config, monitorTargets, useRegExp, sink);
        }

        private ExtendedSink getSink() {
            return (ExtendedSink)this.sink;
        }

        @Override
        public void run() {
            if (this.initAdmin() && this.checkNoTableNames()) {
                Map<String, List<HRegionInfo>> rsAndRMap = this.filterRegionServerByName();
                this.initialized = true;
                this.monitorRegionServers(rsAndRMap);
            }
            this.done = true;
        }

        private boolean checkNoTableNames() {
            ArrayList<String> foundTableNames = new ArrayList<String>();
            TableName[] tableNames = null;
            try {
                tableNames = this.admin.listTableNames();
            }
            catch (IOException e) {
                LOG.error((Object)"Get listTableNames failed", (Throwable)e);
                this.errorCode = 2;
                return false;
            }
            if (this.targets == null || this.targets.length == 0) {
                return true;
            }
            for (String target : this.targets) {
                for (TableName tableName : tableNames) {
                    if (!target.equals(tableName.getNameAsString())) continue;
                    foundTableNames.add(target);
                }
            }
            if (foundTableNames.size() > 0) {
                System.err.println("Cannot pass a tablename when using the -regionserver option, tablenames:" + ((Object)foundTableNames).toString());
                this.errorCode = 1;
            }
            return foundTableNames.size() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void monitorRegionServers(Map<String, List<HRegionInfo>> rsAndRMap) {
            String serverName = null;
            String tableName = null;
            HRegionInfo region = null;
            HTable table = null;
            Get get = null;
            byte[] startKey = null;
            Scan scan = null;
            StopWatch stopWatch = new StopWatch();
            Iterator<Map.Entry<String, List<HRegionInfo>>> i$ = rsAndRMap.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, List<HRegionInfo>> entry = i$.next();
                stopWatch.reset();
                serverName = entry.getKey();
                region = entry.getValue().get(0);
                try {
                    tableName = region.getTable().getNameAsString();
                    table = new HTable(this.admin.getConfiguration(), tableName);
                    startKey = region.getStartKey();
                    if (startKey.length > 0) {
                        get = new Get(startKey);
                        stopWatch.start();
                        table.get(get);
                        stopWatch.stop();
                    } else {
                        scan = new Scan();
                        scan.setCaching(1);
                        scan.setMaxResultSize(1L);
                        stopWatch.start();
                        table.getScanner(scan);
                        stopWatch.stop();
                    }
                    this.getSink().publishReadTiming(tableName, serverName, stopWatch.getTime());
                    continue;
                }
                catch (TableNotFoundException tnfe) {
                    continue;
                }
                catch (TableNotEnabledException tnee) {
                    LOG.debug((Object)"The targeted table was disabled.  Assuming success.");
                    continue;
                }
                catch (DoNotRetryIOException dnrioe) {
                    this.getSink().publishReadFailure(tableName, serverName);
                    LOG.error((Object)dnrioe);
                    continue;
                }
                catch (IOException e) {
                    this.getSink().publishReadFailure(tableName, serverName);
                    LOG.error((Object)e);
                    this.errorCode = 4;
                    continue;
                }
                finally {
                    if (table != null) {
                        try {
                            table.close();
                        }
                        catch (IOException e) {}
                    }
                    scan = null;
                    get = null;
                    startKey = null;
                    continue;
                }
                break;
            }
            return;
        }

        private Map<String, List<HRegionInfo>> filterRegionServerByName() {
            Map<String, List<HRegionInfo>> regionServerAndRegionsMap = this.getAllRegionServerByName();
            regionServerAndRegionsMap = this.doFilterRegionServerByName(regionServerAndRegionsMap);
            return regionServerAndRegionsMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, List<HRegionInfo>> getAllRegionServerByName() {
            HashMap<String, List<HRegionInfo>> rsAndRMap = new HashMap<String, List<HRegionInfo>>();
            HTable table = null;
            try {
                HTableDescriptor[] tableDescs = this.admin.listTables();
                List<HRegionInfo> regions = null;
                for (HTableDescriptor tableDesc : tableDescs) {
                    table = new HTable(this.admin.getConfiguration(), tableDesc.getName());
                    for (Map.Entry entry : table.getRegionLocations().entrySet()) {
                        ServerName rs = (ServerName)entry.getValue();
                        String rsName = rs.getHostname();
                        HRegionInfo r = (HRegionInfo)entry.getKey();
                        if (rsAndRMap.containsKey(rsName)) {
                            regions = (List)rsAndRMap.get(rsName);
                        } else {
                            regions = new ArrayList();
                            rsAndRMap.put(rsName, regions);
                        }
                        regions.add(r);
                    }
                    table.close();
                }
            }
            catch (IOException e) {
                String msg = "Get HTables info failed";
                LOG.error((Object)msg, (Throwable)e);
                this.errorCode = 2;
            }
            finally {
                if (table != null) {
                    try {
                        table.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Close table failed", (Throwable)e);
                    }
                }
            }
            return rsAndRMap;
        }

        private Map<String, List<HRegionInfo>> doFilterRegionServerByName(Map<String, List<HRegionInfo>> fullRsAndRMap) {
            Map<String, List<HRegionInfo>> filteredRsAndRMap = null;
            if (this.targets != null && this.targets.length > 0) {
                filteredRsAndRMap = new HashMap<String, List<HRegionInfo>>();
                Pattern pattern = null;
                Matcher matcher = null;
                boolean regExpFound = false;
                for (String rsName : this.targets) {
                    if (this.useRegExp) {
                        regExpFound = false;
                        pattern = Pattern.compile(rsName);
                        for (Map.Entry<String, List<HRegionInfo>> entry : fullRsAndRMap.entrySet()) {
                            matcher = pattern.matcher(entry.getKey());
                            if (!matcher.matches()) continue;
                            filteredRsAndRMap.put(entry.getKey(), entry.getValue());
                            regExpFound = true;
                        }
                        if (regExpFound) continue;
                        LOG.info((Object)("No RegionServerInfo found, regionServerPattern:" + rsName));
                        continue;
                    }
                    if (fullRsAndRMap.containsKey(rsName)) {
                        filteredRsAndRMap.put(rsName, fullRsAndRMap.get(rsName));
                        continue;
                    }
                    LOG.info((Object)("No RegionServerInfo found, regionServerName:" + rsName));
                }
            } else {
                filteredRsAndRMap = fullRsAndRMap;
            }
            return filteredRsAndRMap;
        }
    }

    private static class RegionMonitor
    extends Monitor {
        public RegionMonitor(Configuration config, String[] monitorTargets, boolean useRegExp, Sink sink) {
            super(config, monitorTargets, useRegExp, sink);
        }

        @Override
        public void run() {
            if (this.initAdmin()) {
                try {
                    if (this.targets != null && this.targets.length > 0) {
                        String[] tables = this.generateMonitorTables(this.targets);
                        this.initialized = true;
                        for (String table : tables) {
                            Canary.sniff(this.admin, this.sink, table);
                        }
                    } else {
                        this.sniff();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Run regionMonitor failed", (Throwable)e);
                    this.errorCode = 4;
                }
            }
            this.done = true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String[] generateMonitorTables(String[] monitorTargets) throws IOException {
            String[] returnTables = null;
            if (!this.useRegExp) return monitorTargets;
            Pattern pattern = null;
            HTableDescriptor[] tds = null;
            TreeSet<String> tmpTables = new TreeSet<String>();
            try {
                for (String monitorTarget : monitorTargets) {
                    pattern = Pattern.compile(monitorTarget);
                    tds = this.admin.listTables(pattern);
                    if (tds == null) continue;
                    for (HTableDescriptor td : tds) {
                        tmpTables.add(td.getNameAsString());
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Communicate with admin failed", (Throwable)e);
                throw e;
            }
            if (tmpTables.size() > 0) {
                return tmpTables.toArray(new String[tmpTables.size()]);
            }
            String msg = "No HTable found, tablePattern:" + Arrays.toString(monitorTargets);
            LOG.error((Object)msg);
            this.errorCode = 2;
            throw new TableNotFoundException(msg);
        }

        private void sniff() throws Exception {
            for (HTableDescriptor table : this.admin.listTables()) {
                Canary.sniff(this.admin, this.sink, table);
            }
        }
    }

    public static abstract class Monitor
    implements Runnable {
        protected Configuration config;
        protected HBaseAdmin admin;
        protected String[] targets;
        protected boolean useRegExp;
        protected boolean initialized = false;
        protected boolean done = false;
        protected int errorCode = 0;
        protected Sink sink;

        public boolean isDone() {
            return this.done;
        }

        public boolean hasError() {
            return this.errorCode != 0;
        }

        protected Monitor(Configuration config, String[] monitorTargets, boolean useRegExp, Sink sink) {
            if (null == config) {
                throw new IllegalArgumentException("config shall not be null");
            }
            this.config = config;
            this.targets = monitorTargets;
            this.useRegExp = useRegExp;
            this.sink = sink;
        }

        @Override
        public abstract void run();

        protected boolean initAdmin() {
            if (null == this.admin) {
                try {
                    this.admin = new HBaseAdmin(this.config);
                }
                catch (Exception e) {
                    LOG.error((Object)"Initial HBaseAdmin failed...", (Throwable)e);
                    this.errorCode = 2;
                }
            } else if (this.admin.isAborted()) {
                LOG.error((Object)"HBaseAdmin aborted");
                this.errorCode = 2;
            }
            return !this.hasError();
        }
    }

    public static class RegionServerStdOutSink
    extends StdOutSink
    implements ExtendedSink {
        @Override
        public void publishReadFailure(String table, String server) {
            LOG.error((Object)String.format("Read from table:%s on region server:%s", table, server));
        }

        @Override
        public void publishReadTiming(String table, String server, long msTime) {
            LOG.info((Object)String.format("Read from table:%s on region server:%s in %dms", table, server, msTime));
        }
    }

    public static class StdOutSink
    implements Sink {
        @Override
        public void publishReadFailure(HRegionInfo region, Exception e) {
            LOG.error((Object)String.format("read from region %s failed", region.getRegionNameAsString()), (Throwable)e);
        }

        @Override
        public void publishReadFailure(HRegionInfo region, HColumnDescriptor column, Exception e) {
            LOG.error((Object)String.format("read from region %s column family %s failed", region.getRegionNameAsString(), column.getNameAsString()), (Throwable)e);
        }

        @Override
        public void publishReadTiming(HRegionInfo region, HColumnDescriptor column, long msTime) {
            LOG.info((Object)String.format("read from region %s column family %s in %dms", region.getRegionNameAsString(), column.getNameAsString(), msTime));
        }
    }

    public static interface ExtendedSink
    extends Sink {
        public void publishReadFailure(String var1, String var2);

        public void publishReadTiming(String var1, String var2, long var3);
    }

    public static interface Sink {
        public void publishReadFailure(HRegionInfo var1, Exception var2);

        public void publishReadFailure(HRegionInfo var1, HColumnDescriptor var2, Exception var3);

        public void publishReadTiming(HRegionInfo var1, HColumnDescriptor var2, long var3);
    }
}

