/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnectable;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsckRepair;
import org.apache.hadoop.hbase.util.KeyRange;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.RegionSplitCalculator;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.hbck.HFileCorruptionChecker;
import org.apache.hadoop.hbase.util.hbck.TableIntegrityErrorHandler;
import org.apache.hadoop.hbase.util.hbck.TableIntegrityErrorHandlerImpl;
import org.apache.hadoop.hbase.util.hbck.TableLockChecker;
import org.apache.hadoop.hbase.zookeeper.MetaRegionTracker;
import org.apache.hadoop.hbase.zookeeper.ZKTableReadOnly;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HBaseFsck
extends Configured {
    public static final long DEFAULT_TIME_LAG = 60000L;
    public static final long DEFAULT_SLEEP_BEFORE_RERUN = 10000L;
    private static final int MAX_NUM_THREADS = 50;
    private static boolean rsSupportsOffline = true;
    private static final int DEFAULT_OVERLAPS_TO_SIDELINE = 2;
    private static final int DEFAULT_MAX_MERGE = 5;
    private static final String TO_BE_LOADED = "to_be_loaded";
    private static final Log LOG = LogFactory.getLog((String)HBaseFsck.class.getName());
    private ClusterStatus status;
    private HConnection connection;
    private HBaseAdmin admin;
    private HTable meta;
    protected ExecutorService executor;
    private long startMillis = System.currentTimeMillis();
    private HFileCorruptionChecker hfcc;
    private int retcode = 0;
    private static boolean details = false;
    private long timelag = 60000L;
    private boolean fixAssignments = false;
    private boolean fixMeta = false;
    private boolean checkHdfs = true;
    private boolean fixHdfsHoles = false;
    private boolean fixHdfsOverlaps = false;
    private boolean fixHdfsOrphans = false;
    private boolean fixTableOrphans = false;
    private boolean fixVersionFile = false;
    private boolean fixSplitParents = false;
    private boolean fixReferenceFiles = false;
    private boolean fixEmptyMetaCells = false;
    private boolean fixTableLocks = false;
    private Set<TableName> tablesIncluded = new HashSet<TableName>();
    private int maxMerge = 5;
    private int maxOverlapsToSideline = 2;
    private boolean sidelineBigOverlaps = false;
    private Path sidelineDir = null;
    private boolean rerun = false;
    private static boolean summary = false;
    private boolean checkMetaOnly = false;
    private boolean checkRegionBoundaries = false;
    private boolean ignorePreCheckPermission = false;
    private final ErrorReporter errors;
    int fixes = 0;
    private TreeMap<String, HbckInfo> regionInfoMap = new TreeMap();
    private TreeSet<TableName> disabledTables = new TreeSet();
    private Set<Result> emptyRegionInfoQualifiers = new HashSet<Result>();
    private SortedMap<TableName, TableInfo> tablesInfo = new ConcurrentSkipListMap<TableName, TableInfo>();
    private List<HbckInfo> orphanHdfsDirs = Collections.synchronizedList(new ArrayList());
    private Map<TableName, Set<String>> orphanTableDirs = new HashMap<TableName, Set<String>>();
    static final Comparator<HbckInfo> cmp = new Comparator<HbckInfo>(){

        @Override
        public int compare(HbckInfo l, HbckInfo r) {
            if (l == r) {
                return 0;
            }
            int tableCompare = l.getTableName().compareTo(r.getTableName());
            if (tableCompare != 0) {
                return tableCompare;
            }
            int startComparison = RegionSplitCalculator.BYTES_COMPARATOR.compare(l.getStartKey(), r.getStartKey());
            if (startComparison != 0) {
                return startComparison;
            }
            byte[] endKey = r.getEndKey();
            endKey = endKey.length == 0 ? null : endKey;
            byte[] endKey2 = l.getEndKey();
            int endComparison = RegionSplitCalculator.BYTES_COMPARATOR.compare(endKey2 = endKey2.length == 0 ? null : endKey2, endKey);
            if (endComparison != 0) {
                return endComparison;
            }
            if (l.hdfsEntry == null && r.hdfsEntry == null) {
                return 0;
            }
            if (l.hdfsEntry == null && r.hdfsEntry != null) {
                return 1;
            }
            if (r.hdfsEntry == null) {
                return -1;
            }
            return (int)(((HbckInfo)l).hdfsEntry.hri.getRegionId() - ((HbckInfo)r).hdfsEntry.hri.getRegionId());
        }
    };

    public HBaseFsck(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException, IOException, ClassNotFoundException {
        super(conf);
        this.setConf(HBaseConfiguration.create((Configuration)this.getConf()));
        this.getConf().setFloat("hfile.block.cache.size", 0.0f);
        this.errors = HBaseFsck.getErrorReporter(conf);
        int numThreads = conf.getInt("hbasefsck.numthreads", 50);
        this.executor = new ScheduledThreadPoolExecutor(numThreads, Threads.newDaemonThreadFactory((String)"hbasefsck"));
    }

    public HBaseFsck(Configuration conf, ExecutorService exec) throws MasterNotRunningException, ZooKeeperConnectionException, IOException, ClassNotFoundException {
        super(conf);
        this.errors = HBaseFsck.getErrorReporter(this.getConf());
        this.executor = exec;
    }

    public void connect() throws IOException {
        this.admin = new HBaseAdmin(this.getConf());
        this.meta = new HTable(this.getConf(), TableName.META_TABLE_NAME);
        this.status = this.admin.getClusterStatus();
        this.connection = this.admin.getConnection();
    }

    private void loadDeployedRegions() throws IOException, InterruptedException {
        Collection regionServers = this.status.getServers();
        this.errors.print("Number of live region servers: " + regionServers.size());
        if (details) {
            for (ServerName rsinfo : regionServers) {
                this.errors.print("  " + rsinfo.getServerName());
            }
        }
        Collection deadRegionServers = this.status.getDeadServerNames();
        this.errors.print("Number of dead region servers: " + deadRegionServers.size());
        if (details) {
            for (ServerName name : deadRegionServers) {
                this.errors.print("  " + name);
            }
        }
        this.errors.print("Master: " + this.status.getMaster());
        Collection backupMasters = this.status.getBackupMasters();
        this.errors.print("Number of backup masters: " + backupMasters.size());
        if (details) {
            for (ServerName name : backupMasters) {
                this.errors.print("  " + name);
            }
        }
        this.errors.print("Average load: " + this.status.getAverageLoad());
        this.errors.print("Number of requests: " + this.status.getRequestsCount());
        this.errors.print("Number of regions: " + this.status.getRegionsCount());
        Map rits = this.status.getRegionsInTransition();
        this.errors.print("Number of regions in transition: " + rits.size());
        if (details) {
            for (RegionState state : rits.values()) {
                this.errors.print("  " + state.toDescriptiveString());
            }
        }
        this.processRegionServers(regionServers);
    }

    private void clearState() {
        this.fixes = 0;
        this.regionInfoMap.clear();
        this.emptyRegionInfoQualifiers.clear();
        this.disabledTables.clear();
        this.errors.clear();
        this.tablesInfo.clear();
        this.orphanHdfsDirs.clear();
    }

    public void offlineHdfsIntegrityRepair() throws IOException, InterruptedException {
        if (this.shouldCheckHdfs() && (this.shouldFixHdfsOrphans() || this.shouldFixHdfsHoles() || this.shouldFixHdfsOverlaps() || this.shouldFixTableOrphans())) {
            LOG.info((Object)"Loading regioninfos HDFS");
            int maxIterations = this.getConf().getInt("hbase.hbck.integrityrepair.iterations.max", 3);
            int curIter = 0;
            do {
                this.clearState();
                this.restoreHdfsIntegrity();
            } while (this.fixes > 0 && ++curIter <= maxIterations);
            if (curIter > 2) {
                if (curIter == maxIterations) {
                    LOG.warn((Object)("Exiting integrity repairs after max " + curIter + " iterations. " + "Tables integrity may not be fully repaired!"));
                } else {
                    LOG.info((Object)("Successfully exiting integrity repairs after " + curIter + " iterations"));
                }
            }
        }
    }

    public int onlineConsistencyRepair() throws IOException, KeeperException, InterruptedException {
        this.clearState();
        this.loadDeployedRegions();
        this.recordMetaRegion();
        if (!this.checkMetaRegion()) {
            String errorMsg = "hbase:meta table is not consistent. ";
            errorMsg = this.shouldFixAssignments() ? errorMsg + "HBCK will try fixing it. Rerun once hbase:meta is back to consistent state." : errorMsg + "Run HBCK with proper fix options to fix hbase:meta inconsistency.";
            this.errors.reportError(errorMsg + " Exiting...");
            return -2;
        }
        LOG.info((Object)"Loading regionsinfo from the hbase:meta table");
        boolean success = this.loadMetaEntries();
        if (!success) {
            return -1;
        }
        this.reportEmptyMetaCells();
        if (this.shouldFixEmptyMetaCells()) {
            this.fixEmptyMetaCells();
        }
        if (!this.checkMetaOnly) {
            this.reportTablesInFlux();
        }
        if (this.shouldCheckHdfs()) {
            this.loadHdfsRegionDirs();
            this.loadHdfsRegionInfos();
        }
        this.loadDisabledTables();
        this.fixOrphanTables();
        this.checkAndFixConsistency();
        this.checkIntegrity();
        return this.errors.getErrorList().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onlineHbck() throws IOException, KeeperException, InterruptedException, ServiceException {
        this.errors.print("Version: " + this.status.getHBaseVersion());
        this.offlineHdfsIntegrityRepair();
        boolean oldBalancer = this.admin.setBalancerRunning(false, true);
        try {
            this.onlineConsistencyRepair();
        }
        finally {
            this.admin.setBalancerRunning(oldBalancer, false);
        }
        if (this.checkRegionBoundaries) {
            this.checkRegionBoundaries();
        }
        this.offlineReferenceFileRepair();
        this.checkAndFixTableLocks();
        this.printTableSummary(this.tablesInfo);
        return this.errors.summarize();
    }

    public static byte[] keyOnly(byte[] b) {
        if (b == null) {
            return b;
        }
        short rowlength = Bytes.toShort((byte[])b, (int)0);
        byte[] result = new byte[rowlength];
        System.arraycopy(b, 2, result, 0, rowlength);
        return result;
    }

    public void checkRegionBoundaries() {
        try {
            Bytes.ByteArrayComparator comparator = new Bytes.ByteArrayComparator();
            List regions = MetaScanner.listAllRegions((Configuration)this.getConf(), (boolean)false);
            RegionBoundariesInformation currentRegionBoundariesInformation = new RegionBoundariesInformation();
            Path hbaseRoot = FSUtils.getRootDir(this.getConf());
            for (HRegionInfo regionInfo : regions) {
                Path tableDir = FSUtils.getTableDir(hbaseRoot, regionInfo.getTable());
                currentRegionBoundariesInformation.regionName = regionInfo.getRegionName();
                Path path = new Path(tableDir, regionInfo.getEncodedName());
                FileSystem fs = path.getFileSystem(this.getConf());
                FileStatus[] files = fs.listStatus(path);
                byte[] storeFirstKey = null;
                byte[] storeLastKey = null;
                for (FileStatus file : files) {
                    FileStatus[] storeFiles;
                    String fileName = file.getPath().toString();
                    if ((fileName = fileName.substring(fileName.lastIndexOf("/") + 1)).startsWith(".") || fileName.endsWith("recovered.edits")) continue;
                    for (FileStatus storeFile : storeFiles = fs.listStatus(file.getPath())) {
                        HFile.Reader reader = HFile.createReader(fs, storeFile.getPath(), new CacheConfig(this.getConf()));
                        if (reader.getFirstKey() != null && (storeFirstKey == null || comparator.compare(storeFirstKey, reader.getFirstKey()) > 0)) {
                            storeFirstKey = reader.getFirstKey();
                        }
                        if (reader.getLastKey() != null && (storeLastKey == null || comparator.compare(storeLastKey, reader.getLastKey()) < 0)) {
                            storeLastKey = reader.getLastKey();
                        }
                        reader.close();
                    }
                }
                currentRegionBoundariesInformation.metaFirstKey = regionInfo.getStartKey();
                currentRegionBoundariesInformation.metaLastKey = regionInfo.getEndKey();
                currentRegionBoundariesInformation.storesFirstKey = HBaseFsck.keyOnly(storeFirstKey);
                currentRegionBoundariesInformation.storesLastKey = HBaseFsck.keyOnly(storeLastKey);
                if (currentRegionBoundariesInformation.metaFirstKey.length == 0) {
                    currentRegionBoundariesInformation.metaFirstKey = null;
                }
                if (currentRegionBoundariesInformation.metaLastKey.length == 0) {
                    currentRegionBoundariesInformation.metaLastKey = null;
                }
                boolean valid = true;
                if (currentRegionBoundariesInformation.storesFirstKey != null && currentRegionBoundariesInformation.metaFirstKey != null) {
                    boolean bl = valid = valid && comparator.compare(currentRegionBoundariesInformation.storesFirstKey, currentRegionBoundariesInformation.metaFirstKey) >= 0;
                }
                if (currentRegionBoundariesInformation.storesLastKey != null && currentRegionBoundariesInformation.metaLastKey != null) {
                    boolean bl = valid = valid && comparator.compare(currentRegionBoundariesInformation.storesLastKey, currentRegionBoundariesInformation.metaLastKey) < 0;
                }
                if (valid) continue;
                this.errors.reportError(ErrorReporter.ERROR_CODE.BOUNDARIES_ERROR, "Found issues with regions boundaries", (TableInfo)this.tablesInfo.get(regionInfo.getTable()));
                LOG.warn((Object)"Region's boundaries not alligned between stores and META for:");
                LOG.warn((Object)currentRegionBoundariesInformation);
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    private void adoptHdfsOrphans(Collection<HbckInfo> orphanHdfsDirs) throws IOException {
        for (HbckInfo hi : orphanHdfsDirs) {
            LOG.info((Object)("Attempting to handle orphan hdfs dir: " + hi.getHdfsRegionDir()));
            this.adoptHdfsOrphan(hi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adoptHdfsOrphan(HbckInfo hi) throws IOException {
        Path p = hi.getHdfsRegionDir();
        FileSystem fs = p.getFileSystem(this.getConf());
        FileStatus[] dirs = fs.listStatus(p);
        if (dirs == null) {
            LOG.warn((Object)("Attempt to adopt ophan hdfs region skipped becuase no files present in " + p + ". This dir could probably be deleted."));
            return;
        }
        TableName tableName = hi.getTableName();
        TableInfo tableInfo = (TableInfo)this.tablesInfo.get(tableName);
        Preconditions.checkNotNull((Object)tableInfo, (Object)("Table '" + tableName + "' not present!"));
        HTableDescriptor template = tableInfo.getHTD();
        Pair orphanRegionRange = null;
        for (FileStatus cf : dirs) {
            FileStatus[] hfiles;
            String cfName = cf.getPath().getName();
            if (cfName.startsWith(".") || cfName.equals("splitWAL")) continue;
            for (FileStatus hfile : hfiles = fs.listStatus(cf.getPath())) {
                byte[] end;
                byte[] start;
                Closeable hf = null;
                try {
                    CacheConfig cacheConf = new CacheConfig(this.getConf());
                    hf = HFile.createReader(fs, hfile.getPath(), cacheConf);
                    hf.loadFileInfo();
                    KeyValue startKv = KeyValue.createKeyValueFromKey((byte[])hf.getFirstKey());
                    start = startKv.getRow();
                    KeyValue endKv = KeyValue.createKeyValueFromKey((byte[])hf.getLastKey());
                    end = endKv.getRow();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Problem reading orphan file " + hfile + ", skipping"));
                    continue;
                }
                catch (NullPointerException ioe) {
                    LOG.warn((Object)("Orphan file " + hfile + " is possibly corrupted HFile, skipping"));
                    continue;
                }
                finally {
                    if (hf != null) {
                        hf.close();
                    }
                }
                if (orphanRegionRange == null) {
                    orphanRegionRange = new Pair((Object)start, (Object)end);
                    continue;
                }
                if (Bytes.compareTo((byte[])((byte[])orphanRegionRange.getFirst()), (byte[])start) > 0) {
                    orphanRegionRange.setFirst((Object)start);
                }
                if (Bytes.compareTo((byte[])((byte[])orphanRegionRange.getSecond()), (byte[])end) >= 0) continue;
                orphanRegionRange.setSecond((Object)end);
            }
        }
        if (orphanRegionRange == null) {
            LOG.warn((Object)("No data in dir " + p + ", sidelining data"));
            ++this.fixes;
            this.sidelineRegionDir(fs, hi);
            return;
        }
        LOG.info((Object)("Min max keys are : [" + Bytes.toString((byte[])((byte[])orphanRegionRange.getFirst())) + ", " + Bytes.toString((byte[])((byte[])orphanRegionRange.getSecond())) + ")"));
        HRegionInfo hri = new HRegionInfo(template.getTableName(), (byte[])orphanRegionRange.getFirst(), (byte[])orphanRegionRange.getSecond());
        LOG.info((Object)("Creating new region : " + hri));
        HRegion region = HBaseFsckRepair.createHDFSRegionDir(this.getConf(), hri, template);
        Path target = region.getRegionFileSystem().getRegionDir();
        this.mergeRegionDirs(target, hi);
        ++this.fixes;
    }

    private int restoreHdfsIntegrity() throws IOException, InterruptedException {
        LOG.info((Object)"Loading HBase regioninfo from HDFS...");
        this.loadHdfsRegionDirs();
        int errs = this.errors.getErrorList().size();
        this.tablesInfo = this.loadHdfsRegionInfos();
        this.checkHdfsIntegrity(false, false);
        if (this.errors.getErrorList().size() == errs) {
            LOG.info((Object)"No integrity errors.  We are done with this phase. Glorious.");
            return 0;
        }
        if (this.shouldFixHdfsOrphans() && this.orphanHdfsDirs.size() > 0) {
            this.adoptHdfsOrphans(this.orphanHdfsDirs);
        }
        if (this.shouldFixHdfsHoles()) {
            this.clearState();
            this.loadHdfsRegionDirs();
            this.tablesInfo = this.loadHdfsRegionInfos();
            this.tablesInfo = this.checkHdfsIntegrity(this.shouldFixHdfsHoles(), false);
        }
        if (this.shouldFixHdfsOverlaps()) {
            this.clearState();
            this.loadHdfsRegionDirs();
            this.tablesInfo = this.loadHdfsRegionInfos();
            this.tablesInfo = this.checkHdfsIntegrity(false, this.shouldFixHdfsOverlaps());
        }
        return this.errors.getErrorList().size();
    }

    private void offlineReferenceFileRepair() throws IOException {
        Configuration conf = this.getConf();
        Path hbaseRoot = FSUtils.getRootDir(conf);
        FileSystem fs = hbaseRoot.getFileSystem(conf);
        Map<String, Path> allFiles = FSUtils.getTableStoreFilePathMap(fs, hbaseRoot);
        for (Path path : allFiles.values()) {
            Path referredToFile;
            boolean isReference = false;
            try {
                isReference = StoreFileInfo.isReference(path);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (!isReference || fs.exists(referredToFile = StoreFileInfo.getReferredToFile(path))) continue;
            this.errors.reportError(ErrorReporter.ERROR_CODE.LINGERING_REFERENCE_HFILE, "Found lingering reference file " + path);
            if (!this.shouldFixReferenceFiles()) continue;
            boolean success = false;
            String pathStr = path.toString();
            int index = pathStr.lastIndexOf(47);
            for (int i = 0; index > 0 && i < 5; ++i) {
                index = pathStr.lastIndexOf(47, index - 1);
            }
            if (index > 0) {
                Path rootDir = this.getSidelineDir();
                Path dst = new Path(rootDir, pathStr.substring(index + 1));
                fs.mkdirs(dst.getParent());
                LOG.info((Object)("Trying to sildeline reference file " + path + " to " + dst));
                this.setShouldRerun();
                success = fs.rename(path, dst);
            }
            if (success) continue;
            LOG.error((Object)("Failed to sideline reference file " + path));
        }
    }

    private void reportEmptyMetaCells() {
        this.errors.print("Number of empty REGIONINFO_QUALIFIER rows in hbase:meta: " + this.emptyRegionInfoQualifiers.size());
        if (details) {
            for (Result r : this.emptyRegionInfoQualifiers) {
                this.errors.print("  " + r);
            }
        }
    }

    private void reportTablesInFlux() {
        AtomicInteger numSkipped = new AtomicInteger(0);
        HTableDescriptor[] allTables = this.getTables(numSkipped);
        this.errors.print("Number of Tables: " + allTables.length);
        if (details) {
            if (numSkipped.get() > 0) {
                this.errors.detail("Number of Tables in flux: " + numSkipped.get());
            }
            for (HTableDescriptor td : allTables) {
                this.errors.detail("  Table: " + td.getTableName() + "\t" + (td.isReadOnly() ? "ro" : "rw") + "\t" + (td.isMetaRegion() ? "META" : "    ") + "\t" + " families: " + td.getFamilies().size());
            }
        }
    }

    public ErrorReporter getErrors() {
        return this.errors;
    }

    private void loadHdfsRegioninfo(HbckInfo hbi) throws IOException {
        Path regionDir = hbi.getHdfsRegionDir();
        if (regionDir == null) {
            LOG.warn((Object)("No HDFS region dir found: " + hbi + " meta=" + (Object)((Object)hbi.metaEntry)));
            return;
        }
        if (((HbckInfo)hbi).hdfsEntry.hri != null) {
            return;
        }
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        HRegionInfo hri = HRegionFileSystem.loadRegionInfoFileContent(fs, regionDir);
        LOG.debug((Object)("HRegionInfo read: " + hri.toString()));
        ((HbckInfo)hbi).hdfsEntry.hri = hri;
    }

    private SortedMap<TableName, TableInfo> loadHdfsRegionInfos() throws IOException, InterruptedException {
        this.tablesInfo.clear();
        Collection<HbckInfo> hbckInfos = this.regionInfoMap.values();
        ArrayList<WorkItemHdfsRegionInfo> hbis = new ArrayList<WorkItemHdfsRegionInfo>(hbckInfos.size());
        for (HbckInfo hbi : hbckInfos) {
            WorkItemHdfsRegionInfo work = new WorkItemHdfsRegionInfo(hbi, this, this.errors);
            hbis.add(work);
        }
        List hbiFutures = this.executor.invokeAll(hbis);
        for (int i = 0; i < hbiFutures.size(); ++i) {
            WorkItemHdfsRegionInfo work = (WorkItemHdfsRegionInfo)hbis.get(i);
            Future f = hbiFutures.get(i);
            try {
                f.get();
                continue;
            }
            catch (ExecutionException e) {
                LOG.warn((Object)("Failed to read .regioninfo file for region " + work.hbi.getRegionNameAsString()), e.getCause());
            }
        }
        Path hbaseRoot = FSUtils.getRootDir(this.getConf());
        FileSystem fs = hbaseRoot.getFileSystem(this.getConf());
        for (HbckInfo hbi : hbckInfos) {
            TableInfo modTInfo;
            block9: {
                if (hbi.getHdfsHRI() == null) continue;
                TableName tableName = hbi.getTableName();
                if (tableName == null) {
                    LOG.warn((Object)("tableName was null for: " + hbi));
                    continue;
                }
                modTInfo = (TableInfo)this.tablesInfo.get(tableName);
                if (modTInfo == null) {
                    modTInfo = new TableInfo(tableName);
                    this.tablesInfo.put(tableName, modTInfo);
                    try {
                        HTableDescriptor htd = FSTableDescriptors.getTableDescriptorFromFs(fs, hbaseRoot, tableName);
                        modTInfo.htds.add(htd);
                    }
                    catch (IOException ioe) {
                        if (this.orphanTableDirs.containsKey(tableName)) break block9;
                        LOG.warn((Object)("Unable to read .tableinfo from " + hbaseRoot), (Throwable)ioe);
                        this.errors.reportError(ErrorReporter.ERROR_CODE.NO_TABLEINFO_FILE, "Unable to read .tableinfo from " + hbaseRoot + "/" + tableName);
                        HashSet<String> columns = new HashSet<String>();
                        this.orphanTableDirs.put(tableName, this.getColumnFamilyList(columns, hbi));
                    }
                }
            }
            if (hbi.isSkipChecks()) continue;
            modTInfo.addRegionInfo(hbi);
        }
        this.loadTableInfosForTablesWithNoRegion();
        return this.tablesInfo;
    }

    private Set<String> getColumnFamilyList(Set<String> columns, HbckInfo hbi) throws IOException {
        FileStatus[] subDirs;
        Path regionDir = hbi.getHdfsRegionDir();
        FileSystem fs = regionDir.getFileSystem(this.getConf());
        for (FileStatus subdir : subDirs = fs.listStatus(regionDir, (PathFilter)new FSUtils.FamilyDirFilter(fs))) {
            String columnfamily = subdir.getPath().getName();
            columns.add(columnfamily);
        }
        return columns;
    }

    private boolean fabricateTableInfo(FSTableDescriptors fstd, TableName tableName, Set<String> columns) throws IOException {
        if (columns == null || columns.isEmpty()) {
            return false;
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (String columnfamimly : columns) {
            htd.addFamily(new HColumnDescriptor(columnfamimly));
        }
        fstd.createTableDescriptor(htd, true);
        return true;
    }

    public void fixEmptyMetaCells() throws IOException {
        if (this.shouldFixEmptyMetaCells() && !this.emptyRegionInfoQualifiers.isEmpty()) {
            LOG.info((Object)"Trying to fix empty REGIONINFO_QUALIFIER hbase:meta rows.");
            for (Result region : this.emptyRegionInfoQualifiers) {
                this.deleteMetaRegion(region.getRow());
                this.errors.getErrorList().remove((Object)ErrorReporter.ERROR_CODE.EMPTY_META_CELL);
            }
            this.emptyRegionInfoQualifiers.clear();
        }
    }

    public void fixOrphanTables() throws IOException {
        if (this.shouldFixTableOrphans() && !this.orphanTableDirs.isEmpty()) {
            ArrayList<TableName> tmpList = new ArrayList<TableName>();
            tmpList.addAll(this.orphanTableDirs.keySet());
            HTableDescriptor[] htds = this.getHTableDescriptors(tmpList);
            Iterator<Map.Entry<TableName, Set<String>>> iter = this.orphanTableDirs.entrySet().iterator();
            int j = 0;
            int numFailedCase = 0;
            FSTableDescriptors fstd = new FSTableDescriptors(this.getConf());
            while (iter.hasNext()) {
                Map.Entry<TableName, Set<String>> entry = iter.next();
                TableName tableName = entry.getKey();
                LOG.info((Object)("Trying to fix orphan table error: " + tableName));
                if (j < htds.length) {
                    if (tableName.equals((Object)htds[j].getTableName())) {
                        HTableDescriptor htd = htds[j];
                        LOG.info((Object)("fixing orphan table: " + tableName + " from cache"));
                        fstd.createTableDescriptor(htd, true);
                        ++j;
                        iter.remove();
                    }
                } else if (this.fabricateTableInfo(fstd, tableName, entry.getValue())) {
                    LOG.warn((Object)("fixing orphan table: " + tableName + " with a default .tableinfo file"));
                    LOG.warn((Object)("Strongly recommend to modify the HTableDescriptor if necessary for: " + tableName));
                    iter.remove();
                } else {
                    LOG.error((Object)("Unable to create default .tableinfo for " + tableName + " while missing column family information"));
                    ++numFailedCase;
                }
                ++this.fixes;
            }
            if (this.orphanTableDirs.isEmpty()) {
                this.setShouldRerun();
                LOG.warn((Object)"Strongly recommend to re-run manually hfsck after all orphanTableDirs being fixed");
            } else if (numFailedCase > 0) {
                LOG.error((Object)("Failed to fix " + numFailedCase + " OrphanTables with default .tableinfo files"));
            }
        }
        this.orphanTableDirs.clear();
    }

    private HRegion createNewMeta() throws IOException {
        Path rootdir = FSUtils.getRootDir(this.getConf());
        Configuration c = this.getConf();
        HRegionInfo metaHRI = new HRegionInfo(HRegionInfo.FIRST_META_REGIONINFO);
        MasterFileSystem.setInfoFamilyCachingForMeta(false);
        HRegion meta = HRegion.createHRegion(metaHRI, rootdir, c, HTableDescriptor.META_TABLEDESC);
        MasterFileSystem.setInfoFamilyCachingForMeta(true);
        return meta;
    }

    private ArrayList<Put> generatePuts(SortedMap<TableName, TableInfo> tablesInfo) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        boolean hasProblems = false;
        for (Map.Entry<TableName, TableInfo> e : tablesInfo.entrySet()) {
            TableName name = e.getKey();
            if (name.compareTo(TableName.META_TABLE_NAME) == 0) continue;
            TableInfo ti = e.getValue();
            for (Map.Entry spl : ti.sc.getStarts().asMap().entrySet()) {
                Collection his = (Collection)spl.getValue();
                int sz = his.size();
                if (sz != 1) {
                    LOG.error((Object)("Split starting at " + Bytes.toStringBinary((byte[])((byte[])spl.getKey())) + " had " + sz + " regions instead of exactly 1."));
                    hasProblems = true;
                    continue;
                }
                HbckInfo hi = (HbckInfo)his.iterator().next();
                HRegionInfo hri = hi.getHdfsHRI();
                Put p = MetaEditor.makePutFromRegionInfo(hri);
                puts.add(p);
            }
        }
        return hasProblems ? null : puts;
    }

    private void suggestFixes(SortedMap<TableName, TableInfo> tablesInfo) throws IOException {
        Iterator<TableInfo> i$ = tablesInfo.values().iterator();
        while (i$.hasNext()) {
            TableInfo tInfo;
            TableInfo tableInfo = tInfo = i$.next();
            tableInfo.getClass();
            TableInfo.IntegrityFixSuggester handler = tableInfo.new TableInfo.IntegrityFixSuggester(tInfo, this.errors);
            tInfo.checkRegionChain(handler);
        }
    }

    public boolean rebuildMeta(boolean fix) throws IOException, InterruptedException {
        LOG.info((Object)"Loading HBase regioninfo from HDFS...");
        this.loadHdfsRegionDirs();
        int errs = this.errors.getErrorList().size();
        this.tablesInfo = this.loadHdfsRegionInfos();
        this.checkHdfsIntegrity(false, false);
        if (this.errors.getErrorList().size() != errs) {
            int errCount;
            do {
                this.fixes = 0;
                this.suggestFixes(this.tablesInfo);
                this.errors.clear();
                this.loadHdfsRegionInfos();
                this.checkHdfsIntegrity(this.shouldFixHdfsHoles(), this.shouldFixHdfsOverlaps());
                errCount = this.errors.getErrorList().size();
            } while (this.fixes != 0);
            if (errCount > 0) {
                return false;
            }
        }
        LOG.info((Object)"HDFS regioninfo's seems good.  Sidelining old hbase:meta");
        Path backupDir = this.sidelineOldMeta();
        LOG.info((Object)"Creating new hbase:meta");
        HRegion meta = this.createNewMeta();
        ArrayList<Put> puts = this.generatePuts(this.tablesInfo);
        if (puts == null) {
            LOG.fatal((Object)"Problem encountered when creating new hbase:meta entries.  You may need to restore the previously sidelined hbase:meta");
            return false;
        }
        meta.batchMutate((Mutation[])puts.toArray(new Put[0]));
        HRegion.closeHRegion(meta);
        LOG.info((Object)"Success! hbase:meta table rebuilt.");
        LOG.info((Object)("Old hbase:meta is moved into " + backupDir));
        return true;
    }

    private SortedMap<TableName, TableInfo> checkHdfsIntegrity(boolean fixHoles, boolean fixOverlaps) throws IOException {
        LOG.info((Object)"Checking HBase region split map from HDFS data...");
        for (TableInfo tInfo : this.tablesInfo.values()) {
            TableInfo.IntegrityFixSuggester handler;
            if (fixHoles || fixOverlaps) {
                TableInfo tableInfo = tInfo;
                tableInfo.getClass();
                handler = tableInfo.new TableInfo.HDFSIntegrityFixer(tInfo, this.errors, this.getConf(), fixHoles, fixOverlaps);
            } else {
                TableInfo tableInfo = tInfo;
                tableInfo.getClass();
                handler = tableInfo.new TableInfo.IntegrityFixSuggester(tInfo, this.errors);
            }
            if (tInfo.checkRegionChain(handler)) continue;
            this.errors.report("Found inconsistency in table " + tInfo.getName());
        }
        return this.tablesInfo;
    }

    private Path getSidelineDir() throws IOException {
        if (this.sidelineDir == null) {
            Path hbaseDir = FSUtils.getRootDir(this.getConf());
            Path hbckDir = new Path(hbaseDir, ".hbck");
            this.sidelineDir = new Path(hbckDir, hbaseDir.getName() + "-" + this.startMillis);
        }
        return this.sidelineDir;
    }

    Path sidelineRegionDir(FileSystem fs, HbckInfo hi) throws IOException {
        return this.sidelineRegionDir(fs, null, hi);
    }

    Path sidelineRegionDir(FileSystem fs, String parentDir, HbckInfo hi) throws IOException {
        TableName tableName = hi.getTableName();
        Path regionDir = hi.getHdfsRegionDir();
        if (!fs.exists(regionDir)) {
            LOG.warn((Object)("No previous " + regionDir + " exists.  Continuing."));
            return null;
        }
        Path rootDir = this.getSidelineDir();
        if (parentDir != null) {
            rootDir = new Path(rootDir, parentDir);
        }
        Path sidelineTableDir = FSUtils.getTableDir(rootDir, tableName);
        Path sidelineRegionDir = new Path(sidelineTableDir, regionDir.getName());
        fs.mkdirs(sidelineRegionDir);
        boolean success = false;
        FileStatus[] cfs = fs.listStatus(regionDir);
        if (cfs == null) {
            LOG.info((Object)("Region dir is empty: " + regionDir));
        } else {
            for (FileStatus cf : cfs) {
                Path src = cf.getPath();
                Path dst = new Path(sidelineRegionDir, src.getName());
                if (fs.isFile(src)) {
                    success = fs.rename(src, dst);
                    if (success) continue;
                    String msg = "Unable to rename file " + src + " to " + dst;
                    LOG.error((Object)msg);
                    throw new IOException(msg);
                }
                fs.mkdirs(dst);
                LOG.info((Object)("Sidelining files from " + src + " into containing region " + dst));
                FileStatus[] hfiles = fs.listStatus(src);
                if (hfiles != null && hfiles.length > 0) {
                    for (FileStatus hfile : hfiles) {
                        success = fs.rename(hfile.getPath(), dst);
                        if (success) continue;
                        String msg = "Unable to rename file " + src + " to " + dst;
                        LOG.error((Object)msg);
                        throw new IOException(msg);
                    }
                }
                LOG.debug((Object)"Sideline directory contents:");
                this.debugLsr(sidelineRegionDir);
            }
        }
        LOG.info((Object)("Removing old region dir: " + regionDir));
        success = fs.delete(regionDir, true);
        if (!success) {
            String msg = "Unable to delete dir " + regionDir;
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
        return sidelineRegionDir;
    }

    void sidelineTable(FileSystem fs, TableName tableName, Path hbaseDir, Path backupHbaseDir) throws IOException {
        Path tableDir = FSUtils.getTableDir(hbaseDir, tableName);
        if (fs.exists(tableDir)) {
            Path backupTableDir = FSUtils.getTableDir(backupHbaseDir, tableName);
            fs.mkdirs(backupTableDir.getParent());
            boolean success = fs.rename(tableDir, backupTableDir);
            if (!success) {
                throw new IOException("Failed to move  " + tableName + " from " + tableDir + " to " + backupTableDir);
            }
        } else {
            LOG.info((Object)("No previous " + tableName + " exists.  Continuing."));
        }
    }

    Path sidelineOldMeta() throws IOException {
        Path hbaseDir = FSUtils.getRootDir(this.getConf());
        FileSystem fs = hbaseDir.getFileSystem(this.getConf());
        Path backupDir = this.getSidelineDir();
        fs.mkdirs(backupDir);
        try {
            this.sidelineTable(fs, TableName.META_TABLE_NAME, hbaseDir, backupDir);
        }
        catch (IOException e) {
            LOG.fatal((Object)("... failed to sideline meta. Currently in inconsistent state.  To restore try to rename .META. in " + backupDir.getName() + " to " + hbaseDir.getName() + "."), (Throwable)e);
            throw e;
        }
        return backupDir;
    }

    private void loadDisabledTables() throws ZooKeeperConnectionException, IOException {
        HConnectionManager.execute((HConnectable)new HConnectable<Void>(this.getConf()){

            public Void connect(HConnection connection) throws IOException {
                ZooKeeperWatcher zkw = HBaseFsck.this.createZooKeeperWatcher();
                try {
                    for (TableName tableName : ZKTableReadOnly.getDisabledOrDisablingTables((ZooKeeperWatcher)zkw)) {
                        HBaseFsck.this.disabledTables.add(tableName);
                    }
                }
                catch (KeeperException ke) {
                    throw new IOException(ke);
                }
                finally {
                    zkw.close();
                }
                return null;
            }
        });
    }

    private boolean isTableDisabled(HRegionInfo regionInfo) {
        return this.disabledTables.contains(regionInfo.getTable());
    }

    public void loadHdfsRegionDirs() throws IOException, InterruptedException {
        Path rootDir = FSUtils.getRootDir(this.getConf());
        FileSystem fs = rootDir.getFileSystem(this.getConf());
        ArrayList tableDirs = Lists.newArrayList();
        boolean foundVersionFile = fs.exists(new Path(rootDir, "hbase.version"));
        List<Path> paths = FSUtils.getTableDirs(fs, rootDir);
        for (Path path : paths) {
            TableName tableName = FSUtils.getTableName(path);
            if ((this.checkMetaOnly || !this.isTableIncluded(tableName)) && !tableName.equals((Object)TableName.META_TABLE_NAME)) continue;
            tableDirs.add(fs.getFileStatus(path));
        }
        if (!foundVersionFile) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NO_VERSION_FILE, "Version file does not exist in root dir " + rootDir);
            if (this.shouldFixVersionFile()) {
                LOG.info((Object)"Trying to create a new hbase.version file.");
                this.setShouldRerun();
                FSUtils.setVersion(fs, rootDir, this.getConf().getInt("hbase.server.thread.wakefrequency", 10000), this.getConf().getInt("hbase.server.versionfile.writeattempts", 3));
            }
        }
        ArrayList<WorkItemHdfsDir> dirs = new ArrayList<WorkItemHdfsDir>(tableDirs.size());
        for (FileStatus fileStatus : tableDirs) {
            LOG.debug((Object)("Loading region dirs from " + fileStatus.getPath()));
            dirs.add(new WorkItemHdfsDir(this, fs, this.errors, fileStatus));
        }
        List dirsFutures = this.executor.invokeAll(dirs);
        for (Future future : dirsFutures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                LOG.warn((Object)"Could not load region dir ", e.getCause());
            }
        }
    }

    private boolean recordMetaRegion() throws IOException {
        ServerName sn;
        HRegionLocation metaLocation = this.connection.locateRegion(TableName.META_TABLE_NAME, HConstants.EMPTY_START_ROW);
        if (metaLocation == null || metaLocation.getRegionInfo() == null || metaLocation.getHostname() == null) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NULL_META_REGION, "META region or some of its attributes are null.");
            return false;
        }
        try {
            sn = this.getMetaRegionServerName();
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
        MetaEntry m = new MetaEntry(metaLocation.getRegionInfo(), sn, System.currentTimeMillis());
        HbckInfo hbckInfo = this.regionInfoMap.get(metaLocation.getRegionInfo().getEncodedName());
        if (hbckInfo == null) {
            this.regionInfoMap.put(metaLocation.getRegionInfo().getEncodedName(), new HbckInfo(m));
        } else {
            hbckInfo.metaEntry = m;
        }
        return true;
    }

    private ZooKeeperWatcher createZooKeeperWatcher() throws IOException {
        return new ZooKeeperWatcher(this.getConf(), "hbase Fsck", new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.error((Object)why, e);
                System.exit(1);
            }

            public boolean isAborted() {
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerName getMetaRegionServerName() throws IOException, KeeperException {
        ZooKeeperWatcher zkw = this.createZooKeeperWatcher();
        ServerName sn = null;
        try {
            sn = MetaRegionTracker.getMetaRegionLocation((ZooKeeperWatcher)zkw);
        }
        finally {
            zkw.close();
        }
        return sn;
    }

    void processRegionServers(Collection<ServerName> regionServerList) throws IOException, InterruptedException {
        ArrayList<WorkItemRegion> workItems = new ArrayList<WorkItemRegion>(regionServerList.size());
        for (ServerName rsinfo : regionServerList) {
            workItems.add(new WorkItemRegion(this, rsinfo, this.errors, this.connection));
        }
        List workFutures = this.executor.invokeAll(workItems);
        for (int i = 0; i < workFutures.size(); ++i) {
            WorkItemRegion item = (WorkItemRegion)workItems.get(i);
            Future f = workFutures.get(i);
            try {
                f.get();
                continue;
            }
            catch (ExecutionException e) {
                LOG.warn((Object)("Could not process regionserver " + item.rsinfo.getHostAndPort()), e.getCause());
            }
        }
    }

    private void checkAndFixConsistency() throws IOException, KeeperException, InterruptedException {
        for (Map.Entry<String, HbckInfo> e : this.regionInfoMap.entrySet()) {
            this.checkRegionConsistency(e.getKey(), e.getValue());
        }
    }

    private void preCheckPermission() throws IOException, AccessControlException {
        FileStatus[] files;
        if (this.shouldIgnorePreCheckPermission()) {
            return;
        }
        Path hbaseDir = FSUtils.getRootDir(this.getConf());
        FileSystem fs = hbaseDir.getFileSystem(this.getConf());
        UserProvider userProvider = UserProvider.instantiate((Configuration)this.getConf());
        UserGroupInformation ugi = userProvider.getCurrent().getUGI();
        for (FileStatus file : files = fs.listStatus(hbaseDir)) {
            try {
                FSUtils.checkAccess(ugi, file, FsAction.WRITE);
            }
            catch (AccessControlException ace) {
                LOG.warn((Object)"Got AccessControlException when preCheckPermission ", (Throwable)ace);
                this.errors.reportError(ErrorReporter.ERROR_CODE.WRONG_USAGE, "Current user " + ugi.getUserName() + " does not have write perms to " + file.getPath() + ". Please rerun hbck as hdfs user " + file.getOwner());
                throw new AccessControlException((Throwable)ace);
            }
        }
    }

    private void deleteMetaRegion(HbckInfo hi) throws IOException {
        this.deleteMetaRegion(hi.metaEntry.getRegionName());
    }

    private void deleteMetaRegion(byte[] metaKey) throws IOException {
        Delete d = new Delete(metaKey);
        this.meta.delete(d);
        this.meta.flushCommits();
        LOG.info((Object)("Deleted " + Bytes.toString((byte[])metaKey) + " from META"));
    }

    private void resetSplitParent(HbckInfo hi) throws IOException {
        RowMutations mutations = new RowMutations(hi.metaEntry.getRegionName());
        Delete d = new Delete(hi.metaEntry.getRegionName());
        d.deleteColumn(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER);
        d.deleteColumn(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER);
        mutations.add(d);
        HRegionInfo hri = new HRegionInfo((HRegionInfo)hi.metaEntry);
        hri.setOffline(false);
        hri.setSplit(false);
        Put p = MetaEditor.makePutFromRegionInfo(hri);
        mutations.add(p);
        this.meta.mutateRow(mutations);
        this.meta.flushCommits();
        LOG.info((Object)("Reset split parent " + hi.metaEntry.getRegionNameAsString() + " in META"));
    }

    private void offline(byte[] regionName) throws IOException {
        String regionString = Bytes.toStringBinary((byte[])regionName);
        if (!rsSupportsOffline) {
            LOG.warn((Object)("Using unassign region " + regionString + " instead of using offline method, you should" + " restart HMaster after these repairs"));
            this.admin.unassign(regionName, true);
            return;
        }
        try {
            LOG.info((Object)("Offlining region " + regionString));
            this.admin.offline(regionName);
        }
        catch (IOException ioe) {
            String notFoundMsg = "java.lang.NoSuchMethodException: org.apache.hadoop.hbase.master.HMaster.offline([B)";
            if (ioe.getMessage().contains(notFoundMsg)) {
                LOG.warn((Object)("Using unassign region " + regionString + " instead of using offline method, you should" + " restart HMaster after these repairs"));
                rsSupportsOffline = false;
                this.admin.unassign(regionName, true);
                return;
            }
            throw ioe;
        }
    }

    private void undeployRegions(HbckInfo hi) throws IOException, InterruptedException {
        for (OnlineEntry rse : hi.deployedEntries) {
            LOG.debug((Object)("Undeploy region " + rse.hri + " from " + rse.hsa));
            try {
                HBaseFsckRepair.closeRegionSilentlyAndWait(this.admin, rse.hsa, rse.hri);
                this.offline(rse.hri.getRegionName());
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Got exception when attempting to offline region " + Bytes.toString((byte[])rse.hri.getRegionName())), (Throwable)ioe);
            }
        }
    }

    private void closeRegion(HbckInfo hi) throws IOException, InterruptedException {
        if (hi.metaEntry == null && hi.hdfsEntry == null) {
            this.undeployRegions(hi);
            return;
        }
        Get get = new Get(hi.getRegionName());
        get.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        get.addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
        get.addColumn(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER);
        Result r = this.meta.get(get);
        ServerName serverName = HRegionInfo.getServerName((Result)r);
        if (serverName == null) {
            this.errors.reportError("Unable to close region " + hi.getRegionNameAsString() + " because meta does not " + "have handle to reach it.");
            return;
        }
        HRegionInfo hri = HRegionInfo.getHRegionInfo((Result)r);
        if (hri == null) {
            LOG.warn((Object)("Unable to close region " + hi.getRegionNameAsString() + " because hbase:meta had invalid or missing " + "info" + ":" + Bytes.toString((byte[])HConstants.REGIONINFO_QUALIFIER) + " qualifier value."));
            return;
        }
        HBaseFsckRepair.closeRegionSilentlyAndWait(this.admin, serverName, hri);
    }

    private void tryAssignmentRepair(HbckInfo hbi, String msg) throws IOException, KeeperException, InterruptedException {
        if (this.shouldFixAssignments()) {
            this.errors.print(msg);
            this.undeployRegions(hbi);
            this.setShouldRerun();
            HRegionInfo hri = hbi.getHdfsHRI();
            if (hri == null) {
                hri = hbi.metaEntry;
            }
            HBaseFsckRepair.fixUnassigned(this.admin, hri);
            HBaseFsckRepair.waitUntilAssigned(this.admin, hri);
        }
    }

    private void checkRegionConsistency(String key, HbckInfo hbi) throws IOException, KeeperException, InterruptedException {
        boolean recentlyModified;
        boolean deploymentMatchesMeta;
        String descriptiveName = hbi.toString();
        boolean inMeta = hbi.metaEntry != null;
        boolean inHdfs = !this.shouldCheckHdfs() || hbi.getHdfsRegionDir() != null;
        boolean hasMetaAssignment = inMeta && ((HbckInfo)hbi).metaEntry.regionServer != null;
        boolean isDeployed = !hbi.deployedOn.isEmpty();
        boolean isMultiplyDeployed = hbi.deployedOn.size() > 1;
        boolean bl = deploymentMatchesMeta = hasMetaAssignment && isDeployed && !isMultiplyDeployed && ((HbckInfo)hbi).metaEntry.regionServer.equals(hbi.deployedOn.get(0));
        boolean splitParent = hbi.metaEntry == null ? false : hbi.metaEntry.isSplit() && hbi.metaEntry.isOffline();
        boolean shouldBeDeployed = inMeta && !this.isTableDisabled(hbi.metaEntry);
        boolean bl2 = recentlyModified = inHdfs && hbi.getModTime() + this.timelag > System.currentTimeMillis();
        if (hbi.containsOnlyHdfsEdits()) {
            return;
        }
        if (inMeta && inHdfs && isDeployed && deploymentMatchesMeta && shouldBeDeployed) {
            return;
        }
        if (inMeta && inHdfs && !shouldBeDeployed && !isDeployed) {
            LOG.info((Object)("Region " + descriptiveName + " is in META, and in a disabled " + "tabled that is not deployed"));
            return;
        }
        if (recentlyModified) {
            LOG.warn((Object)("Region " + descriptiveName + " was recently modified -- skipping"));
            return;
        }
        if (!(inMeta || inHdfs || isDeployed)) {
            assert (false) : "Entry for region with no data";
        } else if (!inMeta && !inHdfs && isDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NOT_IN_META_HDFS, "Region " + descriptiveName + ", key=" + key + ", not on HDFS or in hbase:meta but " + "deployed on " + Joiner.on((String)", ").join((Iterable)hbi.deployedOn));
            if (this.shouldFixAssignments()) {
                this.undeployRegions(hbi);
            }
        } else if (!inMeta && inHdfs && !isDeployed) {
            if (hbi.isMerged()) {
                hbi.setSkipChecks(true);
                LOG.info((Object)("Region " + descriptiveName + " got merge recently, its file(s) will be cleaned by CatalogJanitor later"));
                return;
            }
            this.errors.reportError(ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, "Region " + descriptiveName + " on HDFS, but not listed in hbase:meta " + "or deployed on any region server");
            if (this.shouldFixMeta()) {
                if (!hbi.isHdfsRegioninfoPresent()) {
                    LOG.error((Object)("Region " + hbi.getHdfsHRI() + " could have been repaired" + " in table integrity repair phase if -fixHdfsOrphans was" + " used."));
                    return;
                }
                LOG.info((Object)("Patching hbase:meta with .regioninfo: " + hbi.getHdfsHRI()));
                HBaseFsckRepair.fixMetaHoleOnline(this.getConf(), hbi.getHdfsHRI());
                this.tryAssignmentRepair(hbi, "Trying to reassign region...");
            }
        } else if (!inMeta && inHdfs && isDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NOT_IN_META, "Region " + descriptiveName + " not in META, but deployed on " + Joiner.on((String)", ").join((Iterable)hbi.deployedOn));
            this.debugLsr(hbi.getHdfsRegionDir());
            if (this.shouldFixMeta()) {
                if (!hbi.isHdfsRegioninfoPresent()) {
                    LOG.error((Object)"This should have been repaired in table integrity repair phase");
                    return;
                }
                LOG.info((Object)("Patching hbase:meta with with .regioninfo: " + hbi.getHdfsHRI()));
                HBaseFsckRepair.fixMetaHoleOnline(this.getConf(), hbi.getHdfsHRI());
                this.tryAssignmentRepair(hbi, "Trying to fix unassigned region...");
            }
        } else if (inMeta && inHdfs && !isDeployed && splitParent) {
            if (((HbckInfo)hbi).metaEntry.splitA != null && ((HbckInfo)hbi).metaEntry.splitB != null) {
                HbckInfo infoA = this.regionInfoMap.get(((HbckInfo)hbi).metaEntry.splitA.getEncodedName());
                HbckInfo infoB = this.regionInfoMap.get(((HbckInfo)hbi).metaEntry.splitB.getEncodedName());
                if (infoA != null && infoB != null) {
                    hbi.setSkipChecks(true);
                    return;
                }
            }
            this.errors.reportError(ErrorReporter.ERROR_CODE.LINGERING_SPLIT_PARENT, "Region " + descriptiveName + " is a split parent in META, in HDFS, " + "and not deployed on any region server. This could be transient.");
            if (this.shouldFixSplitParents()) {
                this.setShouldRerun();
                this.resetSplitParent(hbi);
            }
        } else if (inMeta && !inHdfs && !isDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NOT_IN_HDFS_OR_DEPLOYED, "Region " + descriptiveName + " found in META, but not in HDFS " + "or deployed on any region server.");
            if (this.shouldFixMeta()) {
                this.deleteMetaRegion(hbi);
            }
        } else if (inMeta && !inHdfs && isDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NOT_IN_HDFS, "Region " + descriptiveName + " found in META, but not in HDFS, " + "and deployed on " + Joiner.on((String)", ").join((Iterable)hbi.deployedOn));
            if (this.shouldFixAssignments()) {
                this.errors.print("Trying to fix unassigned region...");
                this.closeRegion(hbi);
            }
            if (this.shouldFixMeta()) {
                this.deleteMetaRegion(hbi);
            }
        } else if (inMeta && inHdfs && !isDeployed && shouldBeDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.NOT_DEPLOYED, "Region " + descriptiveName + " not deployed on any region server.");
            this.tryAssignmentRepair(hbi, "Trying to fix unassigned region...");
        } else if (inMeta && inHdfs && isDeployed && !shouldBeDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.SHOULD_NOT_BE_DEPLOYED, "Region " + descriptiveName + " should not be deployed according " + "to META, but is deployed on " + Joiner.on((String)", ").join((Iterable)hbi.deployedOn));
            if (this.shouldFixAssignments()) {
                this.errors.print("Trying to close the region " + descriptiveName);
                this.setShouldRerun();
                HBaseFsckRepair.fixMultiAssignment(this.admin, hbi.metaEntry, hbi.deployedOn);
            }
        } else if (inMeta && inHdfs && isMultiplyDeployed) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.MULTI_DEPLOYED, "Region " + descriptiveName + " is listed in hbase:meta on region server " + ((HbckInfo)hbi).metaEntry.regionServer + " but is multiply assigned to region servers " + Joiner.on((String)", ").join((Iterable)hbi.deployedOn));
            if (this.shouldFixAssignments()) {
                this.errors.print("Trying to fix assignment error...");
                this.setShouldRerun();
                HBaseFsckRepair.fixMultiAssignment(this.admin, hbi.metaEntry, hbi.deployedOn);
            }
        } else if (inMeta && inHdfs && isDeployed && !deploymentMatchesMeta) {
            this.errors.reportError(ErrorReporter.ERROR_CODE.SERVER_DOES_NOT_MATCH_META, "Region " + descriptiveName + " listed in hbase:meta on region server " + ((HbckInfo)hbi).metaEntry.regionServer + " but found on region server " + hbi.deployedOn.get(0));
            if (this.shouldFixAssignments()) {
                this.errors.print("Trying to fix assignment error...");
                this.setShouldRerun();
                HBaseFsckRepair.fixMultiAssignment(this.admin, hbi.metaEntry, hbi.deployedOn);
                HBaseFsckRepair.waitUntilAssigned(this.admin, hbi.getHdfsHRI());
            }
        } else {
            this.errors.reportError(ErrorReporter.ERROR_CODE.UNKNOWN, "Region " + descriptiveName + " is in an unforeseen state:" + " inMeta=" + inMeta + " inHdfs=" + inHdfs + " isDeployed=" + isDeployed + " isMultiplyDeployed=" + isMultiplyDeployed + " deploymentMatchesMeta=" + deploymentMatchesMeta + " shouldBeDeployed=" + shouldBeDeployed);
        }
    }

    SortedMap<TableName, TableInfo> checkIntegrity() throws IOException {
        this.tablesInfo = new TreeMap<TableName, TableInfo>();
        ArrayList<HbckInfo> noHDFSRegionInfos = new ArrayList<HbckInfo>();
        LOG.debug((Object)("There are " + this.regionInfoMap.size() + " region info entries"));
        for (HbckInfo hbi : this.regionInfoMap.values()) {
            if (hbi.metaEntry == null) {
                noHDFSRegionInfos.add(hbi);
                Path p = hbi.getHdfsRegionDir();
                if (p != null) continue;
                this.errors.report("No regioninfo in Meta or HDFS. " + hbi);
                continue;
            }
            if (((HbckInfo)hbi).metaEntry.regionServer == null) {
                this.errors.detail("Skipping region because no region server: " + hbi);
                continue;
            }
            if (hbi.metaEntry.isOffline()) {
                this.errors.detail("Skipping region because it is offline: " + hbi);
                continue;
            }
            if (hbi.containsOnlyHdfsEdits()) {
                this.errors.detail("Skipping region because it only contains edits" + hbi);
                continue;
            }
            if (hbi.deployedOn.size() == 0) continue;
            TableName tableName = hbi.metaEntry.getTable();
            TableInfo modTInfo = (TableInfo)this.tablesInfo.get(tableName);
            if (modTInfo == null) {
                modTInfo = new TableInfo(tableName);
            }
            for (ServerName server : hbi.deployedOn) {
                modTInfo.addServer(server);
            }
            if (!hbi.isSkipChecks()) {
                modTInfo.addRegionInfo(hbi);
            }
            this.tablesInfo.put(tableName, modTInfo);
        }
        this.loadTableInfosForTablesWithNoRegion();
        Iterator<Object> i$ = this.tablesInfo.values().iterator();
        while (i$.hasNext()) {
            TableInfo tInfo;
            TableInfo tableInfo = tInfo = (TableInfo)i$.next();
            tableInfo.getClass();
            TableInfo.IntegrityFixSuggester handler = tableInfo.new TableInfo.IntegrityFixSuggester(tInfo, this.errors);
            if (tInfo.checkRegionChain(handler)) continue;
            this.errors.report("Found inconsistency in table " + tInfo.getName());
        }
        return this.tablesInfo;
    }

    private void loadTableInfosForTablesWithNoRegion() throws IOException {
        Map<String, HTableDescriptor> allTables = new FSTableDescriptors(this.getConf()).getAll();
        for (HTableDescriptor htd : allTables.values()) {
            TableName tableName;
            if (this.checkMetaOnly && !htd.isMetaTable() || !this.isTableIncluded(tableName = htd.getTableName()) || this.tablesInfo.containsKey(tableName)) continue;
            TableInfo tableInfo = new TableInfo(tableName);
            tableInfo.htds.add(htd);
            this.tablesInfo.put(htd.getTableName(), tableInfo);
        }
    }

    public int mergeRegionDirs(Path targetRegionDir, HbckInfo contained) throws IOException {
        int fileMoves = 0;
        String thread = Thread.currentThread().getName();
        LOG.debug((Object)("[" + thread + "] Contained region dir after close and pause"));
        this.debugLsr(contained.getHdfsRegionDir());
        FileSystem fs = targetRegionDir.getFileSystem(this.getConf());
        FileStatus[] dirs = null;
        try {
            dirs = fs.listStatus(contained.getHdfsRegionDir());
        }
        catch (FileNotFoundException fnfe) {
            if (!fs.exists(contained.getHdfsRegionDir())) {
                LOG.warn((Object)("[" + thread + "] HDFS region dir " + contained.getHdfsRegionDir() + " is missing. Assuming already sidelined or moved."));
            } else {
                this.sidelineRegionDir(fs, contained);
            }
            return fileMoves;
        }
        if (dirs == null) {
            if (!fs.exists(contained.getHdfsRegionDir())) {
                LOG.warn((Object)("[" + thread + "] HDFS region dir " + contained.getHdfsRegionDir() + " already sidelined."));
            } else {
                this.sidelineRegionDir(fs, contained);
            }
            return fileMoves;
        }
        for (FileStatus cf : dirs) {
            Path src = cf.getPath();
            Path dst = new Path(targetRegionDir, src.getName());
            if (src.getName().equals(".regioninfo") || src.getName().equals("oldWALs")) continue;
            LOG.info((Object)("[" + thread + "] Moving files from " + src + " into containing region " + dst));
            for (FileStatus hfile : fs.listStatus(src)) {
                boolean success = fs.rename(hfile.getPath(), dst);
                if (!success) continue;
                ++fileMoves;
            }
            LOG.debug((Object)("[" + thread + "] Sideline directory contents:"));
            this.debugLsr(targetRegionDir);
        }
        this.sidelineRegionDir(fs, contained);
        LOG.info((Object)("[" + thread + "] Sidelined region dir " + contained.getHdfsRegionDir() + " into " + this.getSidelineDir()));
        this.debugLsr(contained.getHdfsRegionDir());
        return fileMoves;
    }

    public void dumpOverlapProblems(Multimap<byte[], HbckInfo> regions) {
        for (byte[] k : regions.keySet()) {
            this.errors.print(Bytes.toStringBinary((byte[])k) + ":");
            for (HbckInfo r : regions.get((Object)k)) {
                this.errors.print("[ " + r.toString() + ", " + Bytes.toStringBinary((byte[])r.getEndKey()) + "]");
            }
            this.errors.print("----");
        }
    }

    public void dumpSidelinedRegions(Map<Path, HbckInfo> regions) {
        for (Map.Entry<Path, HbckInfo> entry : regions.entrySet()) {
            TableName tableName = entry.getValue().getTableName();
            Path path = entry.getKey();
            this.errors.print("This sidelined region dir should be bulk loaded: " + path.toString());
            this.errors.print("Bulk load command looks like: hbase org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles " + path.toUri().getPath() + " " + tableName);
        }
    }

    public Multimap<byte[], HbckInfo> getOverlapGroups(TableName table) {
        TableInfo ti = (TableInfo)this.tablesInfo.get(table);
        return ti.overlapGroups;
    }

    HTableDescriptor[] getTables(AtomicInteger numSkipped) {
        ArrayList<TableName> tableNames = new ArrayList<TableName>();
        long now = System.currentTimeMillis();
        for (HbckInfo hbi : this.regionInfoMap.values()) {
            MetaEntry info = hbi.metaEntry;
            if (info == null || info.getStartKey().length != 0 || info.isMetaRegion()) continue;
            if (info.modTime + this.timelag < now) {
                tableNames.add(info.getTable());
                continue;
            }
            numSkipped.incrementAndGet();
        }
        return this.getHTableDescriptors(tableNames);
    }

    HTableDescriptor[] getHTableDescriptors(List<TableName> tableNames) {
        HTableDescriptor[] htd = new HTableDescriptor[]{};
        try {
            LOG.info((Object)("getHTableDescriptors == tableNames => " + tableNames));
            htd = new HBaseAdmin(this.getConf()).getTableDescriptorsByTableName(tableNames);
        }
        catch (IOException e) {
            LOG.debug((Object)"Exception getting table descriptors", (Throwable)e);
        }
        return htd;
    }

    private synchronized HbckInfo getOrCreateInfo(String name) {
        HbckInfo hbi = this.regionInfoMap.get(name);
        if (hbi == null) {
            hbi = new HbckInfo(null);
            this.regionInfoMap.put(name, hbi);
        }
        return hbi;
    }

    private void checkAndFixTableLocks() throws IOException {
        TableLockChecker checker = new TableLockChecker(this.createZooKeeperWatcher(), this.errors);
        checker.checkTableLocks();
        if (this.fixTableLocks) {
            checker.fixExpiredTableLocks();
        }
    }

    boolean checkMetaRegion() throws IOException, KeeperException, InterruptedException {
        ArrayList metaRegions = Lists.newArrayList();
        for (HbckInfo value : this.regionInfoMap.values()) {
            if (value.metaEntry == null || !value.metaEntry.isMetaRegion()) continue;
            metaRegions.add(value);
        }
        List<ServerName> servers = new ArrayList();
        HbckInfo metaHbckInfo = null;
        if (!metaRegions.isEmpty()) {
            metaHbckInfo = (HbckInfo)metaRegions.get(0);
            servers = metaHbckInfo.deployedOn;
        }
        if (servers.size() != 1) {
            if (servers.size() == 0) {
                this.errors.reportError(ErrorReporter.ERROR_CODE.NO_META_REGION, "hbase:meta is not found on any region.");
                if (this.shouldFixAssignments()) {
                    this.errors.print("Trying to fix a problem with hbase:meta..");
                    this.setShouldRerun();
                    HBaseFsckRepair.fixUnassigned(this.admin, HRegionInfo.FIRST_META_REGIONINFO);
                    HBaseFsckRepair.waitUntilAssigned(this.admin, HRegionInfo.FIRST_META_REGIONINFO);
                }
            } else if (servers.size() > 1) {
                this.errors.reportError(ErrorReporter.ERROR_CODE.MULTI_META_REGION, "hbase:meta is found on more than one region.");
                if (this.shouldFixAssignments()) {
                    this.errors.print("Trying to fix a problem with hbase:meta..");
                    this.setShouldRerun();
                    HBaseFsckRepair.fixMultiAssignment(this.admin, metaHbckInfo.metaEntry, servers);
                }
            }
            return false;
        }
        return true;
    }

    boolean loadMetaEntries() throws IOException {
        MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){
            int countRecord = 1;
            final Comparator<Cell> comp = new Comparator<Cell>(){

                @Override
                public int compare(Cell k1, Cell k2) {
                    return (int)(k1.getTimestamp() - k2.getTimestamp());
                }
            };

            public boolean processRow(Result result) throws IOException {
                try {
                    HRegionInfo hri;
                    long ts = Collections.max(result.listCells(), this.comp).getTimestamp();
                    Pair pair = HRegionInfo.getHRegionInfoAndServerName((Result)result);
                    if (pair == null || pair.getFirst() == null) {
                        HBaseFsck.this.emptyRegionInfoQualifiers.add(result);
                        HBaseFsck.this.errors.reportError(ErrorReporter.ERROR_CODE.EMPTY_META_CELL, "Empty REGIONINFO_QUALIFIER found in hbase:meta");
                        return true;
                    }
                    ServerName sn = null;
                    if (pair.getSecond() != null) {
                        sn = (ServerName)pair.getSecond();
                    }
                    if (!HBaseFsck.this.isTableIncluded((hri = (HRegionInfo)pair.getFirst()).getTable()) && !hri.isMetaRegion()) {
                        return true;
                    }
                    PairOfSameType daughters = HRegionInfo.getDaughterRegions((Result)result);
                    MetaEntry m = new MetaEntry(hri, sn, ts, (HRegionInfo)daughters.getFirst(), (HRegionInfo)daughters.getSecond());
                    HbckInfo previous = (HbckInfo)HBaseFsck.this.regionInfoMap.get(hri.getEncodedName());
                    if (previous == null) {
                        HBaseFsck.this.regionInfoMap.put(hri.getEncodedName(), new HbckInfo(m));
                    } else if (previous.metaEntry == null) {
                        previous.metaEntry = m;
                    } else {
                        throw new IOException("Two entries in hbase:meta are same " + previous);
                    }
                    PairOfSameType mergeRegions = HRegionInfo.getMergeRegions((Result)result);
                    for (HRegionInfo mergeRegion : new HRegionInfo[]{(HRegionInfo)mergeRegions.getFirst(), (HRegionInfo)mergeRegions.getSecond()}) {
                        if (mergeRegion == null) continue;
                        HbckInfo hbInfo = HBaseFsck.this.getOrCreateInfo(mergeRegion.getEncodedName());
                        hbInfo.setMerged(true);
                    }
                    if (this.countRecord % 100 == 0) {
                        HBaseFsck.this.errors.progress();
                    }
                    ++this.countRecord;
                    return true;
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("Result=" + result));
                    throw e;
                }
            }
        };
        if (!this.checkMetaOnly) {
            MetaScanner.metaScan((Configuration)this.getConf(), (MetaScanner.MetaScannerVisitor)visitor);
        }
        this.errors.print("");
        return true;
    }

    private void printTableSummary(SortedMap<TableName, TableInfo> tablesInfo) {
        StringBuilder sb = new StringBuilder();
        this.errors.print("Summary:");
        for (TableInfo tInfo : tablesInfo.values()) {
            if (this.errors.tableHasErrors(tInfo)) {
                this.errors.print("Table " + tInfo.getName() + " is inconsistent.");
            } else {
                this.errors.print("  " + tInfo.getName() + " is okay.");
            }
            this.errors.print("    Number of regions: " + tInfo.getNumRegions());
            sb.setLength(0);
            sb.append("    Deployed on: ");
            for (ServerName server : tInfo.deployedOn) {
                sb.append(" " + server.toString());
            }
            this.errors.print(sb.toString());
        }
    }

    static ErrorReporter getErrorReporter(Configuration conf) throws ClassNotFoundException {
        Class reporter = conf.getClass("hbasefsck.errorreporter", PrintingErrorReporter.class, ErrorReporter.class);
        return (ErrorReporter)ReflectionUtils.newInstance((Class)reporter, (Configuration)conf);
    }

    public static void setDisplayFullReport() {
        details = true;
    }

    void setSummary() {
        summary = true;
    }

    void setCheckMetaOnly() {
        this.checkMetaOnly = true;
    }

    void setRegionBoundariesCheck() {
        this.checkRegionBoundaries = true;
    }

    public void setFixTableLocks(boolean shouldFix) {
        this.fixTableLocks = shouldFix;
    }

    void setShouldRerun() {
        this.rerun = true;
    }

    boolean shouldRerun() {
        return this.rerun;
    }

    public void setFixAssignments(boolean shouldFix) {
        this.fixAssignments = shouldFix;
    }

    boolean shouldFixAssignments() {
        return this.fixAssignments;
    }

    public void setFixMeta(boolean shouldFix) {
        this.fixMeta = shouldFix;
    }

    boolean shouldFixMeta() {
        return this.fixMeta;
    }

    public void setFixEmptyMetaCells(boolean shouldFix) {
        this.fixEmptyMetaCells = shouldFix;
    }

    boolean shouldFixEmptyMetaCells() {
        return this.fixEmptyMetaCells;
    }

    public void setCheckHdfs(boolean checking) {
        this.checkHdfs = checking;
    }

    boolean shouldCheckHdfs() {
        return this.checkHdfs;
    }

    public void setFixHdfsHoles(boolean shouldFix) {
        this.fixHdfsHoles = shouldFix;
    }

    boolean shouldFixHdfsHoles() {
        return this.fixHdfsHoles;
    }

    public void setFixTableOrphans(boolean shouldFix) {
        this.fixTableOrphans = shouldFix;
    }

    boolean shouldFixTableOrphans() {
        return this.fixTableOrphans;
    }

    public void setFixHdfsOverlaps(boolean shouldFix) {
        this.fixHdfsOverlaps = shouldFix;
    }

    boolean shouldFixHdfsOverlaps() {
        return this.fixHdfsOverlaps;
    }

    public void setFixHdfsOrphans(boolean shouldFix) {
        this.fixHdfsOrphans = shouldFix;
    }

    boolean shouldFixHdfsOrphans() {
        return this.fixHdfsOrphans;
    }

    public void setFixVersionFile(boolean shouldFix) {
        this.fixVersionFile = shouldFix;
    }

    public boolean shouldFixVersionFile() {
        return this.fixVersionFile;
    }

    public void setSidelineBigOverlaps(boolean sbo) {
        this.sidelineBigOverlaps = sbo;
    }

    public boolean shouldSidelineBigOverlaps() {
        return this.sidelineBigOverlaps;
    }

    public void setFixSplitParents(boolean shouldFix) {
        this.fixSplitParents = shouldFix;
    }

    boolean shouldFixSplitParents() {
        return this.fixSplitParents;
    }

    public void setFixReferenceFiles(boolean shouldFix) {
        this.fixReferenceFiles = shouldFix;
    }

    boolean shouldFixReferenceFiles() {
        return this.fixReferenceFiles;
    }

    public boolean shouldIgnorePreCheckPermission() {
        return this.ignorePreCheckPermission;
    }

    public void setIgnorePreCheckPermission(boolean ignorePreCheckPermission) {
        this.ignorePreCheckPermission = ignorePreCheckPermission;
    }

    public void setMaxMerge(int mm) {
        this.maxMerge = mm;
    }

    public int getMaxMerge() {
        return this.maxMerge;
    }

    public void setMaxOverlapsToSideline(int mo) {
        this.maxOverlapsToSideline = mo;
    }

    public int getMaxOverlapsToSideline() {
        return this.maxOverlapsToSideline;
    }

    boolean isTableIncluded(TableName table) {
        return this.tablesIncluded.size() == 0 || this.tablesIncluded.contains(table);
    }

    public void includeTable(TableName table) {
        this.tablesIncluded.add(table);
    }

    Set<TableName> getIncludedTables() {
        return new HashSet<TableName>(this.tablesIncluded);
    }

    public void setTimeLag(long seconds) {
        this.timelag = seconds * 1000L;
    }

    public void setSidelineDir(String sidelineDir) {
        this.sidelineDir = new Path(sidelineDir);
    }

    protected HFileCorruptionChecker createHFileCorruptionChecker(boolean sidelineCorruptHFiles) throws IOException {
        return new HFileCorruptionChecker(this.getConf(), this.executor, sidelineCorruptHFiles);
    }

    public HFileCorruptionChecker getHFilecorruptionChecker() {
        return this.hfcc;
    }

    public void setHFileCorruptionChecker(HFileCorruptionChecker hfcc) {
        this.hfcc = hfcc;
    }

    public void setRetCode(int code) {
        this.retcode = code;
    }

    public int getRetCode() {
        return this.retcode;
    }

    protected HBaseFsck printUsageAndExit() {
        StringWriter sw = new StringWriter(2048);
        PrintWriter out = new PrintWriter(sw);
        out.println("Usage: fsck [opts] {only tables}");
        out.println(" where [opts] are:");
        out.println("   -help Display help options (this)");
        out.println("   -details Display full report of all regions.");
        out.println("   -timelag <timeInSeconds>  Process only regions that  have not experienced any metadata updates in the last  <timeInSeconds> seconds.");
        out.println("   -sleepBeforeRerun <timeInSeconds> Sleep this many seconds before checking if the fix worked if run with -fix");
        out.println("   -summary Print only summary of the tables and status.");
        out.println("   -metaonly Only check the state of the hbase:meta table.");
        out.println("   -sidelineDir <hdfs://> HDFS path to backup existing meta.");
        out.println("   -boundaries Verify that regions boundaries are the same between META and store files.");
        out.println("");
        out.println("  Metadata Repair options: (expert features, use with caution!)");
        out.println("   -fix              Try to fix region assignments.  This is for backwards compatiblity");
        out.println("   -fixAssignments   Try to fix region assignments.  Replaces the old -fix");
        out.println("   -fixMeta          Try to fix meta problems.  This assumes HDFS region info is good.");
        out.println("   -noHdfsChecking   Don't load/check region info from HDFS. Assumes hbase:meta region info is good. Won't check/fix any HDFS issue, e.g. hole, orphan, or overlap");
        out.println("   -fixHdfsHoles     Try to fix region holes in hdfs.");
        out.println("   -fixHdfsOrphans   Try to fix region dirs with no .regioninfo file in hdfs");
        out.println("   -fixTableOrphans  Try to fix table dirs with no .tableinfo file in hdfs (online mode only)");
        out.println("   -fixHdfsOverlaps  Try to fix region overlaps in hdfs.");
        out.println("   -fixVersionFile   Try to fix missing hbase.version file in hdfs.");
        out.println("   -maxMerge <n>     When fixing region overlaps, allow at most <n> regions to merge. (n=5 by default)");
        out.println("   -sidelineBigOverlaps  When fixing region overlaps, allow to sideline big overlaps");
        out.println("   -maxOverlapsToSideline <n>  When fixing region overlaps, allow at most <n> regions to sideline per group. (n=2 by default)");
        out.println("   -fixSplitParents  Try to force offline split parents to be online.");
        out.println("   -ignorePreCheckPermission  ignore filesystem permission pre-check");
        out.println("   -fixReferenceFiles  Try to offline lingering reference store files");
        out.println("   -fixEmptyMetaCells  Try to fix hbase:meta entries not referencing any region (empty REGIONINFO_QUALIFIER rows)");
        out.println("");
        out.println("  Datafile Repair options: (expert features, use with caution!)");
        out.println("   -checkCorruptHFiles     Check all Hfiles by opening them to make sure they are valid");
        out.println("   -sidelineCorruptHFiles  Quarantine corrupted HFiles.  implies -checkCorruptHFiles");
        out.println("");
        out.println("  Metadata Repair shortcuts");
        out.println("   -repair           Shortcut for -fixAssignments -fixMeta -fixHdfsHoles -fixHdfsOrphans -fixHdfsOverlaps -fixVersionFile -sidelineBigOverlaps -fixReferenceFiles -fixTableLocks");
        out.println("   -repairHoles      Shortcut for -fixAssignments -fixMeta -fixHdfsHoles");
        out.println("");
        out.println("  Table lock options");
        out.println("   -fixTableLocks    Deletes table locks held for a long time (hbase.table.lock.expire.ms, 10min by default)");
        out.flush();
        this.errors.reportError(ErrorReporter.ERROR_CODE.WRONG_USAGE, sw.toString());
        this.setRetCode(-2);
        return this;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        Path hbasedir = FSUtils.getRootDir(conf);
        URI defaultFs = hbasedir.getFileSystem(conf).getUri();
        FSUtils.setFsDefault(conf, new Path(defaultFs));
        int ret = ToolRunner.run((Tool)new HBaseFsckTool(conf), (String[])args);
        System.exit(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBaseFsck exec(ExecutorService exec, String[] args) throws KeeperException, IOException, ServiceException, InterruptedException {
        block56: {
            int code;
            long sleepBeforeRerun = 10000L;
            boolean checkCorruptHFiles = false;
            boolean sidelineCorruptHFiles = false;
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equals("-help") || cmd.equals("-h")) {
                    return this.printUsageAndExit();
                }
                if (cmd.equals("-details")) {
                    HBaseFsck.setDisplayFullReport();
                    continue;
                }
                if (cmd.equals("-timelag")) {
                    if (i == args.length - 1) {
                        this.errors.reportError(ErrorReporter.ERROR_CODE.WRONG_USAGE, "HBaseFsck: -timelag needs a value.");
                        return this.printUsageAndExit();
                    }
                    try {
                        long timelag = Long.parseLong(args[i + 1]);
                        this.setTimeLag(timelag);
                    }
                    catch (NumberFormatException e) {
                        this.errors.reportError(ErrorReporter.ERROR_CODE.WRONG_USAGE, "-timelag needs a numeric value.");
                        return this.printUsageAndExit();
                    }
                    ++i;
                    continue;
                }
                if (cmd.equals("-sleepBeforeRerun")) {
                    if (i == args.length - 1) {
                        this.errors.reportError(ErrorReporter.ERROR_CODE.WRONG_USAGE, "HBaseFsck: -sleepBeforeRerun needs a value.");
                        return this.printUsageAndExit();
                    }
                    try {
                        sleepBeforeRerun = Long.parseLong(args[i + 1]);
                    }
                    catch (NumberFormatException e) {
                        this.errors.reportError(ErrorReporter.ERROR_CODE.WRONG_USAGE, "-sleepBeforeRerun needs a numeric value.");
                        return this.printUsageAndExit();
                    }
                    ++i;
                    continue;
                }
                if (cmd.equals("-sidelineDir")) {
                    if (i == args.length - 1) {
                        this.errors.reportError(ErrorReporter.ERROR_CODE.WRONG_USAGE, "HBaseFsck: -sidelineDir needs a value.");
                        return this.printUsageAndExit();
                    }
                    this.setSidelineDir(args[++i]);
                    continue;
                }
                if (cmd.equals("-fix")) {
                    this.errors.reportError(ErrorReporter.ERROR_CODE.WRONG_USAGE, "This option is deprecated, please use  -fixAssignments instead.");
                    this.setFixAssignments(true);
                    continue;
                }
                if (cmd.equals("-fixAssignments")) {
                    this.setFixAssignments(true);
                    continue;
                }
                if (cmd.equals("-fixMeta")) {
                    this.setFixMeta(true);
                    continue;
                }
                if (cmd.equals("-noHdfsChecking")) {
                    this.setCheckHdfs(false);
                    continue;
                }
                if (cmd.equals("-fixHdfsHoles")) {
                    this.setFixHdfsHoles(true);
                    continue;
                }
                if (cmd.equals("-fixHdfsOrphans")) {
                    this.setFixHdfsOrphans(true);
                    continue;
                }
                if (cmd.equals("-fixTableOrphans")) {
                    this.setFixTableOrphans(true);
                    continue;
                }
                if (cmd.equals("-fixHdfsOverlaps")) {
                    this.setFixHdfsOverlaps(true);
                    continue;
                }
                if (cmd.equals("-fixVersionFile")) {
                    this.setFixVersionFile(true);
                    continue;
                }
                if (cmd.equals("-sidelineBigOverlaps")) {
                    this.setSidelineBigOverlaps(true);
                    continue;
                }
                if (cmd.equals("-fixSplitParents")) {
                    this.setFixSplitParents(true);
                    continue;
                }
                if (cmd.equals("-ignorePreCheckPermission")) {
                    this.setIgnorePreCheckPermission(true);
                    continue;
                }
                if (cmd.equals("-checkCorruptHFiles")) {
                    checkCorruptHFiles = true;
                    continue;
                }
                if (cmd.equals("-sidelineCorruptHFiles")) {
                    sidelineCorruptHFiles = true;
                    continue;
                }
                if (cmd.equals("-fixReferenceFiles")) {
                    this.setFixReferenceFiles(true);
                    continue;
                }
                if (cmd.equals("-fixEmptyMetaCells")) {
                    this.setFixEmptyMetaCells(true);
                    continue;
                }
                if (cmd.equals("-repair")) {
                    this.setFixHdfsHoles(true);
                    this.setFixHdfsOrphans(true);
                    this.setFixMeta(true);
                    this.setFixAssignments(true);
                    this.setFixHdfsOverlaps(true);
                    this.setFixVersionFile(true);
                    this.setSidelineBigOverlaps(true);
                    this.setFixSplitParents(false);
                    this.setCheckHdfs(true);
                    this.setFixReferenceFiles(true);
                    this.setFixTableLocks(true);
                    continue;
                }
                if (cmd.equals("-repairHoles")) {
                    this.setFixHdfsHoles(true);
                    this.setFixHdfsOrphans(false);
                    this.setFixMeta(true);
                    this.setFixAssignments(true);
                    this.setFixHdfsOverlaps(false);
                    this.setSidelineBigOverlaps(false);
                    this.setFixSplitParents(false);
                    this.setCheckHdfs(true);
                    continue;
                }
                if (cmd.equals("-maxOverlapsToSideline")) {
                    if (i == args.length - 1) {
                        this.errors.reportError(ErrorReporter.ERROR_CODE.WRONG_USAGE, "-maxOverlapsToSideline needs a numeric value argument.");
                        return this.printUsageAndExit();
                    }
                    try {
                        int maxOverlapsToSideline = Integer.parseInt(args[i + 1]);
                        this.setMaxOverlapsToSideline(maxOverlapsToSideline);
                    }
                    catch (NumberFormatException e) {
                        this.errors.reportError(ErrorReporter.ERROR_CODE.WRONG_USAGE, "-maxOverlapsToSideline needs a numeric value argument.");
                        return this.printUsageAndExit();
                    }
                    ++i;
                    continue;
                }
                if (cmd.equals("-maxMerge")) {
                    if (i == args.length - 1) {
                        this.errors.reportError(ErrorReporter.ERROR_CODE.WRONG_USAGE, "-maxMerge needs a numeric value argument.");
                        return this.printUsageAndExit();
                    }
                    try {
                        int maxMerge = Integer.parseInt(args[i + 1]);
                        this.setMaxMerge(maxMerge);
                    }
                    catch (NumberFormatException e) {
                        this.errors.reportError(ErrorReporter.ERROR_CODE.WRONG_USAGE, "-maxMerge needs a numeric value argument.");
                        return this.printUsageAndExit();
                    }
                    ++i;
                    continue;
                }
                if (cmd.equals("-summary")) {
                    this.setSummary();
                    continue;
                }
                if (cmd.equals("-metaonly")) {
                    this.setCheckMetaOnly();
                    continue;
                }
                if (cmd.equals("-boundaries")) {
                    this.setRegionBoundariesCheck();
                    continue;
                }
                if (cmd.equals("-fixTableLocks")) {
                    this.setFixTableLocks(true);
                    continue;
                }
                if (cmd.startsWith("-")) {
                    this.errors.reportError(ErrorReporter.ERROR_CODE.WRONG_USAGE, "Unrecognized option:" + cmd);
                    return this.printUsageAndExit();
                }
                this.includeTable(TableName.valueOf((String)cmd));
                this.errors.print("Allow checking/fixes for table: " + cmd);
            }
            try {
                this.preCheckPermission();
            }
            catch (AccessControlException ace) {
                Runtime.getRuntime().exit(-1);
            }
            catch (IOException ioe) {
                Runtime.getRuntime().exit(-1);
            }
            this.connect();
            try {
                if (checkCorruptHFiles || sidelineCorruptHFiles) {
                    LOG.info((Object)"Checking all hfiles for corruption");
                    HFileCorruptionChecker hfcc = this.createHFileCorruptionChecker(sidelineCorruptHFiles);
                    this.setHFileCorruptionChecker(hfcc);
                    Set<TableName> tables = this.getIncludedTables();
                    ArrayList<Path> tableDirs = new ArrayList();
                    Path rootdir = FSUtils.getRootDir(this.getConf());
                    if (tables.size() > 0) {
                        for (TableName t : tables) {
                            tableDirs.add(FSUtils.getTableDir(rootdir, t));
                        }
                    } else {
                        tableDirs = FSUtils.getTableDirs(FSUtils.getCurrentFileSystem(this.getConf()), rootdir);
                    }
                    hfcc.checkTables(tableDirs);
                    hfcc.report(this.errors);
                }
                code = this.onlineHbck();
                this.setRetCode(code);
                if (!this.shouldRerun()) break block56;
                try {
                    LOG.info((Object)("Sleeping " + sleepBeforeRerun + "ms before re-checking after fix..."));
                    Thread.sleep(sleepBeforeRerun);
                }
                catch (InterruptedException ie) {
                    HBaseFsck hBaseFsck = this;
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.connection, this.meta, this.admin});
                    return hBaseFsck;
                }
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.connection, this.meta, this.admin});
                throw throwable;
            }
            this.setFixAssignments(false);
            this.setFixMeta(false);
            this.setFixHdfsHoles(false);
            this.setFixHdfsOverlaps(false);
            this.setFixVersionFile(false);
            this.setFixTableOrphans(false);
            this.errors.resetErrors();
            code = this.onlineHbck();
            this.setRetCode(code);
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.connection, this.meta, this.admin});
        return this;
    }

    void debugLsr(Path p) throws IOException {
        HBaseFsck.debugLsr(this.getConf(), p, this.errors);
    }

    public static void debugLsr(Configuration conf, Path p) throws IOException {
        HBaseFsck.debugLsr(conf, p, new PrintingErrorReporter());
    }

    public static void debugLsr(Configuration conf, Path p, ErrorReporter errors) throws IOException {
        if (!LOG.isDebugEnabled() || p == null) {
            return;
        }
        FileSystem fs = p.getFileSystem(conf);
        if (!fs.exists(p)) {
            return;
        }
        errors.print(p.toString());
        if (fs.isFile(p)) {
            return;
        }
        if (fs.getFileStatus(p).isDir()) {
            FileStatus[] fss;
            for (FileStatus status : fss = fs.listStatus(p)) {
                HBaseFsck.debugLsr(conf, status.getPath(), errors);
            }
        }
    }

    static class HBaseFsckTool
    extends Configured
    implements Tool {
        HBaseFsckTool(Configuration conf) {
            super(conf);
        }

        public int run(String[] args) throws Exception {
            HBaseFsck hbck = new HBaseFsck(this.getConf());
            hbck.exec(hbck.executor, args);
            return hbck.getRetCode();
        }
    }

    static class WorkItemHdfsRegionInfo
    implements Callable<Void> {
        private HbckInfo hbi;
        private HBaseFsck hbck;
        private ErrorReporter errors;

        WorkItemHdfsRegionInfo(HbckInfo hbi, HBaseFsck hbck, ErrorReporter errors) {
            this.hbi = hbi;
            this.hbck = hbck;
            this.errors = errors;
        }

        @Override
        public synchronized Void call() throws IOException {
            if (this.hbi.getHdfsHRI() == null) {
                try {
                    this.hbck.loadHdfsRegioninfo(this.hbi);
                }
                catch (IOException ioe) {
                    String msg = "Orphan region in HDFS: Unable to load .regioninfo from table " + this.hbi.getTableName() + " in hdfs dir " + this.hbi.getHdfsRegionDir() + "!  It may be an invalid format or version file.  Treating as " + "an orphaned regiondir.";
                    this.errors.reportError(ErrorReporter.ERROR_CODE.ORPHAN_HDFS_REGION, msg);
                    try {
                        this.hbck.debugLsr(this.hbi.getHdfsRegionDir());
                    }
                    catch (IOException ioe2) {
                        LOG.error((Object)("Unable to read directory " + this.hbi.getHdfsRegionDir()), (Throwable)ioe2);
                        throw ioe2;
                    }
                    this.hbck.orphanHdfsDirs.add(this.hbi);
                    throw ioe;
                }
            }
            return null;
        }
    }

    static class WorkItemHdfsDir
    implements Callable<Void> {
        private HBaseFsck hbck;
        private FileStatus tableDir;
        private ErrorReporter errors;
        private FileSystem fs;

        WorkItemHdfsDir(HBaseFsck hbck, FileSystem fs, ErrorReporter errors, FileStatus status) {
            this.hbck = hbck;
            this.fs = fs;
            this.tableDir = status;
            this.errors = errors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Void call() throws IOException {
            try {
                FileStatus[] regionDirs;
                for (FileStatus regionDir : regionDirs = this.fs.listStatus(this.tableDir.getPath())) {
                    String encodedName = regionDir.getPath().getName();
                    if (!encodedName.toLowerCase().matches("[0-9a-f]+")) continue;
                    LOG.debug((Object)("Loading region info from hdfs:" + regionDir.getPath()));
                    HbckInfo hbi = this.hbck.getOrCreateInfo(encodedName);
                    HdfsEntry he = new HdfsEntry();
                    HbckInfo hbckInfo = hbi;
                    synchronized (hbckInfo) {
                        if (hbi.getHdfsRegionDir() != null) {
                            this.errors.print("Directory " + encodedName + " duplicate??" + hbi.getHdfsRegionDir());
                        }
                        he.hdfsRegionDir = regionDir.getPath();
                        he.hdfsRegionDirModTime = regionDir.getModificationTime();
                        Path regioninfoFile = new Path(he.hdfsRegionDir, ".regioninfo");
                        he.hdfsRegioninfoFilePresent = this.fs.exists(regioninfoFile);
                        he.hdfsOnlyEdits = true;
                        FileStatus[] subDirs = this.fs.listStatus(regionDir.getPath());
                        Path ePath = HLogUtil.getRegionDirRecoveredEditsDir(regionDir.getPath());
                        for (FileStatus subDir : subDirs) {
                            String sdName = subDir.getPath().getName();
                            if (sdName.startsWith(".") || sdName.equals(ePath.getName())) continue;
                            he.hdfsOnlyEdits = false;
                            break;
                        }
                        hbi.hdfsEntry = he;
                    }
                }
            }
            catch (IOException e) {
                this.errors.reportError(ErrorReporter.ERROR_CODE.RS_CONNECT_FAILURE, "Table Directory: " + this.tableDir.getPath().getName() + " Unable to fetch region information. " + e);
                throw e;
            }
            return null;
        }
    }

    static class WorkItemRegion
    implements Callable<Void> {
        private HBaseFsck hbck;
        private ServerName rsinfo;
        private ErrorReporter errors;
        private HConnection connection;

        WorkItemRegion(HBaseFsck hbck, ServerName info, ErrorReporter errors, HConnection connection) {
            this.hbck = hbck;
            this.rsinfo = info;
            this.errors = errors;
            this.connection = connection;
        }

        @Override
        public synchronized Void call() throws IOException {
            this.errors.progress();
            try {
                AdminProtos.AdminService.BlockingInterface server = this.connection.getAdmin(this.rsinfo);
                List<HRegionInfo> regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server);
                regions = this.filterRegions(regions);
                if (details) {
                    this.errors.detail("RegionServer: " + this.rsinfo.getServerName() + " number of regions: " + regions.size());
                    for (HRegionInfo rinfo : regions) {
                        this.errors.detail("  " + rinfo.getRegionNameAsString() + " id: " + rinfo.getRegionId() + " encoded_name: " + rinfo.getEncodedName() + " start: " + Bytes.toStringBinary((byte[])rinfo.getStartKey()) + " end: " + Bytes.toStringBinary((byte[])rinfo.getEndKey()));
                    }
                }
                for (HRegionInfo r : regions) {
                    HbckInfo hbi = this.hbck.getOrCreateInfo(r.getEncodedName());
                    hbi.addServer(r, this.rsinfo);
                }
            }
            catch (IOException e) {
                this.errors.reportError(ErrorReporter.ERROR_CODE.RS_CONNECT_FAILURE, "RegionServer: " + this.rsinfo.getServerName() + " Unable to fetch region information. " + e);
                throw e;
            }
            return null;
        }

        private List<HRegionInfo> filterRegions(List<HRegionInfo> regions) {
            ArrayList ret = Lists.newArrayList();
            for (HRegionInfo hri : regions) {
                if (!hri.isMetaTable() && (this.hbck.checkMetaOnly || !this.hbck.isTableIncluded(hri.getTable()))) continue;
                ret.add(hri);
            }
            return ret;
        }
    }

    static class PrintingErrorReporter
    implements ErrorReporter {
        public int errorCount = 0;
        private int showProgress;
        Set<TableInfo> errorTables = new HashSet<TableInfo>();
        private ArrayList<ErrorReporter.ERROR_CODE> errorList = new ArrayList();

        PrintingErrorReporter() {
        }

        @Override
        public void clear() {
            this.errorTables.clear();
            this.errorList.clear();
            this.errorCount = 0;
        }

        @Override
        public synchronized void reportError(ErrorReporter.ERROR_CODE errorCode, String message) {
            if (errorCode == ErrorReporter.ERROR_CODE.WRONG_USAGE) {
                System.err.println(message);
                return;
            }
            this.errorList.add(errorCode);
            if (!summary) {
                System.out.println("ERROR: " + message);
            }
            ++this.errorCount;
            this.showProgress = 0;
        }

        @Override
        public synchronized void reportError(ErrorReporter.ERROR_CODE errorCode, String message, TableInfo table) {
            this.errorTables.add(table);
            this.reportError(errorCode, message);
        }

        @Override
        public synchronized void reportError(ErrorReporter.ERROR_CODE errorCode, String message, TableInfo table, HbckInfo info) {
            this.errorTables.add(table);
            String reference = "(region " + info.getRegionNameAsString() + ")";
            this.reportError(errorCode, reference + " " + message);
        }

        @Override
        public synchronized void reportError(ErrorReporter.ERROR_CODE errorCode, String message, TableInfo table, HbckInfo info1, HbckInfo info2) {
            this.errorTables.add(table);
            String reference = "(regions " + info1.getRegionNameAsString() + " and " + info2.getRegionNameAsString() + ")";
            this.reportError(errorCode, reference + " " + message);
        }

        @Override
        public synchronized void reportError(String message) {
            this.reportError(ErrorReporter.ERROR_CODE.UNKNOWN, message);
        }

        @Override
        public synchronized void report(String message) {
            if (!summary) {
                System.out.println("ERROR: " + message);
            }
            this.showProgress = 0;
        }

        @Override
        public synchronized int summarize() {
            System.out.println(Integer.toString(this.errorCount) + " inconsistencies detected.");
            if (this.errorCount == 0) {
                System.out.println("Status: OK");
                return 0;
            }
            System.out.println("Status: INCONSISTENT");
            return -1;
        }

        @Override
        public ArrayList<ErrorReporter.ERROR_CODE> getErrorList() {
            return this.errorList;
        }

        @Override
        public synchronized void print(String message) {
            if (!summary) {
                System.out.println(message);
            }
        }

        @Override
        public boolean tableHasErrors(TableInfo table) {
            return this.errorTables.contains(table);
        }

        @Override
        public void resetErrors() {
            this.errorCount = 0;
        }

        @Override
        public synchronized void detail(String message) {
            if (details) {
                System.out.println(message);
            }
            this.showProgress = 0;
        }

        @Override
        public synchronized void progress() {
            if (this.showProgress++ == 10) {
                if (!summary) {
                    System.out.print(".");
                }
                this.showProgress = 0;
            }
        }
    }

    public static interface ErrorReporter {
        public void clear();

        public void report(String var1);

        public void reportError(String var1);

        public void reportError(ERROR_CODE var1, String var2);

        public void reportError(ERROR_CODE var1, String var2, TableInfo var3);

        public void reportError(ERROR_CODE var1, String var2, TableInfo var3, HbckInfo var4);

        public void reportError(ERROR_CODE var1, String var2, TableInfo var3, HbckInfo var4, HbckInfo var5);

        public int summarize();

        public void detail(String var1);

        public ArrayList<ERROR_CODE> getErrorList();

        public void progress();

        public void print(String var1);

        public void resetErrors();

        public boolean tableHasErrors(TableInfo var1);

        public static enum ERROR_CODE {
            UNKNOWN,
            NO_META_REGION,
            NULL_META_REGION,
            NO_VERSION_FILE,
            NOT_IN_META_HDFS,
            NOT_IN_META,
            NOT_IN_META_OR_DEPLOYED,
            NOT_IN_HDFS_OR_DEPLOYED,
            NOT_IN_HDFS,
            SERVER_DOES_NOT_MATCH_META,
            NOT_DEPLOYED,
            MULTI_DEPLOYED,
            SHOULD_NOT_BE_DEPLOYED,
            MULTI_META_REGION,
            RS_CONNECT_FAILURE,
            FIRST_REGION_STARTKEY_NOT_EMPTY,
            LAST_REGION_ENDKEY_NOT_EMPTY,
            DUPE_STARTKEYS,
            HOLE_IN_REGION_CHAIN,
            OVERLAP_IN_REGION_CHAIN,
            REGION_CYCLE,
            DEGENERATE_REGION,
            ORPHAN_HDFS_REGION,
            LINGERING_SPLIT_PARENT,
            NO_TABLEINFO_FILE,
            LINGERING_REFERENCE_HFILE,
            WRONG_USAGE,
            EMPTY_META_CELL,
            EXPIRED_TABLE_LOCK,
            BOUNDARIES_ERROR;

        }
    }

    public static class HbckInfo
    implements KeyRange {
        private MetaEntry metaEntry = null;
        private HdfsEntry hdfsEntry = null;
        private List<OnlineEntry> deployedEntries = Lists.newArrayList();
        private List<ServerName> deployedOn = Lists.newArrayList();
        private boolean skipChecks = false;
        private boolean isMerged = false;

        HbckInfo(MetaEntry metaEntry) {
            this.metaEntry = metaEntry;
        }

        public synchronized void addServer(HRegionInfo hri, ServerName server) {
            OnlineEntry rse = new OnlineEntry();
            rse.hri = hri;
            rse.hsa = server;
            this.deployedEntries.add(rse);
            this.deployedOn.add(server);
        }

        public synchronized String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ meta => ");
            sb.append(this.metaEntry != null ? this.metaEntry.getRegionNameAsString() : "null");
            sb.append(", hdfs => " + this.getHdfsRegionDir());
            sb.append(", deployed => " + Joiner.on((String)", ").join(this.deployedEntries));
            sb.append(" }");
            return sb.toString();
        }

        @Override
        public byte[] getStartKey() {
            if (this.metaEntry != null) {
                return this.metaEntry.getStartKey();
            }
            if (this.hdfsEntry != null) {
                return this.hdfsEntry.hri.getStartKey();
            }
            LOG.error((Object)("Entry " + this + " has no meta or hdfs region start key."));
            return null;
        }

        @Override
        public byte[] getEndKey() {
            if (this.metaEntry != null) {
                return this.metaEntry.getEndKey();
            }
            if (this.hdfsEntry != null) {
                return this.hdfsEntry.hri.getEndKey();
            }
            LOG.error((Object)("Entry " + this + " has no meta or hdfs region start key."));
            return null;
        }

        public TableName getTableName() {
            if (this.metaEntry != null) {
                return this.metaEntry.getTable();
            }
            if (this.hdfsEntry != null) {
                Path tableDir = this.hdfsEntry.hdfsRegionDir.getParent();
                return FSUtils.getTableName(tableDir);
            }
            return null;
        }

        public String getRegionNameAsString() {
            if (this.metaEntry != null) {
                return this.metaEntry.getRegionNameAsString();
            }
            if (this.hdfsEntry != null && this.hdfsEntry.hri != null) {
                return this.hdfsEntry.hri.getRegionNameAsString();
            }
            return null;
        }

        public byte[] getRegionName() {
            if (this.metaEntry != null) {
                return this.metaEntry.getRegionName();
            }
            if (this.hdfsEntry != null) {
                return this.hdfsEntry.hri.getRegionName();
            }
            return null;
        }

        Path getHdfsRegionDir() {
            if (this.hdfsEntry == null) {
                return null;
            }
            return this.hdfsEntry.hdfsRegionDir;
        }

        boolean containsOnlyHdfsEdits() {
            if (this.hdfsEntry == null) {
                return false;
            }
            return this.hdfsEntry.hdfsOnlyEdits;
        }

        boolean isHdfsRegioninfoPresent() {
            if (this.hdfsEntry == null) {
                return false;
            }
            return this.hdfsEntry.hdfsRegioninfoFilePresent;
        }

        long getModTime() {
            if (this.hdfsEntry == null) {
                return 0L;
            }
            return this.hdfsEntry.hdfsRegionDirModTime;
        }

        HRegionInfo getHdfsHRI() {
            if (this.hdfsEntry == null) {
                return null;
            }
            return this.hdfsEntry.hri;
        }

        public void setSkipChecks(boolean skipChecks) {
            this.skipChecks = skipChecks;
        }

        public boolean isSkipChecks() {
            return this.skipChecks;
        }

        public void setMerged(boolean isMerged) {
            this.isMerged = isMerged;
        }

        public boolean isMerged() {
            return this.isMerged;
        }
    }

    static class OnlineEntry {
        HRegionInfo hri;
        ServerName hsa;

        OnlineEntry() {
        }

        public String toString() {
            return this.hsa.toString() + ";" + this.hri.getRegionNameAsString();
        }
    }

    static class HdfsEntry {
        HRegionInfo hri;
        Path hdfsRegionDir = null;
        long hdfsRegionDirModTime = 0L;
        boolean hdfsRegioninfoFilePresent = false;
        boolean hdfsOnlyEdits = false;

        HdfsEntry() {
        }
    }

    static class MetaEntry
    extends HRegionInfo {
        ServerName regionServer;
        long modTime;
        HRegionInfo splitA;
        HRegionInfo splitB;

        public MetaEntry(HRegionInfo rinfo, ServerName regionServer, long modTime) {
            this(rinfo, regionServer, modTime, null, null);
        }

        public MetaEntry(HRegionInfo rinfo, ServerName regionServer, long modTime, HRegionInfo splitA, HRegionInfo splitB) {
            super(rinfo);
            this.regionServer = regionServer;
            this.modTime = modTime;
            this.splitA = splitA;
            this.splitB = splitB;
        }

        public boolean equals(Object o) {
            boolean superEq = super.equals(o);
            if (!superEq) {
                return superEq;
            }
            MetaEntry me = (MetaEntry)((Object)o);
            if (!this.regionServer.equals((Object)me.regionServer)) {
                return false;
            }
            return this.modTime == me.modTime;
        }

        public int hashCode() {
            int hash = Arrays.hashCode(this.getRegionName());
            hash = (int)((long)hash ^ this.getRegionId());
            hash ^= Arrays.hashCode(this.getStartKey());
            hash ^= Arrays.hashCode(this.getEndKey());
            hash ^= Boolean.valueOf(this.isOffline()).hashCode();
            hash ^= this.getTable().hashCode();
            if (this.regionServer != null) {
                hash ^= this.regionServer.hashCode();
            }
            hash = (int)((long)hash ^ this.modTime);
            return hash;
        }
    }

    public class TableInfo {
        TableName tableName;
        TreeSet<ServerName> deployedOn;
        final List<HbckInfo> backwards = new ArrayList<HbckInfo>();
        final Map<Path, HbckInfo> sidelinedRegions = new HashMap<Path, HbckInfo>();
        final RegionSplitCalculator<HbckInfo> sc = new RegionSplitCalculator<HbckInfo>(cmp);
        final Set<HTableDescriptor> htds = new HashSet<HTableDescriptor>();
        final Multimap<byte[], HbckInfo> overlapGroups = TreeMultimap.create(RegionSplitCalculator.BYTES_COMPARATOR, cmp);

        TableInfo(TableName name) {
            this.tableName = name;
            this.deployedOn = new TreeSet();
        }

        private HTableDescriptor getHTD() {
            if (this.htds.size() == 1) {
                return (HTableDescriptor)this.htds.toArray()[0];
            }
            LOG.error((Object)("None/Multiple table descriptors found for table '" + this.tableName + "' regions: " + this.htds));
            return null;
        }

        public void addRegionInfo(HbckInfo hir) {
            if (Bytes.equals((byte[])hir.getEndKey(), (byte[])HConstants.EMPTY_END_ROW)) {
                this.sc.add(hir);
                return;
            }
            if (Bytes.compareTo((byte[])hir.getStartKey(), (byte[])hir.getEndKey()) > 0) {
                HBaseFsck.this.errors.reportError(ErrorReporter.ERROR_CODE.REGION_CYCLE, String.format("The endkey for this region comes before the startkey, startkey=%s, endkey=%s", Bytes.toStringBinary((byte[])hir.getStartKey()), Bytes.toStringBinary((byte[])hir.getEndKey())), this, hir);
                this.backwards.add(hir);
                return;
            }
            this.sc.add(hir);
        }

        public void addServer(ServerName server) {
            this.deployedOn.add(server);
        }

        public TableName getName() {
            return this.tableName;
        }

        public int getNumRegions() {
            return this.sc.getStarts().size() + this.backwards.size();
        }

        public boolean checkRegionChain(TableIntegrityErrorHandler handler) throws IOException {
            if (HBaseFsck.this.disabledTables.contains(this.tableName)) {
                return true;
            }
            int originalErrorsCount = HBaseFsck.this.errors.getErrorList().size();
            Multimap<byte[], HbckInfo> regions = this.sc.calcCoverage();
            TreeSet<byte[]> splits = this.sc.getSplits();
            byte[] prevKey = null;
            byte[] problemKey = null;
            if (splits.size() == 0) {
                handler.handleHoleInRegionChain(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            }
            for (byte[] key : splits) {
                Collection ranges = regions.get((Object)key);
                if (prevKey == null && !Bytes.equals((byte[])key, (byte[])HConstants.EMPTY_BYTE_ARRAY)) {
                    for (HbckInfo rng : ranges) {
                        handler.handleRegionStartKeyNotEmpty(rng);
                    }
                }
                for (HbckInfo rng : ranges) {
                    byte[] endKey = rng.getEndKey();
                    byte[] byArray = endKey = endKey.length == 0 ? null : endKey;
                    if (!Bytes.equals((byte[])rng.getStartKey(), (byte[])endKey)) continue;
                    handler.handleDegenerateRegion(rng);
                }
                if (ranges.size() == 1) {
                    if (problemKey != null) {
                        LOG.warn((Object)("reached end of problem group: " + Bytes.toStringBinary((byte[])key)));
                    }
                    problemKey = null;
                } else if (ranges.size() > 1) {
                    if (problemKey == null) {
                        LOG.warn((Object)("Naming new problem group: " + Bytes.toStringBinary((byte[])key)));
                        problemKey = key;
                    }
                    this.overlapGroups.putAll(problemKey, (Iterable)ranges);
                    ArrayList subRange = new ArrayList(ranges);
                    for (HbckInfo r1 : ranges) {
                        subRange.remove(r1);
                        for (HbckInfo r2 : subRange) {
                            if (Bytes.compareTo((byte[])r1.getStartKey(), (byte[])r2.getStartKey()) == 0) {
                                handler.handleDuplicateStartKeys(r1, r2);
                                continue;
                            }
                            handler.handleOverlapInRegionChain(r1, r2);
                        }
                    }
                } else if (ranges.size() == 0) {
                    if (problemKey != null) {
                        LOG.warn((Object)("reached end of problem group: " + Bytes.toStringBinary((byte[])key)));
                    }
                    problemKey = null;
                    byte[] holeStopKey = this.sc.getSplits().higher(key);
                    if (holeStopKey != null) {
                        handler.handleHoleInRegionChain(key, holeStopKey);
                    }
                }
                prevKey = key;
            }
            if (prevKey != null) {
                handler.handleRegionEndKeyNotEmpty(prevKey);
            }
            if (HBaseFsck.this.getConf().getBoolean("hbasefsck.overlap.merge.parallel", true)) {
                LOG.info((Object)"Handling overlap merges in parallel. set hbasefsck.overlap.merge.parallel to false to run serially.");
                boolean ok = this.handleOverlapsParallel(handler, prevKey);
                if (!ok) {
                    return false;
                }
            } else {
                LOG.info((Object)"Handling overlap merges serially.  set hbasefsck.overlap.merge.parallel to true to run in parallel.");
                for (Collection overlap : this.overlapGroups.asMap().values()) {
                    handler.handleOverlapGroup(overlap);
                }
            }
            if (details) {
                HBaseFsck.this.errors.print("---- Table '" + this.tableName + "': region split map");
                this.dump(splits, regions);
                HBaseFsck.this.errors.print("---- Table '" + this.tableName + "': overlap groups");
                HBaseFsck.this.dumpOverlapProblems(this.overlapGroups);
                HBaseFsck.this.errors.print("There are " + this.overlapGroups.keySet().size() + " overlap groups with " + this.overlapGroups.size() + " overlapping regions");
            }
            if (!this.sidelinedRegions.isEmpty()) {
                LOG.warn((Object)"Sidelined big overlapped regions, please bulk load them!");
                HBaseFsck.this.errors.print("---- Table '" + this.tableName + "': sidelined big overlapped regions");
                HBaseFsck.this.dumpSidelinedRegions(this.sidelinedRegions);
            }
            return HBaseFsck.this.errors.getErrorList().size() == originalErrorsCount;
        }

        private boolean handleOverlapsParallel(TableIntegrityErrorHandler handler, byte[] prevKey) throws IOException {
            List rets;
            ArrayList<WorkItemOverlapMerge> merges = new ArrayList<WorkItemOverlapMerge>(this.overlapGroups.size());
            for (Collection overlap : this.overlapGroups.asMap().values()) {
                merges.add(new WorkItemOverlapMerge(overlap, handler));
            }
            try {
                rets = HBaseFsck.this.executor.invokeAll(merges);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                LOG.error((Object)"Overlap merges were interrupted", (Throwable)e);
                return false;
            }
            for (int i = 0; i < merges.size(); ++i) {
                WorkItemOverlapMerge work = (WorkItemOverlapMerge)merges.get(i);
                Future f = rets.get(i);
                try {
                    f.get();
                    continue;
                }
                catch (ExecutionException e) {
                    LOG.warn((Object)("Failed to merge overlap group" + work), e.getCause());
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.error((Object)"Waiting for overlap merges was interrupted", (Throwable)e);
                    return false;
                }
            }
            return true;
        }

        void dump(SortedSet<byte[]> splits, Multimap<byte[], HbckInfo> regions) {
            StringBuilder sb = new StringBuilder();
            for (byte[] k : splits) {
                sb.setLength(0);
                sb.append(Bytes.toStringBinary((byte[])k) + ":\t");
                for (HbckInfo r : regions.get((Object)k)) {
                    sb.append("[ " + r.toString() + ", " + Bytes.toStringBinary((byte[])r.getEndKey()) + "]\t");
                }
                HBaseFsck.this.errors.print(sb.toString());
            }
        }

        private class HDFSIntegrityFixer
        extends IntegrityFixSuggester {
            Configuration conf;
            boolean fixOverlaps;

            HDFSIntegrityFixer(TableInfo ti, ErrorReporter errors, Configuration conf, boolean fixHoles, boolean fixOverlaps) {
                super(ti, errors);
                this.fixOverlaps = true;
                this.conf = conf;
                this.fixOverlaps = fixOverlaps;
            }

            @Override
            public void handleRegionStartKeyNotEmpty(HbckInfo next) throws IOException {
                this.errors.reportError(ErrorReporter.ERROR_CODE.FIRST_REGION_STARTKEY_NOT_EMPTY, "First region should start with an empty key.  Creating a new region and regioninfo in HDFS to plug the hole.", this.getTableInfo(), next);
                HTableDescriptor htd = this.getTableInfo().getHTD();
                HRegionInfo newRegion = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, next.getStartKey());
                HRegion region = HBaseFsckRepair.createHDFSRegionDir(this.conf, newRegion, htd);
                LOG.info((Object)("Table region start key was not empty.  Created new empty region: " + newRegion + " " + region));
                ++HBaseFsck.this.fixes;
            }

            @Override
            public void handleRegionEndKeyNotEmpty(byte[] curEndKey) throws IOException {
                this.errors.reportError(ErrorReporter.ERROR_CODE.LAST_REGION_ENDKEY_NOT_EMPTY, "Last region should end with an empty key.  Creating a new region and regioninfo in HDFS to plug the hole.", this.getTableInfo());
                HTableDescriptor htd = this.getTableInfo().getHTD();
                HRegionInfo newRegion = new HRegionInfo(htd.getTableName(), curEndKey, HConstants.EMPTY_START_ROW);
                HRegion region = HBaseFsckRepair.createHDFSRegionDir(this.conf, newRegion, htd);
                LOG.info((Object)("Table region end key was not empty.  Created new empty region: " + newRegion + " " + region));
                ++HBaseFsck.this.fixes;
            }

            @Override
            public void handleHoleInRegionChain(byte[] holeStartKey, byte[] holeStopKey) throws IOException {
                this.errors.reportError(ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN, "There is a hole in the region chain between " + Bytes.toStringBinary((byte[])holeStartKey) + " and " + Bytes.toStringBinary((byte[])holeStopKey) + ".  Creating a new regioninfo and region " + "dir in hdfs to plug the hole.");
                HTableDescriptor htd = this.getTableInfo().getHTD();
                HRegionInfo newRegion = new HRegionInfo(htd.getTableName(), holeStartKey, holeStopKey);
                HRegion region = HBaseFsckRepair.createHDFSRegionDir(this.conf, newRegion, htd);
                LOG.info((Object)("Plugged hold by creating new empty region: " + newRegion + " " + region));
                ++HBaseFsck.this.fixes;
            }

            @Override
            public void handleOverlapGroup(Collection<HbckInfo> overlap) throws IOException {
                Preconditions.checkNotNull(overlap);
                Preconditions.checkArgument((overlap.size() > 0 ? 1 : 0) != 0);
                if (!this.fixOverlaps) {
                    LOG.warn((Object)"Not attempting to repair overlaps.");
                    return;
                }
                if (overlap.size() > HBaseFsck.this.maxMerge) {
                    LOG.warn((Object)("Overlap group has " + overlap.size() + " overlapping " + "regions which is greater than " + HBaseFsck.this.maxMerge + ", the max number of regions to merge"));
                    if (HBaseFsck.this.sidelineBigOverlaps) {
                        this.sidelineBigOverlaps(overlap);
                    }
                    return;
                }
                this.mergeOverlaps(overlap);
            }

            void mergeOverlaps(Collection<HbckInfo> overlap) throws IOException {
                String thread = Thread.currentThread().getName();
                LOG.info((Object)("== [" + thread + "] Merging regions into one region: " + Joiner.on((String)",").join(overlap)));
                Pair range = null;
                for (HbckInfo hi : overlap) {
                    if (range == null) {
                        range = new Pair((Object)hi.getStartKey(), (Object)hi.getEndKey());
                    } else {
                        if (RegionSplitCalculator.BYTES_COMPARATOR.compare(hi.getStartKey(), (byte[])range.getFirst()) < 0) {
                            range.setFirst((Object)hi.getStartKey());
                        }
                        if (RegionSplitCalculator.BYTES_COMPARATOR.compare(hi.getEndKey(), (byte[])range.getSecond()) > 0) {
                            range.setSecond((Object)hi.getEndKey());
                        }
                    }
                    LOG.debug((Object)("[" + thread + "] Closing region before moving data around: " + hi));
                    LOG.debug((Object)("[" + thread + "] Contained region dir before close"));
                    HBaseFsck.this.debugLsr(hi.getHdfsRegionDir());
                    try {
                        LOG.info((Object)("[" + thread + "] Closing region: " + hi));
                        HBaseFsck.this.closeRegion(hi);
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("[" + thread + "] Was unable to close region " + hi + ".  Just continuing... "), (Throwable)ioe);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)("[" + thread + "] Was unable to close region " + hi + ".  Just continuing... "), (Throwable)e);
                    }
                    try {
                        LOG.info((Object)("[" + thread + "] Offlining region: " + hi));
                        HBaseFsck.this.offline(hi.getRegionName());
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("[" + thread + "] Unable to offline region from master: " + hi + ".  Just continuing... "), (Throwable)ioe);
                    }
                }
                HTableDescriptor htd = this.getTableInfo().getHTD();
                HRegionInfo newRegion = new HRegionInfo(htd.getTableName(), (byte[])range.getFirst(), (byte[])range.getSecond());
                HRegion region = HBaseFsckRepair.createHDFSRegionDir(this.conf, newRegion, htd);
                LOG.info((Object)("[" + thread + "] Created new empty container region: " + newRegion + " to contain regions: " + Joiner.on((String)",").join(overlap)));
                HBaseFsck.this.debugLsr(region.getRegionFileSystem().getRegionDir());
                boolean didFix = false;
                Path target = region.getRegionFileSystem().getRegionDir();
                for (HbckInfo contained : overlap) {
                    LOG.info((Object)("[" + thread + "] Merging " + contained + " into " + target));
                    int merges = HBaseFsck.this.mergeRegionDirs(target, contained);
                    if (merges <= 0) continue;
                    didFix = true;
                }
                if (didFix) {
                    ++HBaseFsck.this.fixes;
                }
            }

            void sidelineBigOverlaps(Collection<HbckInfo> bigOverlap) throws IOException {
                int overlapsToSideline = bigOverlap.size() - HBaseFsck.this.maxMerge;
                if (overlapsToSideline > HBaseFsck.this.maxOverlapsToSideline) {
                    overlapsToSideline = HBaseFsck.this.maxOverlapsToSideline;
                }
                List<HbckInfo> regionsToSideline = RegionSplitCalculator.findBigRanges(bigOverlap, overlapsToSideline);
                FileSystem fs = FileSystem.get((Configuration)this.conf);
                for (HbckInfo regionToSideline : regionsToSideline) {
                    try {
                        LOG.info((Object)("Closing region: " + regionToSideline));
                        HBaseFsck.this.closeRegion(regionToSideline);
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("Was unable to close region " + regionToSideline + ".  Just continuing... "), (Throwable)ioe);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)("Was unable to close region " + regionToSideline + ".  Just continuing... "), (Throwable)e);
                    }
                    try {
                        LOG.info((Object)("Offlining region: " + regionToSideline));
                        HBaseFsck.this.offline(regionToSideline.getRegionName());
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("Unable to offline region from master: " + regionToSideline + ".  Just continuing... "), (Throwable)ioe);
                    }
                    LOG.info((Object)("Before sideline big overlapped region: " + regionToSideline.toString()));
                    Path sidelineRegionDir = HBaseFsck.this.sidelineRegionDir(fs, HBaseFsck.TO_BE_LOADED, regionToSideline);
                    if (sidelineRegionDir == null) continue;
                    TableInfo.this.sidelinedRegions.put(sidelineRegionDir, regionToSideline);
                    LOG.info((Object)("After sidelined big overlapped region: " + regionToSideline.getRegionNameAsString() + " to " + sidelineRegionDir.toString()));
                    ++HBaseFsck.this.fixes;
                }
            }
        }

        private class IntegrityFixSuggester
        extends TableIntegrityErrorHandlerImpl {
            ErrorReporter errors;

            IntegrityFixSuggester(TableInfo ti, ErrorReporter errors) {
                this.errors = errors;
                this.setTableInfo(ti);
            }

            @Override
            public void handleRegionStartKeyNotEmpty(HbckInfo hi) throws IOException {
                this.errors.reportError(ErrorReporter.ERROR_CODE.FIRST_REGION_STARTKEY_NOT_EMPTY, "First region should start with an empty key.  You need to  create a new region and regioninfo in HDFS to plug the hole.", this.getTableInfo(), hi);
            }

            @Override
            public void handleRegionEndKeyNotEmpty(byte[] curEndKey) throws IOException {
                this.errors.reportError(ErrorReporter.ERROR_CODE.LAST_REGION_ENDKEY_NOT_EMPTY, "Last region should end with an empty key. You need to create a new region and regioninfo in HDFS to plug the hole.", this.getTableInfo());
            }

            @Override
            public void handleDegenerateRegion(HbckInfo hi) throws IOException {
                this.errors.reportError(ErrorReporter.ERROR_CODE.DEGENERATE_REGION, "Region has the same start and end key.", this.getTableInfo(), hi);
            }

            @Override
            public void handleDuplicateStartKeys(HbckInfo r1, HbckInfo r2) throws IOException {
                byte[] key = r1.getStartKey();
                this.errors.reportError(ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, "Multiple regions have the same startkey: " + Bytes.toStringBinary((byte[])key), this.getTableInfo(), r1);
                this.errors.reportError(ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, "Multiple regions have the same startkey: " + Bytes.toStringBinary((byte[])key), this.getTableInfo(), r2);
            }

            @Override
            public void handleOverlapInRegionChain(HbckInfo hi1, HbckInfo hi2) throws IOException {
                this.errors.reportError(ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN, "There is an overlap in the region chain.", this.getTableInfo(), hi1, hi2);
            }

            @Override
            public void handleHoleInRegionChain(byte[] holeStart, byte[] holeStop) throws IOException {
                this.errors.reportError(ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN, "There is a hole in the region chain between " + Bytes.toStringBinary((byte[])holeStart) + " and " + Bytes.toStringBinary((byte[])holeStop) + ".  You need to create a new .regioninfo and region " + "dir in hdfs to plug the hole.");
            }
        }
    }

    static class WorkItemOverlapMerge
    implements Callable<Void> {
        private TableIntegrityErrorHandler handler;
        Collection<HbckInfo> overlapgroup;

        WorkItemOverlapMerge(Collection<HbckInfo> overlapgroup, TableIntegrityErrorHandler handler) {
            this.handler = handler;
            this.overlapgroup = overlapgroup;
        }

        @Override
        public Void call() throws Exception {
            this.handler.handleOverlapGroup(this.overlapgroup);
            return null;
        }
    }

    public static class RegionRepairException
    extends IOException {
        private static final long serialVersionUID = 1L;
        final IOException ioe;

        public RegionRepairException(String s, IOException ioe) {
            super(s);
            this.ioe = ioe;
        }
    }

    private static class RegionBoundariesInformation {
        public byte[] regionName;
        public byte[] metaFirstKey;
        public byte[] metaLastKey;
        public byte[] storesFirstKey;
        public byte[] storesLastKey;

        private RegionBoundariesInformation() {
        }

        public String toString() {
            return "regionName=" + Bytes.toStringBinary((byte[])this.regionName) + "\nmetaFirstKey=" + Bytes.toStringBinary((byte[])this.metaFirstKey) + "\nmetaLastKey=" + Bytes.toStringBinary((byte[])this.metaLastKey) + "\nstoresFirstKey=" + Bytes.toStringBinary((byte[])this.storesFirstKey) + "\nstoresLastKey=" + Bytes.toStringBinary((byte[])this.storesLastKey);
        }
    }
}

