/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceAudience.Public
public class HLogInputFormat
extends InputFormat<HLogKey, WALEdit> {
    private static final Log LOG = LogFactory.getLog(HLogInputFormat.class);
    public static final String START_TIME_KEY = "hlog.start.time";
    public static final String END_TIME_KEY = "hlog.end.time";

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        Path inputDir = new Path(conf.get("mapred.input.dir"));
        long startTime = conf.getLong(START_TIME_KEY, Long.MIN_VALUE);
        long endTime = conf.getLong(END_TIME_KEY, Long.MAX_VALUE);
        FileSystem fs = inputDir.getFileSystem(conf);
        List<FileStatus> files = this.getFiles(fs, inputDir, startTime, endTime);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(files.size());
        for (FileStatus file : files) {
            splits.add(new HLogSplit(file.getPath().toString(), file.getLen(), startTime, endTime));
        }
        return splits;
    }

    private List<FileStatus> getFiles(FileSystem fs, Path dir, long startTime, long endTime) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        LOG.debug((Object)("Scanning " + dir.toString() + " for HLog files"));
        FileStatus[] files = fs.listStatus(dir);
        if (files == null) {
            return Collections.emptyList();
        }
        for (FileStatus file : files) {
            if (file.isDir()) {
                result.addAll(this.getFiles(fs, file.getPath(), startTime, endTime));
                continue;
            }
            String name = file.getPath().toString();
            int idx = name.lastIndexOf(46);
            if (idx > 0) {
                try {
                    long fileStartTime = Long.parseLong(name.substring(idx + 1));
                    if (fileStartTime <= endTime) {
                        LOG.info((Object)("Found: " + name));
                        result.add(file);
                    }
                }
                catch (NumberFormatException x) {
                    idx = 0;
                }
            }
            if (idx != 0) continue;
            LOG.warn((Object)("File " + name + " does not appear to be an HLog file. Skipping..."));
        }
        return result;
    }

    public RecordReader<HLogKey, WALEdit> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new HLogRecordReader();
    }

    static class HLogRecordReader
    extends RecordReader<HLogKey, WALEdit> {
        private HLog.Reader reader = null;
        private HLog.Entry currentEntry = new HLog.Entry();
        private long startTime;
        private long endTime;

        HLogRecordReader() {
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            HLogSplit hsplit = (HLogSplit)split;
            Path logFile = new Path(hsplit.getLogFileName());
            Configuration conf = context.getConfiguration();
            LOG.info((Object)("Opening reader for " + split));
            try {
                this.reader = HLogFactory.createReader(logFile.getFileSystem(conf), logFile, conf);
            }
            catch (EOFException x) {
                LOG.info((Object)("Ignoring corrupted HLog file: " + logFile + " (This is normal when a RegionServer crashed.)"));
            }
            this.startTime = hsplit.getStartTime();
            this.endTime = hsplit.getEndTime();
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            boolean res;
            HLog.Entry temp;
            if (this.reader == null) {
                return false;
            }
            long i = -1L;
            do {
                try {
                    temp = this.reader.next(this.currentEntry);
                    ++i;
                }
                catch (EOFException x) {
                    LOG.info((Object)"Corrupted entry detected. Ignoring the rest of the file. (This is normal when a RegionServer crashed.)");
                    return false;
                }
            } while (temp != null && temp.getKey().getWriteTime() < this.startTime);
            if (temp == null) {
                if (i > 0L) {
                    LOG.info((Object)("Skipped " + i + " entries."));
                }
                LOG.info((Object)"Reached end of file.");
                return false;
            }
            if (i > 0L) {
                LOG.info((Object)("Skipped " + i + " entries, until ts: " + temp.getKey().getWriteTime() + "."));
            }
            boolean bl = res = temp.getKey().getWriteTime() <= this.endTime;
            if (!res) {
                LOG.info((Object)("Reached ts: " + temp.getKey().getWriteTime() + " ignoring the rest of the file."));
            }
            return res;
        }

        public HLogKey getCurrentKey() throws IOException, InterruptedException {
            return this.currentEntry.getKey();
        }

        public WALEdit getCurrentValue() throws IOException, InterruptedException {
            return this.currentEntry.getEdit();
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public void close() throws IOException {
            LOG.info((Object)"Closing reader");
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    static class HLogSplit
    extends InputSplit
    implements Writable {
        private String logFileName;
        private long fileSize;
        private long startTime;
        private long endTime;

        public HLogSplit() {
        }

        public HLogSplit(String logFileName, long fileSize, long startTime, long endTime) {
            this.logFileName = logFileName;
            this.fileSize = fileSize;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public long getLength() throws IOException, InterruptedException {
            return this.fileSize;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return new String[0];
        }

        public String getLogFileName() {
            return this.logFileName;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void readFields(DataInput in) throws IOException {
            this.logFileName = in.readUTF();
            this.fileSize = in.readLong();
            this.startTime = in.readLong();
            this.endTime = in.readLong();
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.logFileName);
            out.writeLong(this.fileSize);
            out.writeLong(this.startTime);
            out.writeLong(this.endTime);
        }

        public String toString() {
            return this.logFileName + " (" + this.startTime + ":" + this.endTime + ") length:" + this.fileSize;
        }
    }
}

