/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class DeadServer {
    private static final Log LOG = LogFactory.getLog(DeadServer.class);
    private final Map<ServerName, Long> deadServers = new HashMap<ServerName, Long>();
    private int numProcessing = 0;
    private static Comparator<Pair<ServerName, Long>> ServerNameDeathDateComparator = new Comparator<Pair<ServerName, Long>>(){

        @Override
        public int compare(Pair<ServerName, Long> o1, Pair<ServerName, Long> o2) {
            return ((Long)o1.getSecond()).compareTo((Long)o2.getSecond());
        }
    };

    public synchronized boolean cleanPreviousInstance(ServerName newServerName) {
        Iterator<ServerName> it = this.deadServers.keySet().iterator();
        while (it.hasNext()) {
            ServerName sn = it.next();
            if (!ServerName.isSameHostnameAndPort((ServerName)sn, (ServerName)newServerName)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public synchronized boolean isDeadServer(ServerName serverName) {
        return this.deadServers.containsKey(serverName);
    }

    public synchronized boolean areDeadServersInProgress() {
        return this.numProcessing != 0;
    }

    public synchronized Set<ServerName> copyServerNames() {
        HashSet<ServerName> clone = new HashSet<ServerName>(this.deadServers.size());
        clone.addAll(this.deadServers.keySet());
        return clone;
    }

    public synchronized void add(ServerName sn) {
        ++this.numProcessing;
        if (!this.deadServers.containsKey(sn)) {
            this.deadServers.put(sn, EnvironmentEdgeManager.currentTimeMillis());
        }
    }

    public synchronized void finish(ServerName sn) {
        LOG.debug((Object)("Finished processing " + sn));
        --this.numProcessing;
    }

    public synchronized int size() {
        return this.deadServers.size();
    }

    public synchronized boolean isEmpty() {
        return this.deadServers.isEmpty();
    }

    public synchronized void cleanAllPreviousInstances(ServerName newServerName) {
        Iterator<ServerName> it = this.deadServers.keySet().iterator();
        while (it.hasNext()) {
            ServerName sn = it.next();
            if (!ServerName.isSameHostnameAndPort((ServerName)sn, (ServerName)newServerName)) continue;
            it.remove();
        }
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        for (ServerName sn : this.deadServers.keySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(sn.toString());
        }
        return sb.toString();
    }

    public synchronized List<Pair<ServerName, Long>> copyDeadServersSince(long ts) {
        ArrayList<Pair<ServerName, Long>> res = new ArrayList<Pair<ServerName, Long>>(this.size());
        for (Map.Entry<ServerName, Long> entry : this.deadServers.entrySet()) {
            if (entry.getValue() < ts) continue;
            res.add((Pair<ServerName, Long>)new Pair((Object)entry.getKey(), (Object)entry.getValue()));
        }
        Collections.sort(res, ServerNameDeathDateComparator);
        return res;
    }

    public synchronized Date getTimeOfDeath(ServerName deadServerName) {
        Long time = this.deadServers.get(deadServerName);
        return time == null ? null : new Date(time);
    }
}

