/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.util.StringUtils;

public class DefaultStoreFlusher
extends StoreFlusher {
    private static final Log LOG = LogFactory.getLog(DefaultStoreFlusher.class);
    private final Object flushLock = new Object();

    public DefaultStoreFlusher(Configuration conf, Store store) {
        super(conf, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Path> flushSnapshot(SortedSet<KeyValue> snapshot, long cacheFlushId, TimeRangeTracker snapshotTimeRangeTracker, AtomicLong flushedSize, MonitoredTask status) throws IOException {
        StoreFile.Writer writer;
        ArrayList<Path> result = new ArrayList<Path>();
        if (snapshot.size() == 0) {
            return result;
        }
        long smallestReadPoint = this.store.getSmallestReadPoint();
        InternalScanner scanner = this.createScanner(snapshot, smallestReadPoint);
        if (scanner == null) {
            return result;
        }
        long flushed = 0L;
        try {
            Object object = this.flushLock;
            synchronized (object) {
                status.setStatus("Flushing " + this.store + ": creating writer");
                writer = this.store.createWriterInTmp(snapshot.size(), this.store.getFamily().getCompression(), false, true, true);
                writer.setTimeRangeTracker(snapshotTimeRangeTracker);
                try {
                    flushed = this.performFlush(scanner, writer, smallestReadPoint);
                }
                finally {
                    this.finalizeWriter(writer, cacheFlushId, status);
                }
            }
        }
        finally {
            flushedSize.set(flushed);
            scanner.close();
        }
        LOG.info((Object)("Flushed, sequenceid=" + cacheFlushId + ", memsize=" + StringUtils.humanReadableInt((long)flushed) + ", hasBloomFilter=" + writer.hasGeneralBloom() + ", into tmp file " + writer.getPath()));
        result.add(writer.getPath());
        return result;
    }
}

