/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class CloseRegionHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(CloseRegionHandler.class);
    private final int FAILED = -1;
    int expectedVersion = -1;
    private final RegionServerServices rsServices;
    private final HRegionInfo regionInfo;
    private final boolean abort;
    private final boolean zk;
    private ServerName destination;

    public CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo) {
        this(server, rsServices, regionInfo, false, true, -1, EventType.M_RS_CLOSE_REGION, null);
    }

    public CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, boolean abort, boolean zk, int versionOfClosingNode) {
        this(server, rsServices, regionInfo, abort, zk, versionOfClosingNode, EventType.M_RS_CLOSE_REGION, null);
    }

    public CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, boolean abort, boolean zk, int versionOfClosingNode, ServerName destination) {
        this(server, rsServices, regionInfo, abort, zk, versionOfClosingNode, EventType.M_RS_CLOSE_REGION, destination);
    }

    public CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, boolean abort, boolean zk, int versionOfClosingNode, EventType eventType) {
        this(server, rsServices, regionInfo, abort, zk, versionOfClosingNode, eventType, null);
    }

    protected CloseRegionHandler(Server server, RegionServerServices rsServices, HRegionInfo regionInfo, boolean abort, boolean zk, int versionOfClosingNode, EventType eventType, ServerName destination) {
        super(server, eventType);
        this.server = server;
        this.rsServices = rsServices;
        this.regionInfo = regionInfo;
        this.abort = abort;
        this.zk = zk;
        this.expectedVersion = versionOfClosingNode;
        this.destination = destination;
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            String name = this.regionInfo.getRegionNameAsString();
            LOG.debug((Object)("Processing close of " + name));
            String encodedRegionName = this.regionInfo.getEncodedName();
            HRegion region = this.rsServices.getFromOnlineRegions(encodedRegionName);
            if (region == null) {
                LOG.warn((Object)("Received CLOSE for region " + name + " but currently not serving - ignoring"));
                if (this.zk) {
                    LOG.error((Object)("The znode is not modified as we are not serving " + name));
                }
                return;
            }
            if (this.zk && !ZKAssign.checkClosingState((ZooKeeperWatcher)this.server.getZooKeeper(), (HRegionInfo)this.regionInfo, (int)this.expectedVersion)) {
                return;
            }
            if (region.close(this.abort) == null) {
                LOG.warn((Object)("Can't close region: was already closed during close(): " + this.regionInfo.getRegionNameAsString()));
                return;
            }
            this.rsServices.removeFromOnlineRegions(region, this.destination);
            if (this.zk) {
                if (this.setClosedState(this.expectedVersion, region)) {
                    LOG.debug((Object)("Set closed state in zk for " + name + " on " + this.server.getServerName()));
                } else {
                    LOG.debug((Object)("Set closed state in zk UNSUCCESSFUL for " + name + " on " + this.server.getServerName()));
                }
            }
            LOG.debug((Object)("Closed " + region.getRegionNameAsString()));
        }
        finally {
            this.rsServices.getRegionsInTransitionInRS().remove(this.regionInfo.getEncodedNameAsBytes());
        }
    }

    private boolean setClosedState(int expectedVersion, HRegion region) {
        try {
            if (ZKAssign.transitionNodeClosed((ZooKeeperWatcher)this.server.getZooKeeper(), (HRegionInfo)this.regionInfo, (ServerName)this.server.getServerName(), (int)expectedVersion) == -1) {
                LOG.warn((Object)"Completed the CLOSE of a region but when transitioning from  CLOSING to CLOSED got a version mismatch, someone else clashed so now unassigning");
                region.close();
                return false;
            }
        }
        catch (NullPointerException e) {
            LOG.warn((Object)"NPE during close -- catching and continuing...", (Throwable)e);
            return false;
        }
        catch (KeeperException e) {
            LOG.error((Object)"Failed transitioning node from CLOSING to CLOSED", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to close region after failing to transition", (Throwable)e);
            return false;
        }
        return true;
    }
}

