/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.Serializable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Private
public class BlockCacheKey
implements HeapSize,
Serializable {
    private static final long serialVersionUID = -5199992013113130534L;
    private final String hfileName;
    private final long offset;
    private final DataBlockEncoding encoding;
    private final BlockType blockType;
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + ClassSize.REFERENCE + ClassSize.REFERENCE + ClassSize.REFERENCE + 8));

    public BlockCacheKey(String file, long offset, DataBlockEncoding encoding, BlockType blockType) {
        this.hfileName = file;
        this.offset = offset;
        this.encoding = encoding != null && (blockType == null || blockType.isData()) ? encoding : DataBlockEncoding.NONE;
        this.blockType = blockType;
    }

    public BlockCacheKey(String hfileName, long offset) {
        this(hfileName, offset, DataBlockEncoding.NONE, BlockType.DATA);
    }

    public int hashCode() {
        return this.hfileName.hashCode() * 127 + (int)(this.offset ^ this.offset >>> 32) + this.encoding.ordinal() * 17;
    }

    public boolean equals(Object o) {
        if (o instanceof BlockCacheKey) {
            BlockCacheKey k = (BlockCacheKey)o;
            return this.offset == k.offset && this.encoding == k.encoding && (this.hfileName == null ? k.hfileName == null : this.hfileName.equals(k.hfileName));
        }
        return false;
    }

    public String toString() {
        return this.hfileName + "_" + this.offset + (this.encoding == DataBlockEncoding.NONE ? "" : "_" + this.encoding);
    }

    public long heapSize() {
        return ClassSize.align((long)(FIXED_OVERHEAD + (long)(2 * this.hfileName.length())));
    }

    public String getHfileName() {
        return this.hfileName;
    }

    public DataBlockEncoding getDataBlockEncoding() {
        return this.encoding;
    }

    public long getOffset() {
        return this.offset;
    }

    public BlockType getBlockType() {
        return this.blockType;
    }
}

