/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.BlockType;

@InterfaceAudience.Private
public class CacheStats {
    static final int DEFAULT_WINDOW_PERIODS = 5;
    private final AtomicLong hitCount = new AtomicLong(0L);
    private final AtomicLong hitCachingCount = new AtomicLong(0L);
    private final AtomicLong missCount = new AtomicLong(0L);
    private final AtomicLong missCachingCount = new AtomicLong(0L);
    private final AtomicLong evictionCount = new AtomicLong(0L);
    private final AtomicLong evictedBlockCount = new AtomicLong(0L);
    private final AtomicLong failedInserts = new AtomicLong(0L);
    private final AtomicLong dataMissCount = new AtomicLong(0L);
    private final AtomicLong leafIndexMissCount = new AtomicLong(0L);
    private final AtomicLong bloomChunkMissCount = new AtomicLong(0L);
    private final AtomicLong metaMissCount = new AtomicLong(0L);
    private final AtomicLong rootIndexMissCount = new AtomicLong(0L);
    private final AtomicLong intermediateIndexMissCount = new AtomicLong(0L);
    private final AtomicLong fileInfoMissCount = new AtomicLong(0L);
    private final AtomicLong generalBloomMetaMissCount = new AtomicLong(0L);
    private final AtomicLong deleteFamilyBloomMissCount = new AtomicLong(0L);
    private final AtomicLong trailerMissCount = new AtomicLong(0L);
    private final AtomicLong dataHitCount = new AtomicLong(0L);
    private final AtomicLong leafIndexHitCount = new AtomicLong(0L);
    private final AtomicLong bloomChunkHitCount = new AtomicLong(0L);
    private final AtomicLong metaHitCount = new AtomicLong(0L);
    private final AtomicLong rootIndexHitCount = new AtomicLong(0L);
    private final AtomicLong intermediateIndexHitCount = new AtomicLong(0L);
    private final AtomicLong fileInfoHitCount = new AtomicLong(0L);
    private final AtomicLong generalBloomMetaHitCount = new AtomicLong(0L);
    private final AtomicLong deleteFamilyBloomHitCount = new AtomicLong(0L);
    private final AtomicLong trailerHitCount = new AtomicLong(0L);
    private final int numPeriodsInWindow;
    private final long[] hitCounts;
    private final long[] hitCachingCounts;
    private final long[] requestCounts;
    private final long[] requestCachingCounts;
    private long lastHitCount = 0L;
    private long lastHitCachingCount = 0L;
    private long lastRequestCount = 0L;
    private long lastRequestCachingCount = 0L;
    private int windowIndex = 0;

    public CacheStats() {
        this(5);
    }

    public CacheStats(int numPeriodsInWindow) {
        this.numPeriodsInWindow = numPeriodsInWindow;
        this.hitCounts = CacheStats.initializeZeros(numPeriodsInWindow);
        this.hitCachingCounts = CacheStats.initializeZeros(numPeriodsInWindow);
        this.requestCounts = CacheStats.initializeZeros(numPeriodsInWindow);
        this.requestCachingCounts = CacheStats.initializeZeros(numPeriodsInWindow);
    }

    public void miss(boolean caching) {
        this.missCount.incrementAndGet();
        if (caching) {
            this.missCachingCount.incrementAndGet();
        }
    }

    public String toString() {
        return "hitCount=" + this.getHitCount() + ", hitCachingCount=" + this.getHitCachingCount() + ", missCount=" + this.getMissCount() + ", missCachingCount=" + this.getMissCachingCount() + ", evictionCount=" + this.getEvictionCount() + ", evictedBlockCount=" + this.getEvictedCount();
    }

    public void miss(boolean caching, BlockType type) {
        this.missCount.incrementAndGet();
        if (caching) {
            this.missCachingCount.incrementAndGet();
        }
        if (type == null) {
            return;
        }
        switch (type) {
            case DATA: 
            case ENCODED_DATA: {
                this.dataMissCount.incrementAndGet();
                break;
            }
            case LEAF_INDEX: {
                this.leafIndexMissCount.incrementAndGet();
                break;
            }
            case BLOOM_CHUNK: {
                this.bloomChunkMissCount.incrementAndGet();
                break;
            }
            case META: {
                this.metaMissCount.incrementAndGet();
                break;
            }
            case INTERMEDIATE_INDEX: {
                this.intermediateIndexMissCount.incrementAndGet();
                break;
            }
            case ROOT_INDEX: {
                this.rootIndexMissCount.incrementAndGet();
                break;
            }
            case FILE_INFO: {
                this.fileInfoMissCount.incrementAndGet();
                break;
            }
            case GENERAL_BLOOM_META: {
                this.generalBloomMetaMissCount.incrementAndGet();
                break;
            }
            case DELETE_FAMILY_BLOOM_META: {
                this.deleteFamilyBloomMissCount.incrementAndGet();
                break;
            }
            case TRAILER: {
                this.trailerMissCount.incrementAndGet();
                break;
            }
        }
    }

    public void hit(boolean caching, BlockType type) {
        this.hitCount.incrementAndGet();
        if (caching) {
            this.hitCachingCount.incrementAndGet();
        }
        if (type == null) {
            return;
        }
        switch (type) {
            case DATA: 
            case ENCODED_DATA: {
                this.dataHitCount.incrementAndGet();
                break;
            }
            case LEAF_INDEX: {
                this.leafIndexHitCount.incrementAndGet();
                break;
            }
            case BLOOM_CHUNK: {
                this.bloomChunkHitCount.incrementAndGet();
                break;
            }
            case META: {
                this.metaHitCount.incrementAndGet();
                break;
            }
            case INTERMEDIATE_INDEX: {
                this.intermediateIndexHitCount.incrementAndGet();
                break;
            }
            case ROOT_INDEX: {
                this.rootIndexHitCount.incrementAndGet();
                break;
            }
            case FILE_INFO: {
                this.fileInfoHitCount.incrementAndGet();
                break;
            }
            case GENERAL_BLOOM_META: {
                this.generalBloomMetaHitCount.incrementAndGet();
                break;
            }
            case DELETE_FAMILY_BLOOM_META: {
                this.deleteFamilyBloomHitCount.incrementAndGet();
                break;
            }
            case TRAILER: {
                this.trailerHitCount.incrementAndGet();
                break;
            }
        }
    }

    public void evict() {
        this.evictionCount.incrementAndGet();
    }

    public void evicted() {
        this.evictedBlockCount.incrementAndGet();
    }

    public long failInsert() {
        return this.failedInserts.incrementAndGet();
    }

    public long getDataMissCount() {
        return this.dataMissCount.get();
    }

    public long getLeafIndexMissCount() {
        return this.leafIndexMissCount.get();
    }

    public long getBloomChunkMissCount() {
        return this.bloomChunkMissCount.get();
    }

    public long getMetaMissCount() {
        return this.metaMissCount.get();
    }

    public long getRootIndexMissCount() {
        return this.rootIndexMissCount.get();
    }

    public long getIntermediateIndexMissCount() {
        return this.intermediateIndexMissCount.get();
    }

    public long getFileInfoMissCount() {
        return this.fileInfoMissCount.get();
    }

    public long getGeneralBloomMetaMissCount() {
        return this.generalBloomMetaMissCount.get();
    }

    public long getDeleteFamilyBloomMissCount() {
        return this.deleteFamilyBloomMissCount.get();
    }

    public long getTrailerMissCount() {
        return this.trailerMissCount.get();
    }

    public long getDataHitCount() {
        return this.dataHitCount.get();
    }

    public long getLeafIndexHitCount() {
        return this.leafIndexHitCount.get();
    }

    public long getBloomChunkHitCount() {
        return this.bloomChunkHitCount.get();
    }

    public long getMetaHitCount() {
        return this.metaHitCount.get();
    }

    public long getRootIndexHitCount() {
        return this.rootIndexHitCount.get();
    }

    public long getIntermediateIndexHitCount() {
        return this.intermediateIndexHitCount.get();
    }

    public long getFileInfoHitCount() {
        return this.fileInfoHitCount.get();
    }

    public long getGeneralBloomMetaHitCount() {
        return this.generalBloomMetaHitCount.get();
    }

    public long getDeleteFamilyBloomHitCount() {
        return this.deleteFamilyBloomHitCount.get();
    }

    public long getTrailerHitCount() {
        return this.trailerHitCount.get();
    }

    public long getRequestCount() {
        return this.getHitCount() + this.getMissCount();
    }

    public long getRequestCachingCount() {
        return this.getHitCachingCount() + this.getMissCachingCount();
    }

    public long getMissCount() {
        return this.missCount.get();
    }

    public long getMissCachingCount() {
        return this.missCachingCount.get();
    }

    public long getHitCount() {
        return this.hitCount.get();
    }

    public long getHitCachingCount() {
        return this.hitCachingCount.get();
    }

    public long getEvictionCount() {
        return this.evictionCount.get();
    }

    public long getEvictedCount() {
        return this.evictedBlockCount.get();
    }

    public double getHitRatio() {
        return (float)this.getHitCount() / (float)this.getRequestCount();
    }

    public double getHitCachingRatio() {
        return (float)this.getHitCachingCount() / (float)this.getRequestCachingCount();
    }

    public double getMissRatio() {
        return (float)this.getMissCount() / (float)this.getRequestCount();
    }

    public double getMissCachingRatio() {
        return (float)this.getMissCachingCount() / (float)this.getRequestCachingCount();
    }

    public double evictedPerEviction() {
        return (float)this.getEvictedCount() / (float)this.getEvictionCount();
    }

    public long getFailedInserts() {
        return this.failedInserts.get();
    }

    public void rollMetricsPeriod() {
        this.hitCounts[this.windowIndex] = this.getHitCount() - this.lastHitCount;
        this.lastHitCount = this.getHitCount();
        this.hitCachingCounts[this.windowIndex] = this.getHitCachingCount() - this.lastHitCachingCount;
        this.lastHitCachingCount = this.getHitCachingCount();
        this.requestCounts[this.windowIndex] = this.getRequestCount() - this.lastRequestCount;
        this.lastRequestCount = this.getRequestCount();
        this.requestCachingCounts[this.windowIndex] = this.getRequestCachingCount() - this.lastRequestCachingCount;
        this.lastRequestCachingCount = this.getRequestCachingCount();
        this.windowIndex = (this.windowIndex + 1) % this.numPeriodsInWindow;
    }

    public long getSumHitCountsPastNPeriods() {
        return CacheStats.sum(this.hitCounts);
    }

    public long getSumRequestCountsPastNPeriods() {
        return CacheStats.sum(this.requestCounts);
    }

    public long getSumHitCachingCountsPastNPeriods() {
        return CacheStats.sum(this.hitCachingCounts);
    }

    public long getSumRequestCachingCountsPastNPeriods() {
        return CacheStats.sum(this.requestCachingCounts);
    }

    public double getHitRatioPastNPeriods() {
        double ratio = (double)CacheStats.sum(this.hitCounts) / (double)CacheStats.sum(this.requestCounts);
        return Double.isNaN(ratio) ? 0.0 : ratio;
    }

    public double getHitCachingRatioPastNPeriods() {
        double ratio = (double)CacheStats.sum(this.hitCachingCounts) / (double)CacheStats.sum(this.requestCachingCounts);
        return Double.isNaN(ratio) ? 0.0 : ratio;
    }

    private static long sum(long[] counts) {
        long sum = 0L;
        for (long count : counts) {
            sum += count;
        }
        return sum;
    }

    private static long[] initializeZeros(int n) {
        long[] zeros = new long[n];
        for (int i = 0; i < n; ++i) {
            zeros[i] = 0L;
        }
        return zeros;
    }
}

