/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.Iterator;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockCachesIterator;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;

@InterfaceAudience.Private
public class CombinedBlockCache
implements BlockCache,
HeapSize {
    private final LruBlockCache lruCache;
    private final BucketCache bucketCache;
    private final CombinedCacheStats combinedCacheStats;

    public CombinedBlockCache(LruBlockCache lruCache, BucketCache bucketCache) {
        this.lruCache = lruCache;
        this.bucketCache = bucketCache;
        this.combinedCacheStats = new CombinedCacheStats(lruCache.getStats(), bucketCache.getStats());
    }

    public long heapSize() {
        return this.lruCache.heapSize() + this.bucketCache.heapSize();
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory) {
        boolean isMetaBlock;
        boolean bl = isMetaBlock = buf.getBlockType().getCategory() != BlockType.BlockCategory.DATA;
        if (isMetaBlock) {
            this.lruCache.cacheBlock(cacheKey, buf, inMemory);
        } else {
            this.bucketCache.cacheBlock(cacheKey, buf, inMemory);
        }
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf) {
        this.cacheBlock(cacheKey, buf, false);
    }

    @Override
    public Cacheable getBlock(BlockCacheKey cacheKey, boolean caching, boolean repeat, boolean updateCacheMetrics) {
        if (this.lruCache.containsBlock(cacheKey)) {
            return this.lruCache.getBlock(cacheKey, caching, repeat, updateCacheMetrics);
        }
        return this.bucketCache.getBlock(cacheKey, caching, repeat, updateCacheMetrics);
    }

    @Override
    public boolean evictBlock(BlockCacheKey cacheKey) {
        return this.lruCache.evictBlock(cacheKey) || this.bucketCache.evictBlock(cacheKey);
    }

    @Override
    public int evictBlocksByHfileName(String hfileName) {
        return this.lruCache.evictBlocksByHfileName(hfileName) + this.bucketCache.evictBlocksByHfileName(hfileName);
    }

    @Override
    public CacheStats getStats() {
        return this.combinedCacheStats;
    }

    @Override
    public void shutdown() {
        this.lruCache.shutdown();
        this.bucketCache.shutdown();
    }

    @Override
    public long size() {
        return this.lruCache.size() + this.bucketCache.size();
    }

    @Override
    public long getFreeSize() {
        return this.lruCache.getFreeSize() + this.bucketCache.getFreeSize();
    }

    @Override
    public long getCurrentSize() {
        return this.lruCache.getCurrentSize() + this.bucketCache.getCurrentSize();
    }

    @Override
    public long getBlockCount() {
        return this.lruCache.getBlockCount() + this.bucketCache.getBlockCount();
    }

    @Override
    public Iterator<CachedBlock> iterator() {
        return new BlockCachesIterator(this.getBlockCaches());
    }

    @Override
    public BlockCache[] getBlockCaches() {
        return new BlockCache[]{this.lruCache, this.bucketCache};
    }

    private static class CombinedCacheStats
    extends CacheStats {
        private final CacheStats lruCacheStats;
        private final CacheStats bucketCacheStats;

        CombinedCacheStats(CacheStats lbcStats, CacheStats fcStats) {
            this.lruCacheStats = lbcStats;
            this.bucketCacheStats = fcStats;
        }

        @Override
        public long getDataMissCount() {
            return this.lruCacheStats.getDataMissCount() + this.bucketCacheStats.getDataMissCount();
        }

        @Override
        public long getLeafIndexMissCount() {
            return this.lruCacheStats.getLeafIndexMissCount() + this.bucketCacheStats.getLeafIndexMissCount();
        }

        @Override
        public long getBloomChunkMissCount() {
            return this.lruCacheStats.getBloomChunkMissCount() + this.bucketCacheStats.getBloomChunkMissCount();
        }

        @Override
        public long getMetaMissCount() {
            return this.lruCacheStats.getMetaMissCount() + this.bucketCacheStats.getMetaMissCount();
        }

        @Override
        public long getRootIndexMissCount() {
            return this.lruCacheStats.getRootIndexMissCount() + this.bucketCacheStats.getRootIndexMissCount();
        }

        @Override
        public long getIntermediateIndexMissCount() {
            return this.lruCacheStats.getIntermediateIndexMissCount() + this.bucketCacheStats.getIntermediateIndexMissCount();
        }

        @Override
        public long getFileInfoMissCount() {
            return this.lruCacheStats.getFileInfoMissCount() + this.bucketCacheStats.getFileInfoMissCount();
        }

        @Override
        public long getGeneralBloomMetaMissCount() {
            return this.lruCacheStats.getGeneralBloomMetaMissCount() + this.bucketCacheStats.getGeneralBloomMetaMissCount();
        }

        @Override
        public long getDeleteFamilyBloomMissCount() {
            return this.lruCacheStats.getDeleteFamilyBloomMissCount() + this.bucketCacheStats.getDeleteFamilyBloomMissCount();
        }

        @Override
        public long getTrailerMissCount() {
            return this.lruCacheStats.getTrailerMissCount() + this.bucketCacheStats.getTrailerMissCount();
        }

        @Override
        public long getDataHitCount() {
            return this.lruCacheStats.getDataHitCount() + this.bucketCacheStats.getDataHitCount();
        }

        @Override
        public long getLeafIndexHitCount() {
            return this.lruCacheStats.getLeafIndexHitCount() + this.bucketCacheStats.getLeafIndexHitCount();
        }

        @Override
        public long getBloomChunkHitCount() {
            return this.lruCacheStats.getBloomChunkHitCount() + this.bucketCacheStats.getBloomChunkHitCount();
        }

        @Override
        public long getMetaHitCount() {
            return this.lruCacheStats.getMetaHitCount() + this.bucketCacheStats.getMetaHitCount();
        }

        @Override
        public long getRootIndexHitCount() {
            return this.lruCacheStats.getRootIndexHitCount() + this.bucketCacheStats.getRootIndexHitCount();
        }

        @Override
        public long getIntermediateIndexHitCount() {
            return this.lruCacheStats.getIntermediateIndexHitCount() + this.bucketCacheStats.getIntermediateIndexHitCount();
        }

        @Override
        public long getFileInfoHitCount() {
            return this.lruCacheStats.getFileInfoHitCount() + this.bucketCacheStats.getFileInfoHitCount();
        }

        @Override
        public long getGeneralBloomMetaHitCount() {
            return this.lruCacheStats.getGeneralBloomMetaHitCount() + this.bucketCacheStats.getGeneralBloomMetaHitCount();
        }

        @Override
        public long getDeleteFamilyBloomHitCount() {
            return this.lruCacheStats.getDeleteFamilyBloomHitCount() + this.bucketCacheStats.getDeleteFamilyBloomHitCount();
        }

        @Override
        public long getTrailerHitCount() {
            return this.lruCacheStats.getTrailerHitCount() + this.bucketCacheStats.getTrailerHitCount();
        }

        @Override
        public long getRequestCount() {
            return this.lruCacheStats.getRequestCount() + this.bucketCacheStats.getRequestCount();
        }

        @Override
        public long getRequestCachingCount() {
            return this.lruCacheStats.getRequestCachingCount() + this.bucketCacheStats.getRequestCachingCount();
        }

        @Override
        public long getMissCount() {
            return this.lruCacheStats.getMissCount() + this.bucketCacheStats.getMissCount();
        }

        @Override
        public long getMissCachingCount() {
            return this.lruCacheStats.getMissCachingCount() + this.bucketCacheStats.getMissCachingCount();
        }

        @Override
        public long getHitCount() {
            return this.lruCacheStats.getHitCount() + this.bucketCacheStats.getHitCount();
        }

        @Override
        public long getHitCachingCount() {
            return this.lruCacheStats.getHitCachingCount() + this.bucketCacheStats.getHitCachingCount();
        }

        @Override
        public long getEvictionCount() {
            return this.lruCacheStats.getEvictionCount() + this.bucketCacheStats.getEvictionCount();
        }

        @Override
        public long getEvictedCount() {
            return this.lruCacheStats.getEvictedCount() + this.bucketCacheStats.getEvictedCount();
        }

        @Override
        public double getHitRatioPastNPeriods() {
            double ratio = (double)(this.lruCacheStats.getSumHitCountsPastNPeriods() + this.bucketCacheStats.getSumHitCountsPastNPeriods()) / (double)(this.lruCacheStats.getSumRequestCountsPastNPeriods() + this.bucketCacheStats.getSumRequestCountsPastNPeriods());
            return Double.isNaN(ratio) ? 0.0 : ratio;
        }

        @Override
        public double getHitCachingRatioPastNPeriods() {
            double ratio = (double)(this.lruCacheStats.getSumHitCachingCountsPastNPeriods() + this.bucketCacheStats.getSumHitCachingCountsPastNPeriods()) / (double)(this.lruCacheStats.getSumRequestCachingCountsPastNPeriods() + this.bucketCacheStats.getSumRequestCachingCountsPastNPeriods());
            return Double.isNaN(ratio) ? 0.0 : ratio;
        }
    }
}

