/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;

@InterfaceAudience.Private
public class BufferedHTable
extends HTable {
    private boolean closed = false;

    public BufferedHTable(Configuration conf, String tableName) throws IOException {
        super(conf, tableName);
    }

    public BufferedHTable(Configuration conf, byte[] tableName) throws IOException {
        super(conf, tableName);
    }

    public void delete(Delete delete) throws IOException {
        this.doDelete(delete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        for (Delete delete : deletes) {
            this.doDelete(delete);
        }
    }

    private void doDelete(Delete delete) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("BufferedHTable was closed");
        }
        this.currentWriteBufferSize += delete.heapSize();
        this.writeAsyncBuffer.add(delete);
        if (this.currentWriteBufferSize > this.getWriteBufferSize()) {
            this.flushCommits();
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flushCommits();
        this.closed = true;
        super.close();
    }

    @VisibleForTesting
    long getCurrentWriteBufferSize() {
        return this.currentWriteBufferSize;
    }
}

