/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RowCounter {
    static final String NAME = "rowcounter";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        List<MultiRowRangeFilter.RowRange> rowRangeList = null;
        long startTime = 0L;
        long endTime = 0L;
        StringBuilder sb = new StringBuilder();
        String rangeSwitch = "--range=";
        String startTimeArgKey = "--starttime=";
        String endTimeArgKey = "--endtime=";
        for (int i = 1; i < args.length; ++i) {
            if (args[i].startsWith("--range=")) {
                try {
                    rowRangeList = RowCounter.parseRowRangeParameter(args[i], "--range=");
                    continue;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            if (startTime < endTime) {
                RowCounter.printUsage("--endtime=" + endTime + " needs to be greater than --starttime=" + startTime);
                return null;
            }
            if (args[i].startsWith("--starttime=")) {
                startTime = Long.parseLong(args[i].substring("--starttime=".length()));
                continue;
            }
            if (args[i].startsWith("--endtime=")) {
                endTime = Long.parseLong(args[i].substring("--endtime=".length()));
                continue;
            }
            sb.append(args[i]);
            sb.append(" ");
        }
        Job job = new Job(conf, "rowcounter_" + tableName);
        job.setJarByClass(RowCounter.class);
        Scan scan = new Scan();
        scan.setCacheBlocks(false);
        RowCounter.setScanFilter(scan, rowRangeList);
        if (sb.length() > 0) {
            for (String columnName : sb.toString().trim().split(" ")) {
                String family = StringUtils.substringBefore((String)columnName, (String)":");
                String qualifier = StringUtils.substringAfter((String)columnName, (String)":");
                if (StringUtils.isBlank((String)qualifier)) {
                    scan.addFamily(Bytes.toBytes((String)family));
                    continue;
                }
                scan.addColumn(Bytes.toBytes((String)family), Bytes.toBytes((String)qualifier));
            }
        }
        scan.setTimeRange(startTime, endTime == 0L ? Long.MAX_VALUE : endTime);
        job.setOutputFormatClass(NullOutputFormat.class);
        TableMapReduceUtil.initTableMapperJob(tableName, scan, RowCounterMapper.class, ImmutableBytesWritable.class, Result.class, job);
        job.setNumReduceTasks(0);
        return job;
    }

    private static List<MultiRowRangeFilter.RowRange> parseRowRangeParameter(String arg, String rangeSwitch) {
        String[] ranges = arg.substring(rangeSwitch.length()).split(";");
        ArrayList<MultiRowRangeFilter.RowRange> rangeList = new ArrayList<MultiRowRangeFilter.RowRange>();
        for (String range : ranges) {
            String[] startEnd = range.split(",", 2);
            if (startEnd.length != 2 || startEnd[1].contains(",")) {
                RowCounter.printUsage("Please specify range in such format as \"--range=a,b\" or, with only one boundary, \"--range=,b\" or \"--range=a,\"");
                throw new IllegalArgumentException("Wrong range specification: " + range);
            }
            String startKey = startEnd[0];
            String endKey = startEnd[1];
            rangeList.add(new MultiRowRangeFilter.RowRange(Bytes.toBytesBinary((String)startKey), true, Bytes.toBytesBinary((String)endKey), false));
        }
        return rangeList;
    }

    private static void setScanFilter(Scan scan, List<MultiRowRangeFilter.RowRange> rowRangeList) {
        int size;
        int n = size = rowRangeList == null ? 0 : rowRangeList.size();
        if (size <= 1) {
            scan.setFilter((Filter)new FirstKeyOnlyFilter());
        }
        if (size == 1) {
            MultiRowRangeFilter.RowRange range = rowRangeList.get(0);
            scan.setStartRow(range.getStartRow());
            scan.setStopRow(range.getStopRow());
        } else if (size > 1) {
            try {
                scan.setFilter((Filter)new MultiRowRangeFilter(rowRangeList));
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot instantiate MultiRowRangeFilter");
            }
        }
    }

    private static void printUsage(String errorMessage) {
        System.err.println("ERROR: " + errorMessage);
        RowCounter.printUsage();
    }

    private static void printUsage() {
        System.err.println("Usage: RowCounter [options] <tablename> [--starttime=[start] --endtime=[end] [--range=[startKey],[endKey][;[startKey],[endKey]...]] [<column1> <column2>...]");
        System.err.println("For performance consider the following options:\n-Dhbase.client.scanner.caching=100\n-Dmapred.map.tasks.speculative.execution=false");
    }

    public static void main(String[] args) throws Exception {
        Job job;
        Configuration conf = HBaseConfiguration.create();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 1) {
            RowCounter.printUsage("Wrong number of parameters: " + args.length);
            System.exit(-1);
        }
        if ((job = RowCounter.createSubmittableJob(conf, otherArgs)) == null) {
            System.exit(-1);
        }
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    static class RowCounterMapper
    extends TableMapper<ImmutableBytesWritable, Result> {
        RowCounterMapper() {
        }

        public void map(ImmutableBytesWritable row, Result values, Mapper.Context context) throws IOException {
            context.getCounter((Enum)Counters.ROWS).increment(1L);
        }

        public static enum Counters {
            ROWS;

        }
    }
}

