/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionConfiguration;

@InterfaceAudience.Private
class DefaultStoreFileManager
implements StoreFileManager {
    static final Log LOG = LogFactory.getLog(DefaultStoreFileManager.class);
    private final KeyValue.KVComparator kvComparator;
    private final CompactionConfiguration comConf;
    private final int blockingFileCount;
    private final Comparator<StoreFile> storeFileComparator;
    private volatile ImmutableList<StoreFile> storefiles = null;

    public DefaultStoreFileManager(KeyValue.KVComparator kvComparator, Comparator<StoreFile> storeFileComparator, Configuration conf, CompactionConfiguration comConf) {
        this.kvComparator = kvComparator;
        this.storeFileComparator = storeFileComparator;
        this.comConf = comConf;
        this.blockingFileCount = conf.getInt("hbase.hstore.blockingStoreFiles", 7);
    }

    @Override
    public void loadFiles(List<StoreFile> storeFiles) {
        this.sortAndSetStoreFiles(storeFiles);
    }

    @Override
    public final Collection<StoreFile> getStorefiles() {
        return this.storefiles;
    }

    @Override
    public void insertNewFiles(Collection<StoreFile> sfs) throws IOException {
        ArrayList<StoreFile> newFiles = new ArrayList<StoreFile>((Collection<StoreFile>)this.storefiles);
        newFiles.addAll(sfs);
        this.sortAndSetStoreFiles(newFiles);
    }

    @Override
    public ImmutableCollection<StoreFile> clearFiles() {
        ImmutableList<StoreFile> result = this.storefiles;
        this.storefiles = ImmutableList.of();
        return result;
    }

    @Override
    public final int getStorefileCount() {
        return this.storefiles.size();
    }

    @Override
    public void addCompactionResults(Collection<StoreFile> compactedFiles, Collection<StoreFile> results) {
        ArrayList newStoreFiles = Lists.newArrayList(this.storefiles);
        newStoreFiles.removeAll(compactedFiles);
        if (!results.isEmpty()) {
            newStoreFiles.addAll(results);
        }
        this.sortAndSetStoreFiles(newStoreFiles);
    }

    @Override
    public final Iterator<StoreFile> getCandidateFilesForRowKeyBefore(KeyValue targetKey) {
        return new ArrayList(Lists.reverse(this.storefiles)).iterator();
    }

    @Override
    public Iterator<StoreFile> updateCandidateFilesForRowKeyBefore(Iterator<StoreFile> candidateFiles, KeyValue targetKey, KeyValue candidate) {
        return candidateFiles;
    }

    @Override
    public final byte[] getSplitPoint() throws IOException {
        if (this.storefiles.isEmpty()) {
            return null;
        }
        return StoreUtils.getLargestFile(this.storefiles).getFileSplitPoint(this.kvComparator);
    }

    @Override
    public final Collection<StoreFile> getFilesForScanOrGet(boolean isGet, byte[] startRow, byte[] stopRow) {
        return this.getStorefiles();
    }

    @Override
    public int getStoreCompactionPriority() {
        int priority = this.blockingFileCount - this.storefiles.size();
        return priority == 1 ? priority + 1 : priority;
    }

    @Override
    public Collection<StoreFile> getUnneededFiles(long maxTs, List<StoreFile> filesCompacting) {
        ArrayList<StoreFile> expiredStoreFiles = null;
        ImmutableList<StoreFile> files = this.storefiles;
        for (int i = 0; i < files.size() - 1; ++i) {
            StoreFile sf = (StoreFile)files.get(i);
            long fileTs = sf.getReader().getMaxTimestamp();
            if (fileTs >= maxTs || filesCompacting.contains(sf)) continue;
            LOG.info((Object)("Found an expired store file: " + sf.getPath() + " whose maxTimeStamp is " + fileTs + ", which is below " + maxTs));
            if (expiredStoreFiles == null) {
                expiredStoreFiles = new ArrayList<StoreFile>();
            }
            expiredStoreFiles.add(sf);
        }
        return expiredStoreFiles;
    }

    private void sortAndSetStoreFiles(List<StoreFile> storeFiles) {
        Collections.sort(storeFiles, this.storeFileComparator);
        this.storefiles = ImmutableList.copyOf(storeFiles);
    }

    @Override
    public double getCompactionPressure() {
        int minFilesToCompact;
        int storefileCount = this.getStorefileCount();
        if (storefileCount <= (minFilesToCompact = this.comConf.getMinFilesToCompact())) {
            return 0.0;
        }
        return (double)(storefileCount - minFilesToCompact) / (double)(this.blockingFileCount - minFilesToCompact);
    }

    @Override
    public Comparator<StoreFile> getStoreFileComparator() {
        return this.storeFileComparator;
    }
}

