/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public class HeapMemoryManager {
    private static final Log LOG = LogFactory.getLog(HeapMemoryManager.class);
    public static final String HBASE_RS_HEAP_MEMORY_TUNER_PERIOD = "hbase.regionserver.heapmemory.tuner.period";
    public static final int HBASE_RS_HEAP_MEMORY_TUNER_DEFAULT_PERIOD = 60000;
    private float heapOccupancyPercent;
    private Server server;
    private HeapMemoryChore heapMemChore = null;
    private final int defaultChorePeriod;
    private final float heapOccupancyLowWatermark;

    public static HeapMemoryManager create(Server server) {
        return new HeapMemoryManager(server);
    }

    @VisibleForTesting
    HeapMemoryManager(Server server) {
        Configuration conf = server.getConfiguration();
        this.server = server;
        this.defaultChorePeriod = conf.getInt(HBASE_RS_HEAP_MEMORY_TUNER_PERIOD, 60000);
        this.heapOccupancyLowWatermark = conf.getFloat("hbase.heap.occupancy.low_water_mark", 0.95f);
    }

    public void start() {
        this.heapMemChore = new HeapMemoryChore();
        Threads.setDaemonThreadRunning((Thread)this.heapMemChore.getThread());
    }

    public void stop() {
        this.heapMemChore.interrupt();
    }

    public float getHeapOccupancyPercent() {
        return this.heapOccupancyPercent;
    }

    private class HeapMemoryChore
    extends Chore {
        private boolean alarming;

        public HeapMemoryChore() {
            super(HeapMemoryManager.this.server.getServerName() + "-HeapMemoryChore", HeapMemoryManager.this.defaultChorePeriod, (Stoppable)HeapMemoryManager.this.server);
            this.alarming = false;
        }

        protected void sleep() {
            if (!this.alarming) {
                super.sleep();
            } else {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        protected void chore() {
            MemoryUsage memUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            HeapMemoryManager.this.heapOccupancyPercent = (float)memUsage.getUsed() / (float)memUsage.getCommitted();
            if (HeapMemoryManager.this.heapOccupancyPercent >= HeapMemoryManager.this.heapOccupancyLowWatermark) {
                if (!this.alarming) {
                    LOG.warn((Object)("heapOccupancyPercent " + HeapMemoryManager.this.heapOccupancyPercent + " is above heap occupancy alarm watermark (" + HeapMemoryManager.this.heapOccupancyLowWatermark + ")"));
                    this.alarming = true;
                }
            } else if (this.alarming) {
                LOG.info((Object)("heapOccupancyPercent " + HeapMemoryManager.this.heapOccupancyPercent + " is now below the heap occupancy alarm watermark (" + HeapMemoryManager.this.heapOccupancyLowWatermark + ")"));
                this.alarming = false;
            }
        }
    }
}

