/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionWindowFactory;
import org.apache.hadoop.hbase.regionserver.compactions.ExploringCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.ExponentialCompactionWindowFactory;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;

@InterfaceAudience.Private
public class CompactionConfiguration {
    static final Log LOG = LogFactory.getLog(CompactionConfiguration.class);
    private static final String CONFIG_PREFIX = "hbase.hstore.compaction.";
    public static final String HBASE_HSTORE_MIN_LOCALITY_TO_SKIP_MAJOR_COMPACT = "hbase.hstore.min.locality.to.skip.major.compact";
    public static final String RATIO_KEY = "hbase.hstore.compaction.ratio";
    public static final String MIN_KEY = "hbase.hstore.compaction.min";
    public static final String MAX_KEY = "hbase.hstore.compaction.max";
    public static final String DATE_TIERED_MAX_AGE_MILLIS_KEY = "hbase.hstore.compaction.date.tiered.max.storefile.age.millis";
    public static final String DATE_TIERED_INCOMING_WINDOW_MIN_KEY = "hbase.hstore.compaction.date.tiered.incoming.window.min";
    public static final String COMPACTION_POLICY_CLASS_FOR_DATE_TIERED_WINDOWS_KEY = "hbase.hstore.compaction.date.tiered.window.policy.class";
    public static final String DATE_TIERED_SINGLE_OUTPUT_FOR_MINOR_COMPACTION_KEY = "hbase.hstore.compaction.date.tiered.single.output.for.minor.compaction";
    private static final Class<? extends RatioBasedCompactionPolicy> DEFAULT_COMPACTION_POLICY_CLASS_FOR_DATE_TIERED_WINDOWS = ExploringCompactionPolicy.class;
    public static final String DATE_TIERED_COMPACTION_WINDOW_FACTORY_CLASS_KEY = "hbase.hstore.compaction.date.tiered.window.factory.class";
    private static final Class<? extends CompactionWindowFactory> DEFAULT_DATE_TIERED_COMPACTION_WINDOW_FACTORY_CLASS = ExponentialCompactionWindowFactory.class;
    Configuration conf;
    StoreConfigInformation storeConfigInfo;
    long maxCompactSize;
    long minCompactSize;
    int minFilesToCompact;
    int maxFilesToCompact;
    double compactionRatio;
    double offPeekCompactionRatio;
    long throttlePoint;
    long majorCompactionPeriod;
    float majorCompactionJitter;
    final float minLocalityToForceCompact;
    private final long dateTieredMaxStoreFileAgeMillis;
    private final int dateTieredIncomingWindowMin;
    private final String compactionPolicyForDateTieredWindow;
    private final boolean dateTieredSingleOutputForMinorCompaction;
    private final String dateTieredCompactionWindowFactory;

    CompactionConfiguration(Configuration conf, StoreConfigInformation storeConfigInfo) {
        this.conf = conf;
        this.storeConfigInfo = storeConfigInfo;
        this.maxCompactSize = conf.getLong("hbase.hstore.compaction.max.size", Long.MAX_VALUE);
        this.minCompactSize = conf.getLong("hbase.hstore.compaction.min.size", storeConfigInfo.getMemstoreFlushSize());
        this.minFilesToCompact = Math.max(2, conf.getInt(MIN_KEY, conf.getInt("hbase.hstore.compactionThreshold", 3)));
        this.maxFilesToCompact = conf.getInt(MAX_KEY, 10);
        this.compactionRatio = conf.getFloat(RATIO_KEY, 1.2f);
        this.offPeekCompactionRatio = conf.getFloat("hbase.hstore.compaction.ratio.offpeak", 5.0f);
        this.throttlePoint = conf.getLong("hbase.regionserver.thread.compaction.throttle", (long)(2 * this.maxFilesToCompact) * storeConfigInfo.getMemstoreFlushSize());
        this.majorCompactionPeriod = conf.getLong("hbase.hregion.majorcompaction", 604800000L);
        this.majorCompactionJitter = conf.getFloat("hbase.hregion.majorcompaction.jitter", 0.5f);
        this.minLocalityToForceCompact = conf.getFloat(HBASE_HSTORE_MIN_LOCALITY_TO_SKIP_MAJOR_COMPACT, 0.0f);
        this.dateTieredMaxStoreFileAgeMillis = conf.getLong(DATE_TIERED_MAX_AGE_MILLIS_KEY, Long.MAX_VALUE);
        this.dateTieredIncomingWindowMin = conf.getInt(DATE_TIERED_INCOMING_WINDOW_MIN_KEY, 6);
        this.compactionPolicyForDateTieredWindow = conf.get(COMPACTION_POLICY_CLASS_FOR_DATE_TIERED_WINDOWS_KEY, DEFAULT_COMPACTION_POLICY_CLASS_FOR_DATE_TIERED_WINDOWS.getName());
        this.dateTieredSingleOutputForMinorCompaction = conf.getBoolean(DATE_TIERED_SINGLE_OUTPUT_FOR_MINOR_COMPACTION_KEY, true);
        this.dateTieredCompactionWindowFactory = conf.get(DATE_TIERED_COMPACTION_WINDOW_FACTORY_CLASS_KEY, DEFAULT_DATE_TIERED_COMPACTION_WINDOW_FACTORY_CLASS.getName());
        LOG.info((Object)this);
    }

    public String toString() {
        return String.format("size [%d, %d); files [%d, %d); ratio %f; off-peak ratio %f; throttle point %d; major period %d, major jitter %f, min locality to compact %f; tiered compaction: max_age %d, incoming window min %d, compaction policy for tiered window %s, single output for minor %b, compaction window factory %s", this.minCompactSize, this.maxCompactSize, this.minFilesToCompact, this.maxFilesToCompact, this.compactionRatio, this.offPeekCompactionRatio, this.throttlePoint, this.majorCompactionPeriod, Float.valueOf(this.majorCompactionJitter), Float.valueOf(this.minLocalityToForceCompact), this.dateTieredMaxStoreFileAgeMillis, this.dateTieredIncomingWindowMin, this.compactionPolicyForDateTieredWindow, this.dateTieredSingleOutputForMinorCompaction, this.dateTieredCompactionWindowFactory);
    }

    long getMinCompactSize() {
        return this.minCompactSize;
    }

    long getMaxCompactSize() {
        return this.maxCompactSize;
    }

    public int getMinFilesToCompact() {
        return this.minFilesToCompact;
    }

    public void setMinFilesToCompact(int threshold) {
        this.minFilesToCompact = threshold;
    }

    int getMaxFilesToCompact() {
        return this.maxFilesToCompact;
    }

    double getCompactionRatio() {
        return this.compactionRatio;
    }

    double getCompactionRatioOffPeak() {
        return this.offPeekCompactionRatio;
    }

    long getThrottlePoint() {
        return this.throttlePoint;
    }

    long getMajorCompactionPeriod() {
        return this.majorCompactionPeriod;
    }

    float getMajorCompactionJitter() {
        return this.majorCompactionJitter;
    }

    float getMinLocalityToForceCompact() {
        return this.minLocalityToForceCompact;
    }

    public long getDateTieredMaxStoreFileAgeMillis() {
        return this.dateTieredMaxStoreFileAgeMillis;
    }

    public int getDateTieredIncomingWindowMin() {
        return this.dateTieredIncomingWindowMin;
    }

    public String getCompactionPolicyForDateTieredWindow() {
        return this.compactionPolicyForDateTieredWindow;
    }

    public boolean useDateTieredSingleOutputForMinorCompaction() {
        return this.dateTieredSingleOutputForMinorCompaction;
    }

    public String getDateTieredCompactionWindowFactory() {
        return this.dateTieredCompactionWindowFactory;
    }
}

