/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;

@InterfaceAudience.Private
public abstract class SortedCompactionPolicy
extends CompactionPolicy {
    private static final Log LOG = LogFactory.getLog(SortedCompactionPolicy.class);

    public SortedCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) {
        super(conf, storeConfigInfo);
    }

    public List<StoreFile> preSelectCompactionForCoprocessor(Collection<StoreFile> candidates, List<StoreFile> filesCompacting) {
        return this.getCurrentEligibleFiles(new ArrayList<StoreFile>(candidates), filesCompacting);
    }

    public CompactionRequest selectCompaction(Collection<StoreFile> candidateFiles, List<StoreFile> filesCompacting, boolean isUserCompaction, boolean mayUseOffPeak, boolean forceMajor) throws IOException {
        boolean tryingMajor;
        ArrayList<StoreFile> candidateSelection = new ArrayList<StoreFile>(candidateFiles);
        int futureFiles = filesCompacting.isEmpty() ? 0 : 1;
        boolean mayBeStuck = (long)(candidateFiles.size() - filesCompacting.size() + futureFiles) >= this.storeConfigInfo.getBlockingFileCount();
        candidateSelection = this.getCurrentEligibleFiles(candidateSelection, filesCompacting);
        LOG.debug((Object)("Selecting compaction from " + candidateFiles.size() + " store files, " + filesCompacting.size() + " compacting, " + candidateSelection.size() + " eligible, " + this.storeConfigInfo.getBlockingFileCount() + " blocking"));
        if (!forceMajor) {
            candidateSelection = this.skipLargeFiles(candidateSelection);
        }
        boolean bl = tryingMajor = forceMajor && isUserCompaction || (forceMajor || this.shouldPerformMajorCompaction(candidateSelection)) && candidateSelection.size() < this.comConf.getMaxFilesToCompact() || StoreUtils.hasReferences(candidateSelection);
        if (tryingMajor) {
            LOG.debug((Object)("Trying to select files for major compaction with forceMajor:" + forceMajor + ", userCompaction:" + isUserCompaction));
        }
        return this.getCompactionRequest(candidateSelection, tryingMajor, isUserCompaction, mayUseOffPeak, mayBeStuck);
    }

    protected abstract CompactionRequest getCompactionRequest(ArrayList<StoreFile> var1, boolean var2, boolean var3, boolean var4, boolean var5) throws IOException;

    @Override
    public abstract boolean shouldPerformMajorCompaction(Collection<StoreFile> var1) throws IOException;

    public long getNextMajorCompactTime(Collection<StoreFile> filesToCompact) {
        double jitterPct;
        long ret = this.comConf.getMajorCompactionPeriod();
        if (ret > 0L && (jitterPct = (double)this.comConf.getMajorCompactionJitter()) > 0.0) {
            long jitter = Math.round((double)ret * jitterPct);
            Integer seed = StoreUtils.getDeterministicRandomSeed(filesToCompact);
            if (seed != null) {
                double rnd = new Random(seed.intValue()).nextDouble();
                ret += jitter - Math.round((double)(2L * jitter) * rnd);
            } else {
                ret = 0L;
            }
        }
        return ret;
    }

    @Override
    public boolean throttleCompaction(long compactionSize) {
        return compactionSize > this.comConf.getThrottlePoint();
    }

    public boolean needsCompaction(Collection<StoreFile> storeFiles, List<StoreFile> filesCompacting) {
        int numCandidates = storeFiles.size() - filesCompacting.size();
        return numCandidates >= this.comConf.getMinFilesToCompact();
    }

    protected ArrayList<StoreFile> getCurrentEligibleFiles(ArrayList<StoreFile> candidateFiles, List<StoreFile> filesCompacting) {
        if (!filesCompacting.isEmpty()) {
            StoreFile last = filesCompacting.get(filesCompacting.size() - 1);
            int idx = candidateFiles.indexOf(last);
            Preconditions.checkArgument((idx != -1 ? 1 : 0) != 0);
            candidateFiles.subList(0, idx + 1).clear();
        }
        return candidateFiles;
    }

    protected ArrayList<StoreFile> skipLargeFiles(ArrayList<StoreFile> candidates) {
        int pos;
        for (pos = 0; pos < candidates.size() && !candidates.get(pos).isReference() && candidates.get(pos).getReader().length() > this.comConf.getMaxCompactSize(); ++pos) {
        }
        if (pos > 0) {
            LOG.debug((Object)("Some files are too large. Excluding " + pos + " files from compaction candidates"));
            candidates.subList(0, pos).clear();
        }
        return candidates;
    }

    protected ArrayList<StoreFile> filterBulk(ArrayList<StoreFile> candidates) {
        candidates.removeAll(Collections2.filter(candidates, (Predicate)new Predicate<StoreFile>(){

            public boolean apply(StoreFile input) {
                return input.excludeFromMinorCompaction();
            }
        }));
        return candidates;
    }

    protected void removeExcessFiles(ArrayList<StoreFile> candidates, boolean isUserCompaction, boolean isMajorCompaction) {
        int excess = candidates.size() - this.comConf.getMaxFilesToCompact();
        if (excess > 0) {
            if (isMajorCompaction && isUserCompaction) {
                LOG.debug((Object)("Warning, compacting more than " + this.comConf.getMaxFilesToCompact() + " files because of a user-requested major compaction"));
            } else {
                LOG.debug((Object)("Too many admissible files. Excluding " + excess + " files from compaction candidates"));
                candidates.subList(this.comConf.getMaxFilesToCompact(), candidates.size()).clear();
            }
        }
    }

    protected ArrayList<StoreFile> checkMinFilesCriteria(ArrayList<StoreFile> candidates, int minFiles) {
        if (candidates.size() < minFiles) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not compacting files because we only have " + candidates.size() + " files ready for compaction. Need " + minFiles + " to initiate."));
            }
            candidates.clear();
        }
        return candidates;
    }
}

