/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class MetricsWAL
implements WALActionsListener {
    static final Log LOG = LogFactory.getLog(MetricsWAL.class);
    private final MetricsWALSource source;

    public MetricsWAL() {
        this((MetricsWALSource)CompatibilitySingletonFactory.getInstance(MetricsWALSource.class));
    }

    @VisibleForTesting
    MetricsWAL(MetricsWALSource s) {
        this.source = s;
    }

    public void finishSync(long time) {
        this.source.incrementSyncTime(time);
    }

    public void finishAppend(long time, long size) {
        this.source.incrementAppendCount();
        this.source.incrementAppendTime(time);
        this.source.incrementAppendSize(size);
        this.source.incrementWrittenBytes(size);
        if (time > 1000L) {
            this.source.incrementSlowAppendCount();
            LOG.warn((Object)String.format("%s took %d ms appending an edit to hlog; len~=%s", Thread.currentThread().getName(), time, StringUtils.humanReadableInt((long)size)));
        }
    }

    @Override
    public void logRollRequested(boolean underReplicated) {
        this.source.incrementLogRollRequested();
        if (underReplicated) {
            this.source.incrementLowReplicationLogRoll();
        }
    }

    @Override
    public void preLogRoll(Path oldPath, Path newPath) throws IOException {
    }

    @Override
    public void postLogRoll(Path oldPath, Path newPath) throws IOException {
    }

    @Override
    public void preLogArchive(Path oldPath, Path newPath) throws IOException {
    }

    @Override
    public void postLogArchive(Path oldPath, Path newPath) throws IOException {
    }

    @Override
    public void logCloseRequested() {
    }

    @Override
    public void visitLogEntryBeforeWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) {
    }

    @Override
    public void visitLogEntryBeforeWrite(HTableDescriptor htd, HLogKey logKey, WALEdit logEdit) {
    }
}

