/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.ReaderBase;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix", "Configuration"})
public class ProtobufLogReader
extends ReaderBase {
    private static final Log LOG = LogFactory.getLog(ProtobufLogReader.class);
    static final byte[] PB_WAL_MAGIC = Bytes.toBytes((String)"PWAL");
    static final byte[] PB_WAL_COMPLETE_MAGIC = Bytes.toBytes((String)"LAWP");
    protected FSDataInputStream inputStream;
    protected Codec.Decoder cellDecoder;
    protected WALCellCodec.ByteStringUncompressor byteStringUncompressor;
    protected boolean hasCompression = false;
    protected boolean hasTagCompression = false;
    private long walEditsStopOffset;
    private boolean trailerPresent;
    private static List<String> writerClsNames = new ArrayList<String>();

    @InterfaceAudience.Private
    public long trailerSize() {
        if (this.trailerPresent) {
            long expectedSize = this.fileLength - this.walEditsStopOffset;
            long calculatedSize = PB_WAL_COMPLETE_MAGIC.length + 4 + this.trailer.getSerializedSize();
            if (expectedSize != calculatedSize) {
                LOG.warn((Object)("After parsing the trailer, we expect the total footer to be " + expectedSize + " bytes, but we calculate it as being " + calculatedSize));
            }
            return expectedSize;
        }
        return -1L;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    @Override
    public long getPosition() throws IOException {
        return this.inputStream.getPos();
    }

    @Override
    public void reset() throws IOException {
        String clsName = this.initInternal(null, false);
        this.initAfterCompression(clsName);
    }

    @Override
    protected String initReader(FSDataInputStream stream) throws IOException {
        return this.initInternal(stream, true);
    }

    protected List<String> getWriterClsNames() {
        return writerClsNames;
    }

    protected WALHdrContext readHeader(WALProtos.WALHeader.Builder builder, FSDataInputStream stream) throws IOException {
        boolean res = builder.mergeDelimitedFrom((InputStream)stream);
        if (!res) {
            return new WALHdrContext(WALHdrResult.EOF, null);
        }
        if (builder.hasWriterClsName() && !this.getWriterClsNames().contains(builder.getWriterClsName())) {
            return new WALHdrContext(WALHdrResult.UNKNOWN_WRITER_CLS, null);
        }
        String clsName = null;
        if (builder.hasCellCodecClsName()) {
            clsName = builder.getCellCodecClsName();
        }
        return new WALHdrContext(WALHdrResult.SUCCESS, clsName);
    }

    private String initInternal(FSDataInputStream stream, boolean isFirst) throws IOException {
        this.close();
        long expectedPos = PB_WAL_MAGIC.length;
        if (stream == null) {
            stream = this.fs.open(this.path);
            stream.seek(expectedPos);
        }
        if (stream.getPos() != expectedPos) {
            throw new IOException("The stream is at invalid position: " + stream.getPos());
        }
        WALProtos.WALHeader.Builder builder = WALProtos.WALHeader.newBuilder();
        WALHdrContext hdrCtxt = this.readHeader(builder, stream);
        WALHdrResult walHdrRes = hdrCtxt.getResult();
        if (walHdrRes == WALHdrResult.EOF) {
            throw new EOFException("Couldn't read WAL PB header");
        }
        if (walHdrRes == WALHdrResult.UNKNOWN_WRITER_CLS) {
            throw new IOException("Got unknown writer class: " + builder.getWriterClsName());
        }
        if (isFirst) {
            WALProtos.WALHeader header = builder.build();
            this.hasCompression = header.hasHasCompression() && header.getHasCompression();
            this.hasTagCompression = header.hasHasTagCompression() && header.getHasTagCompression();
        }
        this.inputStream = stream;
        this.walEditsStopOffset = this.fileLength;
        long currentPosition = stream.getPos();
        this.trailerPresent = this.setTrailerIfPresent();
        this.seekOnFs(currentPosition);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("After reading the trailer: walEditsStopOffset: " + this.walEditsStopOffset + ", fileLength: " + this.fileLength + ", " + "trailerPresent: " + (this.trailerPresent ? "true, size: " + this.trailer.getSerializedSize() : "false") + ", currentPosition: " + currentPosition));
        }
        return hdrCtxt.getCellCodecClsName();
    }

    private boolean setTrailerIfPresent() {
        try {
            long trailerSizeOffset = this.fileLength - (long)(PB_WAL_COMPLETE_MAGIC.length + 4);
            if (trailerSizeOffset <= 0L) {
                return false;
            }
            this.seekOnFs(trailerSizeOffset);
            int trailerSize = this.inputStream.readInt();
            ByteBuffer buf = ByteBuffer.allocate(PB_WAL_COMPLETE_MAGIC.length);
            this.inputStream.readFully(buf.array(), buf.arrayOffset(), buf.capacity());
            if (!Arrays.equals(buf.array(), PB_WAL_COMPLETE_MAGIC)) {
                LOG.trace((Object)"No trailer found.");
                return false;
            }
            if (trailerSize < 0) {
                LOG.warn((Object)("Invalid trailer Size " + trailerSize + ", ignoring the trailer"));
                return false;
            }
            if (trailerSize > this.trailerWarnSize) {
                LOG.warn((Object)("Please investigate WALTrailer usage. Trailer size > maximum configured size : " + trailerSize + " > " + this.trailerWarnSize));
            }
            long positionOfTrailer = trailerSizeOffset - (long)trailerSize;
            this.seekOnFs(positionOfTrailer);
            buf = ByteBuffer.allocate(trailerSize);
            this.inputStream.readFully(buf.array(), buf.arrayOffset(), buf.capacity());
            this.trailer = WALProtos.WALTrailer.parseFrom((byte[])buf.array());
            this.walEditsStopOffset = positionOfTrailer;
            return true;
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Got IOE while reading the trailer. Continuing as if no trailer is present.", (Throwable)ioe);
            return false;
        }
    }

    protected WALCellCodec getCodec(Configuration conf, String cellCodecClsName, CompressionContext compressionContext) throws IOException {
        return WALCellCodec.create(conf, cellCodecClsName, compressionContext);
    }

    @Override
    protected void initAfterCompression() throws IOException {
        this.initAfterCompression(null);
    }

    @Override
    protected void initAfterCompression(String cellCodecClsName) throws IOException {
        WALCellCodec codec = this.getCodec(this.conf, cellCodecClsName, this.compressionContext);
        this.cellDecoder = codec.getDecoder((InputStream)this.inputStream);
        if (this.hasCompression) {
            this.byteStringUncompressor = codec.getByteStringUncompressor();
        }
    }

    @Override
    protected boolean hasCompression() {
        return this.hasCompression;
    }

    @Override
    protected boolean hasTagCompression() {
        return this.hasTagCompression;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean readNext(HLog.Entry entry) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IOException extractHiddenEof(Exception ex) {
        IOException ioEx = null;
        if (ex instanceof EOFException) {
            return (EOFException)ex;
        }
        if (ex instanceof IOException) {
            ioEx = (IOException)ex;
        } else if (ex instanceof RuntimeException && ex.getCause() != null && ex.getCause() instanceof IOException) {
            ioEx = (IOException)ex.getCause();
        }
        if (ioEx != null) {
            if (ioEx.getMessage().contains("EOF")) {
                return ioEx;
            }
            return null;
        }
        return null;
    }

    @Override
    public WALProtos.WALTrailer getWALTrailer() {
        return this.trailer;
    }

    @Override
    protected void seekOnFs(long pos) throws IOException {
        this.inputStream.seek(pos);
    }

    static {
        writerClsNames.add(ProtobufLogWriter.class.getSimpleName());
    }

    static class WALHdrContext {
        WALHdrResult result;
        String cellCodecClsName;

        WALHdrContext(WALHdrResult result, String cellCodecClsName) {
            this.result = result;
            this.cellCodecClsName = cellCodecClsName;
        }

        WALHdrResult getResult() {
            return this.result;
        }

        String getCellCodecClsName() {
            return this.cellCodecClsName;
        }
    }

    static enum WALHdrResult {
        EOF,
        SUCCESS,
        UNKNOWN_WRITER_CLS;

    }
}

