/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.mortbay.log.Log;

@InterfaceAudience.Private
public class ClientSideRegionScanner
extends AbstractClientScanner {
    private HRegion region;
    private Scan scan;
    RegionScanner scanner;
    List<Cell> values;

    public ClientSideRegionScanner(Configuration conf, FileSystem fs, Path rootDir, HTableDescriptor htd, HRegionInfo hri, Scan scan, ScanMetrics scanMetrics) throws IOException {
        this.scan = scan;
        scan.setIsolationLevel(IsolationLevel.READ_UNCOMMITTED);
        this.region = HRegion.openHRegion(conf, fs, rootDir, hri, htd, null, null, null);
        this.scanner = this.region.getScanner(scan);
        this.values = new ArrayList<Cell>();
        if (scanMetrics == null) {
            this.initScanMetrics(scan);
        } else {
            this.scanMetrics = scanMetrics;
        }
        this.region.startRegionOperation();
    }

    public Result next() throws IOException {
        this.values.clear();
        this.scanner.nextRaw(this.values);
        if (this.values.isEmpty()) {
            return null;
        }
        Result result = Result.create(this.values);
        if (this.scanMetrics != null) {
            long resultSize = 0L;
            for (Cell kv : this.values) {
                resultSize += (long)KeyValueUtil.ensureKeyValue((Cell)kv).getLength();
            }
            this.scanMetrics.countOfBytesInResults.addAndGet(resultSize);
        }
        return result;
    }

    public void close() {
        if (this.scanner != null) {
            try {
                this.scanner.close();
                this.scanner = null;
            }
            catch (IOException ex) {
                Log.warn((String)"Exception while closing scanner", (Throwable)ex);
            }
        }
        if (this.region != null) {
            try {
                this.region.closeRegionOperation();
                this.region.close(true);
                this.region = null;
            }
            catch (IOException ex) {
                Log.warn((String)"Exception while closing region", (Throwable)ex);
            }
        }
    }

    public boolean renewLease() {
        throw new UnsupportedOperationException();
    }
}

