/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFileManager;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFlusher;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactor;
import org.apache.hadoop.hbase.security.User;

@InterfaceAudience.Private
public class DateTieredStoreEngine
extends StoreEngine<DefaultStoreFlusher, DateTieredCompactionPolicy, DateTieredCompactor, DefaultStoreFileManager> {
    @Override
    public boolean needsCompaction(List<StoreFile> filesCompacting) {
        return ((DateTieredCompactionPolicy)this.compactionPolicy).needsCompaction(((DefaultStoreFileManager)this.storeFileManager).getStorefiles(), filesCompacting);
    }

    @Override
    public CompactionContext createCompaction() throws IOException {
        return new DateTieredCompactionContext();
    }

    @Override
    protected void createComponents(Configuration conf, Store store, KeyValue.KVComparator kvComparator) throws IOException {
        this.compactionPolicy = new DateTieredCompactionPolicy(conf, store);
        this.storeFileManager = new DefaultStoreFileManager(kvComparator, StoreFile.Comparators.SEQ_ID_MAX_TIMESTAMP, conf, ((DateTieredCompactionPolicy)this.compactionPolicy).getConf());
        this.storeFlusher = new DefaultStoreFlusher(conf, store);
        this.compactor = new DateTieredCompactor(conf, store);
    }

    private final class DateTieredCompactionContext
    extends CompactionContext {
        private DateTieredCompactionContext() {
        }

        @Override
        public List<StoreFile> preSelect(List<StoreFile> filesCompacting) {
            return ((DateTieredCompactionPolicy)DateTieredStoreEngine.this.compactionPolicy).preSelectCompactionForCoprocessor(((DefaultStoreFileManager)DateTieredStoreEngine.this.storeFileManager).getStorefiles(), filesCompacting);
        }

        @Override
        public boolean select(List<StoreFile> filesCompacting, boolean isUserCompaction, boolean mayUseOffPeak, boolean forceMajor) throws IOException {
            this.request = ((DateTieredCompactionPolicy)DateTieredStoreEngine.this.compactionPolicy).selectCompaction(((DefaultStoreFileManager)DateTieredStoreEngine.this.storeFileManager).getStorefiles(), filesCompacting, isUserCompaction, mayUseOffPeak, forceMajor);
            return this.request != null;
        }

        @Override
        public void forceSelect(CompactionRequest request) {
            if (!(request instanceof DateTieredCompactionRequest)) {
                throw new IllegalArgumentException("DateTieredCompactionRequest is expected. Actual: " + request.getClass().getCanonicalName());
            }
            super.forceSelect(request);
        }

        @Override
        public List<Path> compact(CompactionThroughputController throughputController) throws IOException {
            return this.compact(throughputController, null);
        }

        @Override
        public List<Path> compact(CompactionThroughputController throughputController, User user) throws IOException {
            if (this.request instanceof DateTieredCompactionRequest) {
                return ((DateTieredCompactor)DateTieredStoreEngine.this.compactor).compact(this.request, ((DateTieredCompactionRequest)this.request).getBoundaries(), throughputController, user);
            }
            throw new IllegalArgumentException("DateTieredCompactionRequest is expected. Actual: " + this.request.getClass().getCanonicalName());
        }
    }
}

