/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.math.LongMath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionConfiguration;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionWindow;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionWindowFactory;
import org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.SortedCompactionPolicy;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class DateTieredCompactionPolicy
extends SortedCompactionPolicy {
    private static final Log LOG = LogFactory.getLog(DateTieredCompactionPolicy.class);
    private final RatioBasedCompactionPolicy compactionPolicyPerWindow;
    private final CompactionWindowFactory windowFactory;

    public DateTieredCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) throws IOException {
        super(conf, storeConfigInfo);
        try {
            this.compactionPolicyPerWindow = (RatioBasedCompactionPolicy)ReflectionUtils.instantiateWithCustomCtor((String)this.comConf.getCompactionPolicyForDateTieredWindow(), (Class[])new Class[]{Configuration.class, StoreConfigInformation.class}, (Object[])new Object[]{conf, storeConfigInfo});
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured compaction policy '" + this.comConf.getCompactionPolicyForDateTieredWindow() + "'", e);
        }
        try {
            this.windowFactory = (CompactionWindowFactory)ReflectionUtils.instantiateWithCustomCtor((String)this.comConf.getDateTieredCompactionWindowFactory(), (Class[])new Class[]{CompactionConfiguration.class}, (Object[])new Object[]{this.comConf});
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured window factory '" + this.comConf.getDateTieredCompactionWindowFactory() + "'", e);
        }
    }

    @Override
    @VisibleForTesting
    public boolean needsCompaction(Collection<StoreFile> storeFiles, List<StoreFile> filesCompacting) {
        ArrayList<StoreFile> candidates = new ArrayList<StoreFile>(storeFiles);
        try {
            return !this.selectMinorCompaction(candidates, false, true).getFiles().isEmpty();
        }
        catch (Exception e) {
            LOG.error((Object)"Can not check for compaction: ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean shouldPerformMajorCompaction(Collection<StoreFile> filesToCompact) throws IOException {
        long mcTime = this.getNextMajorCompactTime(filesToCompact);
        if (filesToCompact == null || mcTime == 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("filesToCompact: " + filesToCompact + " mcTime: " + mcTime));
            }
            return false;
        }
        long lowTimestamp = StoreUtils.getLowestTimestamp(filesToCompact);
        long now = EnvironmentEdgeManager.currentTimeMillis();
        if (lowTimestamp <= 0L || lowTimestamp >= now - mcTime) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("lowTimestamp: " + lowTimestamp + " lowTimestamp: " + lowTimestamp + " now: " + now + " mcTime: " + mcTime));
            }
            return false;
        }
        long cfTtl = this.storeConfigInfo.getStoreFileTtl();
        HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
        List<Long> boundaries = this.getCompactBoundariesForMajor(filesToCompact, now);
        boolean[] filesInWindow = new boolean[boundaries.size()];
        for (StoreFile file : filesToCompact) {
            long oldest;
            Long minTimestamp = file.getMinimumTimestamp();
            long l = oldest = minTimestamp == null ? Long.MIN_VALUE : now - minTimestamp;
            if (cfTtl != Long.MAX_VALUE && oldest >= cfTtl) {
                LOG.debug((Object)("Major compaction triggered on store " + this + "; for TTL maintenance"));
                return true;
            }
            if (!file.isMajorCompaction() || file.isBulkLoadResult()) {
                LOG.debug((Object)("Major compaction triggered on store " + this + ", because there are new files and time since last major compaction " + (now - lowTimestamp) + "ms"));
                return true;
            }
            int lowerWindowIndex = Collections.binarySearch(boundaries, minTimestamp == null ? Long.MAX_VALUE : file.getMinimumTimestamp());
            int upperWindowIndex = Collections.binarySearch(boundaries, file.getMaximumTimestamp() == null ? Long.MAX_VALUE : file.getMaximumTimestamp());
            lowerWindowIndex = lowerWindowIndex < 0 ? Math.abs(lowerWindowIndex + 2) : lowerWindowIndex;
            int n = upperWindowIndex = upperWindowIndex < 0 ? Math.abs(upperWindowIndex + 2) : upperWindowIndex;
            if (lowerWindowIndex != upperWindowIndex) {
                LOG.debug((Object)("Major compaction triggered on store " + this + "; because file " + file.getPath() + " has data with timestamps cross window boundaries"));
                return true;
            }
            if (filesInWindow[upperWindowIndex]) {
                LOG.debug((Object)("Major compaction triggered on store " + this + "; because there are more than one file in some windows"));
                return true;
            }
            filesInWindow[upperWindowIndex] = true;
            hdfsBlocksDistribution.add(file.getHDFSBlockDistribution());
        }
        float blockLocalityIndex = hdfsBlocksDistribution.getBlockLocalityIndex(HRegionServer.getHostname(this.comConf.conf));
        if (blockLocalityIndex < this.comConf.getMinLocalityToForceCompact()) {
            LOG.debug((Object)("Major compaction triggered on store " + this + "; to make hdfs blocks local, current blockLocalityIndex is " + blockLocalityIndex + " (min " + this.comConf.getMinLocalityToForceCompact() + ")"));
            return true;
        }
        LOG.debug((Object)("Skipping major compaction of " + this + ", because the files are already major compacted"));
        return false;
    }

    @Override
    protected CompactionRequest getCompactionRequest(ArrayList<StoreFile> candidateSelection, boolean tryingMajor, boolean isUserCompaction, boolean mayUseOffPeak, boolean mayBeStuck) throws IOException {
        CompactionRequest result = tryingMajor ? this.selectMajorCompaction(candidateSelection) : this.selectMinorCompaction(candidateSelection, mayUseOffPeak, mayBeStuck);
        ArrayList filesToCompact = Lists.newArrayList(result.getFiles());
        this.removeExcessFiles(filesToCompact, isUserCompaction, tryingMajor);
        result.updateFiles(filesToCompact);
        result.setOffPeak(!filesToCompact.isEmpty() && !tryingMajor && mayUseOffPeak);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generated compaction request: " + result));
        }
        return result;
    }

    public CompactionRequest selectMajorCompaction(ArrayList<StoreFile> candidateSelection) {
        long now = EnvironmentEdgeManager.currentTimeMillis();
        return new DateTieredCompactionRequest(candidateSelection, this.getCompactBoundariesForMajor(candidateSelection, now));
    }

    public CompactionRequest selectMinorCompaction(ArrayList<StoreFile> candidateSelection, boolean mayUseOffPeak, boolean mayBeStuck) throws IOException {
        long now = EnvironmentEdgeManager.currentTimeMillis();
        long oldestToCompact = DateTieredCompactionPolicy.getOldestToCompact(this.comConf.getDateTieredMaxStoreFileAgeMillis(), now);
        ArrayList storefileMaxTimestampPairs = Lists.newArrayListWithCapacity((int)candidateSelection.size());
        long maxTimestampSeen = Long.MIN_VALUE;
        for (StoreFile storeFile : candidateSelection) {
            maxTimestampSeen = Math.max(maxTimestampSeen, storeFile.getMaximumTimestamp() == null ? Long.MIN_VALUE : storeFile.getMaximumTimestamp());
            storefileMaxTimestampPairs.add(new Pair((Object)storeFile, (Object)maxTimestampSeen));
        }
        Collections.reverse(storefileMaxTimestampPairs);
        CompactionWindow window = this.getIncomingWindow(now);
        int minThreshold = this.comConf.getDateTieredIncomingWindowMin();
        PeekingIterator it = Iterators.peekingIterator(storefileMaxTimestampPairs.iterator());
        while (it.hasNext() && window.compareToTimestamp(oldestToCompact) >= 0) {
            DateTieredCompactionRequest request;
            int compResult = window.compareToTimestamp((Long)((Pair)it.peek()).getSecond());
            if (compResult > 0) {
                window = window.nextEarlierWindow();
                minThreshold = this.comConf.getMinFilesToCompact();
                continue;
            }
            ArrayList fileList = Lists.newArrayList();
            while (it.hasNext() && window.compareToTimestamp((Long)((Pair)it.peek()).getSecond()) <= 0) {
                fileList.add(((Pair)it.next()).getFirst());
            }
            if (fileList.size() < minThreshold) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing files: " + fileList + " for window: " + window));
            }
            if ((request = this.generateCompactionRequest(fileList, window, mayUseOffPeak, mayBeStuck, minThreshold)) == null) continue;
            return request;
        }
        return new CompactionRequest(Collections.<StoreFile>emptyList());
    }

    private DateTieredCompactionRequest generateCompactionRequest(ArrayList<StoreFile> storeFiles, CompactionWindow window, boolean mayUseOffPeak, boolean mayBeStuck, int minThreshold) throws IOException {
        ArrayList<StoreFile> storeFileSelection;
        Collections.reverse(storeFiles);
        this.compactionPolicyPerWindow.setMinThreshold(minThreshold);
        ArrayList<StoreFile> arrayList = storeFileSelection = mayBeStuck ? storeFiles : this.compactionPolicyPerWindow.applyCompactionPolicy(storeFiles, mayUseOffPeak, false);
        if (storeFileSelection != null && !storeFileSelection.isEmpty()) {
            boolean singleOutput = storeFiles.size() != storeFileSelection.size() || this.comConf.useDateTieredSingleOutputForMinorCompaction();
            List<Long> boundaries = DateTieredCompactionPolicy.getCompactionBoundariesForMinor(window, singleOutput);
            DateTieredCompactionRequest result = new DateTieredCompactionRequest(storeFileSelection, boundaries);
            return result;
        }
        return null;
    }

    private List<Long> getCompactBoundariesForMajor(Collection<StoreFile> filesToCompact, long now) {
        long minTimestamp = Long.MAX_VALUE;
        for (StoreFile file : filesToCompact) {
            minTimestamp = Math.min(minTimestamp, file.getMinimumTimestamp() == null ? Long.MAX_VALUE : file.getMinimumTimestamp());
        }
        ArrayList<Long> boundaries = new ArrayList<Long>();
        CompactionWindow window = this.getIncomingWindow(now);
        while (window.compareToTimestamp(minTimestamp) > 0) {
            boundaries.add(window.startMillis());
            window = window.nextEarlierWindow();
        }
        boundaries.add(Long.MIN_VALUE);
        Collections.reverse(boundaries);
        return boundaries;
    }

    private static List<Long> getCompactionBoundariesForMinor(CompactionWindow window, boolean singleOutput) {
        ArrayList<Long> boundaries = new ArrayList<Long>();
        boundaries.add(Long.MIN_VALUE);
        if (!singleOutput) {
            boundaries.add(window.startMillis());
        }
        return boundaries;
    }

    private CompactionWindow getIncomingWindow(long now) {
        return this.windowFactory.newIncomingWindow(now);
    }

    private static long getOldestToCompact(long maxAgeMillis, long now) {
        try {
            return LongMath.checkedSubtract((long)now, (long)maxAgeMillis);
        }
        catch (ArithmeticException ae) {
            LOG.warn((Object)("Value for hbase.hstore.compaction.date.tiered.max.storefile.age.millis: " + maxAgeMillis + ". All the files will be eligible for minor compaction."));
            return Long.MIN_VALUE;
        }
    }
}

