/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.compactions.NoLimitCompactionThroughputController;
import org.apache.hadoop.hbase.security.User;

@InterfaceAudience.Private
public class DefaultCompactor
extends Compactor<StoreFile.Writer> {
    private static final Log LOG = LogFactory.getLog(DefaultCompactor.class);
    private final Compactor.CellSinkFactory<StoreFile.Writer> writerFactory = new Compactor.CellSinkFactory<StoreFile.Writer>(){

        @Override
        public StoreFile.Writer createWriter(InternalScanner scanner, Compactor.FileDetails fd, boolean shouldDropBehind) throws IOException {
            return DefaultCompactor.this.createTmpWriter(fd, shouldDropBehind);
        }
    };

    public DefaultCompactor(Configuration conf, Store store) {
        super(conf, store);
    }

    public List<Path> compact(CompactionRequest request, CompactionThroughputController throughputController, User user) throws IOException {
        return this.compact(request, this.defaultScannerFactory, this.writerFactory, throughputController, user);
    }

    public List<Path> compactForTesting(Collection<StoreFile> filesToCompact, boolean isMajor) throws IOException {
        CompactionRequest cr = new CompactionRequest(filesToCompact);
        cr.setIsMajor(isMajor);
        return this.compact(cr, NoLimitCompactionThroughputController.INSTANCE, null);
    }

    @Override
    protected List<Path> commitWriter(StoreFile.Writer writer, Compactor.FileDetails fd, CompactionRequest request) throws IOException {
        ArrayList newFiles = Lists.newArrayList((Object[])new Path[]{writer.getPath()});
        writer.appendMetadata(fd.maxSeqId, request.isMajor());
        writer.close();
        return newFiles;
    }

    @Override
    protected void abortWriter(StoreFile.Writer writer) throws IOException {
        Path leftoverFile = writer.getPath();
        try {
            writer.close();
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to close the writer after an unfinished compaction.", (Throwable)e);
        }
        try {
            this.store.getFileSystem().delete(leftoverFile, false);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to delete the leftover file " + leftoverFile + " after an unfinished compaction."), (Throwable)e);
        }
    }
}

