/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.SortedCompactionPolicy;

@InterfaceAudience.Private
public class RatioBasedCompactionPolicy
extends SortedCompactionPolicy {
    private static final Log LOG = LogFactory.getLog(RatioBasedCompactionPolicy.class);

    public RatioBasedCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) {
        super(conf, storeConfigInfo);
    }

    @Override
    public boolean shouldPerformMajorCompaction(Collection<StoreFile> filesToCompact) throws IOException {
        boolean result = false;
        long mcTime = this.getNextMajorCompactTime(filesToCompact);
        if (filesToCompact == null || filesToCompact.isEmpty() || mcTime == 0L) {
            return result;
        }
        long lowTimestamp = StoreUtils.getLowestTimestamp(filesToCompact);
        long now = System.currentTimeMillis();
        if (lowTimestamp > 0L && lowTimestamp < now - mcTime) {
            long cfTtl = this.storeConfigInfo.getStoreFileTtl();
            if (filesToCompact.size() == 1) {
                long oldest;
                StoreFile sf = filesToCompact.iterator().next();
                Long minTimestamp = sf.getMinimumTimestamp();
                long l = oldest = minTimestamp == null ? Long.MIN_VALUE : now - minTimestamp;
                if (sf.isMajorCompaction() && (cfTtl == Long.MAX_VALUE || oldest < cfTtl)) {
                    float blockLocalityIndex = sf.getHDFSBlockDistribution().getBlockLocalityIndex(HRegionServer.getHostname(this.comConf.conf));
                    if (blockLocalityIndex < this.comConf.getMinLocalityToForceCompact()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Major compaction triggered on only store " + this + "; to make hdfs blocks local, current blockLocalityIndex is " + blockLocalityIndex + " (min " + this.comConf.getMinLocalityToForceCompact() + ")"));
                        }
                        result = true;
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Skipping major compaction of " + this + " because one (major) compacted file only, oldestTime " + oldest + "ms is < ttl=" + cfTtl + " and blockLocalityIndex is " + blockLocalityIndex + " (min " + this.comConf.getMinLocalityToForceCompact() + ")"));
                    }
                } else if (cfTtl != Integer.MAX_VALUE && oldest > cfTtl) {
                    LOG.debug((Object)("Major compaction triggered on store " + this + ", because keyvalues outdated; time since last major compaction " + (now - lowTimestamp) + "ms"));
                    result = true;
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Major compaction triggered on store " + this + "; time since last major compaction " + (now - lowTimestamp) + "ms"));
                }
                result = true;
            }
        }
        return result;
    }

    @Override
    protected CompactionRequest getCompactionRequest(ArrayList<StoreFile> candidateSelection, boolean tryingMajor, boolean isUserCompaction, boolean mayUseOffPeak, boolean mayBeStuck) throws IOException {
        if (!tryingMajor) {
            candidateSelection = this.filterBulk(candidateSelection);
            candidateSelection = this.applyCompactionPolicy(candidateSelection, mayUseOffPeak, mayBeStuck);
            candidateSelection = this.checkMinFilesCriteria(candidateSelection, this.comConf.getMinFilesToCompact());
        }
        this.removeExcessFiles(candidateSelection, isUserCompaction, tryingMajor);
        CompactionRequest result = new CompactionRequest(candidateSelection);
        result.setOffPeak(!candidateSelection.isEmpty() && !tryingMajor && mayUseOffPeak);
        return result;
    }

    protected ArrayList<StoreFile> applyCompactionPolicy(ArrayList<StoreFile> candidates, boolean mayUseOffPeak, boolean mayBeStuck) throws IOException {
        int filesToLeave;
        if (candidates.isEmpty()) {
            return candidates;
        }
        int start = 0;
        double ratio = this.comConf.getCompactionRatio();
        if (mayUseOffPeak) {
            ratio = this.comConf.getCompactionRatioOffPeak();
            LOG.info((Object)("Running an off-peak compaction, selection ratio = " + ratio));
        }
        int countOfFiles = candidates.size();
        long[] fileSizes = new long[countOfFiles];
        long[] sumSize = new long[countOfFiles];
        for (int i = countOfFiles - 1; i >= 0; --i) {
            StoreFile file = candidates.get(i);
            fileSizes[i] = file.getReader().length();
            int tooFar = i + this.comConf.getMaxFilesToCompact() - 1;
            sumSize[i] = fileSizes[i] + (i + 1 < countOfFiles ? sumSize[i + 1] : 0L) - (tooFar < countOfFiles ? fileSizes[tooFar] : 0L);
        }
        while (countOfFiles - start >= this.comConf.getMinFilesToCompact() && fileSizes[start] > Math.max(this.comConf.getMinCompactSize(), (long)((double)sumSize[start + 1] * ratio))) {
            ++start;
        }
        if (start < countOfFiles) {
            LOG.info((Object)("Default compaction algorithm has selected " + (countOfFiles - start) + " files from " + countOfFiles + " candidates"));
        } else if (mayBeStuck && (filesToLeave = candidates.size() - this.comConf.getMinFilesToCompact()) >= 0) {
            start = filesToLeave;
        }
        candidates.subList(0, start).clear();
        return candidates;
    }

    public void setMinThreshold(int minThreshold) {
        this.comConf.setMinFilesToCompact(minThreshold);
    }
}

