/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.codehaus.jackson.map.ObjectMapper;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HLogPrettyPrinter {
    private boolean outputValues;
    private boolean outputJSON;
    private long sequence;
    private String region;
    private String row;
    private boolean persistentOutput;
    private boolean firstTxn;
    private PrintStream out;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public HLogPrettyPrinter() {
        this.outputValues = false;
        this.outputJSON = false;
        this.sequence = -1L;
        this.region = null;
        this.row = null;
        this.persistentOutput = false;
        this.firstTxn = true;
        this.out = System.out;
    }

    public HLogPrettyPrinter(boolean outputValues, boolean outputJSON, long sequence, String region, String row, boolean persistentOutput, PrintStream out) {
        this.outputValues = outputValues;
        this.outputJSON = outputJSON;
        this.sequence = sequence;
        this.region = region;
        this.row = row;
        this.persistentOutput = persistentOutput;
        if (persistentOutput) {
            this.beginPersistentOutput();
        }
        this.out = out;
        this.firstTxn = true;
    }

    public void enableValues() {
        this.outputValues = true;
    }

    public void disableValues() {
        this.outputValues = false;
    }

    public void enableJSON() {
        this.outputJSON = true;
    }

    public void disableJSON() {
        this.outputJSON = false;
    }

    public void setSequenceFilter(long sequence) {
        this.sequence = sequence;
    }

    public void setRegionFilter(String region) {
        this.region = region;
    }

    public void setRowFilter(String row) {
        this.row = row;
    }

    public void beginPersistentOutput() {
        if (this.persistentOutput) {
            return;
        }
        this.persistentOutput = true;
        this.firstTxn = true;
        if (this.outputJSON) {
            this.out.print("[");
        }
    }

    public void endPersistentOutput() {
        if (!this.persistentOutput) {
            return;
        }
        this.persistentOutput = false;
        if (this.outputJSON) {
            this.out.print("]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFile(Configuration conf, Path p) throws IOException {
        FileSystem fs = p.getFileSystem(conf);
        if (!fs.exists(p)) {
            throw new FileNotFoundException(p.toString());
        }
        if (!fs.isFile(p)) {
            throw new IOException(p + " is not a file");
        }
        if (this.outputJSON && !this.persistentOutput) {
            this.out.print("[");
            this.firstTxn = true;
        }
        HLog.Reader log = HLogFactory.createReader(fs, p, conf);
        try {
            HLog.Entry entry;
            while ((entry = log.next()) != null) {
                HLogKey key = entry.getKey();
                WALEdit edit = entry.getEdit();
                Map<String, Object> txn = key.toStringMap();
                long writeTime = key.getWriteTime();
                if (this.sequence >= 0L && (Long)txn.get("sequence") != this.sequence || this.region != null && !((String)txn.get("region")).equals(this.region)) continue;
                ArrayList actions = new ArrayList();
                for (KeyValue kv : edit.getKeyValues()) {
                    HashMap<String, String> op = new HashMap<String, String>(kv.toStringMap());
                    if (this.outputValues) {
                        op.put("value", Bytes.toStringBinary((byte[])kv.getValue()));
                    }
                    if (this.row != null && !((String)op.get("row")).equals(this.row)) continue;
                    actions.add(op);
                }
                if (actions.size() == 0) continue;
                txn.put("actions", actions);
                if (this.outputJSON) {
                    if (this.firstTxn) {
                        this.firstTxn = false;
                    } else {
                        this.out.print(",");
                    }
                    this.out.print(MAPPER.writeValueAsString(txn));
                    continue;
                }
                this.out.println("Sequence " + txn.get("sequence") + " " + "from region " + txn.get("region") + " " + "in table " + txn.get("table") + " at write timestamp: " + new Date(writeTime));
                for (int i = 0; i < actions.size(); ++i) {
                    Map op = (Map)actions.get(i);
                    this.out.println("  Action:");
                    this.out.println("    row: " + op.get("row"));
                    this.out.println("    column: " + op.get("family") + ":" + op.get("qualifier"));
                    this.out.println("    timestamp: " + new Date((Long)op.get("timestamp")));
                    if (op.get("tag") != null) {
                        this.out.println("    tag: " + op.get("tag"));
                    }
                    if (!this.outputValues) continue;
                    this.out.println("    value: " + op.get("value"));
                }
            }
        }
        finally {
            log.close();
        }
        if (this.outputJSON && !this.persistentOutput) {
            this.out.print("]");
        }
    }

    public static void main(String[] args) throws IOException {
        HLogPrettyPrinter.run(args);
    }

    public static void run(String[] args) throws IOException {
        HelpFormatter formatter;
        Options options = new Options();
        options.addOption("h", "help", false, "Output help message");
        options.addOption("j", "json", false, "Output JSON");
        options.addOption("p", "printvals", false, "Print values");
        options.addOption("r", "region", true, "Region to filter by. Pass region name; e.g. 'hbase:meta,,1'");
        options.addOption("s", "sequence", true, "Sequence to filter by. Pass sequence number.");
        options.addOption("w", "row", true, "Row to filter by. Pass row name.");
        HLogPrettyPrinter printer = new HLogPrettyPrinter();
        PosixParser parser = new PosixParser();
        List files = null;
        try {
            CommandLine cmd = parser.parse(options, args);
            files = cmd.getArgList();
            if (files.size() == 0 || cmd.hasOption("h")) {
                formatter = new HelpFormatter();
                formatter.printHelp("HLog <filename...>", options, true);
                System.exit(-1);
            }
            if (cmd.hasOption("p")) {
                printer.enableValues();
            }
            if (cmd.hasOption("j")) {
                printer.enableJSON();
            }
            if (cmd.hasOption("r")) {
                printer.setRegionFilter(cmd.getOptionValue("r"));
            }
            if (cmd.hasOption("s")) {
                printer.setSequenceFilter(Long.parseLong(cmd.getOptionValue("s")));
            }
            if (cmd.hasOption("w")) {
                printer.setRowFilter(cmd.getOptionValue("w"));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            formatter = new HelpFormatter();
            formatter.printHelp("HFile filename(s) ", options, true);
            System.exit(-1);
        }
        Configuration conf = HBaseConfiguration.create();
        FSUtils.setFsDefault(conf, FSUtils.getRootDir(conf));
        printer.beginPersistentOutput();
        for (Object f : files) {
            Path file = new Path((String)f);
            FileSystem fs = file.getFileSystem(conf);
            if (!fs.exists(file)) {
                System.err.println("ERROR, file doesnt exist: " + file);
                return;
            }
            printer.processFile(conf, file);
        }
        printer.endPersistentOutput();
    }
}

